/**
 * @author isabel maria 
 * // This is to isolate the kendo global variable. 
 * // We can now inject a kendoTest variable for testing
 */

import ContextMenu from '../kendocontextmenu';
import Tooltip from '../tooltip';
import Tree from 'tree';
import DragDrop from '../dragdrop';

export default class KendoTree extends Tree {
	constructor(options, treeElement, angularLibs) {
		super(options, treeElement, kendo, angularLibs);
	}

	build() {
		const self = this;
		var childNodes = {};
		this.callbacks.beforeTreeInitialize.call(this, { tree: this });
		var kendoTree = {
			dataSource: this.buildDataSourceOptions(this.options),
			dataTextField: this.options.dataTextField,
			select: this._selectTree.bind(this),
			expand: this._expandNode.bind(this),
          	check: this._checkboxSelected.bind(this),
			change : this._nodeSelected.bind(this),
			collapse: this._nodeCollapsed.bind(this),
			dragAndDrop: this.options.enableDragAndDrop || false,
			navigate: this._onNavigatebyKey.bind(this),
			dataBound: (e) =>{
				if (_.isUndefined(self.options.actionMenu)) {
					self.treeElement.find("#treeMenuOptions").addClass('hidden');
				} else {
					self.treeElement.find("#treeMenuOptions").removeClass('hidden');
				}
				if (self.options.enableTreeSearch === false && this.options.serverFiltering === false) {
					self.treeElement.find("#treeSearch").addClass('hidden');
				} else {
					self.treeElement.find("#treeSearch").removeClass('hidden');
				}
				this.callbacks.dataBound.call(this, { tree: this });
			}
		};

		if(kendoTree.dragAndDrop === true){
			/* drag & drop events */
			kendoTree.dragstart =this._onDragStart.bind(this);
			kendoTree.drag = this._onDrag.bind(this);
			kendoTree.drop = this._onDrop.bind(this);
			kendoTree.dragend = this._onDragEnd.bind(this);
		}
		
		if(this.options.children){
			kendoTree.dataSource.schema.model.children = this.options.children;
		}
		if(!_.isUndefined(this.options.imageField)){
			kendoTree.dataImageUrlField = this.options.imageField;
		}
		if(!_.isUndefined(this.options.spriteField)){
			kendoTree.dataSpriteCssClassField = this.options.spriteField;
		}

		kendoTree.template = this.kendo.template($(`#treeview-template`).first().html());
		if(!_.isUndefined(this.options.nodeTemplate)){ 
			kendoTree.template = this.options.nodeTemplate;
		}

		if(this.options.enableCheckbox === true){
			if(this.options.disableHierarchyCheckboxSelection){
				kendoTree.checkboxes = true;
			} else {
				kendoTree.checkboxes = {
					checkChildren: true
					// ,
					// template: "<input type='checkbox' class='k-checkbox' id='_#:item.uid#' /><label for='_#:item.uid#' class='k-checkbox-label'></label>"
				};
			}
			
		}
		//to do
		kendoTree.noRecords = {
			template: this.angularLibs.cvLoc('label.noResultsFound')
		};

		this.treeElement.kendoTreeView(kendoTree);
		this.treeview = this.treeElement.data("kendoTreeView");
		this.callbacks.afterTreeInitialize.call(this, { tree: this });
		this._setupContextMenus(this.options);

		this.tooltip = new Tooltip(this.treeElement);
		this.tooltip.build();
	}

	_setupContextMenus(options) {
		const self = this;
		const _buildMenuOptions = menuOptions => {
			if (!_.isArray(menuOptions) || _.isEmpty(menuOptions)) {
				return null;
			}
			return menuOptions.map(option => ({
				...option,
				subOptions: _buildMenuOptions(option.subOptions),
				disabled: false,
				onSelect: (event, eventDetails) => {
					if (_.isFunction(option.onSelect)) {
						option.onSelect.call(self, _buildMenuEvent(event), eventDetails);
					}
				}
			}));
		};
		
		// Setup tree toolbar and action menus:
		const _buildMenuEvent = function(event) {
			let currentNodeValue;
			if (event.rowUid) {
				currentNodeValue = self._getSelectedNodeDetailsUID(event.rowUid);
			}
			return {
				optionId: event.optionId,
				tree: self,
				nodeValue: currentNodeValue
			};
		};
		if (!_.isUndefined(options.actionMenu)) {
			const actionContextMenuList = options.actionMenu;
			if (actionContextMenuList.length > 0) {
				this.actionContextMenu = new ContextMenu({
					alignToAnchor: false,
					target: 'body',
					name: `${this.treeName}_actionContextMenu`,
					attrs: {
						[Tooltip.ATTRS.ALLOW_TOOLTIPS]: 'false'
					},
					options: _buildMenuOptions(actionContextMenuList),
					filter: ".childNode",
					onOpen: event => {
						self._openActiveActionButton();
						if (_.isFunction(options.onActionMenuOpen)) {
							options.onActionMenuOpen.call(self, _buildMenuEvent(event));
						}
					},
					onClose: event => {
						self._closeActiveActionButton();
					}
				});
			}

			const treeContextMenuList = options.actionMenu.filter(option => !option.treeMenuOnly);
			if (treeContextMenuList.length > 0) {
				this.treeContextMenu = new ContextMenu({
					alignToAnchor: true,
					target: this.treeElement,
					name: `${this.treeName}_treeContextMenu`,
					attrs: {
						[Tooltip.ATTRS.ALLOW_TOOLTIPS]: 'false'
					},
					cssClass: 'grid-header-context-menu',
					options: _buildMenuOptions(treeContextMenuList),
					filter: "#treeMenuOptions",
					showOn: "click",
					onOpen: event => {
						self._openActiveActionButton();
						if (_.isFunction(options.onActionMenuOpen)) {
							options.onActionMenuOpen.call(self, _buildMenuEvent(event));
						}
					},
					onClose: event => {
						self._closeActiveActionButton();
					}
				});
			}
		} else {
			this.treeElement.find("#treeMenuOptions").addClass('hidden');
		}

		if(this.options.enableTreeSearch === true || this.options.serverFiltering === true){
			this.searchContextMenu = new ContextMenu({
				alignToAnchor: true,
				target: this.treeElement,
				name: `${this.treeName}_searchContextMenu`,
				attrs: {
					[Tooltip.ATTRS.ALLOW_TOOLTIPS]: 'false'
				},
				cssClass: 'grid-header-context-menu',
				options: _buildMenuOptions([
					{
						id: "KENDO_TREE_SEARCH",
						label:` <form title="Show items with value that:" class="k-filter-menu searchContextMenu">
									<div>
										<div class="k-filter-help-text">Show items with value:</div>
										<input title="Value" type="text" id="searchValue">
										<div>
											<button type="submit" class="k-button k-primary searchButton">Search</button>
											<button type="reset" class="k-button resetButton">Clear</button>
										</div>
									</div>
								</form>`,
						encoded: false
					}
				]),
				filter: "#treeSearch",
				showOn: "click",
				scrollable: true,
				onOpen: event => {
					self._openActiveActionButton();
					if (_.isFunction(options.onActionMenuOpen)) {
						options.onActionMenuOpen.call(self, _buildMenuEvent(event));
					}
				},
				onClose: event => {
					self._closeActiveActionButton();
				},
				onSelect: (event)=>{
				}
			});


			$(".searchButton").on('click', event => {
				self.searchValue = $("#searchValue").val();
				let filterValues = [{ field: self.options.dataTextField, operator: "contains", value: self.searchValue }];
				if(!_.isUndefined(self.headNodeDetails)){
					const nodeID = _.get(self.headNodeDetails, self.options.idField, '');
					self.currentSelectedItem = self.getNodeElementByID(nodeID);
					self.selectNode(nodeID);
					filterValues.push({ field: self.options.dataTextField, operator: "eq", value: self.options.headNodeDetails.headNodeLabel });
				}
				self.filterTree = true;
				self.treeview.dataSource.filter({ logic: "or", filters: filterValues });

			});
			$(".resetButton").on('click', event => {
				self.searchValue = "";
				$("#searchValue").val("");
				let filterValues = [{ field: self.options.dataTextField, operator: "contains", value: self.searchValue}];
				if(!_.isUndefined(self.headNodeDetails)){
					let nodeID = _.get(self.headNodeDetails, self.options.idField, '');
					self.currentSelectedItem = self.getNodeElementByID(nodeID);
					self.selectNode(nodeID);
					filterValues.push({ field: self.options.dataTextField, operator: "eq", value: self.options.headNodeDetails.headNodeLabel });
				}
				self.filterTree = true;
				self.treeview.dataSource.filter({ logic: "or", filters: filterValues });
			});
	
			$(".searchContextMenu").on('click', event => {
				event.preventDefault();
				event.stopPropagation();
				return;
			});

		} else {
			this.treeElement.find("#treeSearch").addClass('hidden');
		}
		
		if(this.options.enableTreeSearch === false && _.isUndefined(options.actionMenu)){
			this.treeElement.find(".headerMenu").addClass('hidden');
		}
	}

	_fetchData(options){
		let headNodeID = _.get(this.headNodeDetails, this.options.idField, '');
		let filterValue = _.get(options, 'data.filter.filters[0].value', "");
		if(this.refreshStart === true){
			this.refreshStart = false;
			this.removeChildNodes(headNodeID);
			// if(_.get(options, 'data.reloadTreeData', []).length > 0){
			// 	refreshStart
			// }
		}
		options.success([this.headNodeDetails]);
		if(this.headNodeDetails.expanded  || this.refreshStart || this.filterTree ){
			var expandOptions = {
				currentNode : this.headNodeDetails,
				success : this._success.bind(this, this.headNodeDetails),
				refreshStart: this.refreshStart,
				filterTree : this.filterTree,
				filterValue
			};
			this.options.expandNode(expandOptions, this.headNodeDetails, this.headNodeDetails);
		}
	}

	_closeActiveActionButton() {
        if (this.activeActionButton) {
            this.activeActionButton.removeClass('action-btn-open');
            delete this.activeActionButton;
        }
    }

    _openActiveActionButton() {
        if (this.activeActionButton) {
            this.activeActionButton.addClass('action-btn-open');
        }
	}

	addCoustomClassToNode(id, className){
		let uid = this.getNodeElementByID(id);
		this.treeview.findByUid(uid).addClass(className);
	}

	pushData(data, parentID, parentNode) {
		if(_.isUndefined(parentNode)){
			var dataToPushBack = this.treeview.dataSource.get(parentID);
			parentNode = this.treeview.findByUid(dataToPushBack.uid);
		}
		if(data.length > 0){
			this.treeview.append(data, parentNode);
		}
	}

	insertBefore(dataToPush, idToPushBack){
		var dataToPushBack = this.treeview.dataSource.get(idToPushBack);
		var dataToPushElement = this.treeview.findByUid(dataToPushBack.uid);
		this.treeview.insertBefore(dataToPush, dataToPushElement);
	}

	removeNode(id){
		var dataToRemove = this.treeview.dataSource.get(id);
		if(!_.isUndefined(dataToRemove)){
			var removeElement = this.treeview.findByUid(dataToRemove.uid);
			this.treeview.remove(removeElement);
		}
	}

	removeChildNodes(parentID){
		if(!_.isUndefined(this.treeview)){
			var parent = this.treeview.dataSource.get(parentID);
			var parentNode = this.treeview.findByUid(parent.uid);
			var selectedItem = this.treeview.dataItem(parentNode);
			if (selectedItem.hasChildren) {
				var items =  selectedItem.children.data();
				for (var i = 0,max = items.length;i < max;i++) {
					var item = this.treeview.findByUid(items[0].uid);
					this.treeview.remove(item);
				}
			}
		}
	}

	removeAllNodes(){
		this.treeview.dataSource.data([]);
	}

	clearAllTreeSelections(){
		var nodes = this.treeview.dataSource.view();
		this._unmarkAllNodes(nodes);
	}

	selectNode(id){
		var selectNode = this.treeview.dataSource.get(id);
		if(!_.isUndefined(selectNode)){
			var nodeElement = this.treeview.findByUid(selectNode.uid);
			this.treeview.select(nodeElement);
		}
	}

	selectNodeByName(nodeName){
		var nodeElement = this.treeview.findByText(nodeName);
		this.treeview.select(nodeElement);
	}

	isNodePresent(id){
		var nodeElement = this.treeview.dataSource.get(id);
		if(_.isUndefined(nodeElement)){
			return false;			//node with id not present
		}
		return true;
	}

	getNodeElementByID(id){
		var nodeElement = this.treeview.dataSource.get(id);
		if(_.isUndefined(nodeElement)){
			return 0;
		}else{
			return this.treeview.findByUid(nodeElement.uid);
		}
	}

	getSelectedNodeDetails(id){
		var node = this.getNodeElementByID(id);
		var selectedItem = this.treeview.dataItem(node);
		return selectedItem;
	}

	collapseAllNodes(){
		this.treeview.collapse(".k-item");
	}

	collapseSingleNodeByText(nodeText){
		this.treeview.collapse(treeview.findByText(nodeText));
	}

	collapseSingleNodeByID(id){
		this.treeview.collapse(this.getNodeElementByID(id));
	}

	expandPaths(IDArray){
		this.treeview.expandPath(IDArray);
	}

	expandNodeID(id){
		//default kendo tree expand function
		//If the node is already expanded, API call is not triggered.
		//Please use forceExpandNode, if you need to expand and trigger 
		//API call, whether or not the node was previously expanded.
		this.treeview.expand(this.getNodeElementByID(id));
	}

	expandNodeName(nodeName){
		this.treeview.expand(this.treeview.findByText(nodeName));
	}

	hasChildNodesPresent(id){
		var node = this.getNodeElementByID(id);
		if(node !== 0){
			return node[0].childNodes.length -1 > 0? true: false;
		}
		return false;
	}

	forceExpandNode(id){
		this._selectTree({node: this.getNodeElementByID(id)[0]});
		this.selectNode(id);
	}

	enableActionMenuOption(id) {
		if (this.treeContextMenu) {
			this.treeContextMenu.enable(id);
		}
		if (this.actionContextMenu) {
			this.actionContextMenu.enable(id);
		}
	}
   
	disableActionMenuOption(id) {
		if (this.treeContextMenu) {
			this.treeContextMenu.disable(id);
		}
		if (this.actionContextMenu) {
			this.actionContextMenu.disable(id);
		}
	}
   
	hideActionMenuOption(id) {
		if (this.treeContextMenu) {
			this.treeContextMenu.hide(id);
		}
		if (this.actionContextMenu) {
			this.actionContextMenu.hide(id);
		}
	}
   
	showActionMenuOption(id) {
		if (this.batchActionMenu) {
			this.batchActionMenu.show(id);
		}
		if (this.actionContextMenu) {
			this.actionContextMenu.show(id);
		}
	}

	getSelector() {
		return '#' + this.treeElement.attr('id');
	}

	getCheckedItems(getSelectedNodesHierarchy){
		getSelectedNodesHierarchy = getSelectedNodesHierarchy || false;
		var nodes = this.treeview.dataSource.view();
		return this._getCheckedNodes(nodes, getSelectedNodesHierarchy);
	}

	getCheckedItemsCount(){
		return this.getCheckedItems().length;
	}
	  
	refreshTree(hardReload){
		this.refreshStart = true;
		this.hardReload = hardReload || false;
		this.treeview.dataSource.read();
		// {
		// 	data: {
		// 		nodes: nodes
		// 	}
		// }
	}

	addTreeNodes(treeData, nodeID, noMoreChildNodes){
		noMoreChildNodes = noMoreChildNodes || false;
		if(this.options.enablePaging === true){
			this._checkPaging(treeData, noMoreChildNodes, nodeID);
		} else {
			this.pushData(treeData, nodeID);
			this.selectNode(nodeID);
		}
	}

	setChildCount(childCount, nodeID){
		if(_.isUndefined(nodeID)){
			let data = this.treeview.dataSource.data()[0];
			nodeID = _.get(this.headNodeDetails, this.options.idField, _.get(data, this.options.idField, ''));
			//nodeID = _.get(this.headNodeDetails, this.options.idField, '');
		}
		let currentSelectedItem = this.getSelectedNodeDetails(nodeID);
		currentSelectedItem.childCount = childCount;
	}

	getChildCount(nodeID){
		let currentSelectedItem = {};
		if(!_.isUndefined(nodeID)){
			currentSelectedItem = this.getSelectedNodeDetails(nodeID);
		}
		return _.get(currentSelectedItem, 'childCount', -1);
	}

	setExtraOptions(name, value){
		this.options[name] = value;
	}

	destroy() {
		super.destroy();
		if (this.tooltip) {
			this.tooltip.destroy();
		}
		if (this.actionContextMenu) {
			this.actionContextMenu.destroy();
		}
		this.treeview.destroy();

	}

	getParents(id){
		this.parentHierarchy = [];
		this._traverseParentRecur(id);
		return this.parentHierarchy;
	}

	_traverseParentRecur(id){
		var selectNode = this.treeview.dataSource.get(id);
		if(!_.isUndefined(selectNode)){
			this.parentHierarchy.push(selectNode);
			var nodeElement = this.treeview.findByUid(selectNode.uid);
			let parentEle = this.treeview.dataItem(this.treeview.parent(nodeElement));
			if(!_.isUndefined(parentEle)){
				this._traverseParentRecur(parentEle.id);
			}
		}
	}
	

}
