import KendoTree from './kendoTree';

import { cvCommonModule } from '../modules';

cvCommonModule.directive('cvKendoTree', [ 
	function() {
		return {
			restrict: 'E',
			transclude: true,
			templateUrl: appUtil.appRoot + 'common/partials/cv-kendo-tree.jsp',
			controllerAs: 'ctrl',
			bindToController: true,
			scope: {
				cvTreeOptions: '='
			},
			controller: ['$scope',	'cvLoc',
				function($scope, cvLoc) {
					this.$onInit = () => {
						$scope.initialize = ($tree, $treeEmptySvg) => {
							this.$tree = $tree;
							this.treeEmptySvg = $treeEmptySvg.html().trim();
							this.kendoTree = new KendoTree(
								{
									treeEmptySvg: this.treeEmptySvg,
									...this.cvTreeOptions
								},
								this.$tree,
								{
									cvLoc: cvLoc	
								}
							);

							$scope.$on('$destroy', () => {
								this.kendoTree.destroy();
							});
							this.kendoTree.build();
						};
						
						$scope.applyFilter = () => {
							this.kendoTree.applyFilter();
						};
					};
				}
			],
			link: function(scope, element, attrs, ctrl, transclude) {
				let $treeEmptySvg = element.find('[data-tree-empty-svg]');
				transclude(scope, function(clone) {
					$treeEmptySvg.append(clone);
				});
				const $tree = $(element).find('[cv-kendo-tree-container]');
				scope.initialize($tree, $treeEmptySvg);
			}
		};
	}
]);

export default cvCommonModule;
