/**
 * @author ssubash
 */
import GridDataSrc from '../gridDataSrc';

describe('Grid data source Filter tests', () => {
	let gridDataSrc;
	beforeEach('Grid initialization', () => {
		const options = {
			url: 'http:///',
			columns: {
				'jobSummary.jobId': {
					type: 'number',
					width: '50%',
					title: 'Suman'
				},
				'jobSummary.clientName': {
					type: 'string',
					width: '50%',
					title: 'clientName'
				}
			}
		};
		gridDataSrc = new GridDataSrc(options, kendo);
	});

	it('should return empty filters', () => {
		expect(gridDataSrc.getAllFilters()).to.be.equals('');
	});

	it('should return single filter when selecting single filter', () => {
		gridDataSrc.dataSource.filter({
			field: 'jobSummary.jobId',
			operator: 'startswith',
			type: 'string',
			value: 'hello'
		});
		const result = '[{"value":"hello","key":"jobSummary.jobId"}]';
		expect(gridDataSrc.getAllFilters()).to.be.equals(result);
	});
});

describe('Grid push notification tests', () => {
	let gridDataSrc;
	beforeEach('Grid initialization', () => {
		const options = {
			id: 'id',
			data: [
				{
					id: 1,
					text: 'hello'
				},
				{
					id: 2,
					text: 'pp'
				}
			],
			columns: {
				id: {
					type: 'number',
					width: '50%',
					title: 'Id'
				},
				text: {
					type: 'string',
					width: '50%',
					title: 'Text'
				}
			}
		};
		gridDataSrc = new GridDataSrc(options, kendo);
	});

	it('should return the size of the model as 2', done => {
		gridDataSrc.dataSource.fetch(() => {
			expect(gridDataSrc.dataSource.data().length).to.be.equal(2);
			done();
		});
	});

	it('should return the size of the model as 3 when push notification sends data', () => {
		gridDataSrc.dataSource.read();
		gridDataSrc.dataSource.pushUpdate([
			{id: 1, text: 'play'},
			{id: 3, text: 'power'}
		]);
		expect(gridDataSrc.dataSource.data().length).to.be.equal(3);
		expect(gridDataSrc.dataSource.data().at(0).text).to.be.equal('play');
	});

	it('should remove the result once completed', () => {
		gridDataSrc.dataSource.read();
		gridDataSrc.dataSource.pushDestroy([{id: 1, text: 'play'}]);
		expect(gridDataSrc.dataSource.data().length).to.be.equal(1);
	});
});

describe('Grid sorting tests', () => {
	let gridDataSrc;
	beforeEach('Grid initialization', () => {
		const options = {
			id: 'id',
			sortable: true,
			sortDir: {field: 'text', dir: 'desc'},
			data: [
				{
					id: 1,
					text: 'hello'
				},
				{
					id: 2,
					text: 'pp'
				}
			],
			columns: {
				id: {
					type: 'number',
					width: '50%',
					title: 'Id'
				},
				text: {
					type: 'string',
					width: '50%',
					title: 'Text'
				}
			}
		};
		gridDataSrc = new GridDataSrc(options, kendo);
	});

	it('should be in sorted order', done => {
		gridDataSrc.dataSource.fetch(function() {
			const data = gridDataSrc.dataSource.view();
			expect(gridDataSrc.dataSource.data().at(0).text).to.be.equal('pp');
		});
	});
});
