/**
 * Tooltip is using the plugin architecture of the grid.
 * @author ssubash
 */
import Tooltip from '../../tooltip';

export class TooltipPlugin {
    constructor(options) {
        this.options = options;
    }

    apply(grid){
        let tooltip;
        grid.hooks.postBuild.tap("TooltipPlugin", function(){
            tooltip = new Tooltip(grid.gridElement);
			tooltip.build();
        });

        grid.hooks.destroy.tap("TooltipPlugin", function(){
            if (tooltip) {
                tooltip.destroy();
            }
        });
    }
}