/**
 * Dragdrop is using the plugin architecture of the grid.
 * @author ssubash
 */
import DragDrop from '../../dragdrop';

export class DragDropPlugin {
    constructor(options) {
        this.options = options;
    }

    apply(grid){
        const self = grid;
        let dragDrop;
        grid.hooks.postBuild.tap("DragDropPlugin", function(){
            if (grid.options.enableRowReordering) {
                const options = {
                    filter: '>tbody >tr',
                    placeholder(element) {
                        return $('<tr colspan="4" class="placeholder"></tr>');
                    },
                    cursor: 'move',
                    container: 'cv-kendo-grid tbody',
                    change(event) {
                        const skip = self.grid.dataSource.skip(),
                            oldIndex = event.oldIndex + skip,
                            newIndex = event.newIndex + skip,
                            data = self.grid.dataSource.data(),
                            dataItem = self.grid.dataSource.getByUid(event.item.data('uid'));
    
                        self.grid.dataSource.remove(dataItem);
                        self.grid.dataSource.insert(newIndex, dataItem);
                    },
                    hint(element) {
                        const style = 'width: ${self.width}px;';
                        const table = $(`<table style=${style} class="k-grid k-widget"></table>`);
                        table.append(element.clone());
                        table.css('opacity', 0.8);
                        return table;
                    }
                };
                dragDrop = new DragDrop(grid.grid.table, options);
                dragDrop.build();
            }
        });

        grid.hooks.destroy.tap("DragDropPlugin", function(){
            if(dragDrop) {
                dragDrop.destroy();
            }
        });
    }
}