/**
 * @author ssubash
 * This represents the View for a grid. Right now its coupled to the
 * grid. We need to decouple this.
 */
import GridColumn from './gridColumn';
import ColumnFilter from './columnFilter';

const GRID_VIEW_PATIAL_PATH = 'common/js/newGrid/createView.jsp';

export const createView = ($modal, viewSelectedId, grid, cvToaster) => {
	const modalInstance = $modal.open({
		templateUrl: appUtil.appRoot + GRID_VIEW_PATIAL_PATH,
		backdrop: 'static',
		controller: [
			'$scope',
			'$timeout',
			'$uibModalInstance',
			'$compile',
			'cvLoc',
			'cvUtil',
			'isDefaultView',
			'systemViewNames',
			'currentViewObj',
			'columns',
			function(
				$scope,
				$timeout,
				$uibModalInstance,
				$compile,
				cvLoc,
				cvUtil,
				isDefaultView,
				systemViewNames,
				currentViewObj,
				columns
			) {
				const self = this;
				this.grid = grid;
				this.$scope = $scope;
				this.$timeout = $timeout;
				this.$uibModalInstance = $uibModalInstance;
				this.cvUtil = cvUtil;
				this.cvLoc = cvLoc;
				$scope.selectedItems = {};
				$scope.prevSelectedItems = {};
				$scope.editMode = !_.isEmpty(currentViewObj);
				$scope.columns = columns.filter(column => {
					const columnOptions = grid.options.columns[column.field];
					return columnOptions && columnOptions.filterType !== false && !columnOptions.disableViewFiltering;
				});
				$scope.ruleOptionVisible = {};
				$scope.columns.forEach(column => {
					$scope.ruleOptionVisible[column.field] = true;
				});
				$scope.columnFilters = {};
				$scope.isDefaultView = isDefaultView;
				$scope.init = _init.apply(this, [currentViewObj]);
				$scope.createView = _createView.bind(self, currentViewObj);
				$scope.addNewRule = _addNewRule.bind(self);
				$scope.removeRule = _removeRule.bind(self);
				$scope.changeRule = _changeRule.bind(self);
				$scope.isRuleOptionVisible = _isRuleOptionVisible.bind(self);
				$scope.clearAll = _clearAll.bind(self);
				$scope.cancel = function() {
					$uibModalInstance.dismiss();
				};
			}
		],
		resolve: {
			systemViewNames: function() {},
			currentViewObj: function() {
				return !_.isEmpty(viewSelectedId) ? grid.getViewSvc().getView(viewSelectedId) : null;
			},
			columns: function() {
				return grid.getColumns();
			},
			//TODO
			//   getAdvancedFilter: function() {
			//       return $scope.getAdvancedFilter.bind(this,$scope.cvGridOptions.cvAdvancedFilters);
			//   },
			isDefaultView: function() {
				return viewSelectedId === grid.getViewSvc().getDefaultViewId();
			},
			kendoGridOptions: function() {}
		}
	});

	return modalInstance.result.then(function(viewObj) {
		if (!viewSelectedId) {
			grid.getViewSvc().saveView(viewObj, cvToaster, grid.options);
		} else {
			grid.getViewSvc().editView(viewObj, cvToaster, grid.options);
		}
	});
};

/**
 * TODO:
 * This function initializes the modal.
 * @param {} currentViewObj
 */
const _init = function(currentViewObj) {
	const name = currentViewObj ? currentViewObj.name : '';
	this.$scope.model = {};
	this.$scope.model.viewName = decodeURIComponent(name);
	this.$scope.model.isDefault = this.$scope.isDefaultView;
	this.$scope.modifiedRules = [];

	if (name) {
		_addExistingRule.call(this, currentViewObj);
		return;
	}

	if (_noRulePresent(this.$scope.modifiedRules)) {
		_addNewRule.call(this);
	}
};

/**
 * This is used to create the view
 */
const _createView = function(currentViewObj) {
	this.$scope.serverMessage = this.cvUtil.emptyMsg();
	//TODO: Overwrite denied
	//   if (isViewMode && systemViewNames.includes(this.$scope.model.viewName)) {
	//     this.$scope.serverMessage = this.cvUtil.errMsgLoc("error.overwriteDenied");
	//   }
	const self = this;
	const newRules = _.map(this.$scope.modifiedRules, rule => {
		const columnFilter = self.$scope.columnFilters[rule.column.field];
		columnFilter.applyInputValue();
		return {
			columnName: rule.column.viewKey ? rule.column.viewKey : rule.column.field,
			filterValue: columnFilter.toViewValue(),
			filterCondition: rule.filterCondition
		};
	});

	if (newRules.find(rule => _.isEmpty(rule.filterValue))) {
		this.$scope.serverMessage = this.cvUtil.errMsgLoc('error.emptyRule');
		return;
	}
	const viewObj = {};
	viewObj.name = encodeURIComponent(this.$scope.model.viewName);
	viewObj.id = currentViewObj ? currentViewObj.id : Date.now();
	viewObj.isDefault = this.$scope.model.isDefault;
	viewObj.filters = newRules;
	this.$uibModalInstance.close(viewObj);
};

const _isRuleOptionVisible = function(ruleId) {
	return function(column) {
		return this.$scope.ruleOptionVisible[column.field] || column.field === this.$scope.selectedItems[ruleId].field;
	}.bind(this);
};

/**
 * To add a new Rule to the view
 */
const _addNewRule = function() {
	const column = this.$scope.columns.find(col => this.$scope.ruleOptionVisible[col.field]);
	return _addToModifiedRule.call(this, column);
};

const ID = function() {
	return (
		'_' +
		Math.random()
			.toString(36)
			.substr(2, 9)
	);
};

const _getFilterConditionOptions = (columnFilter, enableServerLoading) => {
	if (!columnFilter) {
		return enableServerLoading ? [ColumnFilter.DEFAULT_FILTER_CONDITION] : ColumnFilter.FILTER_CONDITION_OPTIONS;
	}
	return columnFilter.getFilterConditionOptions();
};

const _addExistingRule = function(customViewObj) {
	const self = this;

	customViewObj.filters.map(filter => {
		self.$scope.columns.map(column => {
			if (column.field === filter.columnName || column.viewKey === filter.columnName) {
				const id = ID();
				const filterConditionOptions = _getFilterConditionOptions(
					column.columnFilter,
					this.grid.options.enableServerLoading
				);
				let filterCondition = filter.filterCondition;
				if (
					!filterCondition ||
					!column.columnFilter ||
					!filterConditionOptions.some(option => option.value === filterCondition)
				) {
					// Use default option if filterCondition is invalid
					filterCondition = filterConditionOptions[0].value;
				}
				self.$scope.modifiedRules.push({
					id,
					column,
					filterCondition,
					filterConditionOptions,
					colScope: undefined
				});
				this.$scope.selectedItems[id] = column;
				this.$scope.prevSelectedItems[id] = column;
				this.$timeout(() => {
					initComponent.call(self, column, id, filter.filterValue);
				});
			}
		});
	});
};

const _changeRule = function(rule) {
	if (!rule) {
		return;
	}
	const column = this.$scope.selectedItems[rule.id];
	const prevColumn = this.$scope.prevSelectedItems[rule.id];
	if (!column) {
		this.$scope.selectedItems[rule.id] = prevColumn;
		return;
	}
	rule.column = column;

	this.$scope.ruleOptionVisible[prevColumn.field] = true;

	// Remove the input for the previous selected column and initialize
	// the input for the new one:
	__emptyDomRule__.call(this, prevColumn, rule.id);
	initComponent.call(this, column, rule.id, '');

	this.$scope.prevSelectedItems[rule.id] = column;

	// Set the filterConditionOptions:
	rule.filterConditionOptions = _getFilterConditionOptions(column.columnFilter, this.grid.options.enableServerLoading);
	if (
		!rule.filterCondition ||
		!column.columnFilter ||
		!rule.filterConditionOptions.some(option => option.value === rule.filterCondition)
	) {
		// Use default option if filterCondition is invalid
		rule.filterCondition = rule.filterConditionOptions[0].value;
	}
};

const _removeRule = function(rule) {
	_.remove(this.$scope.modifiedRules, item => item.id === rule.id)[0];
	const column = this.$scope.selectedItems[rule.id];
	this.$scope.ruleOptionVisible[column.field] = true;
	this.$scope.addRuleDisabled = false;
	delete this.$scope.selectedItems[rule.id];
	delete this.$scope.prevSelectedItems[rule.id];
};

/**
 *
 */
const initComponent = function(column, index, filterValue) {
	const element = $(`#ruleFilter-${index}`);
	const columnOptions = this.grid.options.columns[column.field] || {};
	// Get the filter data values:
	let data = _.get(column, 'columnFilter.dataSrc.data');
	if (_.isEmpty(data)) {
		const dataSource = this.grid.gridDataSrc.getDataSource();
		data = _initializeDataSource(dataSource, column.field);
	}

	const options = {
		...columnOptions,
		data: data
	};
	const columnFilter = GridColumn.createColumnFilter({
		options: {
			...options,
			popup: null, // If applicable, use default kendo popup positioning
			animation: null, // If applicable, use default kendo animations
			enableFilterConditionDropdown: false, // modal will init its own filter condition dropdown
			// TODO re-use columnFilter's dropdown
		},
		enableServerLoading: this.grid.enableServerLoading,
		angularLibs: {
			$filter: this.grid.angularLibs.$filter,
			$modal: this.grid.angularLibs.$modal,
			cvLoc: this.grid.angularLibs.cvLoc
		}
	});
	columnFilter.build(element);
	this.$scope.columnFilters[column.field] = columnFilter;
	if (columnFilter instanceof ColumnFilter.GenericColumnFilter) {
		const input = $(`<input id="ruleFilter-${index}" type="text" class="grid-rule-input" />`);
		input.change(() => {
			columnFilter.onFilterInputChange();
		});
		input.on('input', columnFilter.onFilterInputChange);
		input.on('blur', columnFilter.onFilterInputChange);
		input.on('change', columnFilter.onFilterInputChange);
		columnFilter.element.replaceWith(input);
		columnFilter.element = input;
	}
	columnFilter.fromViewValue(filterValue);
	this.$scope.ruleOptionVisible[column.field] = false;
	this.$scope.addRuleDisabled = _.every(this.$scope.ruleOptionVisible, visible => !visible);
};

/**
 * Utility function which is used to add a modified rule.
 * @param {*} column
 */
const _addToModifiedRule = function(column) {
	const id = Date.now();
	const self = this;
	const filterConditionOptions = _getFilterConditionOptions(column.columnFilter, this.grid.options.enableServerLoading);
	this.$scope.modifiedRules.push({
		id,
		column,
		filterCondition: filterConditionOptions[0].value,
		filterConditionOptions,
		colScope: undefined
	});
	this.$scope.selectedItems[id] = column;
	this.$scope.prevSelectedItems[id] = column;
	this.$timeout(() => {
		initComponent.call(self, column, id, '');
	});
	return this.$scope.modifiedRules;
};

const _initializeDataSource = (dataSource, field) => {
	return _.map(_.filter(_.uniq(_.map(dataSource.data(), item => _.get(item, field)))), item => ({
		label: item,
		value: item
	}));
};

const __emptyDomRule__ = function(column, index) {
	index = index < 0 ? 0 : index;
	this.$scope.columnFilters[column.field].destroy();
	delete this.$scope.columnFilters[column.field];
	$(`#ruleFilter-${index}_wrapper`).empty();
	$(`#ruleFilter-${index}_wrapper`).append(`<div id="ruleFilter-${index}"></div>`);
};

const _clearAll = function() {};

const _noRulePresent = function(modifiedRules) {
	return modifiedRules.length === 0;
};
