export const deleteView = function($modal, userPrefService, selectedViewId, cvToaster, cvLoc, options, grid) {
	const modalInstance = $modal.open({
		templateUrl: appUtil.appRoot + 'common/partials/deleteView.jsp',
		backdrop: 'static',
		controller: [
			'$scope',
			'$uibModalInstance',
			'cvLoc',
			'userViews',
			'currentViewId',
			function($scope, $modalInstance, cvLoc, userViews, currentViewId) {
				const decodedViews = userViews.map(cur => {
					const obj = angular.copy(cur);
					obj.name = decodeURIComponent(obj.name);
					return obj;
				});
				$scope.model = {
					views: decodedViews,
					selectedViewId: currentViewId
				};

				$scope.deleteView = function() {
					$modalInstance.close($scope.model.selectedViewId);
				};

				$scope.cancel = function() {
					$modalInstance.dismiss();
				};
			}
		],
		resolve: {
			userViews: function() {
				return Object.keys(grid.getViewSvc().getTablePrefs().views)
					.filter(viewId => grid.getViewSvc().getView(viewId).canBeDeleted)
					.map(viewId => grid.getViewSvc().getView(viewId));
			},
			currentViewId: function() {
				return selectedViewId;
			}
		}
	});

	return modalInstance.result.then(viewId => {
		return userPrefService
			.deleteTableView(options.tableName, viewId)
			.success(() => {
				if (selectedViewId === viewId) {
					grid.getViewSvc().updateTablePrefs(true, null);
				} else {
					grid.getViewSvc().updateTablePrefs(true, selectedViewId);
				}
			})
			.error(() => {
				cvToaster.showErrorMessage({
					ttl: '3000', //3 sec
					message: cvLoc('error.deleteViewFailed')
				});
			});
	});
};
