export const customDateTime = function($modal, showFromTime) {
	const modalInstance = $modal.open({
		templateUrl: appUtil.appRoot + 'common/js/newGrid/customTimePickerDialog.jsp',
		backdrop: 'static',
		windowClass: 'small-size grid-date-picker',
		controller: [
			'$scope',
			'$uibModalInstance',
			'cvLoc',
			function($scope, $modalInstance, cvLoc) {
				const checkSameDay = () => {
					return (
						$scope.datepicker.from.value.getDay() === $scope.datepicker.to.value.getDay() &&
						$scope.datepicker.from.value.getMonth() === $scope.datepicker.to.value.getMonth() &&
						$scope.datepicker.from.value.getYear() === $scope.datepicker.to.value.getYear()
					);
				};

				$scope.datepicker = {
					from: {
						open: false,
						dateOptions: {
							dateFormat: 'yyyy-MM-dd',
							showWeeks: false
						},
						timeOptions: {
							get max() {
								if (checkSameDay()) {
									return $scope.datepicker.to.value;
								}
								return undefined;
							}
						},
						get value() {
							return $scope.datepicker.from._value;
						},
						set value(val) {
							if (!val || val >= $scope.datepicker.to.value) {
								$scope.datepicker.from._value = new Date($scope.datepicker.to.value);
								$scope.datepicker.from._value.setMinutes($scope.datepicker.to.value.getMinutes() - 1);
							} else {
								$scope.datepicker.from._value = val;
							}
						}
					},
					to: {
						open: false,
						dateOptions: {
							dateFormat: 'yyyy-MM-dd',
							showWeeks: false
						},
						timeOptions: {
							get min() {
								if (checkSameDay()) {
									return $scope.datepicker.from.value;
								}
								return undefined;
							}
						},
						get value() {
							return $scope.datepicker.to._value;
						},
						set value(val) {
							if (!val || val <= $scope.datepicker.from.value) {
								$scope.datepicker.to._value = new Date($scope.datepicker.from.value);
								$scope.datepicker.to._value.setMinutes($scope.datepicker.from.value.getMinutes() + 1);
							} else {
								$scope.datepicker.to._value = val;
							}
						}
					}
				};

				if (showFromTime !== undefined) {
					$scope.datepicker.showFromTime = showFromTime;
				} else {
					$scope.datepicker.showFromTime = true;
				}
				$scope.clear = function() {
					$scope.datepicker.from._value = new Date();
					$scope.datepicker.from._value.setSeconds(0, 0);
					$scope.datepicker.to._value = new Date();
					$scope.datepicker.to._value.setSeconds(59, 999);
					$scope.datepicker.from.value.setHours($scope.datepicker.from.value.getHours() - 1);
				};

				$scope.clear(); // TODO nsicoco load from current filter

				$scope.addCustom = function() {
					$modalInstance.close();
				};

				$scope.open = function(datepickerObj) {
					datepickerObj.open = !datepickerObj.open;
				};

				$scope.openFrom = function() {
					$scope.datepicker.from.dateOptions.maxDate = $scope.datepicker.to.value;
					$scope.open($scope.datepicker.from);
				};

				$scope.openTo = function() {
					$scope.datepicker.to.dateOptions.minDate = $scope.datepicker.from.value;
					$scope.open($scope.datepicker.to);
				};

				$scope.cancel = function() {
					$modalInstance.dismiss();
				};

				$scope.saveDateRange = function() {
					$modalInstance.close({
						from: $scope.datepicker.from.value,
						to: $scope.datepicker.to.value
					});
				};
			}
		],
		resolve: {
			// TODO nsicoco load current range
		}
	});

	return modalInstance.result.then(function(result) {
		return result;
	});
};
