(function() {
	'use strict';

	angular.module('cvLocalization', []).filter('i18n', [ 'localMsg', 'cvLoc', function(localMsg, cvLoc) {
		return cvLoc;
	} ]);

	// this can be in a separate file, but should load after the filter is loaded
	angular.module('cvLocalization').value('localMsg', localMsg);

	angular.module('cvLocalization').factory('cvLoc', [ 'localMsg', function(localMsg) {
		return function(text, returnNullIfNotFound) {
			var result = '';
			if (localMsg.hasOwnProperty(text)) {
				result = localMsg[text];
			} else {
				if (!!returnNullIfNotFound) {
					return null;
				}
				result = '???' + text + '???';
			}

			if (arguments.length > 1) {
				for (var i = 0; i < arguments.length - 1; i++) {
					result = result.replace('{' + i + '}', arguments[i + 1]);
				}
			}
			return result;
		};
	} ]);
})();