var HashMap = (function() {
	function HashMap() {
		this.keys = new Array();
	}

	HashMap.prototype.put = function(key, value) {
		this[key] = value;
		if (this.keys.indexOf(key) == -1) {
			this.keys.push(key);
		}
	};

	HashMap.prototype.get = function(key) {
		if (typeof this[key] == 'undefined') {
			return null;
		}
		return this[key];
	};

	HashMap.prototype.remove = function(key) {
		var index = this.keys.indexOf(key);
		if (index > -1) {
			this.keys.splice(index, 1);
			var value = this[key];
			delete this[key];

			return value;
		}
		return null;
	};

	HashMap.prototype.clear = function() {
		while (this.keys.length > 0) {
			var key = this.keys.pop();
			delete this[key];
		}
		delete this.keys;
		this.keys = new Array();
		return true;
	};

	HashMap.prototype.size = function() {
		return this.keys.length;
	};

	HashMap.prototype.getKeys = function() {
		return this.keys;
	};

	return HashMap;
})();