/**
 * @author: suman
 * Global error handling
 */
export const chrome = /^\s*at (.*?) ?\(((?:file|https?|blob|chrome-extension|native|eval|webpack|<anonymous>|\/).*?)(?::(\d+))?(?::(\d+))?\)?\s*$/i;

export const firefox = /^\s*(.*?)(?:\((.*?)\))?(?:^|@)((?:file|https?|blob|chrome|webpack|resource|\[native).*?|[^@]*bundle)(?::(\d+))?(?::(\d+))?\s*$/i;

export const ie = /^\s*at (?:((?:\[object object\])?.+) )?\(?((?:file|ms-appx|https?|webpack|blob):.*?):(\d+)(?::(\d+))?\)?\s*$/i;

export const firefoxEval = /(\S+) line (\d+)(?: > eval line \d+)* > eval/i;

export const chromeEval = /\((\S*)(?::(\d+))(?::(\d+))\)/;

export const reference = error => /^(.*) is undefined$/.exec(error.message);

export const UNKNOWN_FUNCTION = "?";
