(function() {
	'use strict';

	var commonMod = angular.module('cvCommon');
	commonMod
			.service('footerService', [ '$http', function($http) {
				this.showQuickSetup = function() {
					return $http.get('showQuickSetup.do');
				}

				this.setShowLicenseWarningsForUser = function(showWarning) {
					return $http.post('setShowLicenseWarningsForUser.do', {
						'showLicenseWarning' : showWarning
					});
				};

				this.getShowLicenseWarningsForUser = function() {
					return $http.get('getShowLicenseWarningsForUser.do');
				};

				this.getCommcellUrls = function() {
					return $http.get('api/CommcellRedirect/Multicommcell', httpHeader.jsonDefaultHeader);
				};
			}

			])
			.controller(
					'footerController',
					[
							'$scope',
							'footerService',
							'userPrefService',
							'cvUtil',
							'$uibModal',
							'cvToaster',
							'cvLoc',
							'multiCommcellFactory',
							'$rootScope',
							function($scope, footerService, userPrefService, cvUtil, $modal, cvToaster, cvLoc,
									multiCommcellFactory, $rootScope) {
								$scope.showSetup = false;

								$scope.showQuickSetup = function() {
									footerService.showQuickSetup().success(function(data) {
										$scope.showSetup = data;
									}).error(function(e) {
										$scope.showSetup = false;
									})
								};

								function setupRegisteredCommcellUrls() {
									footerService.getCommcellUrls().then(
											function(result) {
												result = _.get(result, 'data');
												let commcells = _.get(result, 'serviceCommcell', []);
												let idpCommcell = _.get(result, 'IDPCommcell', {});
												idpCommcell.isIdp = true;
												commcells.push(idpCommcell);
												let commcellUrls = {};
												_.forEach(commcells, function(commcell) {
													_.set(commcell, 'webconsoleUrl', _.get(commcell, 'webUrl'));
													_.set(commcell, 'baseUrl', _.replace(
															_.get(commcell, 'webUrl'),
															'/webconsole',
															'/'));
													_.set(commcell, 'webUrl', _.replace(
															_.get(commcell, 'webUrl'),
															'/webconsole',
															'/adminconsole/'));
													const commcellName = _.get(commcell, 'commcell.commCellName');
													commcellUrls[commcellName] = commcell;
												});
												// Hack: setting global variable here so that it can be used everywhere
												cv.commcellUrls = commcellUrls;
												cv.cometTarget = cv.isCometApp ? '_blank' : '_self';
												cv.IDPCommcell = _.find(commcellUrls, 'isIdp');
												multiCommcellFactory.redirectToCCIfNotGlobal();
											});
								}

								setupRegisteredCommcellUrls();

								/*
								 * Update commcell Urls when a commcell is added or deleted based on events
								 * emitted from commcellRegistrationFactory
								 */
								$rootScope.$on('commcellDeleted', setupRegisteredCommcellUrls);
								$rootScope.$on('commcellAdded', setupRegisteredCommcellUrls);

								var checkValueFromExisted = function(key) {
									var userPref = false;
									var cookie = cvUtil.readCookie(key);
									if (angular.isDefined(cv) && angular.isObject(cv) && angular.isDefined(cv.userPref)
											&& angular.isObject(cv.userPref) && angular.isDefined(cv.userPref[key])) {
										userPref = (cv.userPref[key] == "1");
									}

									cookie = (cookie === "true");

									return cookie || userPref;

								}

								var modalController = function($scope, $modalInstance, cvUtil, cvLoc, showCheckbox,
										saveDir, textObj, footerService) {
									$scope.title = textObj.title;
									$scope.message = textObj.msg;
									$scope.checkboxSet = {
										show : showCheckbox,
										value : false
									}
									$scope.acknowledge = function() {
										if ($scope.checkboxSet.value) {
											userPrefService.setBooleanUserPref(saveDir.key, $scope.checkboxSet.value)
													.error(function(err) {
														console.log("Creating userprefs failed");
													});
										}

										cvUtil.writeCookie(saveDir.key, "true", "", "", saveDir.path);
										footerService.setShowLicenseWarningsForUser(false).success(function() {
											$modalInstance.close();
										}).error(function(err) {
											console.log("Creating userpref for license warning failed");
										});

									}

								}

								var showLabelwithExpiryDate = function(email) {

									var freeTrialLabel = "";
									var textObj_evaluation;
									var showMsg;
									var dirObj_evaluation = new DirObj('evaluationAcknowledged', cv.contextPath);

									footerService.getShowLicenseWarningsForUser().success(
											function(responseData) {
												showMsg = responseData;

												if (showMsg) {
													if (cvApp.licenseExpiryDate === 0) {
														if (cvApp.licenseMode === 'EVALUATION') {
															freeTrialLabel = cvLoc('label.licenseExpired') + " "
																	+ cvLoc('label.toOrderEmail', email);
														}
													} else {
														var dateExp = cvUtil
																.getDateforLicenseExpiry(cvApp.licenseExpiryDate);
														var dateDiff = cvUtil
																.getDaysforLicenseExpiry(cvApp.licenseExpiryDate);

														var isLicenseExpired = cvUtil
																.isLicenseExpired(cvApp.licenseExpiryDate);

														if (cvApp.licenseMode === 'EVALUATION') {
															freeTrialLabel = cvLoc(
																	'label.evaluationTextContent',
																	dateExp,
																	email);
															textObj_evaluation = new TextObj(
																	freeTrialLabel,
																	cvLoc('label.licenseTitle'));

														} else {

															if (isLicenseExpired) {
																freeTrialLabel = cvLoc('label.permanentlicenseExpired')
																		+ " " + cvLoc('label.toRenewEmail', email);

															} else if (dateDiff <= 60) //only show expiration warnings if production license expires within 60 days
															{

																freeTrialLabel = cvLoc(
																		'label.leaseTextContent',
																		dateExp,
																		email);

															}
														}
													}
													if (freeTrialLabel) {
														textObj_evaluation = new TextObj(
																freeTrialLabel,
																cvLoc('label.licenseTitle'));
														$modal.open(new ModalSettings(
																textObj_evaluation,
																dirObj_evaluation,
																false));
													}

												}
											}).error(function(err) {
										$scope.fetchError = err;
									});

									return;
								}

								var ModalSettings = function(textObj, saveDir, showCheckbox) {
									this.templateUrl = appUtil.appRoot + 'common/partials/customStartupMessage.jsp';
									this.backdrop = 'static';
									this.windowClass = 'confirm-dialog';
									this.controller = [
											'$scope',
											'$uibModalInstance',
											'cvUtil',
											'cvLoc',
											'showCheckbox',
											'saveDir',
											'textObj',
											'footerService',
											modalController ];
									this.resolve = {
										showCheckbox : function() {
											return showCheckbox;
										},
										saveDir : function() {
											return saveDir;
										},
										textObj : function() {
											return textObj;
										}
									}
								}

								var TextObj = function(msg, title) {
									this.title = title, this.msg = msg;
								}

								var DirObj = function(key, path) {
									this.key = key, this.path = path;
								}

								// commenting this call, not used anymore. leaving it in here for future use.
								//$scope.showQuickSetup();
								//if customStartupMessage is present and the user has not acknowledged it, then display it
								if (cvConfig && cvConfig.enableCustomStartupMessage && cv.additionalSettings
										&& cv.additionalSettings.Console
										&& cv.additionalSettings.Console.CustomStartUpMessage) {
									var textObj_custom = new TextObj(cv.additionalSettings.Console.CustomStartUpMessage);
									var dirObj_custom = new DirObj('showCustomStartupMessageAcknowledged');

									if (!checkValueFromExisted(dirObj_custom.key)) {
										$modal.open(new ModalSettings(textObj_custom, dirObj_custom, false));
									}

								}
								if (cv.isMspAdmin) {
									var regUrl = '<a target="_blank" href="https://ma.commvault.com/Support/ProductRegistration">'
											+ cvLoc('info.registrationForm') + '</a>';

									showLabelwithExpiryDate(regUrl);

								}
							} ]);
})();
