
import ContextMenu from 'common/js/kendocontextmenu';
const app = angular.module('cvCommon');

const UserSettingDropdown = [
    function() {
        return {
            restrict: 'E',
            templateUrl: appUtil.appRoot + 'common/partials/userSettingsDropdown.jsp',
            replace: true,
            bindToController : true,
            controllerAs: 'ctrl',
            controller: [
                'userPrefService','settingsService', 'cvToaster', 'cvLoc', '$uibModal','$dialogs', '$location','USER_SETTINGS',
                function (userPrefService, settingsService, cvToaster, cvLoc, $modal, $dialogs, $location,USER_SETTINGS) {
                    const ctrl = this;
                    const HIDE_COMMCELL_DROPDOWN = "hideCommcellDropdown";
		            const HIDE_COMPANY_DROPDOWN = "hideCompanyDropdown";
                    this.$onInit = () => {

                        ctrl.showFeedback = cvConfig.showFeedback;
                        
                        ctrl.openSessionLockModal = (fwdSc) =>{
                            $modal.open({
                                templateUrl : appUtil.appRoot + 'modules/settings/partials/sessionLockModal.jsp',
                                backdrop : 'static',
                                keyboard : false,
                                controllerAs : 'dcmCtrl',
                                windowClass : 'confirm-dialog sessionLockModal',
                                size : 'sm',
                                controller: ['$uibModalInstance', 'settingsService', function ($uibModalInstance, settingsService){
                                    this.save = () =>{
                                        this.notValidpwd = false;
                                        // const pwd = btoa(this.userConfirm);
                                        settingsService.unLockSession(btoa(this.userConfirm)).success(result=>{
                                            if (result === 'success'){
                                                $uibModalInstance.dismiss();
                                                if (!!fwdSc){location.href="/adminconsole";}
                                            }else{
                                                this.notValidpwd = true;
                                            }
                                        }).error(e=>{
                                            this.notValidpwd = true;
                                        })
                                    }

                                    this.close = () =>{
                                        location.href = 'logout.do';
                                    }
                                }],
                                resolve: {
                                    fwdOnSuccess: function() {
                                        return  fwdSc || false;
                                    }
                                }
                            })
                        }

                        ctrl.showErrormsg = (err) =>{
                            cvToaster.showErrorMessage({
                                'ttl': '5000', //5 sec
                                'message': err
                            });
                        }

                        ctrl.setAccessiblity = (enableAcbility)=>{
                            $dialogs.confirm(cvLoc('label.accessibilityMode'), enableAcbility ? cvLoc(
                                'label.turnOnAccessibilityConfirmation'): cvLoc('label.turnOffAccessibilityConfirmation'), {
                                noFunction : function() {
                                },

                                yesFunction : function() {
                                    userPrefService.setBooleanUserPref('cvAccessibility', enableAcbility).success(result=>{
                                        userPrefService.updateUserPrefs().success(updateResult =>{
                                            location.reload();
                                        }).error((errUpdate)=>{
                                            ctrl.showErrormsg(errUpdate);
                                        })
                                    }).error(err=>{
                                        ctrl.showErrormsg(err);
                                    })
                                }
                            });



                        }

                        ctrl.setLocksession = () =>{
                            settingsService.lockSession().success(result => ctrl.openSessionLockModal()).error(e => ctrl.showErrorMessage(e));
                        }

                        $(document).on('keydown', function (e) {
                            if (e.altKey == true && e.keyCode === 191) {
                                ctrl.setAccessiblity(!ctrl.enableAcbility);
                            }
                        });

                        ctrl.setLocale = (locale) => {
                            settingsService.setLocaleName(locale).success(data=>{
                                location.reload();
                            }).error(e=>{
                                ctrl.showErrorMessage(cvLoc('error.getLocale'));
                            })
                        }

                        ctrl.openAboutModal = ()=>{
                            $modal.open({
                                templateUrl: appUtil.appRoot + 'common/partials/aboutTemplate.jsp',
                                backdrop: 'static',
                                windowClass: 'confirm-dialog',
                                controller: [
                                    '$scope','$uibModalInstance','settingsService',
                                    function ($scope, $modalInstance, settingsService) {
                                        $scope.ok = function () {
                                            $modalInstance.close();
                                        };
                                        settingsService.getCommserveDetails().success(function (responseData) {
                                            $scope.versionDetails = responseData;
                                        }).error(function (err) {
                                            $scope.fetchError = err;
                                        });
                                    }]
                            });
                        }

                        ctrl.changeLocalefromParent = ()=>{
                            window.addEventListener('message', (e)=>{
                                console.log("CHANGE LOCALE FROM PARENT: ", e.data);
                                const data = _.get(e,'data',{type: '', language: ''});
                                if (data.type === 'languageSelection' && data.language !== '') {
                                    ctrl.setLocale(data.language);
                                }
                            })
                        }

                        ctrl.onActionItemSelect = (data) => {
                            if (!data.optionId) {
                                return;
                            }
                            const menu = _.last(data.optionId.split('-'));
                            switch (menu) {
                                case 'lang': return;
                                case 'lock': ctrl.setLocksession(); return;
                                case 'about': ctrl.openAboutModal(); return;
                                case 'accessibilityOn': ctrl.setAccessiblity(false); return;
                                case 'accessibilityOff':ctrl.setAccessiblity(true);return;
                                default: ctrl.setLocale(data.optionId);
                            }
                        }

                        ctrl.initLocale = () => {
                            this.showLanguageSelectionDropdown = cvConfig.showLanguageSelection || false;
                            this.curLocal = _.assignIn({
                                'localeId': 0,
                                'localeName': 'en',
                                'dispalyString': 'English'
                            }, cv.localeObj);
                            this.testLocaleEnabled = cvConfig.testLocaleEnabled || false;
                        }

                        ctrl.computeHideDropDownMenu = (hideDropDownOptions, data) => {
                            if(!_.isNil(hideDropDownOptions)){
                                _.split(hideDropDownOptions, ',').forEach(menu=>{
                                    if (menu === 'accessibility') {
                                        data['accessibilityOff'] = data['accessibilityOn'] = false;
                                    }
                                    data[menu] = false;
                                });
                            }
                            ctrl.hideDropdownMenu = [];
                            _.forEach(data, (val,key)=>{
                                if(!val){ctrl.hideDropdownMenu.push(key);}
                            });
                            const options = {
                                target: '#user-account-toggle',
                                element: $('#user-header-dropdown'),
                                showOn: 'click touch',
                                onSelect: ctrl.onActionItemSelect,
                                direction: 'left',
                                popupCollision: false
                            }
  
                            const userHeader = new ContextMenu(options);
                            userHeader.build();
        
                            const acbilityMenu = ctrl.enableAcbility === '1' ? 'user-header-accessibilityOff' : 'user-header-accessibilityOn';
                            userHeader.hide(acbilityMenu);
        
                            (ctrl.hideDropdownMenu || []).forEach((val)=>{
                                userHeader.remove('user-header-' + val);
                            })

                            ctrl.allDropDownItemsAreHidden =  Object.values(USER_SETTINGS).every(function(val){
                                return ctrl.hideDropdownMenu.includes(val);
                            });
                        }

                        ctrl.initUserSetting = (isForcePasswordChange) => {
                            ctrl.helpLink = cvConfig.helpLink;
                            ctrl.customerSupportLink = cvConfig.customerSupportLink;
                            const data = {'language':  ctrl.showLanguageSelectionDropdown,
                                'userPreference':  _.isUndefined(cv.sessionContext.operatorCompanyId) && _.get(cv, 'providers', []).length && cvConfig.showOperators,
                                'license':  !isForcePasswordChange && cv.isOnCommcellLevel && cv.isAdmin,
                                'changePassword':  !isForcePasswordChange && cv.isPasswordChangeAllowed && !_.has(cv, 'sessionContext.operatorCompanyId'),
                                'lock':  cvConfig.showLockSession,
                                'about': cv.isAdmin && !cv.isTenantAdmin
                            };
                            ctrl.enableAcbility = _.get(cv, 'userPref.cvAccessibility', '0');
                                //userpreference , license, accessibility, about , help, support , lock, lgout
                            const _hideUserSettingsOptionsS = _.get(cv, "additionalSettings.AdminConsole.hideUserSettingsOptions", "");
                            if (_hideUserSettingsOptionsS.length){
                                _.split(_hideUserSettingsOptionsS, ',').forEach(menu=>{
                                    if (menu === 'accessibility') {
                                        data['accessibilityOff'] = data['accessibilityOn'] = false;
                                    }
                                    data[menu] = false;
                                });
                            }
                            //Honoring User Settings customization
                           
                            settingsService.getHiddenUserSettings((cv.isTenantAdmin || cv.isTenantUser) ? HIDE_COMPANY_DROPDOWN : HIDE_COMMCELL_DROPDOWN).then(function(result){
                                let hideUserOptions = JSON.parse(_.get(result,'data[0].value','""'));
                                ctrl.computeHideDropDownMenu(hideUserOptions, data)
                            }).catch(function(error){
                                $log.error("Failed to load dropdown customization")
                                ctrl.computeHideDropDownMenu("", data)
                            })
                                                      
                        }

                        ctrl.init = (isForcePasswordChange, accountLocked) => {
                            if (_.isUndefined(isForcePasswordChange) && _.isUndefined(accountLocked)) {
                                return;
                            }
                            //initalize locale
                            if(accountLocked){this.openSessionLockModal(true);}

                            //set locale
                            ctrl.initLocale();
                            if (!this.showLanguageSelectionDropdown){ctrl.changeLocalefromParent();}
                            //set userheader
                            this.initUserSetting(isForcePasswordChange);
                        }

                        ctrl.goToFeedback = () => {
                            if ($location.path() === '/feedback') {
                                return;
                            }
                            const refPath = $location.absUrl();
                            $location.path('/feedback').search({
                                ref: refPath
                            });
                        };

                        ctrl.init();
                    };
                }
            ]
        }
    }
]

app.directive('usersettingDropdown', UserSettingDropdown);
export default app;