/**
 * @author ssubash
 */
import 'vsa/js/constants/servers.constants.js';

import { cvCommonModule } from "common/js/modules";

const TAB_TEMPLATE = `<div ng-if="ctrl.displayTab" class="cv-main-bar cv-main-bar-flex vertical-center" >
        <div class="cv-main-bar-title cv-main-bar-flex">
            <div data-ng-repeat="tab in ctrl.tabinfo.tabs track by $index"
                 class="cv-main-bar-tab cv-main-bar-flex vertical-center menu "
                 ng-init="rowIndex = $index"
				 ng-class="{selected: ctrl.isActive(rowIndex)}">
				<div data-ng-if="ctrl.isState" class="tabItems cv-main-bar-tab-menu-link" data-ng-click="ctrl.changeState(rowIndex)"><span ng-bind="tab.title"></span></div>
                <a data-ng-if="!ctrl.isState" class="tabItems font-primary-color cv-main-bar-tab-menu-link crop" ng-href="{{ctrl.getUrl(rowIndex)}}"><span ng-bind="tab.title"></span></a>
            </div>
        </div>
        <div class="cv-main-bar-actions cv-main-bar-flex" data-ng-disabled="ctrl.tabinfo.disabled.action" data-ng-if="ctrl.tabinfo.actions.length">
			<div ng-repeat="action in ctrl.tabinfo.actions | limitTo:2 track by $index"
                ng-init="rowIndex = $index"
				class="cv-main-bar-action menu tabAction"
				data-ng-click="ctrl.performAction(rowIndex)"><span data-ng-bind="action.title"></span><span ng-if="action.dropdown" class="k-icon k-i-arrow-60-down k-menu-expand-arrow"></span></div>
            <div ng-if="ctrl.tabinfo.actions.length > 2" class="no-padding cv-main-bar-dropdown-menu menu" uib-dropdown>
				<a class="uib-dropdown-toggle main-tab-menu-toggle" uib-dropdown-toggle>
				<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 20 20" fill="currentColor" width="20" height="20"><path d="M10.1 0C4.6-.1.1 4.4 0 9.9s4.4 10 9.9 10.1 10-4.4 10.1-9.9v-.2C19.9 4.5 15.5.1 10.1 0zm0 18.9c-5 0-9-4-9-9s4-9 9-9 9 4 9 9-4 9-9 9z"/><path d="M6.1 8.8h2v2h-2zM9.1 8.8h2v2h-2zM12.1 8.8h2v2h-2z"/></svg>
				</a>
				<ul uib-dropdown-menu class="dropdown-menu cv-dropdown-style-2" id="moreActions">
					<li class="no-padding" data-ng-repeat="action in ctrl.tabinfo.actions | limitTo: ctrl.tabinfo.actions.length - 2 : 2 track by $index" ng-init="rowIndex = $index+2">
						<a 
							class="tabAction"
							data-ng-click="ctrl.performAction(rowIndex)"><span data-ng-bind="action.title"></span></a>
						<hr ng-if="action.divider" class="dropdown-divider">					
					</li>
				</ul>
            </div>

		</div>
	</div>`;
				// <ul id="moreActions" class="cv-tap-comp-dropdown"></ul>
const TAB_TEMPLATE_2 = `<div ng-if="parent.displayTab" class="cv-main-bar cv-main-bar-flex vertical-center parent-tab">
		<div class="cv-main-bar-title cv-main-bar-flex">
            <div data-ng-repeat="tab in parent.tabinfo.tabs track by $index"
                 class="cv-main-bar-tab cv-main-bar-flex vertical-center menu crop tabItem2"
                 ng-init="rowIndex = $index"
				 ng-class="{selected: parent.isActive(rowIndex)}">
				<div data-ng-if="parent.isState" class="cv-main-bar-tab-menu-link" data-ng-click="parent.changeState(rowIndex)"><span ng-bind="tab.title"></span></div>
                <a  data-ng-if="!parent.isState" class="font-primary-color cv-main-bar-tab-menu-link" ng-href="{{parent.getUrl(rowIndex)}}"><span ng-bind="tab.title"></span></a>
            </div>
        </div>
    </div>`;


	/*****************
	 * 
	 * tabInfo paramters: 
	 * 
	 * @tabs: array that specifies the tabs to be displayed
	 * @hasParent: flag to show the parent tab
	 * @actions: array of actions to be shown on right side of tab panel
	 * @permittedOptions: object contains entity details, permissionId of the logged in user and the list of permitted actions
	 * 
	 ******************/


export class TabService {
	constructor($transitions, $state, cvNavigationFactory, VSA_SOLUTIONS_STATE, $filter, cvPermissionFactory, $location) {
		const self = this;
		this.callbacks = [];
		this.callbacksParam = [];
		this.$state = $state;
		this.$location = $location;
		this.cvNavigationFactory = cvNavigationFactory;
		this.VSA_SOLUTIONS_STATE = VSA_SOLUTIONS_STATE;
		this.$filter = $filter;
		this.cvPermissionFactory = cvPermissionFactory;
		self._setupDefaultValues();
		this.init = this._init.bind(this);
		this.registerChange = this._registerChange.bind(this);
		this.render = this._render.bind(this);
		
		$transitions.onSuccess({}, function(transition) {
			const from = transition.from();
			const to = transition.to();
			if(_.get(from, 'name') === _.get(to, 'name')) {
				return;
			}
			self._setupDefaultValues();
		}, {
			priority: 9999
		});
	}
	setParam(key, value) {
		const params = {};
		params[key] = value;
		this.setParams(params);
	}

	setParams(obj,label='tabInfo') {
		const params = {...obj};
		this._resolveUrlParams(this[label], params);
		this._render();
	}

	setParent(tabInfo) {
		this.init(tabInfo,'parentInfo');
		this.parentInfo.isParentTab = true;
		this.parentInfo.currentTab = tabInfo.current;
	}

	setParentParam(key, value){
		const parentParams = {};
		parentParams[key] = value;
		this.setParams(obj,'parentInfo');
	}


	_setupDefaultValues() {
		this.tabInfo = {};
		this.tabInfo.tabs = [];
		this.tabInfo.actions = [];
		this.parentInfo = {};
		this.callbacks.forEach(callback => callback());
	}

	_init(tabInfo, label = 'tabInfo') {
		const params = {...this.$state.params};
		this.unResolved = new Map();
		const isState = _.every(tabInfo.tabs,'state');

		this[label] = isState ? this._returnTabsWhichAreAvailable(tabInfo) :  this._resolveUrlParams(tabInfo, params) ;
		this[label].isState = isState;
		this[label].disabled = tabInfo.disabled;
		this[label].hasParent = tabInfo.hasParent || false;
		this[label].actions = tabInfo.actions || undefined;
		this[label].onActionItemSelect = tabInfo.onActionItemSelect;
		this[label].permittedOptions =  tabInfo.permittedOptions || {};
		_.set(this[label].permittedOptions, 'permittedActionsList', _.get(this[label].permittedOptions, 'permittedActionsList', []));
		if(this[label].permittedOptions.permittedActionsList.length > 0){
			this._setPermittedActions(label);
		}
		this._groupTabActions(label);
		if(!this[label].hasParent) this._render(label);
	}

	updateActions(tabInfo) {
		this.tabInfo.actions = tabInfo.actions;
		if(tabInfo.onActionItemSelect) this.tabInfo.onActionItemSelect = tabInfo.onActionItemSelect;
		this._groupTabActions();
		this._render();
	}

	_groupTabActions(label = 'tabInfo') {
		
		const { actions } = this[label];
		if (_.isEmpty(actions)) {
			return;
		}
		
		const sortedActions = _.sortBy(actions, ['groupId', 'rank']);
		
		sortedActions.forEach( (action , index) => {
			if (sortedActions[index + 1] && sortedActions[index + 1].groupId !== action.groupId) {
				action.divider = true;
			}
		});

		actions.length = 0;  
		actions.push(...sortedActions);

	}
	_setPermittedActions(label) {
		const permittedActions = this[label].permittedOptions.permittedActionsList.filter((action) => {
			action.title = action.label;
			action.isPermittedAction = true;
			return this.cvPermissionFactory.filterPermittedActions(
				action,
				this[label].permittedOptions.permissionIds
			);
		});

		if(_.isUndefined(this[label].actions)){
			this[label].actions = [];
		}

		this[label].actions.push(...permittedActions);
	}

	_performPermittedActionsSelect(action, selectedAction, permittedOptions){
		if (selectedAction.onClick && _.isFunction(selectedAction.onClick)) {
			selectedAction.onClick(selectedAction.value, permittedOptions.entity,permittedOptions.entityType, permittedOptions.entityId, permittedOptions.entityName);
		} else {
			selectedAction.href = selectedAction.href.replace('#', '/');
			this.$location.url(selectedAction.href);
		}
	}
	/**
	 *
	 * @param {array[tabInfo]} tabInfo
	 * Accepts array of tabInfo and keeps each tab if the state is available to user
	 */
	_returnTabsWhichAreAvailable(tabInfo) {
		let allowedTabs = [];
		tabInfo.tabs.forEach(tab => {
			if(tab.state && tab.state !== undefined && tab.state !== "" && this.cvNavigationFactory.isStateAvailable(tab.state)){
				allowedTabs.push(tab);
			}
		})

		tabInfo.tabs = angular.copy(allowedTabs)
		return tabInfo;
	}

	_render(label = 'tabInfo') {
		if (this._isParamsResolved()) {
			this.callbacks.forEach( (callback, ind) => {
				const param = this.callbacksParam[ind];
				if(label === param) callback(this[param]);
			});
		}
	}

	_isParamsResolved() {
		for(let [key, value] of this.unResolved){
			if(value) {
				return false;
			}
		}
		return true;
	}

	_resolveUrlParams(tabInfo, params) {
		const self = this;
		if(self.$state.current.name === this.VSA_SOLUTIONS_STATE.APPDETAILS || self.$state.current.name === this.VSA_SOLUTIONS_STATE.APPDETAILSCONFIG) {
			params.vmGuid = this.$filter('encodeParam')(params.vmGuid);
		}
		tabInfo.tabs.forEach(tab => {
			tab.url = tab.url.replace(/\{(.*?)\}/g, function(all) {
				const modifiedData = params[all.replace("{", "").replace("}", "")]
				if(modifiedData){
					self.unResolved.set(all, false);
					return modifiedData;
				}
				self.unResolved.set(all, true);
				return all;
			});
		});
		return tabInfo;
	}

	_registerChange(callback,param) {
		this.callbacks.push(callback);
		this.callbacksParam.push(param);
	}
}

TabService.$inject = ["$transitions", "$state","cvNavigationFactory","VSA_SOLUTIONS_STATE", "$filter", "cvPermissionFactory", "$location"];

export const TabDirective = [
	"tabService", function(tabService) {
		return {
			restrict: "E",
			template: TAB_TEMPLATE,
			controllerAs: "ctrl",
			bindToController: true,
			controller: TabNavController,
			link: {
				post: function($scope,ele,attr,ctrl) {
					ctrl.init(tabService.tabInfo);
					ctrl.outsideWrapper = $(ele).siblings('.wrapper-view').length;
					ctrl.ele = ele;
					ctrl.displayTab = ctrl.toggleInnerTab(tabService.tabInfo.hasParent, ctrl.outsideWrapper);

					if(tabService.tabInfo.hasParent && ctrl.displayTab) tabService.render();
				}
			}
		}
	}
];

export const TabParentDirective = [
	function() {
		return {
			restrict: "E",
			template: TAB_TEMPLATE_2,
			controllerAs: "parent",
			bindToController: true,
			controller: TabNavParentController
		}
	}
];


class TabNavController {
	constructor($state, $location, $stateParams, $timeout, tabService) {
		this.$state = $state;
		this.$location = $location;
		this.$stateParams = $stateParams;
		this.$timeout = $timeout;
		this.tabService = tabService;
		this.displayTab = false;
		if(!_.isEmpty(this.tabinfo)) {
			this.displayTab = false;
			$("#wrapper").addClass("existed-tab-comp");
		}

		this.registerChange(this);
	}

	isActive(index) {
		if(this.isState) {
			return this.$state.current.name === this.tabinfo.tabs[index].state;
		}

		const cn = `_cn=${this.$state.params._cn}`;
		let locationUrl = this.$location.url()
		locationUrl= locationUrl.replace(`&${cn}`,"").replace(`?${cn}`,"");
		if(this.$state.params._cid) {
			const cid = `_cn=${_cid}`;
			locationUrl = locationUrl.replace(`&${cid}`,"").replace(`?${cid}`,"")
		}

		//Mark the tab active if the flag 'ignoreQueryParam' is set, matching only the base url without query params.
		if (_.get(this, `tabinfo.tabs[${index}].ignoreQueryParam`, false)) {
			const [strippedLocationURL = ''] = locationUrl.split('?');
			const [strippedTabURL = ''] = this.tabinfo.tabs[index].url.split('?');
			return _.isEqual(strippedLocationURL, strippedTabURL);
		}

		return this.tabinfo.tabs[index].url === locationUrl;
	}

	registerChange(self) {
		self.tabService.registerChange( tabInfo => {
			if(_.isEmpty(self.tabinfo)) self.tabinfo = {};

			if (!_.isEmpty(tabInfo)) {
				self.displayTab = self.toggleInnerTab(tabInfo.hasParent, self.outsideWrapper);
				$("#wrapper").addClass("existed-tab-comp");
				self.tabinfo = {...self.tabinfo,...tabInfo};
				self.init(self.tabService.tabInfo);
			} else {
				self.displayTab = false;
				$("#wrapper").removeClass("existed-tab-comp");
			}

			self.isState = tabInfo ? tabInfo.isState : false;
		}, 'tabInfo');
	}

	toggleInnerTab(hasParent, outsideWrapper) {
		return !hasParent || !outsideWrapper;
	}

	performAction(index) {
		if (!_.isEmpty(this.tabinfo.actions[index])) {
			if(this.tabinfo.actions[index].isPermittedAction || false){
				this.tabService._performPermittedActionsSelect(this.tabinfo.actions[index].value, this.tabinfo.actions[index], this.tabinfo.permittedOptions);
			}
			else {
				this.tabinfo.onActionItemSelect(
					this.tabinfo.actions[index].value
				);
			}
		}
	}

	changeState(index) {
		this.$state.go(this.tabinfo.tabs[index].state, this.tabinfo.tabs[index].stateParams);
	}

	getUrl(index) {
		return `${cvUtil.CONTEXT_PATH}/#${this.tabinfo.tabs[index].url}`;
	}

	init(tabInfo) {

	}

}

TabNavController.$inject = ['$state', '$location', '$stateParams', '$timeout', 'tabService'];


class TabNavParentController {
	constructor($state, $location, $stateParams, $timeout, tabService) {
		this.$state = $state;
		this.$location = $location;
		this.$stateParams = $stateParams;
		this.$timeout = $timeout;
		this.tabService = tabService;
		this.displayTab = false;
		if(!_.isEmpty(this.tabinfo)) {
			$("#wrapper").addClass("existed-tab-comp");
			this.displayTab = false;
		}

		this.registerChange(this);
	}


	registerChange(self) {
		self.tabService.registerChange((parentInfo) => {
			if(!_.isEmpty(parentInfo)) {
				self.displayTab = true;
				$("#wrapper").addClass("existed-tab-comp");
			}else {
				self.displayTab = false;
				$("#wrapper").removeClass("existed-tab-comp");
			}

			self.isState = parentInfo ? parentInfo.isState : false;
			self.tabinfo = parentInfo;
		},'parentInfo');
	}

	changeState(index) {
		this.$state.go(this.tabinfo.tabs[index].state, this.tabinfo.tabs[index].stateParams);
	}

	getUrl(index) {
		return `${cvUtil.CONTEXT_PATH}/#${this.tabinfo.tabs[index].url}`;
	}

	isActive(index) {
		if(this.isState) {
			return this.tabinfo.tabs[index].state === this.tabinfo.current.state;
		}
		return this.tabinfo.current.url === this.tabinfo.tabs[index].url;
	}
}

TabNavParentController.$inject = ['$state', '$location', '$stateParams', '$timeout', 'tabService'];

cvCommonModule.service("tabService", TabService);
cvCommonModule.directive("cvTabNav", TabDirective);
cvCommonModule.directive("cvParentTabNav",TabParentDirective);
export default cvCommonModule;
