import { cvCommonModule } from "common/js/modules";

// To quickly modify single select to new ist-even style
const selectTemplate = `
<div data-ng-class="{disabled: ctrl.disabled}">
    <isteven-multi-select
        input-model="ctrl.input"
        output-model="ctrl.output"
        button-label="displayString"
        item-label="displayString"
        tick-property="selected"
        class="isteven-multi-select user-group-select"
        id="{{ctrl.id}}"
        directive-id="{{ctrl.id}}"
        directiveId="{{ctrl.id}}"
        name="{{ctrl.name}}"
        on-item-click="ctrl.modelChanged()"
        helper-elements="none filter reset"
        max-labels="1"
        translation="ctrl.localLang"
        disable-property="disabled"
        selection-mode="single">
    </isteven-multi-select>    
</div>
`;

class CvSelectDirective {
    constructor($parse) {
        this.restrict ="E",
        this.template = selectTemplate,
        this.bindToController = true,
        this.replace = true,
        this.controllerAs = 'ctrl',
        this.controller = CvSelectController,
        this.scope = {
            disabled : '=',
            ngModel : '=',
            options: '@',
            ngChange : '&',
            id: '@',
            name: '@',
        }
        this.$parse = $parse
    }
    
    link(scope, ele, attrs, ctrl) {
    }
}

class CvSelectController {
    constructor($scope, cvLoc, $parse, cvUtil) {
        this.cvLoc = cvLoc;
        this.$scope = $scope;
        this.$parse = $parse;
        this.cvUtil = cvUtil;
        this.$onInit = () => {
            this.localLang = this.cvUtil.getIStevenLocLabels();
            if (!this.id)
                this.id ='id_' + $scope.$id;
            if (!this.name)
                this.name = "name_" + $scope.$id;
            this.output = [];
            // ng options is not allowed, using options instead.
            // Regex ng options to get each part of it
            let optionsExp = this.options;
            let NG_OPTIONS_REGEXP = /^\s*([\s\S]+?)(?:\s+as\s+([\s\S]+?))?(?:\s+group\s+by\s+([\s\S]+?))?(?:\s+disable\s+when\s+([\s\S]+?))?\s+for\s+(?:([\$\w][\$\w]*)|(?:\(\s*([\$\w][\$\w]*)\s*,\s*([\$\w][\$\w]*)\s*\)))\s+in\s+([\s\S]+?)(?:\s+track\s+by\s+([\s\S]+?))?$/;
            let match = optionsExp.match(NG_OPTIONS_REGEXP);
            // console.log(match)
            let mInput = match[8];
            this.valuesFn = this.$parse(mInput);

            // What should be added to output model
            var returnVal = match[1];
            
            // variable name for repeat in ng options
            this.variable = match[5];

            // Display as string
            let display = match[2];
            if (!display) {
                display = _.clone(returnVal);
                returnVal = _.clone(this.variable);
            }
            this.display = display.split('+');
            this.returnVal = returnVal;
            this.resetInput();
            this.$scope.$watch(()=>this.valuesFn(this.$scope.$parent), ()=>{this.resetInput(0)});
        };
    }

    resetInput() {
        // The input model to the ng-options
        let input = this.valuesFn(this.$scope.$parent);
        // Find display string from input and add it as displayString property
        _.each(input, value=> {
            let obj = {};
            obj[this.variable] = value;
            let string = "";
            _.each(this.display, part => {
                // remove excess space, and remove quotes
                part = part.trim().replace(/'/g,"").replace(/"/g, "");
                if (_.includes(part, this.variable))
                    string += _.get(obj, part);
                else
                    string += part;
            })
            value.displayString = string;
            if (this.ngModel && _.get(obj, this.returnVal) == this.ngModel) {
                value.selected = true;
            }
        });
        this.input = angular.copy(input);
    }

    modelChanged() {
        if (this.output.length > 0) {
            let obj = {}
            obj[this.variable] = this.output[0]
            this.ngModel = _.get(obj, this.returnVal);
            if (this.ngChange) {
                // Call made post digest so that ng model is reflected in source controller
                this.$scope.$$postDigest(this.ngChange);
            }
        }
    }
}

CvSelectController.$inject = ['$scope', 'cvLoc', '$parse', 'cvUtil'];
cvCommonModule.directive('cvSelect', () => new CvSelectDirective());
export default cvCommonModule;