const previewTEMPLATE = `
<div id="password-preview">
    <input type="{{ctrl.inputType}}" name="{{ctrl.inputName}}" id="{{ctrl.passwordPreviewId}}" data-ng-model="ctrl.value" required autoCompleteType="disable" autocomplete="off" placeholder="{{ctrl.passwordPreviewLabel | localizedString }}" />
        <span data-ng-click="ctrl.showHidePwdPreview()"><i class="k-icon k-i-eye"></i></span>
         <div class="margin-left-0 help-block" data-ng-if="(ctrl.formName.$submitted)">
         <div data-ng-if="ctrl.formName[ctrl.inputName].$error.required">{{ ctrl.error | localizedString}}</div>
         </div>
</div>
`;

/*** 
On click of eye icon, password text is shown or hidden
Usage:
<cv-password-preview value="model.sshPassphrase" 
form-name="pushInstallSoftwareForm" 
input-label="'label.enterPassphrase'" 
input-name="'sshPassphrase'" 
error="'error.passphrase'">
</cv-password-preview>
**/

class CvPasswordPreview {
    constructor() {
        this.restrict = "E";
        this.template = previewTEMPLATE;
        this.bindToController = true;
        this.controllerAs = 'ctrl';
        this.controller = CvPasswordPreviewController;
        this.scope = {
            value: '=',
            formName: '=',
            inputLabel: '=?',
            inputName:  '=?',
            error: '=?'
        }
    }

    link(scope, ele, attrs, ctrl) {
        ctrl.inputType = 'password';
        if (!attrs.passwordPreviewId) ctrl.passwordPreviewId = "CvPasswordPreview-" + Math.random().toString(36).substr(2, 9);
    }
}

class CvPasswordPreviewController {
    constructor() {
    }
    //toggle between preview and password on eye icon click
    showHidePwdPreview() {
        this.inputType = this.inputType ==='password'?'text':'password';
    }
}

export default ['cvPasswordPreview', () => new CvPasswordPreview()];
