const toggleTEMPLATE = `
<div class="cv-material-group-wrapper cv-input-group-wrapper" data-ng-class="{vertical: ctrl.isVertical}" data-ng-disabled="ctrl.isDisabled">
<span class="cv-material-input-wrapper cv-checkbox-wrapper" data-ng-repeat="obj in ctrl.checkObj track by $index" >
    <input type="checkbox" name="{{obj.name}}" id="{{obj.id}}" data-ng-model="obj.model" data-ng-change="ctrl.clickCheckBox(obj)" data-ng-disabled="obj.disabled"/>
    <label for="{{obj.id}}" class="cv-material-label cv-checkbox-label">
        <span data-ng-if="!obj.helpText && !obj.htmLabel">{{obj.label | localizedString}}</span>
        <span data-ng-if="!obj.helpText && obj.htmLabel" data-ng-bind-html="obj.label"></span>
        <cv-help-text class="cv-material-label" data-ng-if="obj.helpText" help-label="obj.label" help-text="obj.helpText"></cv-help-text>
        <cv-call-out data-ng-if="obj.callOut" html-template="obj.callOut.template" trigger="{{obj.callOut.trigger}}" placement="{{obj.callOut.placement}}"></cv-call-out>
    </label>
</span>
</div>
`;

class CvCheckBoxGroup {
    constructor() {
        this.restrict = "E",
            this.template = toggleTEMPLATE,
            this.bindToController = true,
            this.replace = true,
            this.controllerAs = 'ctrl',
            this.controller = CvCheckBoxGroupController,
            this.scope = {
                checkObj: '=',
                isDisabled: '=',
                outputModel: '=',
                isVertical: '@',
                onClickCheckbox: '&'
            }
    }

    link(scope, ele, attrs, ctrl) {
        ctrl.checkObj.forEach(ele => {
            if (ele.model === true) ctrl.outputModel.push(ele)
        });
        ctrl.checkObj.forEach((ele, ind) => {
            ele.id = ele.id || 'check' + ind;
        })
    }
}

class CvCheckBoxGroupController {
    clickCheckBox(data) {
        if (data.model) {
            this.outputModel.push(data);
        } else {
            _.pullAllBy(this.outputModel, [data], 'id')
        }

        if (this.onClickCheckbox) this.onClickCheckbox({
            data: this.outputModel
        });
    }
}

export default ['cvCheckboxGroup', () => new CvCheckBoxGroup()];