import ContextMenu from 'common/js/kendocontextmenu';
const app = angular.module('cvCommon');

const templateCompany = `
<div id="company-setting-toggle" class="">
    <a class="header-menu-item use-before-pesudo" data-ng-if="csCtrl.showCompanyDropdown" data-ng-click="csCtrl.initializeDropdown()">
        <span class="header-menu-small-size header-svg">
            <svg xmlns="http://www.w3.org/2000/svg" fill="curentColor" viewBox="0 0 18 18"><path d="M8.415 8.24a3.453 3.453 0 10-3.452-3.453A3.453 3.453 0 008.415 8.24zm0-6.497a3.044 3.044 0 11-3.044 3.044 3.048 3.048 0 013.044-3.044zM13.246 11.27l-.29.289a7.357 7.357 0 011.9 3.985.662.662 0 01-.149.53.5.5 0 01-.38.182c-1.739-.007-6.12-.024-9.25-.024-1.108 0-1.973.002-2.574.006a.5.5 0 01-.38-.183.659.659 0 01-.148-.528 7.313 7.313 0 012.2-4.273 6.207 6.207 0 014.24-1.71 6.083 6.083 0 012.988.793l.301-.3a6.469 6.469 0 00-3.29-.901 7.136 7.136 0 00-6.843 6.33 1 1 0 00.932 1.18h.006c.642-.004 1.54-.006 2.568-.006 3.084 0 7.324.017 9.247.025h.004a1.001 1.001 0 00.932-1.18 7.748 7.748 0 00-2.014-4.215z"/><path d="M15.827 7.188a2.095 2.095 0 00-3.307 2.509l-4.172 4.172-.048.851.858-.041.592-.593.829.83.686.024-.051-.659-.83-.83.303-.302.83.83.713.04-.08-.675-.828-.83.192-.192.829.83.685.003-.05-.638-.83-.83 1.185-1.183a2.095 2.095 0 002.494-3.316zm-.634 1.033a.393.393 0 110-.556.393.393 0 010 .556z"/></svg></span>
        <span class="header-menu-no-small-size">
            <span>{{csCtrl.currProvider.second || ('label.selectCompany' | cvLoc)}}</span><span class="k-icon k-i-arrow-60-down header-menu-arrow">
        </span>
    </a>
</div>
<ul id="company-setting-dropdown" class="header-dropdown">
    <li class="search-input">
        <span class="glyphicon glyphicon-search"></span><input id="header-company-search" type="text" data-ng-model="csCtrl.companySearch" title="{{('label.filterCompany' | cvLoc)}}" placeholder="{{('label.filterCompany' | cvLoc)}}" data-context-menu-option="SEARCH" data-ng-change="csCtrl.searchCompanyList(csCtrl.companySearch, false)" /><span data-ng-show="csCtrl.companySearch && csCtrl.companySearch !== ''" data-ng-click="csCtrl.clearCompanyFilter();" class="k-icon k-i-close" title="{{('label.filterClear' | cvLoc)}}" /></span>
    </li>
    <li data-ng-show="csCtrl.companySearch && csCtrl.companySearch !== '' && csCtrl.noCompaniesFound === true" >
        <a id="NoCompaniesFound" data-context-menu-option="NO COMPANIES FOUND">
            <span class="crop" title="{{('label.noCompaniesFound' | cvLoc)}}">{{('label.noCompaniesFound' | cvLoc)}}</span>
        </a>
    </li>

</ul>
`

const CompanySettingDropdown = [
    function() {
        return {
            restrict: 'E',
            template: templateCompany,
            bindToController: true,
            controllerAs: 'csCtrl',
            controller: ['cvLoc', 'settingsService', 'cvToaster', '$scope', '$rootScope', '$log',
                function (cvLoc, settingsService, cvToaster, $scope, $rootScope, $log) {
                    const ctrl = this;
                    this.$onInit = () => {
                        ctrl.companySearch = "";
                        ctrl.noCompaniesFound = false;
                        ctrl.isLoggedInUserNonAdmin = _.has(cv,'sessionContext.loggedInUserRole') ? cv.sessionContext.loggedInUserRole === "Role_Tenant_User" || cv.sessionContext.loggedInUserRole === "Role_MSP_User" ? true : false : false;
                        let isSearchElementSelected = false;
                        /**
                         * Resets companySearch string and updates the li properties to show.
                         */
                        ctrl.clearCompanyFilter = () => {
                            ctrl.companySearch = "";
                            ctrl.searchCompanyList(ctrl.companySearch, true);
                        }
                        /**
                         * updates the datasource companies with corresponding show and hide property
                         * 
                         * @param {string} [search="companyToSearch"]
                         * @param {boolean} [reset = true]
                         */
                        ctrl.searchCompanyList = function(search, reset) {
                            if(!reset) {
                                let atleastOneCompanyFound = false;
                                ctrl.providerList.forEach(function(company){
                                    if(!hasSearchMatch(company.label, search)){
                                        ctrl.companyHeader.hide(company.id);
                                    }else{
                                        if(!atleastOneCompanyFound){
                                            atleastOneCompanyFound = true;
                                        }  
                                        ctrl.companyHeader.show(company.id);
                                    }
                                })
                                if(!atleastOneCompanyFound){
                                    ctrl.noCompaniesFound = true;
                                }else{
                                    ctrl.noCompaniesFound = false;
                                }

                            }else{
                                ctrl.providerList.forEach(function(company){
                                    ctrl.companyHeader.show(company.id);    
                                })
                                ctrl.noCompaniesFound = false;
                            }
                            
                        }

                        function setProvider(id) {
                            _.set(cv, 'sessionContext.operatorCompanyId',id);
                            settingsService.setCompanyForUser(id).then(()=>{location.reload()},(e)=>{
                                cvToaster.showErrorMessage({
                                    'ttl': '5000',
                                    'message': e
                                });
                            })
                        }
                        // click listener for the company menu
                        ctrl.onActionItemSelect = ({optionId}) => {
                            if(!_.isUndefined(optionId) && optionId == 'header-company-search'){
                                isSearchElementSelected = true;
                            }else{
                                if(!_.isUndefined(optionId) && optionId !== 'NoCompaniesFound' && +optionId !== ctrl.selectedCompany ){
                                    setProvider(+optionId);
                                    isSearchElementSelected = false;
                                    ctrl.companySearch = "";
                                }
                            }
                            
                        }

                        function initializeContextmenu() {
                            const options = {
                                target: '#company-setting-toggle',
                                showOn: 'click touch',
                                cssClass: 'header-dropdown company-setting-dropdown',
                                onSelect: ctrl.onActionItemSelect,
                                direction: 'left',
                                element : $('#company-setting-dropdown'),
                                onClose : ctrl.preventClose
                            }
                            ctrl.companyHeader = new ContextMenu(options);
                            ctrl.companyHeader.build();
                        }

                        function initializeProviderList() {
                            ctrl.providerList = [];
                            ctrl.providerList = cv.providers.sort(({second:a},{second:b})=> _.toLower(a) < _.toLower(b) ? -1 : 1).map(({first,second})=> ({
                                id: first,
                                label: second,
                                cssClass : first === ctrl.selectedCompany ? 'selected-company' : ''
                                //hidden: first === ctrl.selectedCompany
                            }));
                            ctrl.showCompanyDropdown = _.get(ctrl,'providerList',[]).length;
                        }

                        // When the commcell option is multiple, it prevent the dropdown from closing when an item is selected
                        ctrl.preventClose = (event) =>{
                            if(!event.event && isSearchElementSelected) event.preventDefault();
                        }

                        ctrl.init = () => {
                            ctrl.selectedCompany = _.get(cv, 'orgId', 0);
                            ctrl.resetOn = false;
                            initializeProviderList();
                            if (ctrl.selectedCompany) {
                                ctrl.currProvider = cv.providers.find(({first}) => first === ctrl.selectedCompany);
                                ctrl.resetOn = true;
                                if(!ctrl.isLoggedInUserNonAdmin || (ctrl.isLoggedInUserNonAdmin && (!_.has(cvConfig,'hideDefaultCompany') || (_.has(cvConfig,'hideDefaultCompany') && cvConfig.hideDefaultCompany !== true)))){ 
                                    ctrl.providerList.unshift({
                                        id:0,
                                        label: cvLoc('label.removeCompany'),
                                        cssClass: 'reset-company'
                                    })
                                }
                            }
                        }

                        ctrl.initializeDropdown = () => {
                            if (ctrl.companyHeader) {
                                //clear filter if the search from previous instance of search was present.
                                if(!_.isUndefined(ctrl.companySearch) && ctrl.companySearch !== ""){
                                    ctrl.clearCompanyFilter();
                                }
                                return;
                            }
                            initializeContextmenu();
                            ctrl.companyHeader.add(ctrl.providerList);
                            ctrl.companyHeader.open();
                        }
                        
                        //Delete a provider with providerId from the controller's state and the kendo context menu
                        function deleteProvider(providerId) {
                            for(let i=0;i<cv.providers.length;i++) {
                                if(providerId === cv.providers[i].first) {
                                    cv.providers.splice(i,1);
                                }
                                if(ctrl.providerList[i] && providerId === ctrl.providerList[i].id) {
                                    ctrl.providerList.splice(i,1);
                                }
                            }
                            
                            ctrl.showCompanyDropdown = _.get(ctrl,'providerList',[]).length;
                            ctrl.companyHeader &&  ctrl.companyHeader.remove(providerId);
                        }
                        
                        // List of providers are fetched from the server and the controller, kendo context menu are reinitialized with the updated list
                        function refreshProvidersFromServer(ctrl,subscriptionObject) {
                            settingsService.getOperatorCompanies().then(function(response) {
                                ctrl.providerList.forEach(function(company){
                                    ctrl.companyHeader && ctrl.companyHeader.remove(company.id);
                                })
                                if(response.data && _.isArray(response.data)){
                                    cv.providers = _.cloneDeep(response.data);
                                } else {
                                    cv.providers = [];
                                }
                                ctrl.selectedCompany = _.get(cv, 'orgId', 0);
                                
                                const newLis = cv.providers.sort(({second:a},{second:b})=> _.toLower(a) < _.toLower(b) ? -1 : 1).map(({first,second})=> ({
                                    id: first,
                                    label: second,
                                    cssClass : first === ctrl.selectedCompany ? 'selected-company' : ''
                                    //hidden: first === ctrl.selectedCompany
                                }));
                                if (ctrl.selectedCompany) {
                                    ctrl.currProvider = cv.providers.find(({first}) => first === ctrl.selectedCompany);
                                   
								    if(!ctrl.isLoggedInUserNonAdmin || (ctrl.isLoggedInUserNonAdmin && (!_.has(cvConfig,'hideDefaultCompany') || (_.has(cvConfig,'hideDefaultCompany') && cvConfig.hideDefaultCompany !== true)))){     
                                        newLis.unshift({
                                            id:0,
                                            label: cvLoc('label.removeCompany'),
                                            cssClass: 'reset-company'
                                        })
                                    }
                                    
                                }
                                ctrl.providerList.length = 0;
                                ctrl.providerList.push(...newLis);
                                ctrl.showCompanyDropdown = _.get(ctrl,'providerList',[]).length;
                                ctrl.companyHeader && ctrl.companyHeader.add(ctrl.providerList);
                            }, function(failureReason) {
                                $log.error('Error loading operator companies list');
                            });
                        }
                        
                        function hasSearchMatch(haystack, needle) {
                            return angular.isString(haystack) && haystack.length > 0
                                    && haystack.toLowerCase().indexOf(needle.toLowerCase()) >= 0;
                        }
                        
                        $rootScope.$on('addSubscription', function(event, subscriptionObject) {
                            refreshProvidersFromServer(ctrl, subscriptionObject);
                        });
                        
                        $rootScope.$on('deleteSubscription', function(event, subscriptionObject) {
                            deleteProvider(subscriptionObject.id);
                        });

                        // $scope.$on('CHANGE_COMMCELL',()=>{
                            
                        // })
                        

                        ctrl.init();
                    };
                }
            ]
        }
    }
]

app.directive('companysettingDropdown', CompanySettingDropdown)
export default app;