export function onUploadToolClick(e, popupHtml, editor, cvLoc, maxFileSize) {


	// Store the editor range object
	// Needed for IE
	var storedRange = editor.getRange();

	// create a modal Window from a new DOM element
	var popupWindow = $(popupHtml)
		.appendTo(document.body)
		.kendoWindow({
			// modality is recommended in this scenario
			modal: true,
			width: 600,
			resizable: false,
			title: cvLoc('editor.insertImage.label.insertImage'),
			// ensure opening animation
			visible: false,
			// remove the Window from the DOM after closing animation is finished
			deactivate: function(e){ e.sender.destroy(); },
			activate: windowActivated
		}).data("kendoWindow")
		.center().open();


	// initialize kendo components in the popup

	$("#tabstrip").kendoTabStrip({
        animation:  {
            open: {
                effects: false
            }
        }
    });

	popupWindow.element.find("#files").kendoUpload({
		multiple: false,
		select: onImageUpload,
		remove: onImageDelete,
		localization: {
			invalidMaxFileSize: !isNaN(maxFileSize) ? cvLoc('editor.msg.error', maxFileSize/1000) : undefined
		},
		validation: {
			maxFileSize: maxFileSize || undefined,
			allowedExtensions: [".gif", ".jpg", "jpeg", ".png"]
		}
	});

	var img;
	var widthBox;
	var heightBox;
	var imgUrl;

	function onImageUpload(e) {

		img = e.files[0].rawFile;
		var reader = new FileReader();
		if (img && img.size <= maxFileSize) {
			// enable the insert button
			popupWindow.element.find("#insert-img-btn").prop("disabled", false);
			//popupWindow.element.find("#url").prop('disabled', true);
			reader.readAsDataURL(img);
			reader.onload = function() {
				processImage(reader.result);
			}
		}
		else {
			//disable the insert button
			popupWindow.element.find("#insert-img-btn").prop("disabled", true);
		}
	}

	function onImageDelete(e) {
		popupWindow.element.find("#url").prop('disabled', false);
	}

	function onGiveUrl(e) {
		var url = e.target.value;
		if (url.length > 0) {
			processImage(url);
		}
	}

	function windowActivated() {
		var urlbox = popupWindow.element.find('#url');
		urlbox.blur(onGiveUrl);
	}

	function processImage(src) {
		imgUrl = src;
		var image = new Image();
		image.src = src;
		image.onload = function() {
			widthBox = popupWindow.element.find("#width");
			widthBox.val(this.width);
			heightBox = popupWindow.element.find("#height");
			heightBox.val(this.height);
			var ratio = this.width/this.height;
			widthBox.keyup(changeWidth);
			widthBox.mouseup(changeWidth);
			heightBox.keyup(changeHeight);
			heightBox.mouseup(changeHeight);
			popupWindow.element.find("#lockRatio").change(checkBox);

			function checkBox(e) {
				// adjust height and width values if the checkbox got checked after a height and/or width was applied
				if(e.target.checked){
					var heightGiven = !!heightBox.val();
					var widthGiven = !!widthBox.val();
					if (widthGiven) {
						changeWidth();
					}
					else if (heightGiven) {
						changeHeight();
					}
				}
			}
			function changeWidth() {
				changeWidthOrHeight("width");
			}
			function changeHeight() {
				changeWidthOrHeight("height");
			}
			function changeWidthOrHeight(dimension) {
				//validate input...

				// keep ratio locked
				if (popupWindow.element.find("#lockRatio").prop("checked")) {
					var changedBox;
					var unchangedBox;
					var multiplier;
					if (dimension == "width") {
						changedBox = widthBox;
						unchangedBox = heightBox;
						multiplier = 1/ratio;
					}
					else {
						changedBox = heightBox;
						unchangedBox = widthBox;
						multiplier = ratio;
					}
					unchangedBox.val(Math.round(changedBox.val()*multiplier));
				}
			}
		}
	}

	// insert the new content in the Editor when the Insert button is clicked
	popupWindow.element.find(".k-dialog-insert").click(function(){
		//var img = popupWindow.element.find("input")[0].files[0];

		// set width and height
		var imgProperties="";

		if (widthBox && widthBox.val() && !isNaN(widthBox.val())) {
			imgProperties += 'width="' + widthBox.val() + '" ';
		}
		if (heightBox && heightBox.val() && !isNaN(heightBox.val()) && !popupWindow.element.find("#lockRatio").prop("checked")) { // no need to set both height and width if the ratio is locked
			imgProperties += 'height="' + heightBox.val() + '" ';
		}
		var altTextBox = popupWindow.element.find("#altText");
		if (altTextBox.val()) imgProperties += 'alt="' + altTextBox.val() + '" ';

		if (imgUrl) {
			editor.selectRange(storedRange);
			editor.exec("inserthtml", {value: '<img ' + imgProperties + 'src="' + imgUrl + '">'});
		}

	});

	// close the Window when any button is clicked
	popupWindow.element.find(".k-edit-buttons button").click(function(){
		// detach custom event handlers to prevent memory leaks
		popupWindow.element.find(".k-edit-buttons button").off();
		popupWindow.close();
	});
}