const sublinkTEMPLATE = `
<div class="uib-dropdown dropdown page-action-item" data-uib-dropdown data-ng-disabled="ctrl.isDisabled">
    <a class="uib-dropdown-toggle dropdown-toggle" data-uib-dropdown-toggle>
        <span data-ng-bind="ctrl.toggleLabel">{{ctrl.toggleLabel | localizedString}}</span>
        <span class="k-icon k-i-arrow-60-down"></span>
    </a>
    <ul uib-dropdown-menu class="dropdown-menu cv-dropdown-style-2 margin-top-10">
        <li class="no-padding" data-ng-repeat="item in ctrl.menus track by $index" id="{{item.id}}" data-ng-click="ctrl.itemClick(item)">
            <a data-ng-href="{{item.url}}">{{item.label | localizedString}}</a>
        </li>
    </ul>
</div>
`;

class DropdownSublink {
    constructor() {
        this.restrict = "E";
        this.template = sublinkTEMPLATE;
        this.replace = true;
        this.bindToController = true;
        this.controllerAs = 'ctrl';
        this.controller = DropdownSublinkController;
        this.scope = {
            menus: '=',
            toggleLabel: '@',
            isDisabled: '='
        }
    }
}

class DropdownSublinkController {
    constructor() {

    }

    itemClick(item) {
        if (item.onSelect) item.onSelect();
    }
}

export default ['cvDropdownSublink', () => new DropdownSublink()];
