(/**
	 * 
	 */
function() {
	'use strict';

	var cvCommon = angular.module('cvCommon');

	/*-
	 *
	 * Config parameters
	 *
	 * cvPageLinks : list of links displayed on top right of the grid,
	 * cvDropdowns : list of dropdowns to displayed on top,
	 * cvBreadcrumbs: Breadcrumbs to be displayed on top of grid,
	 * cvTableName : name of the table used to associate in backend,
	 * cvGridTitle : display title shown on top,
	 * cvHasTitle : flag denoting if the grid has any title,
	 * cvIsPageTitle : flag denoting if the grid title is Primary or secondary,
	 * cvServerMessage : variable name pointing to the controlling variable in app scope,
	 * cvIsSearchable : flag denoting if the grid has search enabled,
	 * cvIsSearchExternal : flag denoting if the search is client side or server side,
	 * cvInstantSearch : flag denoting if the search should be fired instantly or after a delay,
	 * cvSearchHandler : callback for handling search value,
	 * cvSearchPlaceholder : Placeholder to be displayed in search text box,
	 * cvSearchFields : list of column fields to search,
	 * cvHasViews : flag indicating if views are activated for this grid,
	 * cvCanSaveViews : flag indicating if user can create views on this grid,
	 * cvHasDefaultView : flag indicating if the grid has any default system generated views,
	 * cvAdvancedFilters : list of advanced filters,
	 * cvBeforeViewsInitialize : callback called before the views are initialized
	 * cvBeforeViewChange : callback called before a view is changed,
	 * cvAfterViewChange : callback after a view is changed,
	 * cvAfterViewCreation : callback after a view is created
	 * cvAfterViewUpdation : callback after a view is updated
	 * cvAfterViewDeletion : callback after a view is deleted
	 * cvGridDirectives : directives activated on the ui grid,
	 * cvGridCssClass : css classes applied to the ui grid,
	 * cvOnGridEmpty : object used to display message when grid does not have any data,
	 * cvShowSelectedOption : flag to show the 'show selected' option on top,
	 * cvShowSelectedCount : flag to show the number of items selected on top (when more then 0),
	 * cvCompanyDropdown : flag to show the company dropdown on top,
	 * cvQueryParamKey : string value to be used for query param instead of 'view'. This is typically used when multiple grids are present on same page,
	 * cvIsViewOpen : flag to indicate if view modal open,
	 * cvHasColumnFilter : flag in grid support column filter
	 * cvInfoText : string value to be used for displaying information about the grid.
	 * gridOptions : ui-grid config object. Refer online guide for this
	 */
	cvCommon.filter('decodeURIComponent', function() {
		return window.decodeURIComponent;
	})


	cvCommon
			.directive(
					'cvGrid',
					[
							'$timeout',
							function($timeout) {
								return {
									restrict : 'E',
									transclude : true,
									templateUrl : appUtil.appRoot + 'common/partials/cvgrid.jsp',
									scope : {
										cvGridOptions : "=",
										// NOTE: all the properties are only used for overriding cvGridOptions values
										cvPageLinks : "=",
										cvDropdowns : "=",
										cvBreadcrumbs : "=",
										cvTableName : "@",
										cvGridTitle : "=",
										cvHasTitle : "=",
										cvIsPageTitle : "=",
										cvServerMessage : "=",
										cvIsSearchable : "=",
										cvIsSearchExternal : "=",
										cvInstantSearch : "=",
										cvSearchPlaceholder : "=",
										cvSearchFields : "=",
										cvHasViews : "=",
										cvCanSaveViews : "=",
										cvHasDefaultView : "=",
										cvAdvancedFilters : "@",
										cvGridCssClass : "=",
										cvOnGridEmpty : "=",
										cvShowSelectedOption : "=",
										cvShowSelectedCount : "=",
										cvAppScope : "=",
										cvCompanyDropdown : "=",
										cvQueryParamKey : "@",
										cvInfoText :  "@",
										cvHideHeader : "=",
										cvIsViewOpen : "=",
										cvMaxColumns : "@"
									},
									controller : [
											'$scope',
											'$log',
											'cvGridSearchFactory',
											'userPrefService',
											'i18nService',
											'i18nConstants',
											'$uibModal',
											'cvToaster',
											'cvLoc',
											'cvUtil',
											'$timeout',
											'$location',
											'$window',
											'$parse',
											'cvMultiCommcell',
											function($scope, $log, cvGridSearchFactory, userPrefService, i18nService,
													i18nConstants, $modal, cvToaster, cvLoc, cvUtil, $timeout,
													$location, $window, $parse, cvMultiCommcell) {
												/*
												 * **************************************************************
												 * Process input parameters
												 * **************************************************************
												 */

												/*- Object structures for parameters
												 *
												 * cvPageLinks : [{
												 *			label : <string>,
												 *			onclick : <functionHandler>,
												 *			show : <string> <variable name in scope/self>,
												 *			href : <string>,
															disableMultiCommcell : true;
												 *		}, {
												 *			label : <string>,
												 *			onclick : <functionHandler>,
												 *			href : <string>,
												 *			sublinks : [{
												 *				label : <string>,
												 *				onclick : <functionHandler>,
												 *				show : <string> <variable name in scope/self>,
												 *				href : <string>,
												 				disableMultiCommcell : true;
												 *			}]
												 *		}]
												 *
												 * cvDropdowns : [{
												 * 				label : <string>,
												 * 				model : <string>, //label to show
												 * 				changeHandler : <functionHandler>,
												 * 				options : [{
												 * 					name : <string>,
												 * 					value : <object>
												 * 				}]
												 *			}]
												 * cvBreadcrumbs: {
												 * 		model: [<object>],
												 * 		//Id of template script or inline template
												 * 		itemTemplate: <string>
												 * }
												 * cvSearchFields : [ <string> ]
												 * cvAdvanedFilters : [
												 * 					<string>,
												 * 					{
												 * 						key : <string>,
												 * 						defaultValue : <object>
												 * 					}
												 * 				]
												 * cvGridCssClass : { '<css-class-name>' : <boolean expression> }
												 * cvOnGridEmpty : {
												 * 				message : <string>,
												 * 				links : [ {
												 * 					label : <string>,
												 * 					onclick : <functionHandler>
												 * 				} ]
												 * 			}
												 *  cvQueryParamKey : <string> 	---> // Used when resolution query param conflict in case of multiple views on same page
												 *
												 */

												/**
												 * Shallow copies properties from src to dst only if the
												 * property in dst is undefined
												 */
												var copyOverUndefinedProps = function(dst, src) {
													for (var prop in src) {
														if (dst[prop] === undefined) {
															dst[prop] = src[prop];
														}
													}
													return dst;
												};

												var defaultValues = {
													cvPageLinks : [],
													cvDropdowns : [],
													cvBreadcrumbs: undefined,
													cvTableName : "",
													cvGridTitle : "",
													cvHasTitle : true,
													cvIsPageTitle : true,
													cvServerMessage : undefined,
													cvIsSearchable : true,
													cvIsSearchExternal : false,
													cvInstantSearch : true,
													cvSearchHandler : undefined,
													cvSearchPlaceholder : cvLoc("label.search"),
													cvSearchFields : [],
													cvHasViews : true,
													cvCanSaveViews : true,
													cvHasDefaultView : true,
													cvAdvancedFilters : [],
													cvBeforeViewsInitialize : undefined,
													cvBeforeViewChange : undefined,
													cvAfterViewChange : undefined,
													cvInfoText : undefined,
													cvGridDirectives : {
														'cvPageHeight' : false,
														'uiGridSelection' : false,
														'uiGridPagination' : true,
														'uiGridTreeView' : false
													},
													cvGridCssClass : {},
													cvOnGridEmpty : {
														'message' : cvLoc("label.noDataAvailable")
													},
													cvShowSelectedOption : false,
													cvShowSelectedCount : false,
													cvCompanyDropdown : false,
													cvQueryParamKey : undefined,
													cvIsViewOpen : undefined,
													cvHasColumnFilter : undefined,
													cvHideHeader: false,
													gridOptions : {
														'enableColumnResizing' : true
													},
													cvMaxColumns: undefined
												};

												copyOverUndefinedProps($scope.cvGridOptions, defaultValues);
												copyOverUndefinedProps($scope.cvGridOptions.cvGridDirectives, defaultValues.cvGridDirectives);
												copyOverUndefinedProps($scope.cvGridOptions.gridOptions, defaultValues.gridOptions);

												// check if inline properties present
												var inlinePropNames = [
														"cvPageLinks",
														"cvDropdowns",
														"cvTableName",
														"cvGridTitle",
														"cvHasTitle",
														"cvIsPageTitle",
														"cvServerMessage",
														"cvIsSearchable",
														"cvIsSearchExternal",
														"cvInstantSearch",
														"cvSearchPlaceholder",
														"cvSearchFields",
														"cvHasViews",
														"cvCanSaveViews",
														"cvHasDefaultView",
														"cvAdvancedFilters",
														"cvGridCssClass",
														"cvCompanyDropdown",
														"cvOnGridEmpty",
														"cvShowSelectedOption",
														"cvShowSelectedCount",
														"cvQueryParamKey",
														"cvMaxColumns"];

												inlinePropNames.forEach(function(propName) {
													if ($scope[propName] !== undefined) {
														$scope.cvGridOptions[propName] = JSON.parse($scope[propName]);
													}
												});

												// Disable uiGrid directives in cvGridDirectives that are false (does not override user gridOptions):
												if (!$scope.cvGridOptions.cvGridDirectives.uiGridSelection) {
													copyOverUndefinedProps($scope.cvGridOptions.gridOptions, {
														enableRowSelection : false,
														multiSelect : false,
														enableRowHeaderSelection : false,
														enableFullRowSelection : false,
														enableSelectAll : false
													});
												}
												if (!$scope.cvGridOptions.cvGridDirectives.uiGridTreeView) {
													copyOverUndefinedProps($scope.cvGridOptions.gridOptions, {
														enableTreeView : false
													});
												}

												/*
												 * **************************************************************
												 * Utility methods
												 * **************************************************************
												 */
												// helper for adding watch
												$scope.appScopeWatchHelper = function(watchVar, watchCallback,
														isCollection) {
													if (angular.isString(watchVar)) {
														var watchDereg;

														if (isCollection) {
															if ($scope.cvGridOptions.cvAppScope) {
																watchDereg = $scope.$watchCollection(function() {
																	return watchVar.split('.').reduce(function(obj, i) {
																		return obj[i];
																	}, $scope.cvGridOptions.cvAppScope);
																}, watchCallback);
															} else {
																watchDereg = $scope.$parent.$watchCollection(
																		watchVar,
																		watchCallback);
															}
														} else {
															if ($scope.cvGridOptions.cvAppScope) {
																watchDereg = $scope.$watch(function() {
																	return watchVar.split('.').reduce(function(obj, i) {
																		return obj[i];
																	}, $scope.cvGridOptions.cvAppScope);
																}, watchCallback);
															} else {
																watchDereg = $scope.$parent.$watch(
																		watchVar,
																		watchCallback);
															}
														}

														$scope.$on('$destroy', watchDereg);
													} else {
														$log
																.debug('Data watchers not installed as data is injected directly.');
													}
												};

												// helper to update pagination control. Param -> total data length
												$scope.updatePaginationControl = function(dataLength) {
													var gridOptions = $scope.cvGridOptions.gridOptions;
													// min rows to show
													if ($scope.cvGridOptions.cvGridDirectives['uiGridPagination']) {
														gridOptions.minRowsToShow = Math
																.min(
																		dataLength
																				- ((gridOptions.paginationCurrentPage - 1) * gridOptions.paginationPageSize),
																		gridOptions.paginationPageSize);
														gridOptions.enablePaginationControls = true;

														// Always show pagination controls if data more than 20
														if ((dataLength <= 20)
																&& (gridOptions.paginationPageSize >= dataLength)) {
															gridOptions.enablePaginationControls = false;
														}
													} else {
														gridOptions.minRowsToShow = dataLength;
													}
												};

												// helper to update isDataAvailable variable. Param -> total data length
												$scope.updateIsDataAvailable = function(visibleItems) {
													$scope.isDataUnavailable = visibleItems === 0;
													$scope.updatePaginationControl(visibleItems || 1);

													// set selected count as the selection event is not triggered on data change
													if ($scope.cvGridOptions.cvShowSelectedCount) {
														$scope.setSelectedItemsCount();
													}
												};

												/*
												 * **************************************************************
												 * Hack: Over ride internal grid localization service
												 * **************************************************************
												 */

												// override service for custom localiztion
												if (!i18nService.isUpdated) {
													i18nService.isUpdated = true;
													var _setCurrentLang = i18nService.setCurrentLang;

													i18nService.setCurrentLang = function(lang) {
														// set the current language from cookie everytime
														_setCurrentLang(cvUtil.readCookie("locale"));
													};

													// redirect to cvloc if text is not found in lang cache
													var _getSafeText = i18nService.getSafeText;
													i18nService.getSafeText = function(path, lang) {
														var _cvText = cvLoc(path);
														if (_cvText) {
															return _cvText;
														} else {
															// default to english if not found by cvLoc
															$log.debug("Text not localized : " + path);
															return _getSafeText(path, "en");
														}
													};
												}

												/*
												 * **************************************************************
												 * Directive setup
												 * **************************************************************
												 */

												// Watch cvGridOptions.gridOptions.data and if it is a string, replace it with the object it is referencing.
												// This must be done because the gridOptions is passed directly to the ui-grid, and the ui-grid will look for
												// the data object on the current cv-grid scope instead of the parent scope.
												// Note: Because of this, issues may arise if gridOptions.data is redefined by parent controllers. Avoid
												//       redefining gridOptions.data from parent controllers if possible.

												var onDataChanged = function(data) {
													if (angular.isString(data)) {
														// If gridOptions.data is a string then it is an angular expression referring to an
														// array on the parent scope. Replace the string with the array it refers to:
														if ($scope.parentDataWatchDereg) {
															$scope.parentDataWatchDereg();
														}
														$scope.originalDataString = data; // Keep the original string to restore it when the grid is destroyed
														var parentScope = $scope.$parent;
														if ($scope.cvGridOptions.cvAppScope) {
															// If cvAppScope is defined then we use it instead of the parent scope
															data = 'cvGridOptions.cvAppScope.' + data;
															parentScope = $scope;
														}
														// Replace gridOptions.data with the array in the parent scope and watch it for changes:
														$scope.parentDataWatchDereg = parentScope.$watch(data, function(dataObj) {
															if (!angular.isString(dataObj)) {
																// Do not update gridOptions.data if the variable in the parent scope is a string
																// to prevent it from triggering onDataChanged and causing the variable being
																// watched in the parent scope to change.
																$scope.cvGridOptions.gridOptions.data = dataObj;
															}
														});
														var parentData = $parse(data)(parentScope);
														if (!angular.isString(parentData)) {
															// Do not update gridOptions.data if the variable in the parent scope is a string
															// to prevent it from triggering onDataChanged and causing the variable being
															// watched in the parent scope to change.
															$scope.cvGridOptions.gridOptions.data = parentData;
														}
													} else {
														// gridOptions.data is not a string, update grid data available:
														// TODO: Once the grid is shown dont hide it.
														// As once the grid is shown the data will be 0 only if filters are applied
														var totalDataItems = $scope.cvGridOptions.gridOptions.totalItems;
														if (data) {
															$scope.showGrid = $scope.showGrid || !!data.length;
															totalDataItems = totalDataItems || data.length;
														}
														$scope.updateIsDataAvailable(totalDataItems);
													}
												};
												$scope.$on('$destroy', function() {
													if ($scope.parentDataWatchDereg) {
														$scope.parentDataWatchDereg();
														// Restore the original data string:
														$scope.cvGridOptions.gridOptions.data = $scope.originalDataString;
													}
												});

												$scope.$watchCollection('cvGridOptions.gridOptions.data', onDataChanged);
												onDataChanged($scope.cvGridOptions.gridOptions.data);

												// This modal gets triggered when user is multicommcellAware and has multiple commcells selected and has clicked the page Links
												$scope.openMultiCommCellSelectionModal= function(linkHref,linkOnClick) {
													return $modal
																.open({
																	templateUrl : appUtil.appRoot
																			+ 'common/partials/commcellSelectionNotification.jsp',
																	backdrop : 'static',
																	controller : [
																			'$scope',
																			'$uibModalInstance',
																			function($scope, $modalInstance) {
																				$scope.title =  cvLoc('label.commcell');
																				// $scope.message = cvLoc("label.singleSelectionForMultipleSelection");
																				$scope.selectedCommcell;
																				$scope.allowNext = true;
																				$scope.multiCommcellList = cv.sessionContext.dataSourceList;
																				$scope.commcellSelection = function(){
																					if ($scope.selectedCommcell === "" || $scope.selectedCommcell === undefined || $scope.selectedCommcell === null){
																						$scope.allowNext = true;
																					}else{
																						$scope.allowNext = false;
																					}
																				}
																				$scope.acknowledge = function() {
																					if($scope.selectedCommcell !== "" && $scope.selectedCommcell !== undefined && $scope.selectedCommcell !== null ){
																						cvMultiCommcell.setcommCellNameforLinks($scope.selectedCommcell);
																					}
																					$modalInstance.close();
																					if(linkHref!== null && linkHref !== undefined){
																						$window.location.href = linkHref;
																					}
																					if(linkOnClick !== null && linkOnClick !== undefined) {
																						linkOnClick();
																					}
																				};
																				$scope.cancel = function() {
																					$modalInstance.dismiss();
																				};
																			} ]
																});
												}
												// inject server-messages from parent
												$scope.appScopeWatchHelper($scope.cvGridOptions.cvServerMessage
														|| 'serverMessage', function(newValue) {
													$scope.serverMessage = newValue;
													$scope.isDataLoading = $scope.serverMessage
															&& $scope.serverMessage.message === cvLoc('Loading');
												});

												/**
												 * Sets watch on prop if attr value is an exp.
												 * 
												 * @param {object}
												 *            item - Item on which the attr is defined
												 * @param {string}
												 *            attr - Attribute name for which exp is set
												 * @param {string}
												 *            prop - Property on which the result needs to be
												 *            set
												 * @param {any}
												 *            defVal - Default value to be set if attr is not
												 *            set
												 */
												function setWatchOnProp(item, attr, prop, defVal) {
													// watch attr
													if (angular.isString(item[attr])) {
														$scope.appScopeWatchHelper(item[attr], function(newValue) {
															item[prop] = newValue;
														});
													} else if (item[attr] === undefined) {
														// if the option is undefined set default value
														item[prop] = defVal;
													} else {
														item[prop] = item[attr];
													}
												}

												var processPageLink = function(link) {
													//Sets watch on show attr
													setWatchOnProp(link, 'show','showItem', true);
													//Sets watch on disabled attr
													setWatchOnProp(link, 'disabled', 'disableItem', false);

													// If user is multicommcellAware and has multiple commcells selected then before the actual page link action happens we need to load the modal of which commcell. Below code overrides the onClick and Hrefs to load the moadal and passes them as arguments which are called during callbacks.

													var linkHref = link.href;
													var linkOnClick = link.onclick;

													if(!link.disableMultiCommcell) {
														if ((cv.sessionContext.isMultiComcellAware)
														&& (cvMultiCommcell.getselectedCClength() > 1) && !$location.search().hasOwnProperty("_cn") ){

																if(link.href !== null && link.href !== undefined ) {
																	link.href = undefined;
																}

																link.onclick = function() {
																	$scope.openMultiCommCellSelectionModal(linkHref, linkOnClick);
																}
														}
													}

												};

												$scope.cvGridOptions.cvPageLinks.forEach(function(link) {
													// process the link
													processPageLink(link);

													// process all sublinks if any sublinks are present
													if (link.subLinks) {
														link.subLinks.forEach(processPageLink);
														//Sets watch on show attr
														setWatchOnProp(link, 'show','showItem', true);
														//Sets watch on disabled attr
														setWatchOnProp(link, 'disabled', 'disableItem', false);
													}
												});

												$scope.openReorderModal = function($event) {
													$event.stopPropagation();
													var modalInstance = $modal.open({
														templateUrl : appUtil.appRoot
																+ 'common/partials/reorderView.jsp',
														backdrop : 'static',
														windowClass : 'reorder-view-modal',
														controller : [
																'$scope',
																'$uibModalInstance',
																'cvLoc',
																'cvUtil',
																'views',
																function($scope, $modalInstance, cvLoc, cvUtil, views) {
																	$scope.views = views;

																	$scope.saveOrder = function() {
																		// pass view order here
																		$modalInstance.close($scope.views.map(function(
																				view) {
																			return view.id;
																		}));
																	};

																	$scope.cancel = function() {
																		$modalInstance.dismiss();
																	};
																} ],
														resolve : {
															views : function() {
																// create a new array to issolate scope
																return $scope.getTablePrefs().viewOrder.map(
																		function(viewId) {
																			return $scope.getView(viewId);
																		}).filter(function(view) {
																	return view !== undefined;
																});
															}
														}
													});

													modalInstance.result.then(function(viewOrder) {
														if (viewOrder) {
															userPrefService.setViewOrder(
																	$scope.getTablePrefs().name,
																	viewOrder).success(function() {
																// update the tablePrefs object
																$scope.getTablePrefs().viewOrder = viewOrder;
																$scope.updateTablePrefs();
																$scope.loadTablePreferences();
															});
														}
													});
												};

												$scope.getValidDefaultView = function() {
													var viewObj = $scope.getView($scope.getTablePrefs().defaultView);

													if (viewObj) {
														return viewObj.id;
													} else {
														if ($scope.getTablePrefs().viewOrder.length) {
															return $scope.getTablePrefs().viewOrder[0];
														} else {
															return Object.keys($scope.getTablePrefs().views)[0];
														}
													}
												};

												// TODO: find a better place for this
												$scope.defaultViewName = cvLoc("viewname.all");
												$scope.model = {};

												// get table preferences if any
												$scope.getTablePrefs = function() {
													return $scope.tablePrefs;
												};

												$scope.getView = function(viewId) {
													return $scope.getTablePrefs().views[viewId];
												};

												// update $scope.tablePrefs from backend
												$scope.updateTablePrefs = function(updateFromServer, callback) {
													if (updateFromServer) {
														// fetch the userPrefs
														userPrefService.updateUserPrefs().success(function() {
															// update table prefs object
															$scope.loadTablePreferences();
															// call callback
															if (typeof callback === "function") {
																callback();
															}
														});
													} else {
														// update local object
														cv.userPref[$scope.cvGridOptions.cvTableName] = angular
																.toJson($scope.getTablePrefs());
													}
												};

												$scope.loadTablePreferences = function() {
													// check if data is present
													if (cv.userPref[$scope.cvGridOptions.cvTableName]) {
														$scope.tablePrefs = JSON
																.parse(cv.userPref[$scope.cvGridOptions.cvTableName]);
														if (!$scope.tablePrefs.name) {
															// data in old style. discard it
															$scope.tablePrefs = undefined;
														}

														// data version is old. update it
														if ($scope.tablePrefs && !$scope.tablePrefs.version) {
															userPrefService.setViewAsDefault(
																	$scope.tablePrefs.name,
																	$scope.tablePrefs.defaultView).success(function() {
																// update the tablePrefs object
																$scope.updateTablePrefs(true);
															}).error(function() {
																$scope.tablePrefs = undefined;
															});
														}
													}

													// Initialize new table preferences
													$scope.tablePrefs = $scope.tablePrefs || {
														'name' : $scope.cvGridOptions.cvTableName,
														'views' : {}
													};

													// Default any invalid column widths to '*'
													angular.forEach($scope.getTablePrefs().columnPrefs, function(columnPref) {
														if ('width' in columnPref) {
															var width = columnPref.width;
															if (typeof(width) === 'string') {
																var validWidthRegex = /^\d+(\.\d+)?%?$/; // Matches numbers and percentages
																if (width !== '*' && !validWidthRegex.test(width)) {
																	columnPref.width = '*';
																}
															} else if (typeof(width) !== 'number') {
																columnPref.width = '*';
															}
														}
													});

													$scope.getTablePrefs().viewOrder = $scope.getTablePrefs().viewOrder || [];
													if (!$scope.cvGridOptions.cvHasViews || $scope.cvGridOptions.cvHasDefaultView) {
														// add default view to tableprefs
														$scope.getTablePrefs().views[$scope.defaultViewName] = {
															'name' : $scope.defaultViewName,
															'id' : $scope.defaultViewName,
															'canBeDeleted' : false,
															'filters' : [],
															'advancedFilters' : {}
														};

														// Add it to the start of view order only if it is not present
														if ($scope.getTablePrefs().viewOrder
																.indexOf($scope.defaultViewName) === -1) {
															$scope.getTablePrefs().viewOrder
																	.unshift($scope.defaultViewName);
														}

														// if no valid view is set to default set default view
														if (!$scope.getTablePrefs().defaultView
																|| !$scope.getView($scope.getTablePrefs().defaultView)) {
															$scope.getTablePrefs().defaultView = $scope.defaultViewName;
														}
													} else {
														// if no valid view is set to default set default view
														if (!$scope.getTablePrefs().defaultView
																|| !$scope.getView($scope.getTablePrefs().defaultView)) {
															$scope.getTablePrefs().defaultView = $scope
																	.getValidDefaultView();
														}
													}

													// update total number of views count (remove hidden views from view count)
													$scope.model.totalViews = Object.values($scope.getTablePrefs().views).filter(function(viewObj) { return viewObj && !viewObj.hidden}).length;

													// update static views object
													$scope.model.views = $scope.getTablePrefs().viewOrder.map(
															function(viewId) {
																return $scope.getView(viewId);
															}).filter(function(view) {
														return view !== undefined;
													});
												};

												/*
												 * **************************************************************
												 * Grid menu (Hamburger menu on top right)
												 * **************************************************************
												 */
												var gridMenuCustomItemsList = [];

												if ($scope.cvGridOptions.cvHasViews) {
													$scope.isDefaultViewLoading = true;
													gridMenuCustomItemsList
															.push({
																title : cvLoc('label.setAsDefault'),
																action : (function() {
																	$scope.setViewAsDefault();
																}).bind(this),
																shown : function() {
																	return $scope.getTablePrefs().defaultView !== $scope.model.selectedViewId;
																},
																order : 200 + gridMenuCustomItemsList.length
															});

													if ($scope.cvGridOptions.cvCanSaveViews) {
														gridMenuCustomItemsList.push({
															title : cvLoc('label.editView'),
															action : function() {
																// edit view is same as create view
																$scope.createView(true);
															},
															shown : function() {
																var viewObj = $scope
																		.getView($scope.model.selectedViewId);
																return viewObj && viewObj.canBeDeleted;
															},
															order : 200 + gridMenuCustomItemsList.length
														});

														gridMenuCustomItemsList.push({
															title : cvLoc('label.createView'),
															action : (function() {
																$scope.createView();
															}).bind(this),
															order : 200 + gridMenuCustomItemsList.length
														});

														gridMenuCustomItemsList.push({
															title : cvLoc('label.deleteView'),
															action : (function() {
																$scope.deleteView();
															}).bind(this),
															shown : function() {
																return Object.keys($scope.getTablePrefs().views).some(
																		function(viewId) {
																			var viewObj = $scope.getView(viewId);
																			return viewObj && viewObj.canBeDeleted;
																		});
															},
															order : 200 + gridMenuCustomItemsList.length
														});
													}
												} else {
													$scope.isDefaultViewLoading = false;
												}

												// add any user provided grid menu items
												if ($scope.cvGridOptions.gridOptions.gridMenuCustomItems) {
													$scope.cvGridOptions.gridOptions.gridMenuCustomItems
															.forEach(function(item) {
																gridMenuCustomItemsList.push(item);
															})
												}

												// provide a handle to the onRegisterApi
												var overriddenOnRegisterApi = $scope.cvGridOptions.gridOptions.onRegisterApi;

												angular
														.extend(
																$scope.cvGridOptions.gridOptions,
																{
																	showGridFooter : $scope.cvGridOptions.gridOptions.showGridFooter === undefined
																			|| $scope.cvGridOptions.gridOptions.showGridFooter,
																	enableGridMenu : $scope.cvGridOptions.gridOptions.enableGridMenu === undefined
																			|| $scope.cvGridOptions.gridOptions.enableGridMenu,
																	gridMenuCustomItems : gridMenuCustomItemsList,
																	onRegisterApi : function(gridApi) {
																		// bind the parent scope as grid appScope to make all the properties accessible
																		gridApi.grid.appScope = $scope.cvGridOptions.cvAppScope
																				|| $scope.$parent;

																		//add title for all grid header
																		gridApi.grid.options.columnDefs.forEach(function(col){
																			col.headerTooltip = true;
																		})

																		//Hide clear all filters option if grid does not have column filter
																		if(angular.isUndefined($scope.cvGridOptions.cvHasColumnFilter)) {
																			// Need the timeout yield to let the grid fully materialize
																			//use jquery to temprately fix this, until ui-grid complete PR and give a support
																			$timeout(function () {
																				$(".ui-grid-menu-button").click(function () {
																					$("button.ui-grid-menu-item:contains('Clear all filters')").hide();
																				});
																			});
																		}

																		$scope.getAdvancedFilter = function(
																				advancedFilters) {
																			if (advancedFilters) {
																				return advancedFilters
																						.reduce(
																								function(map, filter) {
																									var filterKey, filterValue;

																									if (filter.key) {
																										filterKey = filter.key;
																										filterValue = gridApi.grid.appScope[filterKey] === undefined ? filter.defaultValue
																												: gridApi.grid.appScope[filterKey];
																									} else {
																										filterKey = filter;
																										filterValue = gridApi.grid.appScope[filterKey];
																									}

																									map[filterKey] = filterValue;
																									return map;
																								},
																								{})
																			} else {
																				return {};
																			}
																		};

																		/*
																		 * **************************************************************
																		 * show selected option
																		 * **************************************************************
																		 */
																		if ($scope.cvGridOptions.cvShowSelectedOption) {
																			gridApi.grid
																					.registerRowsProcessor(
																							function(renderableRows) {
																								renderableRows
																										.forEach(function(
																												row) {
																											row.visible = $scope.model.isDisplaySelection ? row.isSelected
																													: true;
																										});
																								return renderableRows;
																							},
																							200);

																			$scope.toggleShowSelectedRows = function() {
																				gridApi.grid.refresh();
																			};
																		}

																		if ($scope.cvGridOptions.cvShowSelectedCount) {
																			$scope.setSelectedItemsCount = function(
																					newCount) {
																				$scope.itemsSelected = newCount !== undefined ? newCount
																						: gridApi.selection
																								.getSelectedRows().length;
																			};

																			if (gridApi.selection) {
																				gridApi.selection.on
																						.rowSelectionChanged(
																								$scope,
																								function(row) {
																									$scope
																											.setSelectedItemsCount();
																								});
																				gridApi.selection.on
																						.rowSelectionChangedBatch(
																								$scope,
																								function(rows) {
																									$scope
																											.setSelectedItemsCount();
																								});
																			}
																		}

																		/*
																		 * Convert absolute pixel width to
																		 * percentage of gridWidth. If the
																		 * given width is not a number,
																		 * returns the width unchanged.
																		 * Converted width is returned as a
																		 * string in the form: 99.9% for use
																		 * with ui-grid
																		 */
																		$scope.convertColumnWidth = function(width, gridWidth) {
																			if (typeof(width) !== 'number') {
																				return width;
																			}
																			return (width * 100 / gridWidth).toString() + '%';
																		};

																		/*
																		 * Resizes the columns to valid widths
																		 * so that the grid does not
																		 * overextend past the side of the
																		 * screen. Ensures that no column is
																		 * excessively large, and then reduces
																		 * the widths of columns with defined
																		 * widths, going from right to left
																		 */
																		$scope.fitColumns = function() {
																			// Cancel any pending fitColumns timeout:
																			$timeout.cancel($scope.fitColumnsTimeout);
																			var gridWidth = gridApi.grid.gridWidth;
																			if (typeof(gridWidth) !== 'number') {
																				// Cannot fit to percentage gridWidth, it must be in pixels
																				// This can also occur while the grid is hidden, so retry this every 2 seconds so
																				// that this runs once the grid is visible
																				$scope.fitColumnsTimeout = $timeout($scope.fitColumns.bind(this), 2 * 1000);
																				return;
																			}

																			$scope.columnsFitted = true;
																			var columns = gridApi.grid.columns;
																			// Calculate the total minWidth of all columns in pixels
																			var totalMinWidthPx = 0;
																			columns.forEach(function(column) {
																				if (!column.visible) {
																					// Ignore hidden columns
																					return;
																				}
																				if (column.name === 'selectionRowHeaderCol') {
																					totalMinWidthPx += column.width;
																				} else {
																					totalMinWidthPx += column.minWidth;
																				}
																			});
																			// Calculate the max px width of any column:
																			var maxWidthPx = gridWidth - totalMinWidthPx;
																			if (maxWidthPx < 0) {
																				maxWidthPx = 0;
																			}

																			// Calculate the total width of all columns:
																			var totalWidth = 0;
																			var rightmostColumnSeen = false;
																			for (var i = columns.length - 1; i >= 0; i--) {
																				var column = columns[i];
																				if (!column.visible) {
																					// Ignore hidden columns
																					continue;
																				}
																				if (!rightmostColumnSeen) {
																					// Force the rightmost column to use auto width
																					totalWidth += parseFloat($scope.convertColumnWidth(column.minWidth, gridWidth));
																					column.width = '*';
																					rightmostColumnSeen = true;
																				} else if (column.name === 'selectionRowHeaderCol') {
																					// For selection row column, just add the width. Do not apply the converted width
																					totalWidth += parseFloat($scope.convertColumnWidth(column.width, gridWidth));
																				} else {
																					column.width = $scope.convertColumnWidth(column.width, gridWidth); // Convert widths to percentage
																					if (typeof(column.width) !== 'string' || (column.width === '*' && !column.drawnWidth)) {
																						// If the column does not have a defined width, add the minimum width
																						totalWidth += parseFloat($scope.convertColumnWidth(column.minWidth, gridWidth));
																						if (!column.drawnWidth) {
																							// Column drawn width not known, refit after render:
																							$scope.fitColumnsTimeout = $timeout($scope.fitColumns.bind(this));
																						}
																					} else { // Column has a defined width
																						// Calculate column width in pixels:
																						var columnWidthPx;
																						if (column.width === '*') {
																							// Convert auto widths to percentage based on their current drawn width
																							columnWidthPx = column.drawnWidth;
																							column.width = $scope.convertColumnWidth(column.drawnWidth, gridWidth);
																						} else {
																							columnWidthPx = parseFloat(column.width) * 0.01 * gridWidth;
																						}
																						var maxColumnWidthPx = maxWidthPx - column.minWidth;
																						if (maxColumnWidthPx < column.minWidth) {
																							maxColumnWidthPx = column.minWidth;
																						}
																						if (columnWidthPx > maxColumnWidthPx) {
																							// If the column width exceeds the max width, set it to the max width
																							column.width = $scope.convertColumnWidth(maxColumnWidthPx, gridWidth);
																						} else if (columnWidthPx < column.minWidth) {
																							column.width = $scope.convertColumnWidth(column.minWidth, gridWidth);
																						} else {
																							column.width = $scope.convertColumnWidth(columnWidthPx, gridWidth);
																						}
																						totalWidth += parseFloat(column.width);
																					}
																				}
																			}
																			totalWidth *= 0.01; // Convert percentage from 0-100 scale to 0-1
																			if (totalWidth > 1) { // Total width exceeds 100%
																				// Shrink all columns with defined widths, starting from the rightmost column going left:
																				var remainingExcessWidthPx = (totalWidth - 1) * gridWidth;
																				for(var i = gridApi.grid.columns.length - 1; i >= 0; i--) {
																					var column = gridApi.grid.columns[i];
																					if ((remainingExcessWidthPx > 0)			// There is remaining excess width
																							&& column.visible					// Column is visible
																							&& typeof(column.width) === 'string'	// Column width is defined as percentage
																							&& column.width !== '*') {			// Column width is not auto
																						var oldColumnWidthPx = (parseFloat(column.width) / 100) * gridWidth;
																						var newColumnWidthPx = oldColumnWidthPx - remainingExcessWidthPx;
																						var reducedToMinWidth = false;
																						if (newColumnWidthPx < column.minWidth) {
																							// Columns cannot be resized lower than their minWidth
																							newColumnWidthPx = column.minWidth;
																							reducedToMinWidth = true;
																						}
																						var pxDiff = oldColumnWidthPx - newColumnWidthPx;
																						remainingExcessWidthPx -= pxDiff;
																						if (reducedToMinWidth) {
																							// If a column is reduced to its minWidth, set it to auto instead.
																							// Do this so that if the user resizes the window to be small enough to
																							// reduce columns to minWidth, set the columns to auto so that when the
																							// user increases the size of the window, the columns will expand
																							column.width = '*';
																						} else if (pxDiff > 0) {
																							// Otherwise, apply the new width
																							column.width = $scope.convertColumnWidth(newColumnWidthPx, gridWidth);
																						}
																					}
																				}
																			}
																		};
																		// Cancel pending fitColumns if grid is destroyed:
																		$scope.$on('$destroy', function() {
																			$timeout.cancel($scope.fitColumnsTimeout);
																		});

																		/*
																		 * Utility method to applies a view to
																		 * a ui grid. Applies series of filter
																		 * to the given grid. If no
																		 * columnNames are passed it will
																		 * disable the filtering on the grid
																		 * 
																		 * @params -> @filterObj : is a map of
																		 * columnName as key and its filter as
																		 * value
																		 * 
																		 */
																		$scope.applyView = function(viewId, callback) {
																			var viewObj = $scope.getView(viewId);
																			if (viewObj) {
																				if (!$scope.applyQueued
																						&& typeof $scope.cvGridOptions.cvBeforeViewChange === 'function') {
																					// queue all apply request to prevent multiple request
																					$scope.applyQueued = true;
																					$scope.cvGridOptions
																							.cvBeforeViewChange(
																									viewObj.id,
																									viewObj);
																				}

																				// update all the advanced filters in scope
																				angular
																						.forEach(
																								viewObj.advancedFilters,
																								function(value, key) {
																									gridApi.grid.appScope[key] = value;
																								});

																				var state = gridApi.saveState.save();
																				if (!gridApi.grid.columns.length
																						|| !state.columns.length) {
																					$log
																							.debug('Table not loaded. Trying again..');
																					// cancel any timeout waiting as they are not needed now
																					$timeout
																							.cancel($scope.viewLoadTimeout);

																					// time is in ms. Increase the time exponentially as there might be a http call associated
																					// with each apply view call
																					$scope.viewLoadDelay = 300;
																					$scope.viewLoadTimeout = $timeout(
																							$scope.applyView.bind(
																									this,
																									viewId,
																									callback),
																							$scope.viewLoadDelay);
																					return;
																				}
																				// cancel any timeout waiting as they are not needed now
																				$timeout.cancel($scope.viewLoadTimeout);
																				// reset apply queue
																				$scope.applyQueued = false;

																				var hasFilter = false;
																				// reset all the column filters
																				state.columns
																						.forEach(function(col) {
																							var rules = viewObj.filters ? viewObj.filters
																									.filter(function(
																											rule) {
																										return rule.columnName === col.name;
																									})
																									: [];
																							if (rules.length > 0) {
																								var ruleTerms = [];
																								var ruleCondition
																								rules.map(function(rule){
																									ruleTerms.push(rule.filterValue)
																								})
																								if(rules.length ===1) {
																									//mutiselect filter
																									ruleCondition = decodeURIComponent(rules[0].filterValue).split(',');
																								} else {
																									//mutilple text input filter
																									ruleCondition = ruleTerms;
																								}

																								col.filters = [ {
																									// TODO: Make this extensible to other filter types
																									term : decodeURIComponent(ruleTerms.join(',')),
																								//condition : rule.filterCondition
																									condition : new RegExp(decodeURIComponent(ruleCondition.join('|')), 'i')
																								} ];
																								hasFilter = true;
																							} else {
																								// reset column preferences
																								col.filters = [ {} ];
																								col.filters[0].term = "";
																								col.hasFilter = false;
																							}
																						});

																				// Build mapping of column names to columns:
																				var columnDefMap = {};
																				gridApi.grid.columns.forEach(function(col) {
																					columnDefMap[col.name] = col.colDef;
																				});

																				// apply column preference
																				if ($scope.getTablePrefs().columnPrefs) {
																					state.columns
																							.forEach(function(col) {
																								var columnPref = $scope
																										.getTablePrefs().columnPrefs[col.name];
																								if (columnPref) {
																									var columnDef = columnDefMap[col.name];
																									// User hiding is disabled if enableHiding is defined and is false
																									var hidingDisabled = columnDef && ('enableHiding' in columnDef) && !columnDef.enableHiding;
																									if (!hidingDisabled) {
																										// If user hiding is enabled, then load column visibility from the columnPref
																										// Otherwise, the original column visibility from columnDef is kept
																										col.visible = columnPref.isHidden !== true;
																									}
																									//check if columnDef has changed runtime to make column visible true\false. MUST define overrideVisibilityPref: true at column level if want to override visibility at runtime.
																									col.visible = (columnDef.overrideVisibilityPref && !_.isNil(columnDef.visible)) ? columnDef.visible : columnPref.isHidden !== true;
																									if (columnPref.sortDirection) {
																										col.sort.direction = columnPref.sortDirection;
																									}
																								}
																							});
																				}

																				gridApi.saveState
																						.restore($scope, state);

																				// Convert all number widths to percentage widths
																				gridApi.grid.columns.forEach(function(col, index) {
																					if (col.name === 'selectionRowHeaderCol') {
																						// Do not convert the selection checkbox column
																						return;
																					}

																					if(angular.isDefined(col.colDef.advancedVisible)){
																						col.colDef.visible = col.colDef.advancedVisible
																					};

																					if ($scope.getTablePrefs().columnPrefs && col.colDef.enableColumnResizing) { // Only load width if the column allows resizing.
																						var columnPref = $scope.getTablePrefs().columnPrefs[col.name];
																						if (columnPref) {
																							// Convert user preference to percentage as well
																							columnPref.width = $scope.convertColumnWidth(columnPref.width);
																							if (typeof(columnPref.width) === 'string') {
																								col.colDef.width = columnPref.width;
																							}
																						}
																					}
																					col.colDef.width = $scope.convertColumnWidth(col.colDef.width);

																					if($scope.cvGridOptions.cvMaxColumns) {
																						if(index >= $scope.cvGridOptions.cvMaxColumns) {
																							col.colDef.visible = false;
																							col.colDef.enableHiding = false;
																						} else {
																							col.colDef.width = (100/$scope.cvGridOptions.cvMaxColumns).toString() + '%'
																						}
																					}
																				});
																				if (gridApi.grid.columns.length > 0) {
																					// The last column will always have auto width
																					gridApi.grid.columns[gridApi.grid.columns.length - 1].colDef.width = '*';
																					gridApi.grid.columns[gridApi.grid.columns.length - 1].colDef.enableColumnResizing = false;
																				}

																				// Enable filtering by default
																				//gridApi.grid.options.enableFiltering = hasFilter;
																				if(angular.isDefined($scope.cvGridOptions.cvHasColumnFilter)){
																					gridApi.grid.options.enableFiltering = $scope.cvGridOptions.gridOptions.enableFiltering;
																				} else {
																					gridApi.grid.options.enableFiltering = true;
																				}
																				gridApi.core.notifyDataChange('column');

																				// all the actions to be executed after the grid is rendered
																				$timeout(function() {
																					$scope.fitColumns();

																					// update isDataAvailable for the first time
																					$scope
																							.updateIsDataAvailable(gridApi.grid.options.totalItems);

																					// keep a watch on filters for change
																					if (!$scope.cvGridOptions.gridOptions.useExternalFiltering) {
																						gridApi.core.on
																								.rowsRendered(
																										$scope,
																										function() {
																											$scope
																													.updateIsDataAvailable(gridApi.grid.options.totalItems);
																											// Fit columns after grid rows have rendered:
																											if (!$scope.columnsFitted) {
																												$scope.fitColumns();
																											}
																										});
																					} else {
																						gridApi.core.on
																								.rowsRendered(
																										$scope,
																										function() {
																											// Fit columns after grid rows have rendered:
																											if (!$scope.columnsFitted) {
																												$scope.fitColumns();
																											}
																										});
																					}
																				});

																				// reset search
																				if ($scope.cvGridOptions.cvIsSearchable) {
																					$scope.model.searchText = "";
																				}

																				// set the dropdown value
																				$scope.model.selectedViewId = viewObj.id;

																				// Dont change the query param if views are not activated
																				if ($scope.cvGridOptions.cvHasViews) {
																					var queryParamKey = $scope.cvGridOptions.cvQueryParamKey
																							|| "view";
																					// set query param
																					if ($scope.defaultViewName === viewObj.id) {
																						$location.search(
																								queryParamKey,
																								null).replace();
																					} else {
																						$location.search(
																								queryParamKey,
																								viewObj.id).replace();
																					}
																				}

																				// reset selected count as the selection event is not triggered on view change
																				if ($scope.cvGridOptions.cvShowSelectedCount) {
																					gridApi.selection
																							.clearSelectedRows();
																				}

																				if (typeof callback === "function") {
																					callback();
																				}

																				if (typeof $scope.cvGridOptions.cvAfterViewChange === 'function') {
																					$scope.cvGridOptions
																							.cvAfterViewChange(
																									viewObj.id,
																									viewObj);
																				}
																			} else {
																				$log.debug("View not found: " + viewId);
																			}
																		}

																		/*
																		 * **************************************************************
																		 * Grid initialization
																		 * **************************************************************
																		 */
																		$scope.initializeViews = function() {
																			if ($scope.getTablePrefs()
																					&& $scope.applyView) {

																				if (typeof($scope.cvGridOptions.cvBeforeViewsInitialize) === 'function') {
																					$scope.cvGridOptions.cvBeforeViewsInitialize($scope.model.views);
																				}

																				// set current view
																				var queryParams = $location.search();
																				var currentViewId = $scope.cvGridOptions.cvQueryParamKey ? queryParams[$scope.cvGridOptions.cvQueryParamKey]
																						: queryParams.view;

																				if (!currentViewId) {
																					// If query param not present apply default view
																					currentViewId = $scope
																							.getTablePrefs().defaultView;
																				} else {
																					// check if such a view exists
																					var viewObj = $scope
																							.getView(currentViewId);
																					if (!viewObj) {
																						// if no view exits apply default view
																						currentViewId = $scope
																								.getTablePrefs().defaultView;
																					}
																				}
																				$scope
																						.applyView(
																								currentViewId,
																								function() {
																									$scope.isDefaultViewLoading = false;

																									// for storing column hide preferences
																									gridApi.core.on
																											.columnVisibilityChanged(
																													$scope,
																													function(
																															col) {
																														userPrefService
																																.toggleColumnVisibility(
																																		$scope
																																				.getTablePrefs().name,
																																		col.name)
																																.success(
																																		function() {
																																			$scope
																																					.updateTablePrefs(true);
																																		});
																														$scope.fitColumns();
																													});

																									// for storing column sort preferences
																									gridApi.core.on
																											.sortChanged(
																													$scope,
																													function(
																															grid,
																															cols) {

																														var colsChanged = cols
																																.reduce(
																																		function(
																																				map,
																																				col) {
																																			map[col.name] = {
																																				name : col.name,
																																				isHidden : !col.visible,
																																				sortDirection : col.sort.direction
																																			};
																																			return map;
																																		},
																																		{})

																														var col = cols[0];
																														userPrefService
																																.sortColumns(
																																		$scope
																																				.getTablePrefs().name,
																																		colsChanged)
																																.success(
																																		function() {
																																			$scope
																																					.updateTablePrefs(true);
																																		});
																													});
																									gridApi.colResizable.on.columnSizeChanged(
																											$scope,
																											function(colDef, deltaChange) {
																												gridApi.grid.columns.forEach(function(column) {
																													if (column.name === colDef.name) {
																														$scope.fitColumns();
																														userPrefService.setColumnWidth($scope.getTablePrefs().name, column.name, column.width).success(function() {
																															$scope.updateTablePrefs(true);
																														});
																													}
																												});
																											}
																										);
																								});
																				// update total number of views count (remove hidden views from view count)
																				$scope.model.totalViews = Object.values($scope.getTablePrefs().views).filter(function(viewObj) { return viewObj && !viewObj.hidden}).length;
																			} else {
																				$log
																						.debug("User Table Preferences not loaded. Trying again...");
																				$timeout($scope.initializeViews, 1000);
																			}
																		};
																		userPrefService.getLoadedUserPrefs()['finally']
																				(function() {
																					$scope.loadTablePreferences();
																					$scope.initializeViews();
																				}).catch(function() {
																					$scope.isDefaultViewLoading = false;
																					// In case of error, fit columns anyway to allow grid to render:
																					$timeout($scope.fitColumns());
																				}).then(function() {
																					var onWindowResize = function() {
																						// Fit columns on window resize
																						$scope.fitColumns();
																						$scope.$digest();
																					};
																					angular.element($window).on('resize', onWindowResize);
																					$scope.$on('$destroy', function () {
																						angular.element($window).off('resize', onWindowResize);
																					});
																				});

																		/*
																		 * **************************************************************
																		 * Search related processing
																		 * **************************************************************
																		 */
																		if ($scope.cvGridOptions.cvIsSearchable) {
																			$scope.model.searchText = "";

																			$scope.cvGridOptions.searchTextChange = function() {
																				var onChangeHandler = function() {
																					// call handler if given
																					if (typeof $scope.cvGridOptions.cvSearchHandler === "function") {
																						$scope.cvGridOptions
																								.cvSearchHandler($scope.model.searchText);
																					}

																					gridApi.grid.queueGridRefresh();
																				};

																				if ($scope.cvGridOptions.cvInstantSearch) {
																					onChangeHandler();
																				} else {
																					// provide a delay for user to finish typing
																					window
																							.clearTimeout($scope.searchCallbackTimeout);
																					$scope.searchCallbackTimeout = setTimeout(
																							onChangeHandler,
																							1000);
																				}
																			};

																			var escapeRegExp = function(str) {
																				if (!str) {
																					return '';
																				}
																				return str
																						.replace(
																								/[\-\[\]\/\{\}\(\)\*\+\?\.\\\^\$\|]/g,
																								"\\$&");
																			}

																			if (!$scope.cvGridOptions.cvIsSearchExternal) {
																				gridApi.grid
																						.registerRowsProcessor(
																								function(renderableRows) {
																									return cvGridSearchFactory
																											.singleFilter(
																													renderableRows,
																													escapeRegExp($scope.model.searchText),
																													$scope.cvGridOptions.cvSearchFields);
																								},
																								200);
																			}
																		}

																		/*
																		 * **************************************************************
																		 * Views related processing
																		 * **************************************************************
																		 */
																		$scope.activateViews = function() {
																			// method to change view
																			$scope.updateView = function(viewObj) {
																				var setAsDefault = !!viewObj.isDefault;
																				delete viewObj.isDefault;
																				userPrefService
																						.updateTableView(
																								$scope.cvGridOptions.cvTableName,
																								viewObj,
																								setAsDefault)
																						.success(
																								function(viewId) {
																									// update the tablePrefs object
																									$scope
																											.updateTablePrefs(
																													true,
																													function() {
																														$scope
																																.applyView(viewId);
																														if (typeof($scope.cvGridOptions.cvAfterViewUpdation) === 'function') {
																															$scope.cvGridOptions.cvAfterViewUpdation();
																														}
																													});
																								})
																						.error(
																								function(e) {
																									cvToaster
																											.showErrorMessage({
																												'ttl' : '3000', //3 sec
																												'message' : e
																														+ ". "
																														+ cvLoc("error.saveViewFailed")
																														+ " "
																														+ decodeURIComponent(viewObj.name)
																											});
																								});
																			};

																			// method to save the current view
																			$scope.saveView = function(viewObj) {
																				var setAsDefault = !!viewObj.isDefault;
																				delete viewObj.isDefault;
																				userPrefService
																						.saveTableView(
																								$scope.cvGridOptions.cvTableName,
																								viewObj,
																								setAsDefault)
																						.success(
																								function(viewId) {
																									// update the tablePrefs object
																									$scope
																											.updateTablePrefs(
																													true,
																													function() {
																														$scope
																																.applyView(viewId);
																														if (typeof($scope.cvGridOptions.cvAfterViewCreation) === 'function') {
																															$scope.cvGridOptions.cvAfterViewCreation();
																														}
																													});
																								})
																						.error(
																								function(e) {
																									cvToaster
																											.showErrorMessage({
																												'ttl' : '3000', //3 sec
																												'message' : e
																														+ ". "
																														+ cvLoc("error.saveViewFailed")
																														+ " "
																														+ decodeURIComponent(viewObj.name)
																											});
																								});
																			};

																			// method to delete a view
																			$scope.deleteView = function() {
																				var modalInstance = $modal
																						.open({
																							templateUrl : appUtil.appRoot
																									+ 'common/partials/deleteView.jsp',
																							backdrop : 'static',
																							controller : [
																									'$scope',
																									'$uibModalInstance',
																									'cvLoc',
																									'cvUtil',
																									'userViews',
																									'currentViewId',
																									function(
																											$scope,
																											$modalInstance,
																											cvLoc,
																											cvUtil,
																											userViews,
																											currentViewId) {
																										var decodedViews = userViews
																												.map(function(
																														cur) {
																													var obj = angular
																															.copy(cur);
																													obj.name = decodeURIComponent(obj.name);
																													return obj;
																												})
																										$scope.model = {
																											views : decodedViews,
																											selectedViewId : currentViewId
																										};

																										$scope.deleteView = function() {
																											$modalInstance
																													.close($scope.model.selectedViewId);
																										};

																										$scope.cancel = function() {
																											$modalInstance
																													.dismiss();
																										};
																									} ],
																							resolve : {
																								userViews : function() {
																									return Object
																											.keys(
																													$scope
																															.getTablePrefs().views)
																											.filter(
																													function(
																															viewId) {
																														return $scope
																																.getView(viewId).canBeDeleted;
																													})
																											.map(
																													function(
																															viewId) {
																														return $scope
																																.getView(viewId);
																													});
																								},
																								currentViewId : function() {
																									return $scope.model.selectedViewId;
																								}
																							}
																						});

																				modalInstance.result
																						.then(function(viewId) {
																							userPrefService
																									.deleteTableView(
																											$scope.cvGridOptions.cvTableName,
																											viewId)
																									.success(
																											function() {
																												if ($scope.model.selectedViewId === viewId) {
																													// update the tablePrefs object
																													$scope
																															.updateTablePrefs(
																																	true,
																																	function() {
																																		// apply default view
																																		$scope
																																				.applyView($scope
																																						.getValidDefaultView());
																																		if (typeof($scope.cvGridOptions.cvAfterViewDeletion) === 'function') {
																																			$scope.cvGridOptions.cvAfterViewDeletion();
																																		}
																																	});
																												} else {
																													$scope
																															.updateTablePrefs(true, function() {
																																if (typeof($scope.cvGridOptions.cvAfterViewDeletion) === 'function') {
																																	$scope.cvGridOptions.cvAfterViewDeletion();
																																}
																															});
																												}
																											})
																									.error(
																											function() {
																												cvToaster
																														.showErrorMessage({
																															'ttl' : '3000', //3 sec
																															'message' : cvLoc("error.deleteViewFailed")
																														});
																											});
																						});
																			};

																			// method to set view as default
																			$scope.setViewAsDefault = function(viewId) {
																				var tableName = $scope.getTablePrefs().name;
																				var id = viewId
																						|| $scope.model.selectedViewId;

																				userPrefService
																						.setViewAsDefault(tableName, id)
																						.success(
																								function() {
																									// update the tablePrefs object
																									$scope
																											.getTablePrefs().defaultView = id;
																									$scope
																											.updateTablePrefs();
																								})
																						.error(
																								function() {
																									cvToaster
																											.showErrorMessage({
																												'ttl' : '3000', //3 sec
																												'message' : cvLoc("error.setAsDefaultFailed")
																											});
																								});
																			};

																			$scope.createView = function(editMode) {
																				$scope.cvGridOptions.cvIsViewOpen = true;
																				var modalInstance = $modal
																						.open({
																							templateUrl : appUtil.appRoot
																									+ 'common/partials/createView.jsp',
																							backdrop : 'static',
																							controller : [
																									'$scope',
																									'$uibModalInstance',
																									'$compile',
																									'cvLoc',
																									'cvUtil',
																									'uiGridConstants',
																									'systemViewNames',
																									'currentViewObj',
																									'columns',
																									'getAdvancedFilter',
																									'isDefaultView',
																									'cvGridOptions',
																									function(
																											$scope,
																											$modalInstance,
																											$compile,
																											cvLoc,
																											cvUtil,
																											uiGridConstants,
																											systemViewNames,
																											currentViewObj,
																											columns,
																											getAdvancedFilter,
																											isDefaultView,
																											cvGridOptions) {
																										$scope.editMode = editMode;

																										$scope.model = {
																											'viewName' : $scope.editMode ? decodeURIComponent(currentViewObj.name)
																													: "",
																											'isDefault' : isDefaultView
																										};

																										$scope.createView = function() {
																											$scope.serverMessage = cvUtil
																													.emptyMsg();
																											if (!$scope.editMode
																													&& systemViewNames
																															.indexOf($scope.model.viewName
																																	.toLowerCase()) !== -1) {
																												$scope.serverMessage = cvUtil
																														.errMsgLoc("error.overwriteDenied")
																												return;
																											}

																											var newRules = $scope.modifiedRules
																													.map(function(
																															rule) {
																														return {
																															'columnName' : rule.column.name,
																															'filterValue' : encodeURIComponent(rule.column.filters[0].term),
																															'filterCondition' : rule.filterCondition
																														};
																													});

																											if (newRules
																													.filter(function(
																															rule) {
																														return rule.filterValue === undefined
																																|| rule.filterValue === null
																																|| rule.filterValue === "";
																													}).length > 0) {
																												$scope.serverMessage = cvUtil
																														.errMsgLoc("error.emptyRule");
																												return;
																											}

																											$modalInstance
																													.close({
																														'name' : encodeURIComponent($scope.model.viewName),
																														'id' : $scope.editMode ? currentViewObj.id
																																: Date
																																		.now()
																																		+ "",
																														'isDefault' : $scope.model.isDefault,
																														'filters' : newRules,
																														'advancedFilters' : getAdvancedFilter()
																													});
																										};

																										$scope.cancel = function() {
																											cvGridOptions.cvIsViewOpen = false;
																											$modalInstance
																													.dismiss();
																										};

																										$scope.isTextFilter = function(
																												col) {
																											var column = col;
																											return !(column.filters[0].type !== undefined && column.filters[0].type !== uiGridConstants.filter.INPUT);
																										};

																										$scope.columns = columns
																												.filter(function(
																														col) {
																													//remove job id from view temp, will add it if we need
																													return (col.enableFiltering !== false) && (!col.colDef.disableView);
																												});


																										//add colIndex property for each column
																										$scope.columns.forEach(function(col, index){
																											col.colIndex = index;
																										})

																										if($scope.editMode) {
																											$scope.modifiedRules = $scope.columns
																											.map(
																													function(
																															col,
																															idx) {
																														return {
																															colIndex : idx,
																															column : col,
																															filterCondition : 'contains',
																															colScope : undefined
																														}
																													})
																											.filter(
																													function(
																															rule) {
																														return currentViewObj.filters
																																&& currentViewObj.filters
																																		.some(function(
																																				filterRule) {
																																			return filterRule.columnName === rule.column.name;
																																		});
																													})

																										//map multiple input filtering to view
																										//split multiple filter to multiple rules
																										for(var i = 0; i< $scope.modifiedRules.length;i++) {
																											var allFilterArray = [];
																											var filterArray = $scope.modifiedRules[i].column.filters[0].term.toString().split(',');
																											if((filterArray.length > 1) && $scope.isTextFilter($scope.modifiedRules[i].column)){
																												var array = [];
																												for(var j = 0; j < filterArray.length;j++) {
																													array.push({});
																													// copy by value so the changes wont affect the grid
																													var colStr = JSON
																															.stringify(
																																	$scope.modifiedRules[i],
																																	function(
																																			key,
																																			value) {
																																		if (key === "$$hashKey"
																																				|| key === 'grid') {
																																			return undefined;
																																		}
																																		return value;
																																	});
																													 array[j] = JSON.parse(colStr);
																														array[j].column.filters[0].term = filterArray[j];
																														if(j === 0) {
																															//use new rule replace current one
																															$scope.modifiedRules[i] = array[j];
																														} else {
																															//push additional rule to rule list
																															$scope.modifiedRules.push(array[j]);
																														}

																												}
																											}
																										}


																										}else {
																											$scope.modifiedRules = [];
																										}

																										$scope.applyRuleFilter = function(ruleIndex, newColumn){
																											$scope.modifiedRules[ruleIndex].filterCondition = 'contains';
																											// this is a circular object, pass by reference
																											newColumn.grid = gridApi.grid;

																											// disable cancel filter button
																											newColumn.filters[0].disableCancelFilterButton = true;

																											var elem = angular
																													.element('#ruleFilter-'
																															+ ruleIndex);
																											elem
																													.empty();
																											if (newColumn.enableFiltering) {
																												var newScope = $scope
																														.$new();
																												$scope.modifiedRules[ruleIndex].colScope = newScope;

																												newScope.col = newColumn;
																												newScope.grid = newColumn.grid;

																												if(newScope.col.filters && newScope.col.filters[0].selectOptions && (newScope.col.filters[0].selectOptions.length > 0)) {
																													newScope.col.filters[0].selectOptions = cvUtil.sortAscending(newScope.col.filters[0].selectOptions, 'label');
																												}
																												var template = newScope.col.filterHeaderTemplate;
																												elem
																														.append($compile(
																																template)
																																(
																																		newScope));
																											} else {
																												var el = angular
																														.element("<div class='ui-grid-filter-container'><input type='text' class='ui-grid-filter-input' disabled value='"
																																+ cvLoc("label.noFilterAvailable")
																																+ "' /></div>");
																												elem
																														.append(el);
																											}
																										}

																										$scope.changeRule = function(
																												ruleIndex,
																												newColIndex) {
																											var col = $scope.columns[newColIndex];

																											// copy by value so the changes wont affect the grid
																											var colStr = JSON
																													.stringify(
																															col,
																															function(
																																	key,
																																	value) {
																																if (key === "$$hashKey"
																																		|| key === 'grid') {
																																	return undefined;
																																}
																																return value;
																															});

																											var newColumn = JSON
																													.parse(colStr);

																											$scope.modifiedRules[ruleIndex].colIndex = newColIndex;
																											$scope.modifiedRules[ruleIndex].column = newColumn;
																											// initialize dropdown value
																											$scope.applyRuleFilter(ruleIndex, newColumn);
																										};

																										$scope.initialViewFilter = function(ruleIndex, rule){
																											var newColumn = rule.column;
																											$scope.applyRuleFilter(ruleIndex, newColumn);
																										}

																										$scope.removeRule = function(
																												index) {
																											$scope.modifiedRules
																													.splice(
																															index,
																															1);
																										};

																										$scope.addNewRule = function() {
																											//disable filter option from list
																											if($scope.modifiedRules.length > 0){
																												var modifiedRules = $scope.modifiedRules.map(function(rule){
																													return rule.colIndex;
																												})
																												$scope.columns.map(function(col, index){
																													if(modifiedRules.includes(index) && !$scope.isTextFilter(col)){
																														col.disabled = true;
																													}else {
																														col.disabled = false;
																													}
																												})
																											}
																											var columns =$scope.columns.filter(function(col){
																												return !col.disabled;
																											})
																											$scope.modifiedRules
																													.push({
																														colIndex : columns[0].colIndex,
																														column : columns[0],
																														filterCondition : 'contains',
																														colScope : undefined
																													});
																											var index = $scope.modifiedRules.length - 1;
																											$timeout($scope.changeRule
																													.bind(
																															this,
																															index,
																															$scope.modifiedRules[index].colIndex));
																										};
																										if($scope.modifiedRules.length === 0){
																											$scope.addNewRule();
																										}

																										$scope.filterToString = function(
																												filters) {
																											if (filters[0]
																													&& filters[0].term) {
																												var filter = filters[0];
																												if (filter.type === uiGridConstants.filter.SELECT) {
																													if (filter.selectOptions) {
																														return filter.selectOptions
																																.filter(
																																		function(
																																				option) {
																																			return option.value === filter.term;
																																		})
																																.map(
																																		function(
																																				option) {
																																			return option.label;
																																		})[0];
																													}
																												} else if (filter.type === "cv-grid-filter-date-range") {
																													// its a date range
																													var range = JSON
																															.parse(filter.term);
																													return cvUtil
																															.dateRangeToString(
																																	new Date(
																																			range.start),
																																	new Date(
																																			range.end));
																												} else {
																													return filter.term;
																												}
																											}
																											return "";
																										};

																										// select first column by default
																										$modalInstance.rendered
																												.then(function() {
																													$scope.modifiedRules
																															.forEach(function(
																																	rule,
																																	idx) {
																																$scope
																																		.initialViewFilter(
																																				idx,
																																				rule);
																															});
																												});
																									} ],
																							resolve : {
																								systemViewNames : function() {
																									return Object
																											.keys(
																													$scope
																															.getTablePrefs().views)
																											.filter(
																													function(
																															viewId) {
																														return !$scope
																																.getView(viewId).canBeDeleted;
																													})
																											.map(
																													function(
																															viewId) {
																														return $scope
																																.getView(viewId).name
																																.toLowerCase();
																													});
																								},
																								currentViewObj : function() {
																									return $scope
																											.getView($scope.model.selectedViewId);
																								},
																								columns : function() {
																									// copy by value so the changes wont affect the grid
																									var colStr = JSON
																											.stringify(
																													gridApi.grid.columns,
																													function(
																															key,
																															value) {
																														if (key === "$$hashKey"
																																|| key === 'grid') {
																															return undefined;
																														}
																														return value;
																													});

																									var columns = JSON
																											.parse(colStr);

																									// this is a circular object, pass by reference
																									columns
																											.forEach(function(
																													col) {
																												col.grid = gridApi.grid;
																											});

																									return columns;
																								},
																								getAdvancedFilter : function() {
																									return $scope.getAdvancedFilter
																											.bind(
																													this,
																													$scope.cvGridOptions.cvAdvancedFilters);
																								},
																								isDefaultView : function() {
																									// this condition will only kick in for edit mode. For create view it will always be false
																									return editMode
																											&& ($scope
																													.getTablePrefs().defaultView === $scope.model.selectedViewId);
																								},
																								cvGridOptions : function() {
																									return $scope.cvGridOptions;
																								}
																							}
																						});

																				modalInstance.result
																						.then(function(viewObj) {
																							if (editMode) {
																								// second argument tells its an update operation
																								$scope
																										.updateView(viewObj);
																							} else {
																								$scope
																										.saveView(viewObj);
																							}
																							$scope.cvGridOptions.cvIsViewOpen = false;
																						});
																			};
																		}

																		if ($scope.cvGridOptions.cvHasViews) {
																			// as soon as tablePrefs has some value activate the views
																			var tablePrefsWatchDereg = $scope.$watch(
																					"tablePrefs",
																					function(newValue) {
																						if (newValue && newValue.name) {
																							$scope.activateViews();
																							tablePrefsWatchDereg();
																						}
																					});
																		}

																		// call the handle provided for onRegisterApi
																		if (typeof overriddenOnRegisterApi === "function") {
																			overriddenOnRegisterApi(gridApi);
																		}
																	}
																});
											} ],
									link : function(scope, element, attr, ctrl, transclude) {

										/*
										 * *******************************************************************
										 * Transclude code
										 * *******************************************************************
										 */

										var insertElementAt = function(parentElement, index, element) {
											if (index === 0) {
												parentElement.prepend(element);
											} else {
												parentElement.children().eq(index - 1).after(element);
											}
										};

										$timeout(function() {
											// for page links
											transclude(function(clone) {
												var componentPageLinks = angular.element(element[0]
														.querySelector("[data-cv-page-links]"));

												clone.each(function(idx, eleNode) {
													if (eleNode.hasAttribute) {
														var indexAt;
														var isPageLink = false;
														if (eleNode.hasAttribute("data-cv-page-link")) {
															indexAt = parseInt(eleNode
																	.getAttribute("data-cv-page-link"));
															isPageLink = true;
														} else if (eleNode.hasAttribute("cv-page-link")) {
															indexAt = parseInt(eleNode.getAttribute("cv-page-link"));
															isPageLink = true;
														}

														if (isPageLink) {
															if (indexAt !== undefined && !isNaN(indexAt)) {
																insertElementAt(componentPageLinks, indexAt, eleNode);
															} else {
																componentPageLinks.append(eleNode);
															}
														}
													}
												});
											});

											if (scope.cvGridOptions.cvOnGridEmpty) {
												// for grid on empty
												transclude(function(clone) {
													var componentSvgPlaceholder = angular.element(element[0]
															.querySelector("[data-svg-placeholder]"));

													var hasSvg = false;
													clone.each(function(idx, eleNode) {
														if (eleNode.hasAttribute) {
															if (eleNode.hasAttribute("data-cv-on-grid-empty")) {
																hasSvg = true;
																componentSvgPlaceholder.append(eleNode);
															} else if (eleNode.hasAttribute("cv-on-grid-empty")) {
																hasSvg = true;
																componentSvgPlaceholder.append(eleNode);
															}
														}
													});

													if (!hasSvg && scope.cvGridOptions.cvOnGridEmpty.message) {
														// hack for showing empty message inside the grid
														// show the grid in case there is no grid
														// as the above design wont look good without a center svg
														scope.showGridDereg = scope.$watch("showGrid", function(
																newValue) {
															if (newValue !== undefined) {
																scope.showGridEmptyMessage = true;
																scope.showGridDereg();
															}
														});
													}
												});
											}
										});
									}
								};
							} ]);

	// Directive to add date filters for grid. See jobs grid (column: startTime) for usage
	cvCommon
			.directive(
					'cvGridFilterDateRange',
					[ function() {
						return {
							restrict : 'E',
							//replace : true,
							require : 'ngModel',
							templateUrl : appUtil.appRoot + 'common/partials/cvGridFilterDateRange.jsp',
							scope : {
								ngModel : '=',
								cvAllowCustomRange : '@',
								cvMaxRangeAllowed : '=',
								cvOnChange : '&',
								cvIsViewOpen : '='
							},
							controller : [
									'$scope',
									'$filter',
									'$uibModal',
									'$timeout',
									'cvUtil',
									'cvLoc',
									'cvGridFactory',
									function($scope, $filter, $modal, $timeout, cvUtil, cvLoc, cvGridFactory) {
										// hack for adding ng-if containter in jsp
										$scope.colFilter = {
											type : "select"
										};

										var now = new Date();
										// populate the options
										$scope.selectOptions = [ {
											label : $scope.cvIsViewOpen ? '' : cvLoc('viewname.all'),
											value : undefined
										}, {
											label : cvLoc('label.dateRangeOptions.lastHour'),
											value : 'last1hour'
										}, {
											label : cvLoc('label.dateRangeOptions.last2Hours'),
											value : 'last2hour'
										}, {
											label : cvLoc('label.dateRangeOptions.last24Hours'),
											value : 'last24hour'
										}, {
											label : cvLoc('label.dateRangeOptions.last48Hours'),
											value : 'last48hour'
										}, {
											label : cvLoc('label.dateRangeOptions.lastWeek'),
											value : 'last1week'
										} ];

										if ($scope.cvAllowCustomRange === "true") {
											$scope.selectOptions.push({
												label : cvLoc('label.dateRangeOptions.customRange'),
												value : "Custom"
											});
										}

										// if value is preset
										if($scope.ngModel && (cvGridFactory.convertTimeDuration($scope.ngModel) === 'custom')) {
											$scope.isCustomRange = true;
											$scope.selectedRange = JSON.parse($scope.ngModel);
												$scope.selectedRange = {
														start : new Date($scope.selectedRange.start),
														end : new Date($scope.selectedRange.end)
													};
											$scope.selectedRangeString = cvUtil.dateRangeToString(
													$scope.selectedRange.start,
													$scope.selectedRange.end);
										} else {
											$scope.selectedRange = $scope.ngModel;
										}

										var openCustomRangeModal = function(startDateTime, endDateTime) {
											var modalInstance = $modal
													.open({
														templateUrl : appUtil.appRoot
																+ 'common/partials/dateRangeSelector.jsp',
														backdrop : 'static',
														controller : [
																'$scope',
																'$uibModalInstance',
																'cvMaxRangeAllowed',
																function($scope, $modalInstance, cvMaxRangeAllowed) {
																	$scope.clear = function() {
																		$modalInstance.dismiss("clear");
																	};

																	$scope.saveDateRange = function() {
																		$modalInstance.close({
																			start : $scope.datepicker.from.value,
																			end : $scope.datepicker.to.value
																		});
																	};

																	// date and time picker options
																	$scope.datepicker = {
																		from : {
																			open : false,
																			dateOptions : {
																				dateFormat : 'yyyy-MM-dd',
																				showWeeks : false
																			},
																			timeOptions : {
																				max : null
																			},
																			value : startDateTime || new Date()
																		},
																		to : {
																			open : false,
																			dateOptions : {
																				dateFormat : 'yyyy-MM-dd',
																				showWeeks : false
																			},
																			timeOptions : {
																				min : null
																			},
																			value : endDateTime || new Date()
																		}
																	};
																	$scope.open = function(openToDate) {
																		$scope.datepicker[openToDate].open = !$scope.datepicker[openToDate].open;
																	}

																	$scope
																			.$watchGroup(
																					[
																							'datepicker.from.value',
																							'datepicker.to.value' ],
																					function(newValues) {
																						// set min value of "to" datepicker as "from" value
																						$scope.datepicker.to.dateOptions.minDate = newValues[0];
																						$scope.datepicker.to.timeOptions.min = newValues[0];

																						// set max value of "from" datepicker as "to" value
																						$scope.datepicker.from.dateOptions.maxDate = newValues[1];
																						$scope.datepicker.from.timeOptions.max = newValues[1];

																						if (cvMaxRangeAllowed) {
																							// set max value of "to" datepicker based on range allowed
																							var allowedMaxRange = new Date($scope.datepicker.from.value);
																							allowedMaxRange
																									.setDate($scope.datepicker.from.value
																											.getDate()
																											+ cvMaxRangeAllowed);
																							$scope.datepicker.to.dateOptions.maxDate = allowedMaxRange;
																							$scope.datepicker.to.timeOptions.max = allowedMaxRange;

																							//reset to date since max time duration is reached
																							if(($scope.datepicker.to.value.getTime() - $scope.datepicker.from.value.getTime()) > cvMaxRangeAllowed*24*60*60*1000) {
																								$scope.datepicker.to.value = allowedMaxRange;
																							}
																						}
																					});
																} ],
														resolve : {
															cvMaxRangeAllowed : function() {
																return $scope.cvMaxRangeAllowed;
															}
														}
													});
											modalInstance.result.then(function(range) {
												if (range.start && range.end) {
													$scope.isCustomRange = true;
													$scope.selectedRange = range;
													$scope.selectedRangeString = cvUtil.dateRangeToString(
															$scope.selectedRange.start,
															$scope.selectedRange.end);
													$scope.ngModel = angular.toJson($scope.selectedRange);
												} else {
													$scope.isCustomRange = false;
													$scope.ngModel = "";
												}
												// call the handler
												$scope.externalCallback();
											}, function(obj) {
												if (obj === "close") {
													// x on top the modal is clicked
													if ($scope.selectedRange === "Custom") {
														// treat as clear button is invoked
														$scope.isCustomRange = false;
														$scope.selectedRange = undefined;
														$scope.ngModel = "";
														$scope.externalCallback();
													}
													// else do nothing
												} else if (obj === "clear") {
													// clear button is invoked
													$scope.isCustomRange = false;
													$scope.selectedRange = undefined;
													$scope.ngModel = "";
													$scope.externalCallback();
												}
											});
										};

										$scope.onChangeHandler = function(_selectedRange) {
											if (_selectedRange === "Custom") {
												openCustomRangeModal();
											} else {
												$scope.ngModel = _selectedRange;
												$scope.externalCallback();
											}
										};

										$scope.editCustomRange = function() {
											//convert time range to date format to match calendar
												var modelObj = JSON.parse($scope.selectedRange);
												$scope.selectedRange =  {
													start : new Date(modelObj.start),
													end : new Date(modelObj.end)
												};
											openCustomRangeModal($scope.selectedRange.start, $scope.selectedRange.end);
										};

										$scope.externalCallback = function() {
											$timeout(function() {
												$scope.cvOnChange()($scope.selectedRange);
											});
										};
									} ],
							link : function(scope, element, attrs, ngModelCtrl) {

								ngModelCtrl.$parsers.push(function(viewValue) {
									return viewValue ? JSON.stringify(viewValue) : undefined;
								});

								ngModelCtrl.$render = function() {
									if (!ngModelCtrl.$viewValue) {
										// set default value if nothing is set
										ngModelCtrl.$viewValue = undefined;
										scope.selectedRange = ngModelCtrl.$viewValue;
									} else {
										scope.selectedRange = ngModelCtrl.$viewValue;
									}
								};
							}
						};
					} ]);

	// directive to parse string value to number format for numeric inputs
	cvCommon.directive('input', [ function() {
		return {
			restrict : 'E',
			require : '?ngModel',
			link : function(scope, element, attrs, ngModel) {
				if (attrs.type === 'number' && attrs.class !== undefined
						&& attrs.class.indexOf("ui-grid-filter-input") !== -1 && ngModel) {
					ngModel.$formatters.push(function(modelValue) {
						return Number(modelValue);
					});

					ngModel.$parsers.push(function(viewValue) {
						return Number(viewValue);
					});
				}
			}
		}
	} ]);

	// Directive to add size filters for grid.
	cvCommon
			.directive(
					'cvGridFilterSize',
					[ function() {
						return {
							restrict : 'E',
							//replace : true,
							require : 'ngModel',
							templateUrl : appUtil.appRoot + 'common/partials/cvGridFilterSize.jsp',
							scope : {
								ngModel : '=',
								cvOnChange : '&'
							},
							controller : [
									'$scope',
									'$filter',
									'$uibModal',
									'$timeout',
									'cvUtil',
									function($scope, $filter, $modal, $timeout, cvUtil) {

										// populate the options
										$scope.selectOptions = [ {
											label : 'B',
											value : 1
										}, {
											label : 'KB',
											value : 1024
										}, {
											label : 'MB',
											value : 1024 * 1024
										}, {
											label : 'GB',
											value : 1024 * 1024 * 1024
										}, {
											label : 'TB',
											value : 1024 * 1024 * 1024 * 1024
										} ];

										// if value is preset
										if ($scope.ngModel) {
											$scope.isCustomRange = true;
											$scope.selectedRange = JSON.parse($scope.ngModel);
											$scope.selectedRange = {
												start : new Date($scope.selectedRange.start),
												end : new Date($scope.selectedRange.end)
											};
											$scope.selectedRangeString = cvUtil.dateRangeToString(
													$scope.selectedRange.start,
													$scope.selectedRange.end);
										}

										var openCustomRangeModal = function(startDateTime, endDateTime) {
											var modalInstance = $modal
													.open({
														templateUrl : appUtil.appRoot
																+ 'common/partials/dateRangeSelector.jsp',
														backdrop : 'static',
														controller : [
																'$scope',
																'$uibModalInstance',
																function($scope, $modalInstance) {
																	$scope.clear = function() {
																		$modalInstance.dismiss({
																			start : "",
																			end : ""
																		});
																	};

																	$scope.saveDateRange = function() {
																		$modalInstance.close({
																			start : $scope.datepicker.from.value,
																			end : $scope.datepicker.to.value
																		});
																	};

																	// date and time picker options
																	$scope.datepicker = {
																		from : {
																			open : false,
																			dateOptions : {
																				dateFormat : 'yyyy-MM-dd',
																				showWeeks : false
																			},
																			timeOptions : {
																				max : null
																			},
																			value : startDateTime || new Date()
																		},
																		to : {
																			open : false,
																			dateOptions : {
																				dateFormat : 'yyyy-MM-dd',
																				showWeeks : false
																			},
																			timeOptions : {
																				min : null
																			},
																			value : endDateTime || new Date()
																		}
																	};
																	$scope.open = function(openToDate) {
																		$scope.datepicker[openToDate].open = !$scope.datepicker[openToDate].open;
																	}

																	$scope
																			.$watchGroup(
																					[
																							'datepicker.from.value',
																							'datepicker.to.value' ],
																					function(newValues) {
																						$scope.datepicker.to.dateOptions.minDate = newValues[0];
																						$scope.datepicker.to.timeOptions.min = newValues[0];

																						$scope.datepicker.from.dateOptions.maxDate = newValues[1];
																						$scope.datepicker.from.timeOptions.max = newValues[1];
																					});
																} ]
													});
											modalInstance.result.then(function(range) {
												if (range.start && range.end) {
													$scope.isCustomRange = true;
													$scope.selectedRange = range;
													$scope.selectedRangeString = cvUtil.dateRangeToString(
															$scope.selectedRange.start,
															$scope.selectedRange.end);
												} else {
													$scope.isCustomRange = false;
													$scope.selectedRange = undefined;
												}
												// call the handler
												$scope.externalCallback();
											}, function(obj) {
												if (obj && obj.start !== undefined) {
													// clear button is invoked
													$scope.isCustomRange = false;
													$scope.selectedRange = undefined;
													$scope.externalCallback();
												}
											});
										};

										$scope.onChangeHandler = function(_selectedRange) {
											if (_selectedRange === null) {
												openCustomRangeModal();
											} else {
												$scope.selectedRange = _selectedRange;
												$scope.externalCallback();
											}
										};

										$scope.editCustomRange = function() {
											openCustomRangeModal($scope.selectedRange.start, $scope.selectedRange.end);
										};

										$scope.externalCallback = function() {
											$timeout(function() {
												$scope.cvOnChange()($scope.selectedRange);
											});
										};
									} ],
							link : function(scope, element, attrs, ngModelCtrl) {
								ngModelCtrl.$formatters.push(function(modelValue) {
									if (modelValue) {
										var modelObj = JSON.parse(modelValue);
										return {
											start : new Date(modelObj.start),
											end : new Date(modelObj.end)
										};
									}
									return undefined;
								});

								ngModelCtrl.$parsers.push(function(viewValue) {
									return viewValue ? JSON.stringify(viewValue) : undefined;
								});

								scope.$watch('selectedRange', function() {
									ngModelCtrl.$setViewValue(scope.selectedRange);
								}, true);

								ngModelCtrl.$render = function() {
									if (!ngModelCtrl.$viewValue) {
										// set default value if nothing is set
										ngModelCtrl.$viewValue = undefined;
									}

									scope.selectedRange = ngModelCtrl.$viewValue;
								};
							}
						};
					} ]);

			cvCommon.directive('optionsClass', ['$parse',  function ($parse) {
				  return {
				    require: 'select',
				    link: function(scope, elem, attrs, ngSelect) {
				      // get the source for the items array that populates the select.
				      var optionsSourceStr = attrs.ngOptions.split(' ').pop(),
				      // use $parse to get a function from the options-class attribute
				      // that you can use to evaluate later.
				          getOptionsClass = $parse(attrs.optionsClass);

				      scope.$watch(optionsSourceStr, function(items) {
				        // when the options source changes loop through its items.
				        angular.forEach(items, function(item, index) {
				          // evaluate against the item to get a mapping object for
				          // for your classes.
				          var classes = getOptionsClass(item),
				          // also get the option you're going to need. This can be found
				          // by looking for the option with the appropriate index in the
				          // value attribute.
				          option = elem.find('option[value=\'number:' + index + '\']');
				          // now loop through the key/value pairs in the mapping object
				          // and apply the classes that evaluated to be truthy.
				          angular.forEach(classes, function(add, className) {
				            if(add) {
				              angular.element(option).addClass(className);
				            }
				          });
				        });
				      });
				    }
				  };
				}]);
})();