(/**
	 *
	 *
	 */
function() {
	'use strict';

	var cvCommon = angular.module('cvCommon');

	cvCommon
			.directive(
					'cvCompanyDropdown',
					function() {
						return {
							restrict : 'E',
							templateUrl : appUtil.appRoot + 'common/partials/companyDropdown.jsp',
							scope : {
								companyId : '='
							},
							controller : [
									'$scope',
									'subscriptionService',
									'$stateParams',
									'$state',
									'cvLoc',
									'$timeout',
									'cvUtil',
									'cvToaster',
									'cvMultiCommcell',
									function($scope, subscriptionService, $stateParams, $state, cvLoc, $timeout,
											cvUtil, cvToaster, cvMultiCommcell) {

										if (cv.isOnCommcellLevel) {
											//indicate if there're at least two commcells installed on this machine
											$scope.multiCC = cv.sessionContext.isMultiComcellAware
													&& (cv.sessionContext.dataSourceList.length > 1);
											$scope.companyId = $stateParams["companyId"];
											$scope.isLoading = true;
											var selectedDataSource = cvMultiCommcell.getSelectedCommcell();
											var allCommcells = cv.sessionContext.dataSourceList;
											if (selectedDataSource
													&& (selectedDataSource.length === allCommcells.length)) {
												$scope.commcellName = null;
											} else {
												$scope.commcellName = selectedDataSource;
											}
											$scope.showCompanyDropdown = cv.sessionContext
													&& cv.sessionContext.operatorCompanyId ? false : true;
											$scope.companyList = [];
											$scope.labels = {
												nothingSelected : "",
												search : cvLoc('placeholder.searchCompany')
											}

											subscriptionService
													.getSubscriptionsByCre($scope.commcellName)
													.success(
															function(data) {
																if ((data.errorCode && data.errorCode != 0)
																		|| (data.error && data.error.errorCode != 0)) {
																	cvToaster
																			.showErrorMessage({
																				'ttl' : '5000', //5 sec
																				'message' : cvLoc('error.subscriptionLoadError')
																			});
																	$scope.companyList.unshift({
																		'name' : cvLoc('label.allCompanies'),
																		'value' : undefined,
																		'selected' : true
																	});
																	return;
																}

																data = data.providers || [];
																var isCompanySelected = false;

																$scope.companyCommcellList = {};
																data
																		.forEach(function(s) {
																			if (s.shortName) {
																				var company = {
																					'name' : s.connectName,
																					'value' : s.shortName.id
																				}
																				var companyId = parseInt($scope.companyId);
																				//add commcell name is multi commcell supported and multiple commcell selected
																				if ($scope.multiCC
																						&& selectedDataSource
																						&& (selectedDataSource.length > 1)
																						&& s._commcell_
																						&& s._commcell_.commCellName) {
																					company.commcellName = s._commcell_.commCellName;
																					if ($scope.companyCommcellList[company.commcellName]) {
																						$scope.companyCommcellList[company.commcellName]
																								.push(company);
																					} else {
																						$scope.companyCommcellList[company.commcellName] = [ company ];
																					}
																					;
																					company.selected = (company.value === companyId)
																							&& (company.commcellName === $stateParams["_cn"]) ? true
																							: false;
																				} else {
																					company.selected = company.value === companyId ? true
																							: false;
																					$scope.companyList.push(company);
																				}
																				if (company.selected
																						&& !isCompanySelected) {
																					isCompanySelected = true;
																				}
																			}
																		});

																//if setup is multi commcell and multiple commcell selected, add group in selections
																if ($scope.multiCC && selectedDataSource
																		&& (selectedDataSource.length > 1)) {
																	// add groups in dropdown options
																	for ( var commcellName in $scope.companyCommcellList) {
																		$scope.companyList.push({
																			name : commcellName,
																			msGroup : true
																		});
																		var companies = cvUtil
																				.sortAscending(
																						$scope.companyCommcellList[commcellName],
																						'name');
																		$scope.companyList = $scope.companyList
																				.concat(companies);
																		$scope.companyList.push({
																			msGroup : false
																		});
																	}
																} else {
																	$scope.companyList = cvUtil.sortAscending(
																			$scope.companyList,
																			'name');
																}

																var defaultItem = {
																	'name' : cvLoc('label.allCompanies'), // localize
																	'value' : undefined,
																	'selected' : isCompanySelected ? false : true
																}

																$scope.companyList.unshift(defaultItem);
																$scope.isLoading = false;
															}).error(function(e) {
														$scope.isLoading = false;
														cvToaster.showErrorMessage({
															'ttl' : '5000', //5 sec
															'message' : cvLoc('error.subscriptionLoadError')
														});
													});

										} else {
											$scope.showCompanyDropdown = false;
										}

										$scope.changeCompany = function(selectedCompany) {
											var params = {
												companyId : selectedCompany.value,
												_cn : $stateParams["_cn"]
											}
											//if selected "All companies" option, remove _cn from url params
											if (params.companyId == undefined) {
												params._cn = undefined;
											} else if (selectedCompany.commcellName) { //if multi-commcell supported, selected company has commcell name
												params._cn = selectedCompany.commcellName;
											}

											$state.go('.', params, {
												notify : true
											});
										};

									} ]
						}
					});

	cvCommon.directive('cvAlertComponent', function() {
		return {
			restrict : 'E',
			templateUrl : appUtil.appRoot + 'common/partials/alertTemplate.jsp',
			scope : {
				alerts : '=',
				showEdit : '=',
				planAlertsObj : '=',
				overrideText : '=?'
			},
			controller : [
					'$scope',
					'$uibModal',
					function($scope, $modal) {
						$scope.modifyAlertsList = function() {
							var modalInstance = $modal.open({
								templateUrl : appUtil.appRoot + 'dlo/partials/editAlertsList.jsp',
								backdrop : 'static',
								controller : [
										'$scope',
										'$log',
										'$uibModalInstance',
										'$state',
										'cvLoc',
										'$stateParams',
										'profileService',
										'cvUtil',
										'$location',
										'planAlertsObj',
										function($scope, $log, $modalInstance, $state, cvLoc, $stateParams,
												profileService, cvUtil, $location, planAlertsObj) {
											$scope.editAlertsServerMessage = cvUtil.emptyMsg();
											$scope.currentAlerts = planAlertsObj.alertInfo.currentAlerts;
											$scope.globalAlerts = planAlertsObj.globalAlerts;
											$scope.profileId = planAlertsObj.profileId;

											function alertCheck(value) {
												return $scope.currentAlerts.some(function(el) {
													return el.value === value;
												});
											}

											for (var i = 0; i < $scope.globalAlerts.length; i++) {
												if (alertCheck($scope.globalAlerts[i].value)) {
													$scope.globalAlerts[i].selected = true;
												} else {
													$scope.globalAlerts[i].selected = false;
												}
											}

											$scope.saveAlerts = function() {

												$scope.editAlertsServerMessage = cvUtil.emptyMsg();

												var selectedAlerts = [];
												var newAlerts = [];
												var alert = {};
												for (var i = 0; i < $scope.globalAlerts.length; i++) {
													if ($scope.globalAlerts[i].selected == true) {
														selectedAlerts.push($scope.globalAlerts[i].value);
														alert = $scope.globalAlerts[i];
														newAlerts.push(alert)
													}
												}

												$scope.editAlertsServerMessage = cvUtil.infoMsg(cvLoc('label.saving'));
												profileService.editProfileAlerts({
													'id' : $scope.profileId,
													'alertIds' : JSON.stringify(selectedAlerts)
												}).success(function(data) {
													planAlertsObj.alertInfo.currentAlerts = newAlerts;
													$modalInstance.dismiss();
												}).error(function(e) {
													$scope.editAlertsServerMessage = {
														type : 'error',
														message : e
													};
												});

											};

											$scope.cancel = function() {
												$modalInstance.dismiss();
											};
										} ],
								resolve : {
									planAlertsObj : function() {
										return $scope.planAlertsObj;
									}
								}
							});
						};
					} ]
		}
	});

	cvCommon.directive('cvWizardComponent', [ function() {

		var wizardController = [
				'$scope',
				'$log',
				'cvLoc',
				'cvUtil',
				'$uibModal',
				function($scope, $log, cvLoc, cvUtil, $modal) {
					var self = this;

					self.step = 0;
					self.initData = function(steps, wizardTitle, submitMethod, cancelMethod) {
						self.steps = steps;
						self.wizardTitle = wizardTitle;
						self.submitMethod = submitMethod;
						self.cancelMethod = cancelMethod;
					}

					self.getCurrentStep = function() {
						return self.step;
					};

					self.getCurrentPage = function() {
						if (self.steps && (self.steps.length > self.getCurrentStep())) {
							return self.steps[self.getCurrentStep()];
						}
					};

					self.setCurrentStep = function(stepNumber) {
						self.step = stepNumber;
					}

					self.isFirstStep = function() {
						return self.step === 0;
					};

					self.isStepDone = function(stepNumber) {
						if (stepNumber == (self.steps.length - 1)) {
							return false;
						}
						return self.steps[stepNumber].completed;
					};

					self.isLastStep = function() {
						return self.step === (self.steps.length - 1);
					};

					self.getNextLabel = function() {
						return (self.isLastStep()) ? cvLoc('Finish') : cvLoc('Next');
					};

					self.getPreviousLabel = function() {
						return cvLoc('previous');
					};

					self.goToNextPage = function(event) {
						//add a validation method to add more complex validations
						if (self.getCurrentPage().validateMethod) {
							var errorMessage = self.getCurrentPage().validateMethod();
							if (errorMessage) {
								self.wizardMessage = {
									'message' : errorMessage,
									'type' : 'error'
								};
								return;
							}
						}
						self.wizardMessage = {};
						self.steps[self.step].completed = true;
						self.step++;
						if (self.steps[self.step].skipStep) {
							self.step++; // skip the step in not need.
						}
						if (self.isLastStep()) {
							self.steps[self.step].completed = true;
						}
					}

					self.goToPreviousPage = function() {
						self.step--;
						if (self.steps[self.step].skipStep) {
							self.step--; // skip the step in not need.
						}
					}
				} ];
		return {
			restrict : 'E',
			templateUrl : appUtil.appRoot + 'common/partials/wizardTemplate.jsp',
			controller : wizardController,
			controllerAs : 'wizardCtrl'
		};
	} ]);

	cvCommon
			.directive(
					'cvPlanComponent',
					[ function() {
						return {
							restrict : 'E',
							templateUrl : appUtil.appRoot + 'common/partials/planTemplate.jsp',
							scope : {
								subclientId : '=',
								backupSetId : '=',
								type : '@',
								isDevice : '@',
								planEntity : '=',
								clientId : '=',
								appId : '=',
								vendor : '=',
								highlightError : '@',
								dontShowEdit : '=',
								dontReload : '@',
								disablePlanLink : '=?',
								showLoader : '=?'
							},
							controller : [
									'$scope',
									'$log',
									'cvLoc',
									'cvUtil',
									'profileService',
									'$uibModal',
									'profileUIFactory',
									function($scope, $log, cvLoc, cvUtil, profileService, $modal, profileUIFactory) {

										if (angular.isDefined($scope.planEntity)
												&& angular.isDefined($scope.planEntity.planId)) {
											$scope.planTemplate = true;
											$scope.planName = $scope.planEntity.planName;
											$scope.planId = $scope.planEntity.planId;
										} else if (angular.isDefined($scope.subclientId)) {
											profileService.getPlanForSubclient($scope.subclientId).success(
													function(data) {
														if (data.summary && data.summary.plan
																&& data.summary.plan.planId) {
															$scope.planName = data.summary.plan.planName;
															$scope.planId = data.summary.plan.planId;
															$scope.planSubType = data.summary.subtype;
														} else {
															$scope.planMessage = cvUtil
																	.errMsgLoc('error.noPlanAssociated');
															// no plan is associated
															$scope.planId = -1;
														}

														$scope.planTemplate = true;
													}).error(function(e) {
												$scope.planMessage = cvUtil.errMsg(e);
												$scope.planTemplate = true;
											});
										} else {
											if ($scope.highlightError && $scope.highlightError === "false") {
												$scope.planMessage = cvUtil.infoMsgLoc('error.noPlanAssociated');
											} else {
												$scope.planMessage = cvUtil.errMsgLoc('error.noPlanAssociated');
											}

											$scope.planId = -1;
											$scope.planTemplate = true;
										}

										$scope.editPlanBackupset = function() {
											var modalInstance = $modal
													.open({
														templateUrl : appUtil.appRoot
																+ 'common/partials/editPlanBackupset.jsp',
														backdrop : 'static',
														controller : [
																'$scope',
																'$log',
																'$uibModalInstance',
																'$state',
																'cvLoc',
																'$stateParams',
																'cvUtil',
																'$location',
																'planId',
																'backupSetId',
																'profileService',
																'planType',
																'clientId',
																'appId',
																function($scope, $log, $modalInstance, $state, cvLoc,
																		$stateParams, cvUtil, $location, planId,
																		backupSetId, profileService, planType,
																		clientId, appId) {

																	$scope.planId = planId;
																	$scope.planType = "MSP";

																	$scope.localLang = cvUtil.getIStevenLocLabels();
																	$scope.selectedPlanList = [];

																	$scope.parseIStevenOutput = function() {
																		if ($scope.selectedPlanList.length) {
																			$scope.selectedPlan = $scope.selectedPlanList[0].planId;
																		} else {
																			$scope.selectedPlan = undefined;
																		}
																	};

																	$scope.editPlanServerMessage = cvUtil
																			.infoMsgLoc('Loading');
																	profileService
																			.getEligiblePlansForBackupSet({
																				clientId : clientId,
																				appId : appId,
																				backupSetId : backupSetId
																			})
																			.success(
																					function(data) {
																						$scope.editPlanServerMessage = cvUtil
																								.emptyMsg();
																						if (data.length > 0) {
																							$scope.planList = [];
																							$scope.planListByTypes = {};
																							data
																									.forEach(function(
																											planSummary) {
																										var planObj = {
																											planName : planSummary.plan.planName,
																											planId : planSummary.plan.planId,
																											planType : planSummary.type,
																											type : planSummary.subtype,
																											selected : $scope.planId === planSummary.plan.planId,
																											rpoInMinutes : planSummary.rpoInMinutes,
																											numAssocEntities : planSummary.numAssocEntities,
																											numCopies : planSummary.numCopies
																										};
																										// rename FSServer to File System
																										if (planObj.type === 'FSServer') {
																											planObj.type = cvLoc(planObj.type);
																										}

																										if ($scope.planListByTypes[planObj.type]) {
																											$scope.planListByTypes[planObj.type]
																													.push(planObj);
																										} else {
																											$scope.planListByTypes[planObj.type] = [ planObj ];
																										}
																									});

																							$scope.selectedPlan = $scope.planId;
																							for ( var planType in $scope.planListByTypes) {
																								$scope.planList
																										.push({
																											planName : planType,
																											msGroup : true
																										});
																								var plansByType = cvUtil
																										.sortAscending(
																												$scope.planListByTypes[planType],
																												'planName');
																								$scope.planList = $scope.planList
																										.concat(plansByType);
																								$scope.planList.push({
																									msGroup : false
																								});
																							}
																						} else {
																							$scope.planList = [];
																							$scope.editPlanServerMessage = cvUtil
																									.errMsgLoc('error.noProfiles');
																						}
																					})
																			.error(
																					function(e) {
																						$scope.editPlanServerMessage = cvUtil
																								.errMsg(e);
																					});

																	$scope.savePlanForBackupset = function() {

																		$scope.editPlanServerMessage = cvUtil
																				.emptyMsg();

																		profileService
																				.editPlanForBackupSet({
																					'planId' : $scope.selectedPlan,
																					'backupSetId' : backupSetId,
																					'appId' : appId,
																					'clientId' : clientId
																				})
																				.success(
																						function(data) {
																							$modalInstance
																									.close({
																										'planId' : $scope.selectedPlan,
																										'planName' : $scope.selectedPlanList[0].planName,
																										'planType' : $scope.selectedPlanList[0].planType
																									});
																						})
																				.error(
																						function(e) {
																							$scope.editPlanServerMessage = cvUtil
																									.errMsg(e);
																						});

																	};

																	$scope.cancel = function() {
																		$modalInstance.dismiss();
																	};
																} ],
														resolve : {
															planId : function() {
																return $scope.planId;
															},
															backupSetId : function() {
																return $scope.backupSetId;
															},
															planType : function() {
																return $scope.type;
															},
															clientId : function() {
																return $scope.clientId;
															},
															appId : function() {
																return $scope.appId;
															}
														}
													});

											modalInstance.result.then(function(planObj) {
												if (planObj) {
													$scope.planMessage = cvUtil.emptyMsg();
													$scope.planName = planObj.planName;
													$scope.planId = planObj.planId;
													// add subclient button in backup set details page is based on this
													$scope.$emit('backupSetPlanChanged', planObj);
													//$scope.planEntity = planObj;
												}
											});
										};

										$scope.editPlanSubclient = function() {
											var modalInstance = $modal
													.open({
														templateUrl : appUtil.appRoot
																+ 'common/partials/editPlanSubclient.jsp',
														backdrop : 'static',
														controller : [
																'$scope',
																'$log',
																'$uibModalInstance',
																'$state',
																'cvLoc',
																'$stateParams',
																'cvUtil',
																'$location',
																'planId',
																'subclientId',
																'profileService',
																'collectionFactory',
																'planType',
																'clientId',
																'appId',
																'vendor',
																'dontReload',
																function($scope, $log, $modalInstance, $state, cvLoc,
																		$stateParams, cvUtil, $location, planId,
																		subclientId, profileService, collectionFactory,
																		planType, clientId, appId, vendor, dontReload) {

																	$scope.planId = planId;
																	$scope.planType = "MSP";

																	$scope.localLang = cvUtil.getIStevenLocLabels();
																	$scope.selectedPlanList = [];

																	$scope.parseIStevenOutput = function() {
																		if ($scope.selectedPlanList.length) {
																			$scope.selectedPlan = $scope.selectedPlanList[0].planId;
																		} else {
																			$scope.selectedPlan = undefined;
																		}
																	};

																	$scope.editPlanServerMessage = cvUtil
																			.infoMsgLoc('Loading');
																	profileService
																			.getEligiblePlansForSubClient({
																				clientId : clientId,
																				appId : appId,
																				subClientId : subclientId
																			})
																			.success(
																					function(data) {
																						$scope.editPlanServerMessage = cvUtil
																								.emptyMsg();
																						if (data.length > 0) {
																							if (vendor) {
																								// filter data by vendor
																								data = collectionFactory
																										.filterPlansByVendor(
																												data,
																												vendor);
																							}

																							$scope.planList = [];
																							$scope.planListByTypes = {};
																							data
																									.forEach(function(
																											planSummary) {
																										var planObj = {
																											planName : planSummary.plan.planName,
																											planId : planSummary.plan.planId,
																											type : planSummary.subtype,
																											selected : $scope.planId === planSummary.plan.planId,
																											rpoInMinutes : planSummary.rpoInMinutes,
																											numAssocEntities : planSummary.numAssocEntities,
																											numCopies : planSummary.numCopies
																										};
																										// rename FSServer to File System
																										if (planObj.type === 'FSServer') {
																											planObj.type = cvLoc(planObj.type);
																										}

																										if ($scope.planListByTypes[planObj.type]) {
																											$scope.planListByTypes[planObj.type]
																													.push(planObj);
																										} else {
																											$scope.planListByTypes[planObj.type] = [ planObj ];
																										}
																									});

																							$scope.selectedPlan = $scope.planId;
																							for ( var planType in $scope.planListByTypes) {
																								$scope.planList
																										.push({
																											planName : planType,
																											msGroup : true
																										});
																								var plansByType = cvUtil
																										.sortAscending(
																												$scope.planListByTypes[planType],
																												'planName');
																								$scope.planList = $scope.planList
																										.concat(plansByType);
																								$scope.planList.push({
																									msGroup : false
																								});
																							}
																						} else {
																							$scope.planList = [];
																							$scope.editPlanServerMessage = cvUtil
																									.errMsgLoc('error.noProfiles');
																						}
																					})
																			.error(
																					function(e) {
																						$scope.editPlanServerMessage = cvUtil
																								.errMsg(e);
																					});

																	$scope.savePlanForSubclient = function() {

																		$scope.editPlanServerMessage = cvUtil
																				.emptyMsg();

																		profileService
																				.editPlanForSubclient({
																					'planId' : $scope.selectedPlan,
																					'subclientId' : subclientId
																				})
																				.success(
																						function(data) {
																							if (dontReload) {
																								$modalInstance
																										.close({
																											'planId' : $scope.selectedPlan,
																											'planName' : $scope.selectedPlanList[0].planName
																										});
																							} else {
																								$modalInstance
																										.dismiss();
																								$state.forceReload();
																							}

																						})
																				.error(
																						function(e) {
																							$scope.editPlanServerMessage = cvUtil
																									.errMsg(e);
																						});

																	};

																	$scope.cancel = function() {
																		$modalInstance.dismiss();
																	};
																} ],
														resolve : {
															planId : function() {
																return $scope.planId;
															},
															subclientId : function() {
																return $scope.subclientId;
															},
															planType : function() {
																return $scope.type;
															},
															clientId : function() {
																return $scope.clientId;
															},
															appId : function() {
																return $scope.appId;
															},
															vendor : function() {
																return $scope.vendor;
															},
															dontReload : function() {
																return $scope.dontReload;
															}
														}
													});

											modalInstance.result.then(function(planObj) {
												if (planObj) {
													$scope.planMessage = cvUtil.emptyMsg();
													$scope.planName = planObj.planName;
													$scope.planId = planObj.planId;

													// reload page to update content and other tiles
													// location.reload();
												}
											});
										};

									} ]
						};
					} ]);

	// Directive used for right click support as per http://jsfiddle.net/7nm0LprL/
	cvCommon.directive('contextMenu', function($parse) {
		var renderContextMenu = function($scope, event, options) {
			if (!$) {
				var $ = angular.element;
			}
			$(event.currentTarget).addClass('context');
			var $contextMenu = $('<div>');
			$contextMenu.addClass('uib-dropdown clearfix');
			var $ul = $('<ul>');
			$ul.addClass('uib-dropdown-menu');
			$ul.attr({
				'role' : 'menu'
			});
			$ul.css({
				display : 'block',
				position : 'absolute',
				left : event.pageX + 'px',
				top : event.pageY + 'px'
			});
			angular.forEach(options, function(item, i) {
				var $li = $('<li>');
				if (item === null) {
					$li.addClass('divider');
				} else {
					var $a = $('<a>');
					$a.attr({
						tabindex : '-1',
						href : '#'
					});
					$a.text(typeof item[0] == 'string' ? item[0] : item[0].call($scope, $scope));
					$li.append($a);
					$li.on('click', function($event) {
						$event.preventDefault();
						$scope.$apply(function() {
							$(event.currentTarget).removeClass('context');
							$contextMenu.remove();
							item[1].call($scope, $scope);
						});
					});
				}
				$ul.append($li);
			});
			$contextMenu.append($ul);
			var height = Math.max(
					document.body.scrollHeight,
					document.documentElement.scrollHeight,
					document.body.offsetHeight,
					document.documentElement.offsetHeight,
					document.body.clientHeight,
					document.documentElement.clientHeight);
			$contextMenu.css({
				width : '100%',
				height : height + 'px',
				position : 'absolute',
				top : 0,
				left : 0,
				zIndex : 9999
			});
			$(document).find('body').append($contextMenu);
			$contextMenu.on("mousedown", function(e) {
				if ($(e.target).hasClass('uib-dropdown')) {
					$(event.currentTarget).removeClass('context');
					$contextMenu.remove();
				}
			}).on('contextmenu', function(event) {
				$(event.currentTarget).removeClass('context');
				event.preventDefault();
				$contextMenu.remove();
			});
		};
		return function($scope, element, attrs) {
			element.on('contextmenu', function(event) {
				$scope.$apply(function() {
					event.preventDefault();
					var options = $scope.$eval(attrs.contextMenu);
					if (options instanceof Array) {
						renderContextMenu($scope, event, options);
					} else {
						throw '"' + attrs.contextMenu + '" not an array';
					}
				});
			});
		};
	});

	/*
	 * Directive is used to resize the grid as per the page height
	 */
	cvCommon.directive('cvPageHeight', [ '$log', '$window', function($log, $window) {
		return {
			restrict : 'A',
			link : function(scope, element, attrs) {
				function resizeRestoreGrid() {
					var wrapper = angular.element("#wrapper").height();
					var elementTop = element[0].getBoundingClientRect().top;
					var pagingSpacing = parseInt(attrs.cvBottomOffset) || 10; // kinda hacky

					element.height(wrapper - elementTop - pagingSpacing);
				}
				var w = angular.element($window);
				w.on('resize', resizeRestoreGrid);
				resizeRestoreGrid();
			}

		//				return function(scope, element) {
		//					var w = angular.element($window);
		//					console.log("binding resize event");
		//					w.on('resize', resizeRestoreGrid);
		//				};
		}
	} ]);

	/*
	 * Directive is used to resize the graph in serverDetails and collectionDetails pages
	 */

	cvCommon.directive('cvResizeGraph', [ '$log', '$window', function($log, $window) {
		return function(scope, element) {
			var w = angular.element($window);

			w.on('resize', function() {
				scope.vmStatusChartConfig.size.width = angular.element('.page-details-box').width() - 100;
				scope.$apply();
			});
		};
	} ]);

	/*
	 * Used to adjust the height of the UI grid according to the number of rows to be shown on the page
	 */
	cvCommon.directive('cvUiGridResize', [
			'gridUtil',
			'$window',
			function(gridUtil, $window) {
				return {
					restrict : 'A',
					require : 'uiGrid',
					link : function($scope, $elm, $attrs, uiGridCtrl) {
						var grid = uiGridCtrl.grid;

						if (grid.api.pagination) {
							grid.api.pagination.on.paginationChanged($scope, function(newPage, pageSize) {
								var dataLength;
								if (grid.options.totalItems) {
									dataLength = grid.options.totalItems;
								} else {
									dataLength = angular.isString(grid.options.data) ? $scope[grid.options.data].length
											: grid.options.data.length;
								}

								grid.options.minRowsToShow = Math
										.min(dataLength - ((newPage - 1) * pageSize), pageSize);
							});
						}

						var getGridHeight = function() {
							if ($elm.css('max-height') !== "none") {
								return parseInt($elm.css('max-height'));
							}

							// Figure out the new height
							var contentHeight = grid.options.minRowsToShow * grid.options.rowHeight;
							var headerHeight = grid.options.hideHeader ? 0 : grid.options.headerRowHeight;
							var footerHeight = grid.options.showFooter ? grid.options.footerRowHeight : 0;
							var columnFooterHeight = grid.options.showColumnFooter ? grid.options.columnFooterHeight
									: 0;
							var scrollbarHeight = grid.options.enableScrollbars ? gridUtil.getScrollbarWidth() : 0;
							var pagerHeight = 0;
							if ($elm.children('.ui-grid-pager-panel').length > 0) {
								pagerHeight = grid.options.enablePagination ? gridUtil.elementHeight($elm
										.children(".ui-grid-pager-panel")) : 0;
							}

							var maxNumberOfFilters = 0;
							// Calculates the maximum number of filters in the columns
							// inline filters are disabled in grids
							if (false && grid.options.enableFiltering) {
								angular.forEach(grid.options.columnDefs, function(col) {
									if (col.hasOwnProperty('filter')) {
										if (maxNumberOfFilters < 1) {
											maxNumberOfFilters = 1;
										}
									} else if (col.hasOwnProperty('filters')) {
										if (maxNumberOfFilters < col.filters.length) {
											maxNumberOfFilters = col.filters.length;
										}
									}
								});
							}
							var filterHeight = maxNumberOfFilters * headerHeight;

							var newHeight = headerHeight + contentHeight + footerHeight + columnFooterHeight
									+ scrollbarHeight + filterHeight + pagerHeight;

							return newHeight;
						};

						function startResizing() {
							var newGridHeight = getGridHeight();

							if (newGridHeight !== grid.gridHeight) {
								if (newGridHeight) {
									grid.gridHeight = newGridHeight;
									// fix for removing initial unaligned state when rendered
									if (isNaN(grid.gridWidth)) {
										var containerWidth = angular.element(".grid" + grid.id).parent().width();
										if (containerWidth > 0) {
											angular.element(".grid" + grid.id).css("width", containerWidth + "px");
											grid.gridWidth = grid.canvasWidth = containerWidth;
										}
									} else {
										angular.element(".grid" + grid.id).css("width", "");
									}
									grid.updateCanvasHeight();
									$elm.css('height', newGridHeight + 'px');
								} else {
									$elm.css('height', 'auto');
								}

								grid.queueGridRefresh().then(function() {
									newGridHeight = grid.gridHeight
								});
							}
						}

						startResizing();

						var varNamesToWatch = [ $attrs.uiGrid + '.minRowsToShow', $attrs.uiGrid + '.enableFiltering' ];

						var gridResizeTimeout;
						var gridChangesDereg = $scope.$watch('[' + varNamesToWatch.join(',') + ']', function(val) {
							clearTimeout(gridResizeTimeout);
							gridResizeTimeout = setTimeout(startResizing, 50);
						});

						// Bind to window resize events
						var windowResizeTimeout;
						var windowResizeHandler = function() {
							clearTimeout(windowResizeTimeout);
							windowResizeTimeout = setTimeout(startResizing, 750);
						};
						angular.element($window).on('resize', windowResizeHandler);

						$scope.$on('$destroy', function() {
							gridChangesDereg();
							// Unbind from window resize events when the grid is destroyed
							angular.element($window).off('resize', windowResizeHandler);
						});
					}
				};
			} ]);

	/*
	 * Used to show loading spinner when waiting for data from server.
	 */
	cvCommon.directive('cvLoadingSpinner', [
			'$log',
			function($log) {
				return {
					restrict : 'A',
					scope : {
						ngModel : '='
					},
					require : '^ngModel',
					template : '<img ng-show="ngModel==undefined || (ngModel==false && !(ngModel.length == 0))" src="'
							+ appUtil.appRoot + 'common/img/ajax-loader.gif" class="ajax-loader">'
				};
			} ]);

	/*
	 * Used to take user directly to Full restore Page when appType is MSP
	 */
	cvCommon.directive('cvRestoreLink', [ '$log', '$compile', function($log, $compile) {
		return {
			restrict : 'A',
			link : function(scope, ele, attrs) {

				function getParamValue(name, url) {
					if (!url) {
						url = location.href
					}
					name = name.replace(/[\[]/, "\\\[").replace(/[\]]/, "\\\]");
					var regexS = "[\\?&]" + name + "=([^&#]*)";
					var regex = new RegExp(regexS);
					var results = regex.exec(url);
					return results == null ? null : results[1];
				}

				if (cv.nav.appType && (cv.nav.appType == 'msp')) {
					var collectionId = getParamValue('collectionId', attrs.href);
					scope.href = "#browse/vsVolumeBrowse/" + collectionId + "/%5c";
					var fromTime = getParamValue('fromTime', attrs.href);
					var toTime = getParamValue('toTime', attrs.href);
					var vmName = getParamValue('vmname', attrs.href);
					var vmGuid = getParamValue('vmGuid', attrs.href);
					if (fromTime && toTime) {
						scope.href += "?fromTime=" + fromTime;
						scope.href += "&toTime=" + toTime;
					} else if (vmName && vmGuid) {
						scope.href += vmGuid;
						scope.href += "?vmname=" + vmName + "&currentPage=1&bc=true";
					}

				} else {
					return;
				}
				var html = '<a class=' + ele.attr('class') + ' href="' + scope.href + '">' + ele[0].innerHTML + '</a>';
				var e = $compile(html)(scope);
				ele.replaceWith(e);
			}
		};
	} ]);

	/*
	 * Directive used to create Modal
	 */
	cvCommon.directive('cvComponent', [
			'$uibModal',
			'$http',
			'$compile',
			'$log',
			function($modal, $http, $compile, $log) {
				return {
					restrict : 'A',
					compile : function(ele, attrs) {
						$log.debug('Compiling now: ' + attrs.cvComponent);
						if (!service.isVisible(attrs.cvComponent)) {
							ele.html('');
							return null;
						}
					}
				};
			} ]);

	/*
	 * This directive is used when a input box has a model and a watch is applied on that model. We dont want
	 * the watch to be fired before the user enters the full information in the text field.
	 */
	cvCommon.directive('cvModelOnblur', function() {
		return {
			restrict : 'A',
			require : 'ngModel',
			link : function(scope, elm, attr, ngModelCtrl) {

				elm.unbind('input').unbind('change');
				elm.on('blur', function() {
					if (!((elm.val() >= attr.min) && (elm.val() <= attr.max))) {
						return;
					}
					scope.$apply(function() {
						ngModelCtrl.$setViewValue(elm.val());
					});
				});

				elm.on('keydown keypress', function(event) {
					if (event.which === 13) {
						if (!((elm.val() >= attr.min) && (elm.val() <= attr.max))) {
							return;
						}
						scope.$apply(function() {
							ngModelCtrl.$setViewValue(elm.val());
						});
					}
				});
			}
		};
	});

	/**
	 *
	 */
	cvCommon.factory('cvSuperBreadcrumbData', [ '$rootScope', '$transitions', function($rootScope, $transitions) {
		var bcData = {};
		var bc = {};
		var bcCallbacks = [];

		bc.registerBcDataChangeObserver = function(callback) {
			bcCallbacks.push(callback);
		};

		$transitions.onStart({}, function() {
			bcData = [];
			bcCallbacks = [];
		});

		bc.setData = function(key, val) {
			bcData[key] = val;
			angular.forEach(bcCallbacks, function(fn) {
				fn(bcData);
			});
		};

		bc.get = function(key) {
			return bcData[key];
		};

		return bc;
	} ]);

	/**
	 *
	 */
	cvCommon.directive('cvSuperBreadcrumb', [
			'$log',
			'$rootScope',
			'$state',
			function(logger, rootScope, state) {
				var template = '<ul><li ng-repeat="item in bcItems">{{item.title}}</li></ul>';

				var controller = [
						'$scope',
						'cvLoc',
						'cvSuperBreadcrumbData',
						'$transitions',
						function($scope, cvLoc, cvSuperBreadcrumbData, $transitions) {
							$scope.cvLoc = cvLoc;
							$scope.cvSuperBreadcrumbData = cvSuperBreadcrumbData;

							$transitions.onStart({}, function(transition) {
								var toState = transition.to();
								logger.debug('State changed to: ' + toState);
								var cvLoc = event.currentScope.cvLoc;
								var bcFac = event.currentScope.cvSuperBreadcrumbData;
								var bcData = {};

								var getBcData = function(key) {
									return bcData[key];
								};

								//this method goes through the cvBreadcrumbs in the nav object and evaluates each link and title
								var buildBc = function(event) {
									var bcList = toState.cvBreadcrumbs;

									event.currentScope.bcItems = [];
									if (bcList !== undefined && (bcList.length > 0)) {
										event.currentScope.bcItems = [];
										for (var idx = 0; idx < bcList.length; idx++) {
											var bc = bcList[idx];
											event.currentScope.bcItems.push({
												title : eval(bc.title),
												link : eval(bc.link)
											});
										}
										console.debug(event.currentScope.bcItems);
									}
								};

								//this is a callback method to get informed of changes to breadcrumb data
								bcFac.registerBcDataChangeObserver(function(newData) {
									bcData = newData;
									//if there's new data in the factory re-build the breadcrumbs
									buildBc(event);
								});

								//build breadcrumbs first time
								buildBc(event);
							});
						} ];

				return {
					restrict : 'A',
					template : template,
					controller : controller
				};
			} ]);

	/*
	 * Directive for bread crumbs
	 */
	cvCommon.directive('cvBreadcrumb', function() {
		return {
			restrict : 'AE',
			scope : {
				breadcrumbModel : '=ngModel',
				itemTemplate : '=itemTemplate'
			},
			templateUrl : appUtil.appRoot + 'common/partials/breadcrumbs.html'
		};
	});

	cvCommon
			.directive(
					'cvTileLabelValue',
					[ function() {
						return {
							replace : true,
							restrict : 'EA',
							transclude : true,
							scope : {
								label : '@',
								value : '@',
								entityType : '@',
								entity : '='
							},
							
							template : '<li class="group"> \
											<span class="pageDetailColumn">{{label}}</span> \
											<span ng-hide = "isEntity" class="pageDetailColumn">{{value}}</span> \
											<span ng-show = "isEntity" class="pageDetailColumn"><a href="{{getEntityLink(entity)}}"> {{entityName}}</></span> \
										</li>',
							link : function(scope, ele, attrs) {

								scope.isEntity = false;
								if (scope.entityType) {
									scope.isEntity = true;
								}
								scope.getEntityLink = function(entity) {
									var entityLink = '';
									if (entity) {
										switch (scope.entityType) {
										case 'CLIENT_ENTITY':
											scope.entityName = entity.clientName;
											entityLink = '#/clientDetails/' + entity.clientId;
											break;
										case 'APPTYPE_ENTITY':
											scope.entityName = entity.appName;
											entityLink = '#/agentDetails/' + entity.instanceId + '/'
													+ entity.applicationId;
											break;
										case 'INSTANCE_ENTITY':
											scope.entityName = entity.instanceName;
											entityLink = '#/databaseDetails/' + entity.instanceId;
											break;
										case 'BACKUPSET_ENTITY':
											scope.entityName = entity.backupsetName;
											entityLink = '#/dbBackupsetDetails/' + entity.backupsetId;
											break;
										case 'PLAN_ENTITY':
											scope.entityName = entity.planName;
											entityLink = '#/profileDetails/' + entity.planId;
											break;
										case 'VIRTUAL_MACHINE_ENTITY':
											scope.entityName = entity.clientName;
											entityLink = '#/servers/' + entity.clientId;
											break;
										}
									}
									return entityLink;
								}
							}
						};
					} ]);

	cvCommon.directive('cvJobs', [ '$log', function(logger) {
		return {
			restrict : 'AE',
			transclude : true,
			scope : {
				title : '@',
				cvClass : '@',
				jobType : '@',
				entity : '=',
				entityType : '@',
				activeJobs : '='
			},
			template : '<a class="{{cvClass}}" href="{{urlString}}" data-ng-transclude > </a> ',
			link : function(scope, ele, attrs) {

				var urlString = '#jobs?';
				var entity = scope.entity;
				if (entity == null) {
					entity = new Object();
				}
				if (angular.isUndefined(scope.cvClass)) {
					scope.cvClass = 'crop';
				}

				/**
				 * entityType will be the node type for which jobs need to show
				 */
				if (angular.isUndefined(scope.entityType)) {
					scope.entityType = 'COMMCELL_ENTITY';
				}
				/**
				 * jobTypes : 'Backup' or 'Restore'
				 */
				if (angular.isUndefined(scope.jobType)) {
					scope.jobType = 'Backup';
				}
				urlString = urlString + '&jobType=' + scope.jobType;

				if (angular.isUndefined(scope.activeJobs)) {
					scope.activeJobs = 0;
				}
				urlString = urlString + '&activeJobs=' + scope.activeJobs

				/**
				 * Population of node ids based on entityType selection
				 */
				var entityString = null;
				switch (scope.entityType) {
				case 'SUBCLIENT_ENTITY':
					if (entityString != null) {
						entityString = entityString + '&';
					}
					entityString = 'collectionId=' + entity.subclientId + '&collectionName=' + entity.subclientName;
				case 'BACKUPSET_ENTITY':
					if (entityString != null) {
						entityString = entityString + '&';
					}
					if (entity.backupsetId != null) {
						entityString = entityString + '&backupsetId=' + entity.backupsetId;
					}

				case 'INSTANCE_ENTITY':
					if (entityString != null) {
						entityString = entityString + '&';
					} else {
						entityString = "";
					}
					if (entity.instanceId != null) {
						entityString = entityString + 'instanceId=' + entity.instanceId;
					}

				case 'APPTYPE_ENTITY':
					if (entityString != null) {
						entityString = entityString + '&';
					} else {
						entityString = "";
					}
					entityString = entityString + 'applicationId=' + entity.applicationId;
				case 'CLIENT_ENTITY':
					if (entityString != null) {
						entityString = entityString + '&';
					} else {
						entityString = "";
					}
					entityString = entityString + 'serverId=' + entity.clientId + '&serverName=' + entity.clientName;
					break;
				}
				if (entityString != null) {
					urlString = urlString + '&' + entityString;
				}

				urlString = urlString + '&view=finishedJobs1';

				scope.urlString = urlString;
			}
		};
	} ]);

	cvCommon
			.directive(
					'cvTileComponent',
					[
							'cvLoc',
							'$timeout',
							'$sce',
							function(cvLoc, $timeout, $sce) {
								return {
									restrict : 'E',
									transclude : true,
									scope : {
										loader : '=',
										title : '@',
										helpText : '@',
										helpLabel : '@',
										helpId : '@',
										helpType : '@',
										minHeight : '@',
										enableAccordion : '@',
										editText : '=',
										sla : '@',
										overrideText : '=?',
										hideTitle : '=?',
										loadManually : '@',
										loadFunc : '=',
										previousMsg : '@',
										extraClass : '@',
										includedSvg : '=?'

									},
									link : function(scope, ele, attrs) {
										scope.showLoader = angular.isDefined(attrs.loader) ? true : false;
										scope.helpText = angular.isDefined(attrs.helpText) ? attrs.helpText : false;
										scope.helpLabel = angular.isDefined(attrs.helpLabel) ? attrs.helpLabel : false;
										scope.helpId = angular.isDefined(attrs.helpId) ? attrs.helpId : false;
										scope.helpType = angular.isDefined(attrs.helpType) ? attrs.helpType : false;
										scope.showTitleBar = (angular.isDefined(attrs.title) && (!angular
												.isDefined(scope.hideTitle) || (scope.hideTitle != true))) ? true
												: false;
										scope.showMinHeight = (angular.isDefined(attrs.minHeight) && (attrs.minHeight == 'true')) ? true
												: false;
										scope.enableAccordion = _.isUndefined(attrs.enableAccordion) ? false : true
										scope.enablelimitHeight = scope.enableAccordion;
										scope.sla = (angular.isDefined(attrs.sla) && (attrs.sla == 'true')) ? true
												: false;
										scope.loadManually = angular.isDefined(attrs.loadManually) ? true : false;
										scope.previousMsg = angular.isDefined(attrs.previousMsg) ? attrs.previousMsg
												: cvLoc('label.previousMsg', attrs.title);
										scope.closeLoader = scope.showLoader;
										scope.showAccordion = false;
										if (scope.includedSvg) {
											scope.includedSvgHtmlContent = $sce.trustAsHtml(scope.includedSvg)
													.$$unwrapTrustedValue();
										}
										scope.loadData = function() {
											if (!scope.loadManually) {
												return;
											}

											scope.loadManually = false;
											scope.loadFunc ? scope.loadFunc() : scope.closeLoader = true;
										}

										scope.toggleTileHeight = function() {
											scope.enablelimitHeight = !scope.enablelimitHeight;
										}

										scope
												.$watch(
														'loader',
														function(newVal) {
															scope.loader = newVal;
															scope.closeLoader = scope.showLoader ? (((newVal != undefined) && (newVal != false))
																	|| Array.isArray(newVal) || newVal === "")
																	: true;
															if (scope.enableAccordion && scope.closeLoader) {
																$timeout(function() {
																	var tileHeight = $(
																			"[id='tileContent_" + scope.title + "']")
																			.height();
																	if (tileHeight > 200) {
																		scope.showAccordion = true;
																	}
																})
															}
														});
										//show "more" option only if accordian enabled and there're more than 5 items (200 px in tile)
										if (scope.enableAccordion) {
											//wait for browser render the DOM
											$timeout(function() {
												var tileHeight = $("[id='tileContent_" + scope.title + "']").height();
												if (tileHeight > 200) {
													scope.showAccordion = true;
												}
											})
										}
									},
									templateUrl : appUtil.appRoot + 'common/partials/tileComponent.jsp'
								};
							} ]);

	cvCommon.directive('cvHelpComponent', [ 'cvLoc', '$http', '$window', function(cvLoc, $http, $window) {
		return {
			restrict : 'E',
			transclude : true,
			scope : {
				helpText : '@',
				helpLabel : '@',
				helpId : '@',
				helpType : '@',
				helpPlacement : '@',
				helpIcon : '@'
			},
			link : function(scope, ele, attrs) {
				scope.showToolTip = true;
				if ((scope.helpText && (scope.helpText != "false")) || (scope.helpId && (scope.helpId != "false"))) {
					scope.showHelp = true;
					if (scope.helpId && (scope.helpId != "false")) {

						if (scope.helpType && (scope.helpType == "newWindow")) {
							scope.showToolTip = false;
							ele.on('click', function(e) {
								$window.open(cvConfig.helpLink + '?p=' + scope.helpId, '_blank');
							});

						} else {
							ele.on('mouseover', function(e) {
								if (!scope.helpText || (scope.helpText == "false")) {
									scope.helpText = "Loading";
									// Dummy .do for now. Need to write Java layer when API is provided by Doc team
									$http({
										method : 'GET',
										url : "/getHelpDetails.do?helpId=" + scope.helpId
									}).then(function successCallback(response) {
										scope.helpText = "Success";
									}, function errorCallback(response) {
										scope.helpText = "Error while loading help from server";
									});
								}
							});
						}

					}
				} else {
					scope.showHelp = false;
				}

				if (scope.helpLabel && (scope.helpLabel != "false")) {
					scope.showLabel = true;
				} else {
					scope.showLabel = false;
				}

			},
			templateUrl : appUtil.appRoot + 'common/partials/helpComponent.jsp'
		};
	} ]);

	cvCommon.directive('cvGlobalBreadcrumb', [ 'cvBreadcrumbsTabsFactory', function(cvBreadcrumbsTabsFactory) {
		return {
			restrict : 'AE',
			templateUrl : appUtil.appRoot + 'common/partials/globalBreadcrumbs.html',
			controller : [ '$scope', function($scope) {
				cvBreadcrumbsTabsFactory.registerBcDataChangeObserver(function(newData) {
					$scope.bcData = newData.filter(function(data) {
						if (data.title.length > 21) {
							var length = parseInt(data.title.length * 2 / 3);
							data.titles = [ data.title.substring(0, length), data.title.substring(length) ];
						} else {
							data.titles = [ '', data.title ];
						}
						return data.link;
					});
				});
				cvBreadcrumbsTabsFactory.registerTabDataChangeObserver(function(newData) {
					$scope.tabData = newData;
				});
			} ],
			link : function(scope, ele, attrs) {
				scope.bcData = cvBreadcrumbsTabsFactory.bcData;
				scope.tabData = cvBreadcrumbsTabsFactory.tabData;
			}
		};
	} ]);

	cvCommon.directive('cvGlobalMulticommcell', [ 'cvMultiCommcell', function(cvMultiCommcell) {
		return {
			restrict : 'AE',
			templateUrl : appUtil.appRoot + 'common/partials/globalMulticommcell.html',
			controller : [ '$scope', function($scope) {
				$scope.isMultiCCAware = cv.sessionContext.isMultiComcellAware;
				$scope.multicomcellCapability = cvMultiCommcell.getCapability();
				$scope.multiselection = cvMultiCommcell.getmultiselection();
				$scope.ccName = cvMultiCommcell.getccName();
				$scope.isMultiCommcellAwareFeature = function() {
					return !cvMultiCommcell.getCapability() && cvMultiCommcell.getmultiselection();
				}

			} ]
		}
	} ]);

	cvCommon.directive('cvPageActions', [ 'cvPageActionsFactory', function(cvPageActionsFactory) {
		return {
			restrict : 'AE',
			replace : true,
			templateUrl : appUtil.appRoot + 'common/partials/pageActions.html',
			controller : [ '$scope', function($scope) {
				cvPageActionsFactory.registerChangeObserver(function(newActions) {
					$scope.actions = newActions;
				});
			} ],
			link : function(scope, ele, attrs) {
				scope.actions = cvPageActionsFactory.actions;
			}
		};
	} ]);

	cvCommon.factory('ajaxButtonFactory', function() {
		var ajaxButton = {
			currentButton : null,
			isRequestOngoing : false
		}
		return ajaxButton;
	});

	cvCommon.directive('cvBusyOnAjax', [ 'ajaxButtonFactory', 'PayloadFactory', function(ajaxButton, PayloadFactory) {
		return {
			restrict : 'C',
			link : function(scope, ele, attrs) {
				ele.on("click", function() {
					ajaxButton.currentButton = ele;
				});

				scope.$on('modal.closing', function(event, reason, closed) {
					if (ajaxButton.currentButton && ajaxButton.isRequestOngoing) {
						event.preventDefault();
					}
				});
			}
		};
	} ]);

	// Used when a text input box has a pre-defined value and the tax index should point to the first position
	// For example see add user page for email field
	cvCommon.directive('cvFirstCursorPosition', [ 'cvLoc', function(cvLoc) {
		return {
			restrict : 'C',
			link : function(scope, ele, attrs) {
				ele.on("focus", function() {
					document.getElementById(angular.element(ele).attr('id')).setSelectionRange(0, 0);
				});

			}
		};
	} ]);

	/**
	 * A directive that applies the class "field-has-input" to all search fields that have at least one
	 * character entered in it. Removes the class if the field is empty.
	 */
	cvCommon.directive('searchField', [ function() {
		return {
			require : 'ngModel',
			restrict : 'C',
			link : function(scope, element, attr, ngModel) {
				scope.$watch(function() {
					return ngModel.$viewValue;
				}, function(value) {
					if (angular.isDefined(value) && (value.length > 0)) {
						element.addClass('field-has-input');
					} else {
						element.removeClass('field-has-input');
					}
				});
			}
		}
	} ]);

	/*
	 * Directive used to validate fields that must equal each other (such as password / confirm-password).
	 *
	 * Based on a stackoverflow post by Jan Laussmann:
	 * http://stackoverflow.com/questions/14012239/password-check-directive-in-angularjs *
	 */
	cvCommon.directive('cvEquals', [ '$parse', function($parse) {
		return {
			restrict : 'A',
			require : '?ngModel',
			link : function(scope, elem, attrs, ngModel) {
				if (!ngModel) {
					return;
				}

				// Re-validate if own value changes:
				scope.$watch(attrs.ngModel, function() {
					validate();
				});

				// Re-validate if the "cvEquals" value changes:
				attrs.$observe('cvEquals', function(val) {
					validate();
				});

				// Re-validate if the "cvEqualsWhen" expression changes:
				scope.$watch(function() {
					return scope.$eval(attrs.cvEqualsWhen);
				}, function() {
					validate();
				});

				/**
				 * Performs the validation for matching the current model value with the specified value to
				 * match.
				 */
				var validate = function() {
					var val1 = ngModel.$viewValue;
					var val2 = attrs.cvEquals;

					/*
					 * Sometimes you don't always want to validate, so ONLY if the "cvEqualsWhen" attribute is
					 * given and evaluates to a TRUE expression will the validation occur.
					 */
					var requireValidation = angular.isUndefined(attrs.cvEqualsWhen) || scope.$eval(attrs.cvEqualsWhen);
					ngModel.$setValidity('cvEquals', !requireValidation || val1 === val2);

				};
			}
		};
	} ]);

	/*
	 * Directive used to access the formController from parent scope
	 */
	cvCommon.directive('referenceFormController', [ '$rootScope', function($rootScope) {
		return {
			restrict : "A",
			require : '^form', // require FormController
			link : function(scope, element, attrs, ctrl) {
				// broadcast existence of new FormController
				$rootScope.$broadcast('referenceFormController', ctrl);
			}
		};
	} ]);

	/**
	 * PayloadFactory It is used to load json modal once the response is received from http service
	 */
	cvCommon.factory('PayloadFactory', [ 'customAPIHeaderFactory', function(customAPIHeaderFactory) {
		function PayloadFactory() {
			var self = this;
			self.customKey = 'ReturnReqPayloadAsResp';
			self.dismissParentModal = false;
			self.saveAsScriptEventControl = {
				initModal : null
			};
			self.showPayloadInModal = function(response) {
				self.saveAsScriptEventControl.initModal(response);
			}
			self.removeCustomHeader = function() {
				customAPIHeaderFactory.remove(self.customKey);
				self.dismissParentModal = true;
			}
		}
		return new PayloadFactory();
	} ]);

	/*
	 * Custom directive which intercepts submits to perform validation checks, so validation errors are shown
	 * to a user only once a field is interacted with or an attempt is made to submit the form.
	 *
	 * This is based on code from: http://plnkr.co/edit/DdawkKnuSAl4Hv4t9Liq?p=preview
	 */
	cvCommon
			.directive(
					'cvSubmit',
					[
							'$parse',
							'customAPIHeaderFactory',
							'$compile',
							'$uibModal',
							'PayloadFactory',
							'cvUtil',
							'hideToaster',
							function($parse, customAPIHeaderFactory, $compile, $uibModal, PayloadFactory, cvUtil,
									hideToaster) {
								return {
									restrict : 'A',
									require : [ 'cvSubmit', '?form' ],
									controller : [
											'$scope',
											function($scope) {
												this.attempted = false;
												var formController = null;

												this.setAttempted = function(tried) {
													this.attempted = tried;
												};

												this.getAttempted = function() {
													return this.attempted;
												};

												this.setFormController = function(controller) {
													formController = controller;
												};

												this.needsAttention = function(fieldModelController) {
													if (!formController) {
														return false;
													}

													if (fieldModelController) {
														return fieldModelController.$invalid
																&& (fieldModelController.$dirty || this.attempted);
													} else {
														return formController && formController.$invalid
																&& (formController.$dirty || this.attempted);
													}
												};
											} ],
									compile : function(cElement, cAttributes, transclude) {
										return {
											pre : function(scope, formElement, attributes, controllers) {
												var submitController = controllers[0];
												var formController = (controllers.length > 1) ? controllers[1] : null;

												submitController.setFormController(formController);
												//will enable save as script by default if the need be, by uncommenting this line
												scope.isReadyForAPICall = _.isUndefined(scope.isReadyForAPICall) ? function() {
												}
														: scope.isReadyForAPICall;
												scope.cv = scope.cv || {};
												scope.cv[attributes.name] = submitController;
											},
											post : function(scope, formElement, attributes, controllers) {

												var submitController = controllers[0];
												var formController = (controllers.length > 1) ? controllers[1] : null;
												var fn = $parse(attributes.cvSubmit);

												formElement.parent().on('keyup', function(event) {
													if (event.which === 27) {
														modalInstance=null;
														PayloadFactory.removeCustomHeader();
													}
												});
												//stop csrf appending when save as script modal's form is submitted from inside parent modal's form
												formElement.on('submit', function() {
													submitController.setAttempted(true);
													if (!scope.$$phase) {
														scope.$apply();
													}
													// Remove custom header whenever there is avalidation error.
													// to fix no payload popup
													if (submitController.validate) {
														// If cvValidate is defined, use it to validate instead of angular form.$valid
														if (!submitController.validate()) {
															PayloadFactory.removeCustomHeader();
															return false;
														}
													} else if (_.get(scope, '$parent.$cvWizardStepInstance')) {
														if (formController.$valid) {
															scope.$parent.wizardStepValid = true;
															if (scope.$parent.$cvWizardStepInstance.isLastStep()) {
																scope.$parent.$cvWizardStepInstance.finish();
															} else {
																scope.$parent.$cvWizardStepInstance.next();
															}

														}
														PayloadFactory.removeCustomHeader();
														return;
													} else if (!formController.$valid) {
														PayloadFactory.removeCustomHeader();
														// Check angular form validity only if cvValidate is not defined
														return false;
													}
													//remove error message hide class
													(formElement.parent().find('.serverMessage'))
															.removeClass('script-error');
													// Do not allow multiple submission of forms when already one request is going on
													if (angular.element(this).find('.cvDisabledOnAjax').length === 0) {
														scope.$apply(function(event) {
															fn(scope, {
																$event : event
															});
														});
													}

												});
												if (!scope.isReadyForAPICall) {
													PayloadFactory.removeCustomHeader();
													return;
												}
												//global flag + user  is admin + hide flag for this form not set + executable function is available
												if (cvConfig.showSaveAsScript && cv.nav.isAdmin
														&& !submitController.hideApiReference && attributes.cvSubmit) {
													let jsonScript = {};
													let downloadScript = {};
													var modalInstance;
													PayloadFactory.dismissParentModal = true;

													const buttonTEMPLATE = "<span class='save-as-script-container'><button id='saveAsScriptButton' type='button' class='btn btn-outline-primary cvBusyOnAjax'></button></div>";
													let saveAsScriptEventControl = PayloadFactory.saveAsScriptEventControl;
													let compiledButtonTemplate = $compile(buttonTEMPLATE)(scope);
													($(compiledButtonTemplate).find('#saveAsScriptButton')).html(cvUtil
															.getLocalizedString('label.saveAsScript'));
													//Add save as script button on bottom left corner of the modal
													formElement.find('.button-container').addClass(
															'save-as-script-container').prepend(compiledButtonTemplate);
													formElement.find('.modal-footer').addClass(
															'save-as-script-container').prepend(compiledButtonTemplate);

													//trigger form submission on save as script button click

													function onAPIButtonClick() {
														scope.isAPICall = true;
														//set custom key to fetch request data in json format
														customAPIHeaderFactory.add(
																PayloadFactory.customKey,
																"application/json");
														formElement.trigger('submit');
													}
													formElement.find('#saveAsScriptButton').bind(
															'click',
															onAPIButtonClick);

													scope.$on('modal.closing', function(event, reason, closed) {
														if (!PayloadFactory.dismissParentModal) {
															event.preventDefault();
														} else {
															scope.isAPICall = false;
															customAPIHeaderFactory.remove(PayloadFactory.customKey);
														}
													});

													//stop csrf appending when save as script modal's form is submitted from inside parent modal's form
													formElement.bind('submit', function(event) {
														event.preventDefault();
													});
													/*********************************************************
													 * this opens modal with local json data received as a
													 * response from java layer initialize modal here to
													 * refresh its data instead of opening another instance of
													 * modal when there are multiple api requests within
													 * single form submit
													 ********************************************************/
													const saveAsScriptCallBack = function(response) {
														PayloadFactory.dismissParentModal = false;
														//using add class instead of html method because it clears
														//data once and for all messages
														//if valid response is there show that, else check if previous json objecthad response
														if (!(response && response.method)
																&& !Object.keys(jsonScript).length) {
															response = {};
														}
														(formElement.parent().find('.serverMessage'))
																.addClass('script-error');
														if (response.method  && response.method !== "GET") {
															response.data = response.data ? JSON.parse(response.data)
																	: undefined;
															downloadScript = JSON.stringify({
																"api" : response.url,
																"method" : response.method,
																"payload" : response.data
															}, undefined, 2)

															jsonScript = {
																"api" : response.url,
																"method" : response.method,
																"payload" : JSON.stringify(response.data, undefined, 2)
															}
														}

														if (!modalInstance) {
															modalInstance = $uibModal.open({
																templateUrl : appUtil.appRoot
																		+ 'common/partials/cvJsonScript.jsp',
																backdrop : 'static',
																windowClass : 'small-size modal-company-hideCross',
																controller : [
																		'$scope',
																		'$uibModalInstance',
																		function($scope, $modalInstance) {
																			$scope.docLink = cvConfig.helpLink
																					+ "?p=45540.htm";
																			$scope.close = function() {
																				modalInstance = null;
																				jsonScript = {};
																				downloadScript = {};
																				$modalInstance.dismiss();
																				hideToaster.hide = false;
																				scope.isAPICall = false;
																				PayloadFactory.removeCustomHeader();
																			};
																			$scope.jsonScript = jsonScript;
																			$scope.downloadScript = downloadScript;
																		} ]
															});
														}
													}
													//call back instantiation done here to avoid template url error
													//caused by direct function implementation instead of using saveAsScriptCallBack
													saveAsScriptEventControl.initModal = saveAsScriptCallBack;
												}
											}
										};
									}
								};
							} ]);

	// This directive can be used to provide a custom validate function to cvSubmit.
	// If provided, cvSubmit will ignore the value of formController.$valid
	cvCommon.directive('cvValidate', [ '$parse', function($parse) {
		return {
			restrict : 'A',
			require : [ 'cvSubmit' ],
			compile : function(cElement, cAttributes, transclude) {
				return {
					pre : function(scope, formElement, attributes, controllers) {
						var validateFunction = $parse(attributes.cvValidate);
						controllers[0].validate = function() {
							return validateFunction(scope);
						};
					}
				};
			}
		};
	} ]);

	cvCommon.directive('cvHideApi', [ '$parse', function($parse) {
		return {
			restrict : 'A',
			require : [ 'cvSubmit' ],
			compile : function(cElement, cAttributes, transclude) {
				return {
					pre : function(scope, formElement, attributes, controllers) {
						controllers[0].hideApiReference = true;
					}
				};
			}
		};
	} ]);

	cvCommon.directive('time', function() {
		return {
			restrict : 'CA',
			replace : true,
			transclude : true,
			controller : [ '$scope', '$filter', function($scope, $filter) {
				$scope.format = function(time) {
					if (time <= 0) {
						return $scope.emptyValue || '';
					}

					// Commented out because the CS APIs are returning GMT timestamps and the 'date'
					// filter below is already converting the GMT timestamp to the browser's timezone. Can
					// remove this after confirming this is true in all cases:
					//
					//	// Convert time from CS to browser time
					//	var currDate = new Date();
					//	var browserTimeZoneOffset = currDate.getTimezoneOffset();
					//	var timeDiffMinutes = 0; // browserTimeZoneOffset;// !!! (cv.timeZone - browserTimeZoneOffset);
					//	var addedMinutes = (time * 1000) + (timeDiffMinutes * 60 * 1000);
					// The 'date' filter below seems to accept GMT and convert it into the local time zone for display
					// return $filter('date')(addedMinutes, 'MMM dd, yyyy HH:mm:ss a');

					const timeFormat =
						new Date().getFullYear() === new Date(time * 1000).getFullYear()
							? 'MMM d, h:mm:ss a'
							: 'MMM d, y h:mm:ss a';  // Show year if not current year

					// Use locale-specific medium format converted to local timezone:
					return $filter('date')(time * 1000, timeFormat);
				}
			} ],
			scope : {
				time : '@val',
				emptyValue : '@empty'
			},
			template : "<div class='etime' title='{{format(time)}}'>{{format(time)}}</div>"
		};
	});

	cvCommon.directive('yearTime', function() {
		return {
			restrict : 'CA',
			replace : true,
			transclude : true,
			controller : [ '$scope', '$filter', function($scope, $filter) {
				$scope.format = function(time) {
					if (time <= 0) {
						return '';
					}
					return $filter('date')(time * 1000, 'MMM d, y h:mm:ss a');
				}
			} ],
			scope : {
				time : '@val'
			},
			template : "<div class='etime' title='{{format(time)}}'>{{format(time)}}</div>"
		};
	});

	/* stop propagation directive on MOUSEOVER */
	cvCommon.directive('stopMouseOverPropagation', function() {
		return {
			restrict : 'A',
			link : function(scope, element, attr) {
				element.on('mouseover', function(e) {
					e.stopPropagation();
				});
			}
		};
	});

	cvCommon
			.directive(
					'gridActionIcon',
					function() {
						return {
							restrict : 'C',
							template : '<svg xmlns="http://www.w3.org/2000/svg" version="1.1" x="0" y="0" viewBox="0 0 20 20" xml:space="preserve"><path d="M10.1 0C4.6-0.1 0.1 4.4 0 9.9s4.4 10 9.9 10.1 10-4.4 10.1-9.9c0-0.1 0-0.1 0-0.2C19.9 4.5 15.5 0.1 10.1 0zM10.1 18.9c-5 0-9-4-9-9s4-9 9-9 9 4 9 9S15.1 18.9 10.1 18.9L10.1 18.9z"/><rect x="6.1" y="8.8" width="2" height="2"/><rect x="9.1" y="8.8" width="2" height="2"/><rect x="12.1" y="8.8" width="2" height="2"/></svg>'
						};
					});

	/* This directive is used to determine which direction the dropdown should open in */
	cvCommon.directive('uibDropdown', [ '$window', function($window) {
		return {
			restrict : 'A',
			link : function(scope, element, attr) {
				function orientDropdown() {
					var elementBottom = $window.pageYOffset + element[0].getBoundingClientRect().bottom;
					var windowBottom = $window.pageYOffset + $window.innerHeight;
					var dropdownHeight = element.find(".dropdown-menu").height();

					//Decide if dropdown has to be rendered at the top or bottom of its parent container
					function setDropdownPosition() {
						if (elementBottom + dropdownHeight >= windowBottom) {
							element.addClass('dropup');
						} else {
							element.removeClass('dropup');
						}
					}
					//if the dropdown is not appended to the body tag,
					//then set its max height to 350px and add a scroll in case the size exceeds
					//the max height
					if (!($("body")[0].lastChild).classList.contains('dropdown-menu')) {
						if (dropdownHeight > 350) {
							element.addClass('dropdown-fixed-height');
							dropdownHeight = 350;
						} else {
							element.removeClass('dropdown-fixed-height');
						}
					}
					setDropdownPosition();
				}

				element.on('click', orientDropdown);
			}
		};
	} ]);

	cvCommon.directive('toggleControl', function() {
		return {
			restrict : 'EA',
			transclude : true,
			scope : {
				status : '=',
				tooltip : '@',
				disabled : '=',
				trueProperty : '@',
				falseProperty : '@'
			},
			templateUrl : appUtil.appRoot + 'common/partials/toggleControls.jsp',
			link : function(scope, element) {
				var classes = [ 'enabled-activity', 'disabled-activity' ];
				scope.trueProperty = scope.trueProperty || classes[0];
				scope.falseProperty = scope.falseProperty || classes[1];
			}
		};
	});

	/*
	 * Adjust the elements in a given space, so if the elements are overflowing, it creates a tooltip
	 * @attribute objects: list of objects {link:"", text=""}, @attribute displayWidth: width of the space to
	 * display
	 */
	cvCommon
			.directive(
					'cvFancyTooltip',
					function() {
						return {
							restrict : 'E',
							templateUrl : appUtil.appRoot + 'common/partials/fancyTooltip.jsp',
							scope : {
								'cvObjects' : '=',
								'cvDisplayWidth' : '='
							},
							link : function(scope, element, attr) {
								element
										.append('<span id="ruler' + scope.$id
												+ '" class="text-size-calculator"></span>');

								var renderTooltip = function(_objects, _displayWidth) {
									// initialize objects based on objects provided. if no objects are provided
									// initialize with one empty element as placeholder
									var objs = _objects && _objects.length ? _objects : [ {
										text : ""
									} ];

									// if only object is present, show that irrespectively
									if (objs.length === 1) {
										scope.displayText = (objs[0].link ? '<a class="crop" href="' + objs[0].link
										// For companies page in comet
										+ (objs[0].openNewTab ? '" target="_blank"' : '') + '" title="' + objs[0].text
												+ '">' + objs[0].text + '</a>' : '<label class="crop" title="'
												+ objs[0].text + '">' + objs[0].text + '</label>');
										// reset remainingObjects as previous scope is retained
										scope.remainingObjects = [];
									} else {
										// render
										var ruler = document.getElementById("ruler" + scope.$id);
										if (ruler) {
											var previousValue = "";
											ruler.innerHTML = previousValue;
											scope.displayText = previousValue;

											var clone = null;
											if (isNaN(_displayWidth)) {
												// If display width cannot be calculated, use 0 so that we can
												// display the smallest tooltip instead of creating a large
												// tooltip that overflows.
												_displayWidth = 0;
											} else {
												// If the ruler width cannot be calculated use a clone attached
												// to the body so that we can calculate the ruler width:
												var $ruler = $(ruler);
												if ($ruler.is(':hidden')) {
													clone = $ruler.clone();
													$(document.body).append(clone);
													ruler = clone[0];
												}
											}
											// determine how many items could be accommodated inside the cell
											for (var i = 0; i < objs.length; i++) {
												// appendRemaining will have count one more then the true value
												// this is intentional
												var appendRemaining = (i === 0 ? '+' : ', +') + (objs.length - i);

												// check to see if the current list fits in the display area
												ruler.innerHTML += (i === 0 ? '' : ', ')
														+ (objs[i].link ? '<a href="' + objs[i].link + '">'
																+ objs[i].text + '</a>' : '<label>' + objs[i].text
																+ '</label>') + appendRemaining;
												if (ruler.offsetWidth >= _displayWidth) {
													// use text from previous iteration and put rest of objects in the dropdown
													scope.remainingObjects = objs.slice(i);
													scope.displayText = previousValue;
													break;
												} else {
													// remove the extra suffix text appended
													ruler.innerHTML = ruler.innerHTML.substring(
															0,
															ruler.innerHTML.length - appendRemaining.length - 1);
													previousValue = ruler.innerHTML;
													scope.remainingObjects = objs.slice(i + 1);
													scope.displayText = previousValue;
												}
											}
											if (clone) {
												clone.remove();
											}

											if (scope.displayText == "") {
												scope.displayText = (scope.remainingObjects[0].link ? '<a class="crop fancy-tooltip" href="'
														+ scope.remainingObjects[0].link
														+ '" title="'
														+ scope.remainingObjects[0].text
														+ '">'
														+ scope.remainingObjects[0].text + '</a>'
														: '<label class="crop fancy-tooltip" title="'
																+ scope.remainingObjects[0].text + '">'
																+ scope.remainingObjects[0].text + '</label>');
												scope.remainingObjects = scope.remainingObjects.slice(1);
											}
										}
									}
								};

								scope.$watch('cvDisplayWidth', function(newVal, oldVal) {
									renderTooltip(scope.cvObjects, newVal);
								});

								scope.$watchCollection('cvObjects', function(newVal, oldVal) {
									renderTooltip(newVal, scope.cvDisplayWidth);
								});

							}
						};
					});

	cvCommon
			.directive(
					'cvDomainTile',
					function() {
						return {
							restrict : 'E',
							templateUrl : appUtil.appRoot + 'common/partials/domainTile.jsp',
							scope : {
								domainInfo : '=',
								subscriptionId : '='
							},
							controller : [
									'$scope',
									'$uibModal',
									function($scope, $modal) {
										if (!cv.nav.isAdmin) {
											$scope.tenantAdmin = true;
										}
										$scope.isMsp = cv.isMspAdmin;
										$scope.isReseller = cv.isReseller;
										$scope.isNotOwnCompany = parseInt($scope.subscriptionId) === parseInt(cv.orgId) ? false
												: true;
										$scope.modifyDomainForCompany = function() {
											var modalInstance = $modal
													.open({
														templateUrl : appUtil.appRoot
																+ 'vsa/partials/editDomainForCompany.jsp',
														windowClass : 'small-size',
														backdrop : 'static',
														controller : [
																'$scope',
																'$uibModalInstance',
																'cvLoc',
																'$stateParams',
																'cvUtil',
																'subscriptionId',
																'domainInfo',
																'subscriptionService',
																'$state',
																'REGEX',
																function($scope, $modalInstance, cvLoc, $stateParams,
																		cvUtil, subscriptionId, domainInfo,
																		subscriptionService, $state, REGEX) {
																	$scope.domainRegex = REGEX.DOMAIN;
																	$scope.isReseller = cv.isReseller;
																	$scope.isNotOwnCompany = angular
																			.isDefined(subscriptionId)
																			&& parseInt(subscriptionId) === parseInt(cv.orgId) ? false
																			: true;

																	$scope.model = {
																		primaryDomainName : domainInfo.primaryDomainName ? domainInfo.primaryDomainName
																				: '',
																		additionalDomainList : []
																	}
																	var count = 1;
																	if (domainInfo.additionalDomainList
																			&& (domainInfo.additionalDomainList.length > 0)) {
																		domainInfo.additionalDomainList.map(function(
																				domain) {
																			if (domain) {
																				var obj = {
																					id : domain + count,
																					value : domain
																				}
																				$scope.model.additionalDomainList
																						.push(obj)
																				count++;
																			}
																		})
																	}
																	if (!cv.nav.isAdmin) {
																		$scope.tenantAdmin = true;
																		if ($scope.model.additionalDomainList.length < 1) {
																			var obj = {
																				id : 'domainName0',
																				value : ''
																			}
																			$scope.model.additionalDomainList.push(obj);
																		}
																	}

																	$scope.addSecondaryDomain = function() {
																		var obj = {
																			id : 'domainName' + count,
																			value : ''
																		}
																		$scope.model.additionalDomainList.push(obj);
																		count++;
																	}

																	$scope.removeDomain = function(domain) {
																		for (var i = 0; i < $scope.model.additionalDomainList.length; i++) {
																			if (domain.id == $scope.model.additionalDomainList[i].id) {
																				$scope.model.additionalDomainList
																						.splice(i, 1);
																			}
																		}
																	}

																	var isArrayDuplicate = function(array) {
																		array.sort();
																		for (var i = 0; i < array.length; i++) {
																			if (array[i] == array[i + 1]) {
																				return true;
																			}
																		}
																		return false;

																	}

																	$scope.saveDomainForCompany = function() {
																		$scope.editDomainMessage = cvUtil.emptyMsg();
																		var objToSend = {};
																		var secondaryDomain = $scope.model.additionalDomainList
																				.filter(function(domain) {
																					return domain.value;
																				}).map(function(domain) {
																					return domain.value;
																				});
																		var domainList = angular.copy(secondaryDomain);
																		domainList.push($scope.model.primaryDomainName);

																		if (isArrayDuplicate(domainList)) {
																			$scope.editDomainMessage = {
																				message : cvLoc('error.duplicateDomian'),
																				type : 'error'
																			};
																			return;
																		}

																		if ($scope.tenantAdmin) {
																			objToSend = {
																				'subDomain' : secondaryDomain.join(',')
																			};
																		} else {
																			objToSend = {
																				'id' : subscriptionId,
																				'domain' : $scope.model.primaryDomainName,
																				'subDomain' : secondaryDomain.join(',')
																			};
																		}

																		subscriptionService
																				.updateCompanyInfo(objToSend).success(
																						function(data) {
																							$state.forceReload();
																							$modalInstance.close();
																						}).error(function(e) {
																					$scope.editDomainMessage = {
																						message : e,
																						type : 'error'
																					};
																				});

																	};

																	$scope.cancel = function() {
																		$modalInstance.dismiss();
																	};
																} ],
														resolve : {
															subscriptionId : function() {
																return $scope.subscriptionId;
															},
															domainInfo : function() {
																return $scope.domainInfo;
															}
														}
													});
										}
									} ],
							link : function(scope, element, attr) {
							}
						};
					});

	cvCommon.directive('dragSelect', function() {
		return {
			scope : {
				dragSelectIds : '='
			},
			controller : [
					'$scope',
					'$element',
					'$window',
					'$document',
					function($scope, $element, $window, $document) {
						var cls = 'eng-selected-item';
						var startCell = null;
						var dragging = false;
						$scope.dragSelectIds = $scope.dragSelectIds ? $scope.dragSelectIds : [];
						$scope.currentDragIds = [];
						function mouseUp(el) {
							dragging = false;
						}

						function mouseDown(el) {
							dragging = true;
							setStartCell(el);

							var el = angular.element(el);
							if (el.hasClass('eng-selected-item')) {
								el.removeClass('eng-selected-item');
								console.log(el.attr('id'))
								for (var i = 0; i < $scope.dragSelectIds.length; i++) {
									if (el.attr('id') == parseInt($scope.dragSelectIds[i])) {
										$scope.dragSelectIds.splice(i, 1)
									}
								}
							} else {
								setEndCell(el);
							}

						}

						function mouseEnter(el) {
							if (!dragging) {
								return;
							}
							setEndCell(el);
						}

						function setStartCell(el) {
							startCell = el;
						}

						function setEndCell(el) {
							cellsBetween(startCell, el).each(function() {
								var el = angular.element(this);
								el.addClass(cls);
								if ($scope.dragSelectIds.indexOf(el.attr('id')) == -1) {
									$scope.dragSelectIds.push(el.attr('id'));
								}

							});
						}

						function cellsBetween(start, end) {
							var coordsStart = getCoords(start);
							var coordsEnd = getCoords(end);
							var topLeft = {
								column : $window.Math.min(coordsStart.column, coordsEnd.column),
								row : $window.Math.min(coordsStart.row, coordsEnd.row),
							};
							var bottomRight = {
								column : $window.Math.max(coordsStart.column, coordsEnd.column),
								row : $window.Math.max(coordsStart.row, coordsEnd.row),
							};
							return $element.find('td').filter(
									function() {
										var el = angular.element(this);
										var coords = getCoords(el);
										return (coords.column >= topLeft.column)
												&& (coords.column <= bottomRight.column) && (coords.row >= topLeft.row)
												&& (coords.row <= bottomRight.row);
									});
						}

						function getCoords(cell) {
							var row = cell.parents('row');
							return {
								column : cell[0].cellIndex,
								row : cell.parent()[0].rowIndex
							};
						}

						function wrap(fn) {
							return function() {
								var el = angular.element(this);
								$scope.$apply(function() {
									fn(el);
								});
							}
						}

						$element.delegate('td', 'mousedown', wrap(mouseDown));
						$element.delegate('td', 'mouseenter', wrap(mouseEnter));
						$document.delegate('body', 'mouseup', wrap(mouseUp));
					} ]
		}
	});

	cvCommon
			.directive(
					'cvStoragePoolTile',
					function() {
						return {
							restrict : 'E',
							templateUrl : appUtil.appRoot + 'common/partials/storagePoolTile.jsp',
							scope : {
								primaryStoragePoolInfo : '=',
								secondaryStoragePoolInfo : '=',
								snapStorageInfo : '=',
								planSubType : '=',
								showEdit : '=',
								profileId : '=',
								storageType : '@',
								subclientId : '=',
								showextendedretention : '@',
								overrideText : '=?'
							},
							controller : [
									'$scope',
									'$uibModal',
									'cvLoc',
									function($scope, $modal, cvLoc) {
										$scope.title = cvLoc('label.storagePool');
										if ($scope.planSubType && $scope.planSubType === 'Database') {
											$scope.title = cvLoc('label.dataStoragePool');
										}
										if ($scope.storageType && $scope.storageType === 'Log') {
											$scope.title = cvLoc('label.logStoragePool');
										}

										$scope.modifyStoragePool = function() {
											var modalInstance = $modal
													.open({
														templateUrl : appUtil.appRoot
																+ 'common/partials/editStoragePool.jsp',
														backdrop : 'static',
														windowClass : 'backupOptionsDialog',
														controller : [
																'$scope',
																'$log',
																'$uibModalInstance',
																'$state',
																'cvLoc',
																'$stateParams',
																'cvUtil',
																'primaryStoragePoolInfo',
																'secondaryStoragePoolInfo',
																'storageService',
																'profileId',
																'planSubType',
																'snapStorageInfo',
																'profileService',
																'storageType',
																function($scope, $log, $modalInstance, $state, cvLoc,
																		$stateParams, cvUtil, primaryStoragePoolInfo,
																		secondaryStoragePoolInfo, storageService,
																		profileId, planSubType, snapStorageInfo,
																		profileService, storageType) {
																	$scope.profileId = profileId;
																	$scope.planSubType = planSubType;
																	$scope.editStoragePoolMessage = cvUtil
																			.infoMsgLoc('Loading');
																	$scope.model = {};
																	$scope.model.snapRecoveryPoints = snapStorageInfo ? snapStorageInfo.snapRecoveryPoints
																			: null;
																	storageService
																			.getAllStoragePools()
																			.success(
																					function(data) {
																						$scope.storagePools = data;
																						$scope.secondaryStoragePools = data;
																						$scope.editStoragePoolMessage = cvUtil
																								.emptyMsg();
																						if ($scope.storagePools.length == 0) {
																							// Editing storage pool is currently disabled, so no need to
																							// display error when loading storage pools. Should be allowed
																							// once editing storage pool is implemented.
																							// $scope.editStoragePoolMessage = {
																							// 	'message' : cvLoc('error.noStorageFound'),
																							// 	'type' : 'error'
																							// };
																						}
																						$scope.sp1 = {
																							'storagePoolId' : primaryStoragePoolInfo.storagePoolId,
																							'storagePoolName' : primaryStoragePoolInfo.storagePoolName,
																							'retentionInDays' : primaryStoragePoolInfo.retentionInDays
																						};
																						if (secondaryStoragePoolInfo) {
																							$scope.sp2 = {
																								'storagePoolId' : secondaryStoragePoolInfo.storagePoolId,
																								'storagePoolName' : secondaryStoragePoolInfo.storagePoolName,
																								'retentionInDays' : secondaryStoragePoolInfo.retentionInDays
																							};
																						}
																						// If primary/secondary storage pools are not present in storagePools, add them:
																						var addStoragePoolIfMissing = function(
																								storagePoolToAdd) {
																							var storagePoolPresent = $scope.storagePools
																									.some(function(
																											storagePool) {
																										return storagePool.storagePoolEntity.storagePoolId === storagePoolToAdd.storagePoolId;
																									});
																							if (!storagePoolPresent) {
																								$scope.storagePools
																										.push({
																											storagePoolEntity : storagePoolToAdd
																										});
																							}
																						};
																						addStoragePoolIfMissing($scope.sp1);
																						if (secondaryStoragePoolInfo) {
																							addStoragePoolIfMissing($scope.sp2);
																						}
																					})
																			.error(
																					function(e) {
																						$scope.editStoragePoolMessage = cvUtil
																								.errMsg(e);
																					});

																	$scope.saveStoragePool = function() {
																		$scope.editStoragePoolMessage = cvUtil
																				.emptyMsg();

																		if ($scope.planSubType == 'Snap') {
																			if (($scope.model.snapRecoveryPoints == null)
																					|| ($scope.model.snapRecoveryPoints > 9999)
																					|| ($scope.model.snapRecoveryPoints < 1)) {
																				$scope.editStoragePoolMessage = {
																					message : cvLoc('error.snapRecoveryPoints'),
																					type : 'error'
																				}
																				return;
																			}
																			if (($scope.sp1.retentionInDays == null)
																					|| ($scope.sp1.retentionInDays > 9999)
																					|| ($scope.sp1.retentionInDays < 1)) {
																				$scope.editStoragePoolMessage = {
																					message : cvLoc('error.backupCopyRetention'),
																					type : 'error'
																				}
																				return;
																			}
																		} else {
																			if (($scope.sp1.retentionInDays == null)
																					|| ($scope.sp1.retentionInDays > 9999)
																					|| ($scope.sp1.retentionInDays < 1)) {
																				$scope.editStoragePoolMessage = {
																					message : cvLoc('error.retentionPeriod'),
																					type : 'error'
																				}
																				return;
																			}
																			if (secondaryStoragePoolInfo) {
																				if (($scope.sp2.retentionInDays == null)
																						|| ($scope.sp2.retentionInDays > 9999)
																						|| ($scope.sp2.retentionInDays < 1)) {
																					$scope.editStoragePoolMessage = {
																						message : cvLoc('error.retentionPeriod'),
																						type : 'error'
																					}
																					return;
																				}
																			}
																		}

																		$scope.editStoragePoolMessage = cvUtil
																				.infoMsg(cvLoc('label.saving'));
																		var objToSend = {
																			'primaryRetentionInDays' : $scope.sp1.retentionInDays
																		};
																		if (secondaryStoragePoolInfo) {
																			objToSend.secondaryRetentionInDays = $scope.sp2.retentionInDays;
																		}
																		if ($scope.planSubType == 'Snap') {
																			objToSend.snapRecoveryPoints = $scope.model.snapRecoveryPoints;
																		}

																		var isLogStorage = false;
																		if (storageType && storageType === 'Log') {
																			isLogStorage = true;
																		}
																		// send request to server
																		profileService
																				.editPlanStorage(
																						{
																							'id' : $scope.profileId,
																							'storage' : JSON
																									.stringify(objToSend),
																							'planType' : $scope.planSubType,
																							'isLogStorage' : isLogStorage
																						})
																				.success(
																						function(data) {

																							primaryStoragePoolInfo.retentionInDays = $scope.sp1.retentionInDays;
																							if (secondaryStoragePoolInfo) {
																								secondaryStoragePoolInfo.retentionInDays = $scope.sp2.retentionInDays;
																							}
																							if (snapStorageInfo) {
																								snapStorageInfo.snapRecoveryPoints = $scope.model.snapRecoveryPoints;
																							}
																							$modalInstance.dismiss();
																						}).error(function(e) {
																					$scope.editStoragePoolMessage = {
																						type : 'error',
																						message : e
																					};
																				});
																	};

																	$scope.cancel = function() {
																		$modalInstance.dismiss();
																	};

																} ],
														resolve : {
															primaryStoragePoolInfo : function() {
																return $scope.primaryStoragePoolInfo;
															},
															secondaryStoragePoolInfo : function() {
																return $scope.secondaryStoragePoolInfo;
															},
															profileId : function() {
																return $scope.profileId;
															},
															planSubType : function() {
																return $scope.planSubType;
															},
															snapStorageInfo : function() {
																return $scope.snapStorageInfo;
															},
															storageType : function() {
																return $scope.storageType;
															}
														}
													});
										};
									} ]
						}
					});

	//overide html input built-in autofocus for working as intended across multiple browsers and auto focus every time
	cvCommon.directive('autofocus', [ '$timeout', function($timeout) {
		return {
			restrict : 'A',
			link : function($scope, $element) {
				$timeout(function() {
					$element[0].focus();
				});
			}
		}
	} ]);

	/**
	 * common directive for 'please note' kind of elements. Useful when you need to display a prominently
	 * visible note instead of one that only shows up as tooltip
	 */
	cvCommon.directive('cvPleaseNote', [ function() {
		return {
			templateUrl : appUtil.appRoot + 'common/partials/cvPleaseNote.jsp',
			replace : true,
			scope : {
				header : "@",
				body : "@"
			}
		}
	} ]);

	cvCommon.directive('cvGenerateDeviceActions', [ function() {
		return {
			templateUrl : appUtil.appRoot + 'common/partials/cvDeviceActions.jsp',
			transclude : true,
			restrict : 'E',
			replace : true,
			scope : {
				params : "=",
				redirectOnDelete : "="
			},
			controller : [
					'$scope',
					'$state',
					'$dialogs',
					'cvLoc',
					'cvUtil',
					'cvToaster',
					'releaseLicenseFactory',
					'uninstallSoftwareFactory',
					'updateSoftwareFactory',
					'reconfigureClientFactory',
					'cvActionsEventFactory',
					'allAgentsService',
					'cvMultiCommcell',
					'agentFactory',
					function($scope, $state, $dialogs, cvLoc, cvUtil, cvToaster, releaseLicenseFactory,
							uninstallSoftwareFactory, updateSoftwareFactory, reconfigureClientFactory,
							cvActionsEventFactory, allAgentsService, cvMultiCommcell, agentFactory) {
						/*-
						 * params can include either entity object or all the required properties,
						 *
						 * params = { entity : {...} }
						 *
						 * OR
						 *
						 * params = {
						 * 	isClientDeconfigured : $scope.clientDetails.clientProps.IsDeletedClient,
						 * 	isUserCentricClient : $scope.clientDetails.clientProps.IsVirtualClient,
						 * 	clientId : $scope.clientDetails.client.clientEntity.clientId,
						 * 	clientName : $scope.clientDetails.client.clientEntity.clientName,
						 * 	physicalClientId : $scope.clientDetails.clientProps.physicalClient.clientId ***OPTIONAL***
						 * }
						 *
						 * redirectOnDelete takes the value as name of the state to redirect to when delete action is invoked
						 */

						$scope.currentState = $state.current.name;
						// take params from either entity or directly
						$scope.$watch('params', function() {
							if ($scope.params && $scope.params.entity) {
								$scope.isDeconfigured = $scope.params.entity.isClientDeconfigured;
								$scope.isUserCentricClient = $scope.params.entity.isUserCentricClient;
								$scope.clientName = $scope.params.entity.subClient.clientName;
								$scope.clientId = $scope.params.entity.subClient.clientId;
								$scope.physicalClientId = $scope.params.entity.physicalClient
										&& $scope.params.entity.physicalClient.clientId;
								$scope.hideSoftwareOptions = $scope.params.entity.hideSoftwareOptions;
								$scope.hideReadinessCheck = $scope.params.entity.hideReadinessCheck;
								$scope.isCommCellPackageAbsent = $scope.params.entity.isCommCellPackageAbsent;
								$scope.grcMigratedClient = $scope.params.entity.grcMigratedClient;
								$scope.commcellName = $scope.params.entity.commcellName;
								$scope.osInfo = $scope.params.entity.osInfo;
								$scope.isSendLogsSupported = $scope.params.entity.isSendLogsSupported;
								$scope.isMultiCC = (cv.sessionContext.isMultiComcellAware)
										&& ($scope.commcellName !== null) && ($scope.commcellName !== undefined);
							} else if ($scope.params) {
								$scope.isDeconfigured = $scope.params.isClientDeconfigured;
								$scope.isUserCentricClient = $scope.params.isUserCentricClient;
								$scope.clientName = $scope.params.clientName;
								$scope.clientId = $scope.params.clientId;
								$scope.applicationName = $scope.params.applicationName;
								$scope.applicationId = $scope.params.applicationId;
								$scope.physicalClientId = $scope.params.physicalClientId;
								$scope.hideSoftwareOptions = $scope.params.hideSoftwareOptions;
								$scope.hideReadinessCheck = $scope.params.hideReadinessCheck;
								$scope.isCommCellPackageAbsent = $scope.params.isCommCellPackageAbsent;
								$scope.grcMigratedClient = $scope.params.grcMigratedClient;
								$scope.osInfo = $scope.params.osInfo;
								$scope.commcellName = $scope.params.commcellName;
								$scope.isVirtualMachine = $scope.params.isVirtualMachine;
								$scope.isSPFarmPseudoClient = $scope.params.isSPFarmPseudoClient;
								$scope.isSendLogsSupported = $scope.params.isSendLogsSupported;
								$scope.isMultiCC = (cv.sessionContext.isMultiComcellAware)
										&& ($scope.commcellName !== null) && ($scope.commcellName !== undefined);
							}
							if ($scope.hideSoftwareOptions) {
								//hide update software and uninstall software
								$scope.showUpdateSoftware = false;
								$scope.showUninstallSoftware = false;
							} else {
								// update software: show when the entity is configured
								$scope.showUpdateSoftware = !$scope.isDeconfigured;
								// uninstall software: show when the entity is configured and only if it is a physical client
								$scope.showUninstallSoftware = cvActionsEventFactory.getShowUninstallAndReleaseKey()
										&& !$scope.isDeconfigured && !$scope.isUserCentricClient
										&& !$scope.isCommCellPackageAbsent && !$scope.grcMigratedClient
										&& !$scope.isSPFarmPseudoClient;
							}

							if ($scope.hideReadinessCheck || $scope.isVirtualMachine) {
								$scope.showReadinessCheck = false;
							} else {
								$scope.showReadinessCheck = true;
							}

							// release license: show when the entity is configured
							$scope.showReleaseLicense = cvActionsEventFactory.getShowUninstallAndReleaseKey()
									&& !$scope.isDeconfigured && !$scope.isVirtualMachine;
							// reconfigure: show when the entity is deconfigured
							$scope.showReconfigureClient = $scope.isDeconfigured && !$scope.isVirtualMachine;
							// delete: show when the entity is deconfigured
							$scope.showDeleteClient = $scope.isDeconfigured && !$scope.isVirtualMachine;
							$scope.showRetireAgent = !$scope.isDeconfigured && !$scope.isVirtualMachine;
							//show send logs for clients
							$scope.showSendLogs = $scope.isSendLogsSupported;
						})

						$scope.appenCnifMultiCommcell = function() {

							if (cv.sessionContext.isMultiComcellAware && $scope.commcellName !== null
									&& $scope.commcellName !== undefined) {
								cvMultiCommcell.setcommCellNameforLinks($scope.commcellName);
							}

						}

						// all the action handlers
						$scope.openUpdateSoftwareDialog = function() {
							var deviceId = $scope.isUserCentricClient ? $scope.physicalClientId : $scope.clientId;
							updateSoftwareFactory.openUpdateSoftwareDialog(deviceId, $scope.clientName);
						};

						$scope.retireAgent = function() {
							agentFactory.retireAgent(
									$scope.clientId,
									$scope.clientName,
									$scope.applicationId,
									$scope.applicationName);
						};

						$scope.openUninstallSoftwareDialog = function() {
							uninstallSoftwareFactory.openUninstallSoftwareDialog(
									$scope.clientId,
									$scope.clientName,
									$scope.params.osInfo.Type);
						};

						//						$scope.sendLogsForClient = function () {
						//							$state.go('sendLogs', {
						//								sourceid : $scope.clientId,
						//								sourceName : $scope.clientName,
						//								destination: $scope.currentState
						//							});
						//						};

						$scope.openReleaseLicenseDialog = function() {
							var deviceId = $scope.clientId;
							var deviceName = $scope.clientName;
							releaseLicenseFactory.openReleaseLicenseDialog(deviceId, deviceName);
							//											$dialogs
							//													.confirm(
							//															cvLoc('label.confirmReleaseLicense'),
							//															cvLoc('prompt.confirmReleaseLicense') + ' ' + deviceName
							//																	+ '?',
							//															{
							//																noFunction : function() {
							//																},
							//																yesFunction : function() {
							//																	// TODO: Hardcoding File System here because that is the only license a device has
							//																	var params = {
							//																		'clientId' : deviceId,
							//																		'licenseList' : '[{"license":{"appType":33,"licenseType":1,"licenseName":"Server File System - Windows File System","checked":true},"platformType":1}]',
							//																		'isClientLevelOperation' : true
							//																	}
							//																	releaseLicenseService
							//																			.releaseLicense(params)
							//																			.success(
							//																					function(data) {
							//																						$state.reload();
							//																						cvToaster
							//																								.showSuccessMessage({
							//																									'ttl' : '10000',
							//																									'message' : "License for "
							//																											+ deviceName
							//																											+ " is now released."
							//																								});
							//																					})
							//																			.error(
							//																					function(e) {
							//																						cvToaster
							//																								.showErrorMessage({
							//																									'ttl' : '10000',
							//																									'message' : e ? e
							//																											: cvLoc("generic_error")
							//																								});
							//																					});
							//																}
							//															});
						};

						$scope.reconfigureClient = function() {
							reconfigureClientFactory.reconfigureClient($scope.clientId, $scope.clientName);
						}

						$scope.deleteClient = function() {
							var deviceId = $scope.clientId;
							var deviceName = $scope.clientName;
							$dialogs.confirm(cvLoc('label.confirmDeleteClient'), cvLoc(
									'prompt.confirmDeleteClient',
									'<b>' + deviceName + '</b>'), {
								noFunction : function() {
								},

								yesFunction : function() {
									allAgentsService.deleteClient(deviceId).success(function(data) {
										if ($scope.redirectOnDelete) {
											$state.go($scope.redirectOnDelete);
										} else {
											$state.reload();
										}
										cvToaster.showSuccessMessage({
											'message' : deviceName + " " + cvLoc("info.deleteSuccessful")
										});
									}).error(function(e) {
										cvToaster.showErrorMessage({
											'ttl' : '10000',
											'message' : e ? e : cvLoc("generic_error")
										});
									});
								}
							});
						}
					} ],
			link : function(scope, element, attr, ctrl, transclude) {
				var insertElementAt = function(parentElement, index, element) {
					if (index === 0) {
						parentElement.prepend(element);
					} else {
						parentElement.children().eq(index - 1).after(element);
					}
				};

				transclude(function(clone) {
					var componentPageLinks = angular.element(element[0]);

					clone.each(function(idx, eleNode) {
						if (eleNode.tagName === "LI") {
							var indexAt;
							if (eleNode.hasAttribute("data-cv-pos")) {
								indexAt = parseInt(eleNode.getAttribute("data-cv-pos"));
							} else if (eleNode.hasAttribute("cv-pos")) {
								indexAt = parseInt(eleNode.getAttribute("cv-pos"));
							}

							if (indexAt !== undefined && !isNaN(indexAt)) {
								insertElementAt(componentPageLinks, indexAt, eleNode);
							} else {
								componentPageLinks.append(eleNode);
							}
						}
					});
				});
			}
		}
	} ]);

	cvCommon.directive('cvGlobalJobLoader', [
			'cvUtil',
			'$rootScope',
			function(cvUtil, $rootScope) {
				return {
					restrict : 'E',
					template : '<div class="growl loader" data-ng-if="showJobLoader">'
							+ '\t<div class="growl-item alert alert-info">' + '{{submittingJobMessage}}' + '\t</div>'
							+ '<div data-cv-loading-spinner> </div>' + '</div>',
					scope : {
						label : '@'
					},
					controller : [
							'$scope',
							'$timeout',
							'cvLoc',
							'$transitions',
							function($scope, $timeout, cvLoc, $transitions) {
								$scope.submittingJobMessage = $scope.label;
								$rootScope.$on('jobLoader', function(evt, action, loadTime) {
									if (action) {
										$scope.showJobLoader = action;
									} else {
										if (loadTime < 2000) {
											$timeout(function() {
												$scope.showJobLoader = false
											}, 2000 - loadTime);
										} else {
											$scope.showJobLoader = false
										}

									}
								})

								$transitions.onStart({}, function() {
									$scope.showJobLoader = false;
								});
							} ]
				};
			} ]);
	cvCommon.directive('cvUserMode', [ function() {
		return {
			restrict : 'EAC',
			transclude : true,
			scope : {
				userMode : "@",
			},
			template : '<div data-ng-if="limitedUser">' + '<ng-transclude></ng-transclude>' + '</div>',
			controller : [
					'$scope',
					function($scope) {
						$scope.limitedUser = false;

						if ((cv.additionalSettings != null) && (cv.additionalSettings.AdminConsole != null)
								&& (cv.additionalSettings.AdminConsole.userMode || 'beginner') === 'advanced'
								&& (($scope.userMode || 'beginner') == 'advanced')) {
							$scope.limitedUser = true;
						}

					} ]

		}
	} ])
	cvCommon.directive("filesInput", function() {
		return {
			require : "ngModel",
			link : function postLink(scope, elem, attrs, ngModel) {
				elem.on("change", function(e) {
					var files = elem[0].files;
					ngModel.$setViewValue(files);
					elem.val('');
				})
			}
		}
	});

	cvCommon.directive('cvCapability', [ 'ngIfDirective', function(ngIfDirective) {
		var ngIf = ngIfDirective[0];
		return {
			transclude : ngIf.transclude,
			priority : ngIf.priority - 1,
			terminal : ngIf.terminal,
			restrict : ngIf.restrict,
			$$tlb : true,
			link : {
				pre : function(scope, ele, attrs) {
					scope.__ifAttr = attrs.ngIf;
				},
				post : function(scope, ele, attrs) {
					var __cvCapable = false;
					function _isCapable(cvCapability) {
						var isCapable = false;
						_.each(cvCapability.permissionIds, function(permission) {
							if (permission === 31 || permission === cvCapability.permissionId) {
								isCapable = true;
								return false;
							}
						});

						return isCapable;
					}

					attrs.ngIf = function() {
						return (scope.__ifAttr ? scope.$eval(scope.__ifAttr) : true) && __cvCapable;
					};

					var _deRegWatch = scope.$watch(attrs.cvCapability, function(nv) {
						if (nv) {
							if (nv.permissionIds && !_isCapable(nv)) {
								__cvCapable = false;
							} else {
								__cvCapable = true;
							}
							_deRegWatch();
						}
					});

					ngIf.link.apply(ngIf, arguments);
				}
			}
		}
	} ]);

	cvCommon.directive('cvDragButton', function() {
		return {
			restrict : 'E',
			templateUrl : appUtil.appRoot + 'common/partials/cvDragButton.jsp'
		};
	});

	cvCommon.directive('cvCopyToClipboard', ['$timeout', function($timeout) {
		return {
			restrict: 'AE',
			transclude: true,
			template: '<span data-ng-class="{\'k-icon k-i-copy font-size-26 color-link\' : useIcon === \'true\'}" uib-tooltip="{{copyMessage}}" tooltip-placement="auto" tooltip-class="fit-content"> \
						<span data-ng-if="useIcon === \'false\'" data-ng-transclude></span> \
					  </span>',
			scope: {
				copytext: '@',
				copyContainerCssSelector: '@',
				helpText: '@',
				useIcon: '@',
			},
			controller : [
				'$scope',
				'cvLoc',
				function($scope, cvLoc){
					$scope.copyMessage = $scope.helpText;
					$scope.feedbackText = cvLoc('label.copied');
					$scope.useIcon = $scope.useIcon || 'true';
				}
			],
			link: function(scope, element, attrs) {
				$(element).click(function(e, rowid) {
					e.preventDefault();
					const el = document.createElement('textarea');
					el.setAttribute('class', 'move-out-of-viewport');
					el.value = scope.copyContainerCssSelector? $(scope.copyContainerCssSelector).text(): scope.copytext;
					document.body.appendChild(el);
					el.select();
					try{
						document.execCommand('copy');
						$timeout(function() {
							scope.copyMessage = scope.feedbackText;
						});
					}catch(e) {
						console.log("copy unsuccessful: ", e);
					}
					document.body.removeChild(el);
					$timeout(function() {
						scope.copyMessage = scope.helpText;
					}, 1500);
				});
			}
		};
	}]);

	cvCommon.directive('cvDownloadAsFile', function() {
		return {
			restrict: 'AE',
			template: '<span data-ng-class="{\'k-icon k-i-download font-size-26 color-link\' : useIcon === \'true\'}" uib-tooltip="{{helpText}}" tooltip-placement="auto" tooltip-class="fit-content"> \
						<span data-ng-if="useIcon === \'false\'" data-ng-transclude></span> \
					  </span>',
			scope: {
				downloadContent: '@',
				downloadFilename: '@',
				helpText: '@',
				useIcon: '@',
			},
			controller : [
				'$scope',
				function($scope){
					$scope.useIcon = $scope.useIcon || 'true';
				}
			],
			link: function(scope, element, attrs) {
				$(element).click(function(e, rowid) {
					e.preventDefault();
					var a = document.createElement("a");
					a.setAttribute("class", "move-out-of-viewport");
					var file = new Blob(
							[ scope.downloadContent ],
							{
								type : 'text/plain'
							});
					a.href = URL.createObjectURL(file);
					a.download = scope.downloadFilename;
					document.body.appendChild(a);
					a.click();
					window.setTimeout(function() {
						document.body.removeChild(a);
						URL.revokeObjectURL(a)
					},100);
				});
			}
		};
	});

})();
