import { cvCommonModule } from "common/js/modules";

export class CvWizardButtonDirective {
	constructor() {
		this.restrict = 'E';
        this.templateUrl = appUtil.appRoot + 'adminConsole/partials/cvWizardButton.jsp';
		this.require = ['^cvWizard', '^cvWizardStep'];
		this.bindToController = true;
		this.controller = CvWizardButtonController;
		this.controllerAs = 'wizButtonCtrl';
		this.scope = {
			type: '@cvType',
			label: '@?cvLabel', // Optional label
			disabled: '=?cvDisabled',
			keepDefaultButton: '=?cvKeepDefaultButton', // If true, the default button will be kept.
			// Default behavior is to instead override/remove the default button if the step is defining one.
		};
	}

	link(scope, element, attrs, controllers) {
		const wizCtrl = controllers[0];
		const wizStepCtrl = controllers[1];
		const wizButtonCtrl = scope.wizButtonCtrl;
		const wizard = wizCtrl.wizard;

		// If label is not set, inherit it from the parent wizard:
		wizButtonCtrl.label = wizButtonCtrl.label || wizCtrl.getLabels()[wizButtonCtrl.type];

		if (!wizButtonCtrl.keepDefaultButton) {
			// If this is not a default button (the button has been defined by the step)
			// hide the default button
			wizStepCtrl.hideDefaultButton(wizButtonCtrl.type);
		}

		if (wizButtonCtrl.type === CvWizardButtonTypes.NEXT || wizButtonCtrl.type === CvWizardButtonTypes.FINISH) {
			wizButtonCtrl.buttonClass['cvBusyOnAjax'] = true;
			wizButtonCtrl.buttonClass['btn-primary'] = true;
			wizButtonCtrl.buttonClass['btn-default'] = false;
		}

		switch(wizButtonCtrl.type) {
			case CvWizardButtonTypes.NEXT:
				wizButtonCtrl._onClick = () => { wizard.next(); };
				break;
			case CvWizardButtonTypes.SKIP:
				wizButtonCtrl._onClick = () => { wizard.skip(); };
				break;
			case CvWizardButtonTypes.PREVIOUS:
				wizButtonCtrl._onClick = () => { wizard.previous(); };
				break;
			case CvWizardButtonTypes.FINISH:
				wizButtonCtrl._onClick = () => { wizard.finish(); };
				break;
			case CvWizardButtonTypes.CANCEL:
				wizButtonCtrl._onClick = () => { wizard.cancel(); };
				break;
			// TODO implement a GOTO type
		}
	}
};

export class CvWizardButtonController {
	static $inject = ['$scope'];
	constructor($scope) {
		this.$scope = $scope;
		this.buttonClass = {
			'btn-default': true,
			'btn-primary': false,
			'cvBusyOnAjax': false,
		};
		// By default, this button does nothing unless a valid type is set
		this._onClick = angular.noop();
	}

	$onInit() {
		if (this.type === CvWizardButtonTypes.FINISH || this.type === CvWizardButtonTypes.NEXT ) {
			this.buttonType = 'submit';
		} else {
			this.buttonType = 'button';
		}
	}

	click() {
		this._onClick();
	}
};

cvCommonModule.directive('cvWizardButton', () => new CvWizardButtonDirective());

export const CvWizardButtonTypes = Object.freeze({
	CANCEL: 'cancel',
	NEXT: 'next',
	PREVIOUS: 'previous',
	SKIP: 'skip',
	FINISH: 'finish',
	// TODO implement a GOTO type
});