import { cvCommonModule } from "common/js/modules";

const cvSelectedItemsTEMPLATE = `
<div class="col-md-12 selection-wrapper">
		<a href="" data-ng-click="ctrl.showContentDialog(ctrl.selectedItems)" data-ng-bind="ctrl.seletedItemLabel"
			class="margin-bottom-5 margin-right-5 float-right">
		</a>
	</div>`;


class cvSelectedItems {
	constructor() {
		this.bindToController = true;
		this.controllerAs = 'ctrl';
		this.scope = {
			selectedItems: '=' //displayName attribute will be used for column
		};
		this.template = cvSelectedItemsTEMPLATE;
		this.controller = cvSelectedItemsController;
	}
	link(scope, ele, attrs, ctrl) {
		ctrl.init();
	}
}


class cvSelectedItemsController {
	constructor($uibModal, cvLoc, $scope) {
		this.$uibModal = $uibModal;
		this.cvLoc = cvLoc;
		this.$scope = $scope;
	}
	init() {
		this.seletedItemLabel = this.cvLoc('label.selectedItems') + ' (' + this.selectedItems.length + ') ';
	}

	updateSelectedItems(sourceItems) {
		this.selectedItems = sourceItems;
		this.seletedItemLabel = this.cvLoc('label.selectedItems') + ' (' + this.selectedItems.length + ') ';
	}

	showContentDialog(selectedItems) {
		const uibModalInstance = this.$uibModal.open({
			templateUrl: appUtil.appRoot + 'modules/ida/partials/cloudMigrateContent.jsp',
			backdrop: 'static',
			windowClass: 'small-size',
			restrict: 'AE',
			controller: [
				'$scope',
				'$uibModalInstance',
				'uiGridConstants',
				'cvLoc',
				'cvToaster',
				'cvTableOptions',
				function($scope, $uibModalInstance, uiGridConstants, cvLoc, cvToaster, cvTableOptions) {
					$scope.sourceItems = angular.copy(selectedItems);
					$scope.cancel = function() {
						$uibModalInstance.dismiss();
					};
					$scope.save = function() {
						$uibModalInstance.close($scope.sourceItems);
					};

					const columns = [
						{
							name: 'name',
							enableSorting: false,
							displayName: '',
							cellTemplate: '<span title="{{row.entity.displayName}}">{{row.entity.displayName}}</span>',
							width: '80%'
						},
						{
							name: 'actionMenu',
							enableSorting: false,
							displayName: '',
							cellTemplate:
								'<span title="' +
								cvLoc('label.remove') +
								'"><a data-ng-click="grid.appScope.removeContent(row.entity)"><i class="glyphicon glyphicon-remove"></i></a></span>',
							width: '20%'
						}
					];

					const globalGridOptions = angular.copy(cvTableOptions.commonNgGridOptions);
					angular.extend(globalGridOptions, {
						data: 'sourceItems',
						enableGridMenu: false,
						columnDefs: columns,
						onRegisterApi: function(gridApi) {
							$scope.gridApi = gridApi;

							$scope.refreshGrid = function() {
								gridApi.core.notifyDataChange(uiGridConstants.dataChange.ALL);
							};
						}
					});

					$scope.contentGridOptions = {
						cvHasTitle: false,
						cvTableName: 'selecteItemsTable',
						cvIsSearchable: false,
						cvHasViews: false,
						cvGridCssClass: {
							'modal-grid': true
						},
						gridOptions: globalGridOptions
					};

					$scope.removeContent = function(entity) {
						if ($scope.sourceItems.length == 1) {
							cvToaster.showErrorMessage({
								ttl: '5000', //5 sec
								message: cvLoc('error.contentEmpty')
							});
						} else {
							const index = $scope.sourceItems.findIndex(obj => obj.displayName == entity.displayName);

							if (index >= 0) {
								$scope.sourceItems.splice(index, 1);
								$scope.refreshGrid();
							}
						}
					};
				}
			]
		});

		uibModalInstance.result.then(this.updateSelectedItems.bind(this), function() {});
	};
}


cvSelectedItemsController.$inject = ['$uibModal', 'cvLoc', '$scope'];

cvCommonModule.directive("cvSelectedItems", () => new cvSelectedItems());
export default cvCommonModule;