import { cvCommonModule } from "common/js/modules";

const kpiTEMPLATE = `
<a class="kpi-tile page-details-box load-manually" data-ng-href="{{ctrl.link}}" data-ng-class="{'cursor-auto': !ctrl.needCursor }" data-ng-click="ctrl.onClickTile()" aria-labelledby="{{ctrl.obj.name | cvLoc}}" aria-describedby="{{ctrl.obj.value}}">
    <div class="page-details kpi-tile-state">
        <div class="shorten-loading-data" data-ng-class="{'loading-data margin-top-0': !ctrl.obj.fetched}">
        <h3 class="no-margin kpi-tile-state-value load-shape" ng-bind="ctrl.obj.value"/>
        </div>
        <div class="shorten-loading-data" data-ng-class="{'loading-data margin-top-0': !ctrl.obj.fetched}">
        <h5 class="no-margin kpi-tile-state-title load-shape" ng-bind="ctrl.obj.name"/>
        </div>
    </div>
    <div class="page-details-prev  kpi-tile-icon" data-ng-class="{'icon-invisible': !ctrl.obj.fetched}">
        <span data-ng-if="ctrl.iconType === 'svg'" class="kpi-icon" data-ng-bind-html="ctrl.obj.icon" data-ng-style="{'fill':ctrl.obj.color}"></span>
    </div>
</a>
`;

export class CVkpiDirective {
    constructor(){
        this.restrict = 'E',
        this.template = kpiTEMPLATE,
        this.bindToController = true,
        this.controllerAs = 'ctrl',
        this.replace = true,
        this.controller = CVKPIdirController,
        this.scope={
            obj: '=',
            // name, value, icon, iconType, color, link
            onClick: '&'
        }
    }

    link(scope, ele, attrs,ctrl) {
        ctrl.needCursor = ctrl.obj.link || attrs.onClick;
    }

}

class CVKPIdirController {
    constructor($scope,cvLoc) {
        this.$scope = $scope,
        this.cvLoc = cvLoc;
    }

    $onInit() {
        this.init(this);
    }

    init(self){

        self.iconType = self.obj.iconType || 'svg';
        self.onClickTile = () =>{
            if(_.isFunction(self.onClick)){self.onClick(self.obj);}
        }
    }
}

CVKPIdirController.$inject = ['$scope', 'cvLoc'];
cvCommonModule.directive('cvKpiTile', () => new CVkpiDirective());
export default cvCommonModule;
