const cvBrowseInputTEMPLATE = `
<div class="form-group" data-ng-if="ctrl.keys.length !== 1">
    <label class="col-xs-12 col-sm-5 margin-top-5">{{ctrl.inputLabel.type | localizedString}}</label>
    <div class="col-xs-12 col-sm-7 margin-bottom-5">
        <cv-radio-group radio-name="'path'" radio-obj="ctrl.pathObj" radio-model="ctrl.selectedPath"></cv-radio-group>
    </div>
</div>
 <div class="form-group">
    <label class="col-xs-12 col-sm-5">{{ctrl.inputLabel.path | localizedString}}</label>
    <div class="col-xs-12 col-sm-7" data-ng-switch="ctrl.selectedPath">
        <div data-ng-switch-when="local">
            <div class="col-xs-11 padding-left-0 padding-right-0" ng-class="{ 'col-xs-12': ctrl.hideBrowse }"><input id="{{ ctrl.pathObj.local.id }}" name="{{ ctrl.pathObj.local.name }}" class="no-margin" type="text" data-ng-model="ctrl.path.local" data-ng-required="ctrl.pathObj.local.required" data-ng-pattern="ctrl.pathObj.local.pattern" autocomplete="off" /></div>
            <div class="col-xs-1 padding-left-0 padding-right-0" ng-if="!ctrl.hideBrowse"><a href="" class="btn btn-ternary padding-3 rounded-border-radius" data-ng-click="ctrl.clickbrowse()" title="{{'action.browse' | localizedString}}"><span class="k-icon k-i-folder-more font-size-page-title"></span></a></div>
        </div>
        <div data-ng-switch-when="network">
            <input type="text" id="{{ ctrl.pathObj.local.id }}" class='no-margin' name="{{ ctrl.pathObj.network.name }}" data-ng-model="ctrl.path.network" data-ng-required="ctrl.pathObj.network.required" data-ng-pattern="ctrl.pathObj.network.pattern" autocomplete="off" />
        </div>
        <div class="margin-left-0 help-block" data-ng-if="(ctrl.formName[ctrl.pathObj.local.name].$dirty && ctrl.formName[ctrl.pathObj.local.name].$invalid) || (ctrl.formName[ctrl.pathObj.network.name].$dirty && ctrl.formName[ctrl.pathObj.network.name].$invalid)">
            <div data-ng-if="ctrl.formName[ctrl.pathObj.local.name].$error.required || ctrl.formName[ctrl.pathObj.network.name].$error.required">{{ 'error.path' | localizedString}}</div>
            <div data-ng-if="ctrl.formName[ctrl.pathObj.local.name].$error.pattern ||ctrl.formName[ctrl.pathObj.network.name].$error.pattern">{{ 'error.path' | localizedString}}</div>
        </div>
    </div>
 </div>
`;

class CvBrowseInput {
    constructor() {
        this.restrict = 'E';
        this.template = cvBrowseInputTEMPLATE;
        this.bindToController = true;
        this.controller = CvBrowseInputController;
        this.controllerAs = 'ctrl';
        this.scope = {
            inputLabel: '=?',
            pathObj: '=?',
            hideBrowse: '=?',
            selectedPath: '=',
            formName: '=',
            path: '=',
            browseFunc: '&'
        };
    }

    link(scope, ele, attr, ctrl) {
        ctrl.init();
    }
}

class CvBrowseInputController {
    constructor(REGEX) {
        this.REGEX = REGEX;
    }

    init() {
        const defaultLabels = {
            type: 'Path type',
            path: 'Path'
        }

        const defaultPathType = {
            'network': {
                label: 'label.networkShare',
                value: 'network',
                pattern: this.REGEX.WINDOWS_NETWORK_PATH,
                id: 'path',
                name: 'pathName',
                required: true,
            },
            'local': {
                label: 'label.localDrive',
                value: 'local',
                pattern: this.REGEX.WINDOWS_LOCAL_PATH,
                id: 'path',
                name: 'pathName',
                required: true
            }
        };

        this.inputLabel = {
            ...defaultLabels,
            ...this.inputLabel
        };
        this.keys = Object.keys(this.pathObj || {});
        for (let key of this.keys) {
            this.pathObj[key] = {
                ...defaultPathType[key],
                ...this.pathObj[key]
            }
        }
        if (!this.keys.length) this.pathObj = {
            ...defaultPathType
        };
        if (!this.selectedPath) this.selectedPath = keys[0];

        if (!this.hideBrowse) this.hideBrowse = false;
    }

    clickbrowse() {
        this.formName.$dirty = true;
        if (this.browseFunc) this.browseFunc();
    }
}

CvBrowseInputController.$inject = ['REGEX'];
export default ['cvBrowseInput', () => new CvBrowseInput()];