import { cvCommonModule } from "common/js/modules";

const TEMPLATE = `
<div id="cv-changename" class="cv-change-name" >
<span data-ng-if="ctrl.statusIcon" class="{{ctrl.statusIcon}}"></span>
<h1 class="loader-skeleton title-style" data-ng-if="!ctrl.obj.name"></h1>
<h1 id="changeNameTitle{{ctrl.obj.id}}" class="no-margin page-title editable js-page-title{{obj.id}}" data-ng-bind="ctrl.obj.name" contenteditable="true" data-ng-click="ctrl.toggleClick()" data-ng-keyup="ctrl.handleKeyUp($event)"  data-ng-blur="ctrl.handleFocusout()"  ></h1>
<div title="{{ctrl.btnLabl}}" class="glyphicon change-name-btn{{ctrl.obj.id}} change-name-icon" data-ng-class="{'glyphicon-trash remove-mode': ctrl.isEdit,'glyphicon-pencil edit-mode':!ctrl.isEdit}" data-ng-mousedown="ctrl.cancelChangeName()"></div>
</div>`;


class cvChangenameDirective {
    constructor() {
        this.restrict = 'E',
        this.template = TEMPLATE;
        this.bindToController = true;
        this.scope = {
            obj : '=',
            serviceMethod : '@',
            change: '&',
            callback: '=',
            statusIcon: '@'
        };
        this.replace = true,
        this.controllerAs = 'ctrl';
        this.controller = cvChangenameController;
    }

    link(scope, element, attr, ctrl){

        ctrl.getElement = ()=>{
            return element.find("#changeNameTitle"+ctrl.obj.id);
        };

        scope.$on('changeNameFailed', (evt,data)=>{
            ctrl.failedChangeName(data && data.errorMessage ? data.errorMessage : ctrl.cvLoc('error.changeNameFailed'));
        })

    }
}

class cvChangenameController {
    constructor(cvLoc,cvToaster,$http) {
        this.cvLoc = cvLoc;
        this.cvToaster = cvToaster;
        this.$http = $http;
    }

    $onInit() {
        this.handleFocusout = this._handleFocusout.bind(this);
        // this.initializeHandler(this);
    }

    initializeHandler(self) {
        const arr = ['failedChangeName'];
        _.forOwn(arr,(val)=>{
            self[val] = self['_'+val].bind(self);
        })
    }

    toggleClick() {
        this.toggleButton(true);
    }

    toggleButton(bol) {
        this.isEdit = bol;
        this.btnLabl = bol? 'Change name' : this.cvLoc('label.cancel');
    }

    handleEventChanged(text) {

        if(!this.serviceMethod) {
            this.change({
                id:this.obj.id,
                name: text
            })
            this.toggleButton(false);
            return;
        }

        const obj = _.assignIn({},this.obj);
        obj.name = text;

        const appObj = {
            'newApp': JSON.stringify({
                appName: text,
                appKey : this.obj.appKey || ''
            })
        };

        const self = this;
        let returnObj = {};
        this.$http.post(this.serviceMethod, this.obj.appName ? appObj:obj).success(()=>{
            self.obj.name = text;
            returnObj = {
                type: 'success',
                value: text
            }

        }).error((errorMessage)=>{
            debugger;
            self.failedChangeName(errorMessage);
            returnObj = {
                type:'error',
                value: errorMessage
            }


        }).finally(()=>{
            this.toggleButton(false);

            if(self.callback) {
                if(returnObj.type === 'success') {
                    self.callback(null,returnObj.value)
                }else{
                    self.callback(returnObj.value);
                }
            }
        });

    }

    failedChangeName(data) {
        this.getElement().text(this.obj.name);
        this.cvToaster.showErrorMessage({
            'ttl':'5000',
            'message': data
        });
    }

    cancelChangeName() {
        console.log("CANCEL");

        if(this.isEdit) {
            this.clickedCancel = true;
            this.handleFocusout();
        }
    }

    _handleFocusout() {
        const ele = this.getElement();
        const msg = _.trim(ele.text());
        //remove Enter
        ele.text(msg);

        if(msg === this.obj.name ||  msg === '' || this.clickedCancel) {
            ele.text(this.obj.name);
            this.clickedCancel = false;
            this.toggleButton(false);
            return;
        }

        this.handleEventChanged(msg);
    }

    handleKeyUp(e) {
        if(e.keyCode === 13) { //enter
            this.getElement().blur();
        }else if(e.keyCode === 27) { //escape
            this.cancelChangeName();
        }
    }
}

cvChangenameController.$inject = ['cvLoc','cvToaster','$http'];
cvCommonModule.directive('cvChangename', ()=> new cvChangenameDirective);
export default cvCommonModule;