import { cvCommonModule } from "common/js/modules";

const TEMPLATE = `
<div class="alert-sign-detail text-center" data-ng-class="{'danger':ctrl.type === 'danger', 'alert':ctrl.type !== 'danger'}">
    <span>
        <span data-ng-switch="ctrl.type">
            <span data-ng-switch-when="question" class="alert-detail-icon k-icon k-i-question"></span>
            <span data-ng-switch-when="danger" class="alert-detail-icon k-icon k-i-notification"></span>
            <span data-ng-switch-default class="alert-detail-icon k-icon k-i-warning"></span>
        </span>
        <span>{{ctrl.getLocalizedString(ctrl.text)}}</span>
        <a data-ng-if="ctrl.linkLabel" data-ng-click="ctrl.extraFunc(data)">{{ctrl.getLocalizedString(ctrl.linkLabel)}}</a>
	</span>
	<button type="button" class="close" data-dismiss="alert" aria-label="Close" ><span aria-hidden="true" class="k-icon k-i-close"></span></button>
</div>
`;

class AlertDetailSign {
    constructor() {
        this.restrict ="E",
        this.template = TEMPLATE,
        this.bindToController = true,
        this.replace = true,
        this.controllerAs = 'ctrl',
        this.controller = CvCheckboxController,
        this.scope = {
            type : '@',
            text : '@',
            linkLabel : '@',
            extraFunc : '&'
        }
    }

    link(scope, ele, attrs, ctrl) {
        scope.cvLoc = ctrl.cvLoc;
    }
}

class CvCheckboxController {
    constructor(cvLoc) {
        this.cvLoc = cvLoc;
    }

    $onInit() {
        this.getLocalizedString = this._getLocalizedString.bind(this);
    }

    _getLocalizedString(st) {
        //will remove after form# 1150 is checked-in
        if(st && !_.isUndefined(st)){
            let localizedString = this.cvLoc(st);
            if(localizedString.substring(0,3) === "???"){
                return st;
            }
            return localizedString;
        }
        return "";
    }	
}

CvCheckboxController.$inject = ['cvLoc'];
cvCommonModule.directive('alertDetailSign', () => new AlertDetailSign());
export default cvCommonModule;