export default class NotifQueue {
  constructor(arr, max) {
	this.MAX = max || 5;
    this.data = [...arr];
  }
  
  get data() {
    return this._data;
  }
  
  removeOldest(){
    if(this._data.length <= this.MAX) {
		return;
	}

    const length = this._data.length;
    this._data.splice(this.MAX, length);
  }
  
  set data(arr) {
    if(Array.isArray(arr)){
      this._data = arr;
      this.removeOldest();
    }
  }
  
}
