import { cvCommonModule } from "common/js/modules";
cvCommonModule.constant('deepLinkActionTypes', )
cvCommonModule.factory('deepLink', ['$location', 'multiCommcellFactory', function($location, multiCommcellFactory) {
    const factory = {};

    const actionTypes = {
        rowAction: 'rowAction',
    }

    factory.getDeepLink = function(options, type = actionTypes.rowAction) {
        if (type == actionTypes.rowAction) {
            /**
             * options: {
             *  permittedOptions: object mapping all available actions and entity identifiers,
             *  params: Parameters passed to the onClickFunction for rowAction
             * }
             */
            const action = _.get(options, 'params[0]', '');
            const deepLink = {
                type,
                action,
                id: _.get(options, 'permittedOptions.entityId', 0),
                name: _.get(options, 'permittedOptions.entityName', ''),
            }
            // get current link, add the deeplink param and navigate there
            const currentUrl = window.location.hash;
            let connector = '?';
            if (_.includes(currentUrl, '?')) {
                connector = '&';
            }
            return  currentUrl + connector + 'deepLink=' + encodeURIComponent(JSON.stringify(deepLink));
        }

    }

    /**
     * 
     * deepLink: {
     *  type: type of action to perform values: 'rowAction'
     *  action: Action Identifier
     *  id: identifier on where to perform action: Eg: rowId
     * }
     */
    factory.deepLinkWrapper = function(options = {}) {
        _.defaults(options, {
            deepLink: '',
            rows: [],
            rowId: 'permittedOptions.entityId', 
            permittedOptionsId: 'permittedOptions',
            actions: 'permittedOptions.permittedActionList', 
            actionId: 'value',
            defaultGridAction: 'onClick',
            actionClickId: 'onClickWithParams',
            hrefId: 'href',
        });
        if (options.stateParams && !options.deepLink) {
            options.deepLink = options.stateParams.deepLink
        }
        return factory.deepLink(options);
    }

    function getAction(actionObject, permittedOptions = {}, defaultGridAction = '') {
        // Specifically for kendo grid actions
        if (actionObject && permittedOptions) {
            let action = _.get(actionObject, defaultGridAction)
            if (action) {
                return () => {
                    action(
                        actionObject.value,
                        permittedOptions.entity,
                        permittedOptions.entityType,
                        actionObject,
                        permittedOptions.entityId,
                        permittedOptions.entityName,
                        permittedOptions.entityListPageState
                    );
                }
            }
        }
    }

    factory.deepLink = function({ deepLink, rows, rowId, actions, actionId, actionClickId, permittedOptionsId, defaultGridAction, hrefId, grid }) {
        if (!deepLink)
            return;
            
        try {
            deepLink = JSON.parse(deepLink);
        } catch (error) {
            console.warn(error);
            return;
        }

        if (deepLink.type == actionTypes.rowAction) {
            if (deepLink.action) {
                const row = _.find(rows, (row) => {
                    return _.get(row, rowId, '0') == deepLink.id
                });
                const actionObject = _.find(_.get(row, actions, []), tAction => {
                    return _.get(tAction, actionId, '0') == deepLink.action
                });
                let action = _.get(actionObject, actionClickId);
                if (!action && actionObject) {
                    const permittedOptions = _.get(row, permittedOptionsId)
                    action = getAction(actionObject, permittedOptions, defaultGridAction);
                }
                let href = _.get(actionObject, hrefId);
                if (action) {
                    action();
                } else if (href) {
                    multiCommcellFactory.openUrl(href);
                } else if (deepLink.name && grid) {
                    // Doesn't get stuck in an infinite loop here since kendo ignores subsequent searches with same content
                    grid && grid.search && grid.search(deepLink.name);
                }
            }
        }
    }

    return factory;
}]);
export default cvCommonModule;
