export default class DatePicker {
	constructor(element, options) {
		this.element = element;
		this.start = options.start;
		this.depth = options.depth;
		this.format = options.format;
		this.dateInput = options.dateInput;
		this.onChange = options.onChange;
	}

	build() {
		super.build();
		this.element.kendoDatePicker({
			start: this.start,
			depth: this.depth,
			format: this.format,
			dateInput: this.dateInput,
			change: this.onChange.bind(this)
		});
	}
}
