var cvUtil = {};

cvUtil.DEFAULT_TIMEOUT = (typeof cvUtil.DEFAULT_TIMEOUT === "number" && cvUtil.DEFAULT_TIMEOUT && !isNaN(cvUtil.DEFAULT_TIMEOUT)) ? cvUtil.DEFAULT_TIMEOUT
		: 60000;
cvUtil.DEFAULT_SESSION_TIMEOUT = 1800000;
cvUtil.DEFAULT_SESSION_MODAL_OPEN = 120000;
cvUtil.SESSION_LAST_USED = "sessionlastUsed";
cvUtil.sessionTimerTask = null;

cvUtil.taskPollInitialized = false;
cvUtil.notificationsInitialized = false;

// Names of URL parameters for passing remote CommCell details.
cvUtil.PARAM_CCID = "_cid";
cvUtil.PARAM_CCNAME = "_cn";
cvUtil.ajaxReqQueue = [];

var initDummyLocalForage = function(){
	return {
		setItem: function(){
			console.log("***Nothing happening here. Do not use localForage");
		},
		getItem: function(){
			console.log("***Nothing happening here. Do not use localForage");
		}
	};
}

var localforage = localforage || initDummyLocalForage();

cvUtil.CancelAllQueuedAjaxReqs = function() {
	for (index = 0; index < cvUtil.ajaxReqQueue.length; index++) {
		cvUtil.ajaxReqQueue[index].abort();

	}
	cvUtil.ajaxReqQueue = [];
}
cvUtil.getTopWindow = function() {
	if (window.self == window.parent) {
		return window;
	}
	var currWindow = window;
	try {
		while (currWindow.parent.location.href) {
			if (currWindow.document.getElementById('webConsoleIFrame')) {
				return currWindow.document.getElementById('webConsoleIFrame').contentWindow;
			}
			if (currWindow.self == currWindow.parent || currWindow === currWindow.parent) {
				return currWindow;
			}
			currWindow = currWindow.parent;

		}
	} catch (err) {
		return currWindow;
	}

};



/**
 *
 */
cvUtil.handleIfFwkErr = function(xhr, ajaxOptions, thrownError) {
	var serverError;
	var nhMsg;

	if (xhr.status == 0 && thrownError !== null && thrownError.length == 0 && !xhr.getAllResponseHeaders()) {
		console
				.debug("Ajax call aborted. No response or error code was returned. This could be due to a redirection to another page while a call is in progress.");
		return true;
	} else if (xhr.status == 901) {
		console
				.error("Ajax call aborted. CSRF Security token mismatch occured or referrer is invalid. The request was cancelled.");
		return true;
	} else if (xhr.status == 401) {
		cvUtil.getTopWindow().location.href = cvUtil.getTopWindow().location.origin + cvUtil.CONTEXT_PATH +
				"/login/?relogin";
		return;
	} else if (xhr.status == 900) {
		// Show error popup - if a message was returned in the response, show that, otherwise fetch from the server
		serverError = '';
		if (typeof xhr.responseText !== "undefined") {
			serverError = xhr.responseText.trim();
		}
		if (serverError === '') {
			serverError = cvUtil.getServerErrorString();
		}

		nhMsg = localMsg.exceptionText;
		if (serverError !== null && serverError !== "") {
			nhMsg += " [" + serverError + "]";
		}
		cvUtil.notify("notificationTemplateServerError", {
			text : serverError
		}, 0, true, nh.NOTIFICATION_ERROR, nhMsg);

		return true;
	}
	return false;
};

cvUtil.escapeHtml = function(str) {
	var div = document.createElement('div');
	div.appendChild(document.createTextNode(str));
	return div.innerHTML;
};

cvUtil.escapeRegExp = function(str) {
	return str.replace(/[\-\[\]{}()*+?.,\\\^$|#\s]/g, '\\$&');
}

/**
 *
 */
cvUtil.handleError = function(xhr, ajaxOptions, thrownError) {
	if (xhr.status === 404) {
		return;
	}
	if (!cvUtil.handleIfFwkErr(xhr, ajaxOptions, thrownError)) {
		var exText = cvUtil.getString("Exception_Text", function() {
		});
		if (exText == "") {
			exText = "We're sorry, something went wrong. Please try again.";
		}
		alert(exText);
	}
};

/**
 *
 */
cvUtil.isParentIFrame = function() {
	return window.location != window.parent.location;
};

/**
 * Use this function to make a asynchronous POST call. The result handler callbacks can be passed as
 * parameters to this function.
 */
cvUtil.loadPageWithPOST = function(tgtUrl, params, successFunc, errorFunc) {
	return cvUtil.loadPage(tgtUrl, params, successFunc, errorFunc, {
		callType : "POST"
	});
};

/**
 * Use this function to make a asynchronous GET call. The result handler callbacks can be passed as parameters
 * to this function.
 */
cvUtil.loadPageWithGET = function(tgtUrl, params, successFunc, errorFunc) {
	console.debug("Loading with get: " + tgtUrl); // !!!

	return cvUtil.loadPage(tgtUrl, params, successFunc, errorFunc, {
		callType : "GET"
	});
};

/**
 * Use this function to make a asynchronous call with specified options. The result handler callbacks can be
 * passed as parameters to this function.
 */
cvUtil.loadPage = function(tgtUrl, params, successFunc, errorFunc, options) {
	if (typeof errorFunc === 'undefined' || errorFunc === null) {
		errorFunc = cvUtil.handleError;
	}
	var callType = "POST";
	var timeout = cvUtil.DEFAULT_TIMEOUT;
	var contentType = "application/x-www-form-urlencoded; charset=UTF-8";
	var async = true;
	var addCsrf = true;
	var additionalParams = cvUtil.getAdditionalParams();
	var headers = {};

	var anyExtraOptionsPresent = function() {
		return !(typeof options === 'undefined' || options === null);
	}
	if (anyExtraOptionsPresent()) {
		if ("callType" in options) {
			callType = options.callType;
		}
		if ("timeout" in options) {
			timeout = options.timeout;
		}
		if ("contentType" in options) {
			contentType = options.contentType;
		}
		if ("async" in options) {
			async = options.async;
		}
		if ("addCsrf" in options) {
			addCsrf = options.addCsrf;
		}
		if("headers" in options) {
			headers = options.headers;
		}
	}

	if (additionalParams) {
		params = params || {};
		$.each(additionalParams, function(index, param) {
			params[param.key] = param.value;
		});
	}

	var ajaxSettings = {
		url : tgtUrl,
		type : callType,
		success : successFunc,
		error : function(xhr, ajaxOptions, thrownError) {
			if (xhr.status == 401) {
				cvUtil.getTopWindow().location.href = cvUtil.getTopWindow().location.origin + cvUtil.CONTEXT_PATH +
						"/login/?relogin";
			} else if (!xhr.statusText || xhr.statusText != "abort") {
				errorFunc(xhr, ajaxOptions, thrownError);
			}
		},
		data : params,
		timeout : timeout,
		cache : false,
		contentType : contentType,
		async : async,
		addCsrf : addCsrf,
		headers : headers
	};

	if (anyExtraOptionsPresent() && typeof options.complete === 'function') {
		ajaxSettings.complete = options.complete;
	}

	if (anyExtraOptionsPresent() && options.traditional) {
		ajaxSettings.traditional = options.traditional;
	}

	if (anyExtraOptionsPresent() && options.dataType) {
		ajaxSettings.dataType = options.dataType;
	}

	if (cvUtil.sessionLocked === true && tgtUrl.trim().localeCompare("/webconsole/unLockSession.do") !== 0) {
		//make no requets
		cvUtil.initializeLockedDialog();
		return;
	}

	return $.ajax(ajaxSettings);
};

cvUtil.loadPageWithSessionCheck = function(tgtUrl, params, successFunc, errorFunc, options) {
	cvUtil.isSessionAlive(true, function() {
		cvUtil.loadPage(tgtUrl, params, successFunc, errorFunc, options);
	});

};

cvUtil.getAdditionalParams = function() {
	return undefined;
};

/**
 * Use this function to make a synchronous call and get the result as return value
 */
cvUtil.loadSynchronously = function(tgtUrl, params, errorFunc) {
	if (typeof errorFunc === 'undefined') {
		errorFunc = cvUtil.handleError;
	}
	if (typeof params === 'undefined') {
		params = null;
	}
	var returnVal = "";
	$.ajax({
		url : tgtUrl,
		type : "POST",
		success : function(data) {
			returnVal = data;
		},
		error : errorFunc,
		data : params,
		contentType : "application/x-www-form-urlencoded; charset=UTF-8",
		async : false,
		addCsrf : true
	});
	return returnVal;
};

/**
 * Use this function to get query string parameters as an associative array. This method will take url as an
 * optional parameter or use the current query string based on the application context (works for both
 * webconsole and adminconsole).
 */
cvUtil.getUrlParams = function(url) {
	var urlParams = {};
	var tempUrl = url || window.location.search.substring(1);
	if(!url && cvUtil.CONTEXT_PATH === '/adminconsole'){
		tempUrl = window.location.hash.substring(window.location.hash.indexOf('?')+1);
	}
	var e, a = /\+/g, // Regex for replacing addition symbol with a space
	r = /([^&=]+)=?([^&]*)/g, d = function(s) {
		return decodeURIComponent(s.replace(a, " "));
	}, q = tempUrl;

	while (e = r.exec(q)) {
		urlParams[d(e[1])] = d(e[2]);
	}

	return urlParams;
};

/**
 * Use this function to get a particular query string parameter. This method will work with parameters after
 * hash as well. You can optionally pass in a url string to extract the parameter from, or omit it to use the
 * current url. If the parameter is not found, the value in defaultValue will be returned, or an empty string
 * if defaultValue is not specified.
 *
 * The getUrlViaHistoryJs param MUST be set to true for any application that uses the History.js API,
 * otherwise history handling in Internet Explorer will not function properly.
 */
cvUtil.getParameterByName = function(name, url, defaultValue, getUrlViaHistoryJs, doNotEscape) {
	if (typeof doNotEscape === "undefined") {
		doNotEscape = true;
	}
	name = name.replace(/[\[]/, "\\\[").replace(/[\]]/, "\\\]");
	var regexS = "[\\?&]" + name + "=([^&#]*)";
	var regex = new RegExp(regexS);
	if (typeof url === "undefined" || url === null) {
		url = window.location.href;
		if (!!getUrlViaHistoryJs) {
			// Using the History.js plugin to get the current URL:
			// console.debug("URL from window.location.href=" + window.location.href);
			// console.debug("URL from history.getState().url=" + History.getState().url);
			var state = History.getState();
			if (typeof state !== 'undefined' && state !== null) {
				url = History.getState().url.replace(/&nbsp;/g, ' ');
			}
		}
	}
	var results = regex.exec(url);
	if (results === null) {
		if (typeof defaultValue !== 'undefined') {
			return defaultValue;
		} else {
			return "";
		}
	} else {
		return (doNotEscape === true) ? decodeURIComponent(results[1].replace(/\+/g, " "))
				: escape(decodeURIComponent(results[1].replace(/\+/g, " ")));
	}
};

/*
 * Convenience method that delegates to getParameterByName with getUrlViaHistoryJs==true and (optionally)
 * defaultValue params. This method MUST be used instead of cvUtil.getParameter for any application that uses
 * the History.js API, otherwise history handling in Internet Explorer will not function properly.
 */
cvUtil.getParameterViaHistory = function(name, defaultValue) {
	return cvUtil.getParameterByName(name, null, defaultValue, true);
};

/*
 * Convenience method that delegates to getParameterByName using only name and (optionally) defaultValue
 * params This method MUST NOT for any application that uses the History.js API, or history handling in
 * Internet Explorer will not function properly. use cvUtil.getParameterViaHistory instead.
 */
cvUtil.getParameter = function(name, defaultValue) {
	return cvUtil.getParameterByName(name, null, defaultValue);
};

/**
 *
 */
cvUtil.getContextPath = function() {
	if (typeof cvUtil.CONTEXT_PATH === 'undefined') {
		console
				.debug("CONTEXTPATH NOT DEFINED. PLEASE ENSURE YOU'RE NOT INCLUDING CVUTIL.JS TWICE IN YOUR CODE. FALLING BACK ON WEBCONSOLE");
		cvUtil.CONTEXT_PATH = '/webconsole';
	}
	return cvUtil.CONTEXT_PATH;
};

/**
 *
 * @returns
 */
cvUtil.getLocAfterHash = function() {
	var loc = window.location;
	return loc.hash;
};

/**
 *
 */
cvUtil.runTimerTaskAfterDelay = function(functionToCall, interval, delay) {
	return window.setTimeout(cvUtil.addTimerTask(functionToCall, interval), delay);
};

/**
 *
 */
cvUtil.runTaskAfterDelay = function(functionToCall, delay) {
	return window.setTimeout(functionToCall, delay);
};

/**
 * Start timer task
 */
cvUtil.addTimerTask = function(functionToCall, interval) {
	return window.setInterval(function() {
		return functionToCall()
	}, interval);
};

/**
 * Cancel timer task
 */
cvUtil.cancelTimerTask = function(intervalId) {
	window.clearInterval(intervalId);
};

/**
 * Cancel runTask
 *
 */
cvUtil.cancelRunningTask = function(timerId) {
	window.clearTimeout(timerId);
}

/**
 *
 * /** Use this function to get localized string
 */
cvUtil.getString = function(key, errorFunc) {
	var page = "../string.jsp?key=" + key;
	if (typeof errorFunc !== "undefined") {
		return cvUtil.loadSynchronously(page, "", errorFunc);
	} else {
		return cvUtil.loadSynchronously(page);
	}
};

/**
 * Use this function to get the sessionScope.ERROR value
 */
cvUtil.getServerErrorString = function(errorFunc) {
	var page = "retrieveServerError.do";
	if (typeof errorFunc !== "undefined") {
		return $.trim(cvUtil.loadSynchronously(page, "", errorFunc));
	} else {
		return $.trim(cvUtil.loadSynchronously(page));
	}
};

/**
 * Checks if the session is alive. If redirect is present, the user will be redirected to the login page.
 * Otherwise status if session is alive or not is returned.
 */
cvUtil.isSessionAlive = function(redirect, callback) {
	console.debug("Checking if session is alive");
	var loc = window.location.toString();
	var isLoginPage = loc.match(/login\/index.jsp$/) || loc.match(/login\/logout.jsp$/) || loc.match(/login$/) ||
			loc.match(/login\/$/);
	console.debug("Location: " + loc);
	if (isLoginPage) {
		return true;
	}

	if (!redirect) {
		console.debug("Making sync call to isSessionAlive");
		var sessionAlive = false;
		var status = cvUtil.loadSynchronously(cvUtil.getContextPath() + "/isSessionAlive.do", null, function(err) {
			console.debug("Ignoring session alive check error");
		});
		sessionAlive = status == 1;
		return sessionAlive;
	} else {
		console.debug("Making async call to isSessionAlive");
		cvUtil.loadPage(cvUtil.getContextPath() + "/isSessionAlive.do", null, function(status) {
			if (status == -1) {
				window.location = cvUtil.getContextPath() + "/login/logout.jsp";
			} else if (callback && typeof callback === 'function') {
				callback();
			}
		}, function(err) {
			console.debug("Ignoring session alive check error");
		});
	}
};

/**
 * Use this method instead of setTimeout for redirects, for better performance and rendering
 */

cvUtil.cvRedirect = function(params) {
	if(typeof params === "undefined" || params === null) {
		return;
	}

	if(typeof params.delay === "undefined" || params.delay === null || isNaN(params.delay)){params.delay = 0;}
	requestAnimationFrame(function(startTimeStamp) {
		redirectAfterDelay(startTimeStamp, params.redirectURL, params.delay);
	});
};

var redirectAfterDelay = function(startTimeStamp, redirectURL, delay) {
	requestAnimationFrame(function(currentTimeStamp) {
		if (currentTimeStamp - startTimeStamp > delay) {
			window.location.href = redirectURL;
			return;
		} else {
			redirectAfterDelay(startTimeStamp, redirectURL, delay);
		}
	});
};

/**
 *
 */
cvUtil.isEmailValid = function(email) {
	var re = /^(([^<>()[\]\\.,;:\s@\"]+(\.[^<>()[\]\\.,;:\s@\"]+)*)|(\".+\"))@((\[[0-9]{1,3}\.[0-9]{1,3}\.[0-9]{1,3}\.[0-9]{1,3}\])|(([a-zA-Z\-0-9]+\.)+[a-zA-Z]{2,}))$/;
	return re.test(email);
};

/**
 *
 * @param url
 * @returns {Boolean}
 */
cvUtil.isDestSafe = function(url) {
	return true;
};

/**
 *
 * @param task
 * @param delay
 */
cvUtil.setOneTimeCall = function(task, delay) {
	if (logging.polling) {
		console.debug("Starting req for " + task);
	}
	var url = task.relativeUrl;
	var interval = task.interval;

	if (typeof delay !== "undefined") {
		interval = delay;
	}

	var fnCallBack = function(data) {
		cvUtil.callback(task, data);
	};

	var fnLoad = function() {
		cvUtil.loadPage(cvUtil.getContextPath() + url, null, function(data) {
			fnCallBack(data);
		}, function() {
		});
	};

	if (interval < 3000) {
		// !!! Sanity check. Clean up polling code so this doesn't happen.
		console.warn("Polling interval was " + interval + " - increased to 3000");
		interval = 3000;
	}
	window.setTimeout(fnLoad, interval);
};

cvUtil.initTasksToPoll = function() {
	var loc = window.location.toString();
	var isLoginPage = loc.match(/login\/index.jsp$/) || loc.match(/login\/logout.jsp$/) || loc.match(/login$/) ||
			loc.match(/login\/$/);
	console.debug("Location: " + loc);
	if (isLoginPage) {
		return true;
	}
	if (cvUtil.taskPollInitialized) {
		return;
	}
	if (cvUtil.isParentIFrame()) {
		return;
	}
	taskPollInitialized = true;
	console.debug("Getting queued items");
	cvUtil.loadPage(cvUtil.getContextPath() + "/getQueuedTasks.do", null, function(pollStruc) {
		console.debug("Queued items rcvd");
		if(pollStruc) {
			var json = cvUtil.parseJSON(pollStruc);
			if (json !== null) {
				cvUtil.setActiveDownloadsVisible(true);
				$.each(json.listData, function(i, task) {
					cvUtil.setOneTimeCall(task, 3000);
				});
			}
		}
	}, function() {
		console.error("Error loading task queue.");
	});
};

/*
 * Initialized the notifications system. This will be called automatically when the cvUtil.toast(),
 * cvUtil.errorToast(), or cvUtil.notify() functions are used, but must be called manually if you use the
 * notify API directly (not recommended).
 */
cvUtil.initializeNotifications = function() {
	if (!cvUtil.notificationsInitialized) {
		$("#notificationContainer").notify();
		cvUtil.notificationsInitialized = true;
		console.debug("Notification system initialized");
	}
};

/**
 *
 * @param task
 * @param data
 */
cvUtil.callback = function(task, data) {
	if (logging.polling) {
		console.debug("Analyzing data from poll for " + task);
		console.debug("Data: " + data);
	}
	json = data;
	if (typeof json == 'string') {
		json = cvUtil.parseJSON(data);
	}
	if (json.data.done == true) {
		if (json.data.callbackFunction) {
			eval(json.data.callbackFunction);
		} else {
			toast(data);
		}
	} else {
		cvUtil.setOneTimeCall(task);
	}
};

cvUtil.closeNotification = function() {
	$('.notification .close').click();
};

/*
 * Subroutine of toast and toastError that displays a notification. All parameters are mandatory. If delay==0,
 * the message will persist until explicitly closed.
 */
cvUtil.notify = function(messageTemplate, messageData, delay, addToHistory, historyType, historyMessage, closeOnClick) {
	if (!cvUtil.notificationsInitialized) {
		cvUtil.initializeNotifications();
	}

	// Sanitize inputs:
	if (messageData && messageData.text) {
		messageData.text = DOMPurify.sanitize(messageData.text, {SAFE_FOR_JQUERY: true});
	}
	if (historyMessage) {
		historyMessage = DOMPurify.sanitize(historyMessage, {SAFE_FOR_JQUERY: true});
	}

	var nhid = null;
	if (addToHistory) {
		nhid = nh.addNotificationToHistory(historyType, historyMessage, false, '', messageData.data);
	}
	if (typeof closeOnClick === 'undefined' || closeOnClick === null) {
		closeOnClick = true;
	}

	var returnVal = $("#notificationContainer").notify("create", messageTemplate, messageData, {
		expires : delay,
		speed : 300,
		stack : "above",
		click : function(e, instance) {
			if (nhid !== null) {
				nh.setNotificationStatus(nhid, true);
			}
			if (closeOnClick) {
				instance.close();
			}
		}
	});

	/*
	 * We want to mark history entries read when the user clicks on the close button on a notification.
	 * However, we can't use notify's built-in close handler for this because that event gets triggered when a
	 * notification times out, not just when it clicked. So:
	 */
	$(".ui-notify-close").on("click", function(e) {
		if (nhid !== null) {
			nh.setNotificationStatus(nhid, true);
		}
	});

	return returnVal;

};

cvUtil.toast = function(message, delay, persist, addToHistory, additionalData) {
	if (typeof delay === 'undefined' || delay === null) {
		delay = 5000;
	}
	if (!!persist) {
		delay = 0;
	}
	if (typeof addToHistory === "undefined" || addToHistory === null) {
		addToHistory = true;
	}
	if (typeof historyType === "undefined") {
		historyType = null;
	}
	return cvUtil.notify("notificationTemplateInfo", {
		text : message,
		data : additionalData
	}, delay, addToHistory, nh.NOTIFICATION_INFO, message);
};

cvUtil.errorToast = function(message, delay, persist, addToHistory) {
	if (typeof message === 'undefined' || message === null) {
		return;
	}
	if (typeof delay === 'undefined' || delay === null) {
		delay = 10000;
	}
	if (!!persist) {
		delay = 0;
	}
	if (typeof addToHistory === "undefined" || addToHistory === null) {
		addToHistory = true;
	}
	if (typeof historyType === "undefined") {
		historyType = null;
	}

	// If an element with a textContent was passed in instead of a string, extract it:
	if (typeof message.textContent !== 'undefined') {
		// !!! Identify these cases, handle them in the caller, and maybe remove this block
		console.debug("Using message.textContext for errorToast: " + message.textContext);
		message = message.textContent;
	}

	return cvUtil.notify("notificationTemplateError", {
		text : message
	}, delay, addToHistory, nh.NOTIFICATION_ERROR, message);
};

cvUtil.errorWithDetailsToast = function(message, exception, moreLabel, lessLabel, delay, persist, addToHistory) {
	if (typeof moreLabel === 'undefined' || moreLabel === null) {
		moreLabel = "Show Details";
	}
	if (typeof lessLabel === 'undefined' || lessLabel === null) {
		lessLabel = "Hide Details";
	}
	if (typeof delay === 'undefined' || delay === null) {
		delay = 10000;
	}
	if (!!persist) {
		delay = 0;
	}
	if (typeof addToHistory === "undefined" || addToHistory === null) {
		addToHistory = true;
	}

	var retval = cvUtil.notify("notificationTemplateErrorWithDetails", {
		moreLabel : moreLabel, //More &gt;&gt;
		lessLabel : lessLabel, //Less &lt;&lt;
		text : message,
		exceptionText : exception
	}, delay, addToHistory, nh.NOTIFICATION_ERROR, message, false);

	$("#errorMoreLink").click(function() {
		$(this).next().slideToggle();
		if ($(this).html() == moreLabel) {
			$(this).html(lessLabel);
		} else {
			$(this).html(moreLabel);
		}
	});
	return retval;
};

cvUtil.infoToastWithDetails = function(message, exception, moreLabel, lessLabel, delay, persist, addToHistory) {
	if (typeof moreLabel === 'undefined' || moreLabel === null) {
		moreLabel = "Show Details";
	}
	if (typeof lessLabel === 'undefined' || lessLabel === null) {
		lessLabel = "Hide Details";
	}
	if (typeof delay === 'undefined' || delay === null) {
		delay = 10000;
	}
	if (!!persist) {
		delay = 0;
	}
	if (typeof addToHistory === "undefined" || addToHistory === null) {
		addToHistory = true;
	}

	var retval = cvUtil.notify("notificationTemplateInfoWithDetails", {
		moreLabel : moreLabel, //More &gt;&gt;
		lessLabel : lessLabel, //Less &lt;&lt;
		text : message,
		exceptionText : exception
	}, delay, addToHistory, nh.NOTIFICATION_ERROR, message, false);

	$("#errorMoreLink").click(function() {
		$(this).next().slideToggle();
		if ($(this).html() == moreLabel) {
			$(this).html(lessLabel);
		} else {
			$(this).html(moreLabel);
		}
	});
	return retval;
};
//modal methods
cvUtil.openDialogs = [];
cvUtil.closeListenerMap = {};
cvUtil.dialogDataMap = {};
/**
 *
 */
cvUtil.getTopModal = function() {
	if (window.location != window.parent.location) {
		return cvUtil.getTopWindow().modal;
	} else {
		return modal;
	}
};

/**
 *
 * @param target
 * @param dialogContent
 * @param closeListener
 */
cvUtil.showModal = function(target, dialogContent, closeListener, initData) {

	// Add remote CommServer details to request URL.
	cvUtil.addRemoteCSDetailsToTarget(target)

	var modalId = cvUtil.getTopModal().show(target, dialogContent, initData, closeListener);
	cvUtil.getTopWindow().cvUtil.dialogDataMap[modalId] = initData;
	cvUtil.getTopWindow().cvUtil.openDialogs.push(modalId);
	if (typeof closeListener !== "undefined" && closeListener !== null) {
		cvUtil.getTopWindow().cvUtil.closeListenerMap[modalId] = closeListener;
	}
};

/**
 *
 * @param target
 * @param dialogContent
 * @param closeListener
 */
cvUtil.setModalTitle = function(title) {
	var od = cvUtil.getTopWindow().cvUtil.openDialogs;
	if (typeof od != 'undefined' && od.length > 0) {
		var modalId = od[od.length - 1];
		cvUtil.getTopWindow().$("#ui-dialog-title-modal" + modalId).html(title);
	}
};

/**
 *
 * @returns
 */
cvUtil.getInitModalData = function() {
	var thisModalId = cvUtil.getTopWindow().cvUtil.openDialogs[cvUtil.getTopWindow().cvUtil.openDialogs.length - 1];
	return cvUtil.getTopWindow().cvUtil.dialogDataMap[thisModalId];
};

cvUtil.toByteArray = function(str) {
	if (!str) {
		return null;
	}
	var bytes = [];
	for (var i = 0; i < str.length; ++i) {
		bytes.push(str.charCodeAt(i));
	}
	return bytes;
};

cvUtil.closeModal = function(closeAndDestroy, options) {
	var lastDialog = cvUtil.getTopWindow().cvUtil.openDialogs.pop();
	var clMap = cvUtil.getTopWindow().cvUtil.closeListenerMap;
	var divRef = "modal" + lastDialog;

	dDiv = cvUtil.getTopWindow().$("div[id=modal" + lastDialog + "]").filter(".modal");
	//get contained iframe and call getData
	if (lastDialog in clMap) {
		var closeListener = clMap[lastDialog];
		holderFrame = dDiv.children("iframe");
		if (typeof holderFrame !== 'undefined' && holderFrame.length > 0 && holderFrame[0].contentWindow.getData) {
			returnData = holderFrame[0].contentWindow.getData();
			if (returnData !== null) {
				closeListener(returnData);
			} else {
				closeListener();
			}
			holderFrame.attr("src", "");
		} else {
			closeListener();
		}
		clMap[lastDialog] = null;
	}
	cvUtil.getTopWindow().$("div[id=modal-overlay" + lastDialog + "]").remove();
	if (typeof closeAndDestroy === "undefined") {
		closeAndDestroy = true;
		dDiv.dialog("option", "beforeClose", null);
	}
	if (closeAndDestroy) {
		dDiv.dialog("close");
	}
	if (options && options.usePostMessage) {
		parent.postMessage(divRef, window.location.origin);
		return;
	}
	var divToRemove = cvUtil.getTopWindow().document.getElementById(divRef);
	if (divToRemove && divToRemove.parentNode) {
		cvUtil.getTopWindow().document.body.removeChild(divToRemove.parentNode);
	}
};

/**
 *
 */
cvUtil.test = function() {
	cvUtil.loadPage(cvUtil.getContextPath() + "/server/clearMessages", null, function(data) {
		if (data == "true") {
			window.location = cvUtil.getContextPath() + "/server/clearMessages?d=true";
		}
	});
};

/**
 *
 * @returns {Boolean}
 */
cvUtil.isCaptchaValid = function() {
	var captchaVal = $("#captcha").val();
	if ($.trim(captchaVal) != "") {
		var valid = cvUtil.loadSynchronously(cvUtil.getContextPath() + "/checkCaptchaValue.do", {
			captcha : captchaVal.toUpperCase()
		});
		return valid == "true";
	}
	return false;
};

/**
 *
 */
cvUtil.doSearch = function() {
	//to be implemented by pages
	alert("Not implemented");
};

/*
 * Creates a string for a single parameter for use in a URL. The parameter's value, if any, is escaped.
 * Example: given "name" and "my value", returns "name=my%20val".
 */
cvUtil.createParamString = function(name, value) {
	if (typeof value === "undefined") {
		return name;
	} else {
		return name + "=" + encodeURIComponent(value);
	}
};

/*
 * Takes a list of parameter strings (in the form name=value; use createParamString to create properly escaped
 * parameter strings). Returns parameter string form name1=val1&name2=val2.
 */
cvUtil.createParamsString = function(params) {
	var paramStr = "";
	var first = true;
	for ( var i in params) {
		if (first) {
			first = false;
		} else {
			paramStr += "&";
		}
		paramStr += params[i];
	}
	return paramStr;
};

cvUtil.setSearchBarText = function(keywords) {
	if (typeof keywords === "undefined" || keywords === null) {
		keywords = "";
	}
	$("#pgsearch").val(keywords);
	if (keywords != "") {
		$('#pgsearch').removeClass("showSearch");
		$('#pgsearch').addClass("hideSearch");
		$('.deleteText').css('display', 'inline-block');
	} else {
		$('#pgsearch').addClass("showSearch");
		$('#pgsearch').removeClass("hideSearch");
		$('.deleteText').css('display', 'none');
	}
};

cvUtil.setSearchCheckboxes = function(showFolders, showAllIncrements) {
	if (showFolders) {
		checkCb($("#showFolders"));
	}
	if (showAllIncrements) {
		checkCb($("#showAllFileVersions"));
	}
};

/*
 * Takes a url (without params) and a list of parameter strings (in the form name=value; use createParamString
 * to create properly escaped parameter strings). Returns a url in the form url?name1=val1&name2=val2
 */
cvUtil.createUrlWithParams = function(base, params) {
	return base + "?" + cvUtil.createParamsString(params);
};

/**
 *
 * @param state
 */
cvUtil.setActiveDownloadsVisible = function(state) {
	$("#activeDownloadsOpener").css("visibility", state ? "visible" : "hidden");
};

/**
 * This function can be passed any number (>2) of arguments. The first argument being the status (true or
 * false) and the remaining selectors.
 */
cvUtil.setEnabled = function() {
	if (arguments.length < 2) {
		//doesn't help
		return;
	}
	var enabled = arguments[0];
	for (var idx = 1; idx < arguments.length; idx++) {
		var ele = $(arguments[idx]);
		if (ele.is("a")) {
			if (enabled) {
				ele.removeClass("disabledActions");
			} else {
				ele.addClass("disabledActions");
			}
		} else {
			if (enabled) {
				ele.removeAttr("disabled");
			} else {
				ele.attr("disabled", "disabled");
			}
		}
	}
};

cvUtil.writeCookie = function(name, value, expires, maxAge, path) {
	document.cookie = name + "=" + value + ";" + (window.location.protocol == "https:" ? "secure;" : "") +
			(expires ? " expires=" + expires : "") + (path ? " path=" + path : "") +
			(maxAge ? " max-age=" + maxAge : "");
};
/**
 *
 * @param name
 * @returns
 */
cvUtil.readCookie = function(name) {
	var nameEQ = name + "=";
	var ca = document.cookie.split(';');
	for (var i = 0; i < ca.length; i++) {
		var c = ca[i];
		while (c.charAt(0) == ' ') {
			c = c.substring(1, c.length);
		}
		if (c.indexOf(nameEQ) == 0) {
			return c.substring(nameEQ.length, c.length);
		}
	}
	return null;
};

/**
 * @param id
 * @param message
 */
cvUtil.mask = function(selector, message, hideLoader) {
	var loading = "";
	if (message && message !== null) {
		loading = message;
	}
	if (selector && selector !== null) {
		$(selector).mask(loading);
	} else {
		$("#content").mask(loading);
	}

	if (hideLoader === true) {
		$(".loadmask-msg div").css("background", "none");
	}
};

/**
 * @param id
 */
cvUtil.unmask = function(selector) {
	if (selector) {
		$(selector).unmask();
	} else {
		$("#content").unmask();
	}
};

//TODO - Format must come from user preferences
cvUtil.formatDate = function(date) {
	return date.toLocaleDateString();
};

//TODO - Format must come from user preferences
cvUtil.formatDateTime = function(date) {
	return date.toLocaleTimeString();
};

/**
 *
 */
cvUtil.requestToUrl = function(a1) {
	var u = [];
	for ( var x in a1) {
		if (x == 'invisible') {
			continue;
		}
		var curr = a1[x];
		var elementToPush = null;
		if (curr instanceof Array) {
			if (curr.length > 0 && curr[0] instanceof Object) {
				var objs = [];
				var index = 0;
				var len = curr.length;
				for (index = 0; index < len; index++) {
					objs.push("[" + cvUtil.parseObject(curr[index]) + "]");
				}
				elementToPush = x + "=[" + objs.join(",") + "]";
			} else {
				elementToPush = x + "=[" + encodeURI(curr.join(",")) + "]";
			}
		} else if (curr instanceof Object) {
			elementToPush = cvUtil.requestToUrl(curr);
		} else {
			elementToPush = x + "=" + encodeURI(curr);
		}
		u.push(elementToPush);
	}
	return u.join("&");
};

/**
 *
 */
cvUtil.urlToRequest = function(hash) {
	var requestString = {};
	var tokens = hash.split('&');
	$.each(tokens, function(index, token) {
		if (token.indexOf("[[") != -1) {
			cvUtil.objectArrayToRequest(token, requestString);
		} else {
			var nameValue = token.split('=');
			var key = nameValue[0];
			var value = nameValue[1];
			value = decodeURI(value);
			if (value.charAt(0) == '[') {
				requestString[key] = [];
				value = value.substring(1, value.length - 1);
				if (value.length > 0) {
					var items = value.split(',');
					$.each(items, function(index, item) {
						requestString[key].push(item);
					});
				}
			} else {
				requestString[key] = value;
			}
		}

	});
	return requestString;
	// alert(requestToUrl(requestString));
};

/**
 *
 */
cvUtil.hideModal = function() {
	var lastDialog = cvUtil.getTopWindow().cvUtil.openDialogs.pop();
	var clMap = cvUtil.getTopWindow().cvUtil.closeListenerMap;
	var divRef = "modal" + lastDialog;

	dDiv = cvUtil.getTopWindow().$("div[id=modal" + lastDialog + "]").filter(".modal");
	//get contained iframe and call getData
	if (lastDialog in clMap) {
		var closeListener = clMap[lastDialog];
		holderFrame = dDiv.children("iframe");
		if (typeof holderFrame !== 'undefined' && holderFrame.length > 0 && holderFrame[0].contentWindow.getData) {
			returnData = holderFrame[0].contentWindow.getData();
			if (returnData !== null) {
				closeListener(returnData);
			} else {
				closeListener();
			}
		} else {
			closeListener();
		}
		clMap[lastDialog] = null;
	}
	cvUtil.getTopWindow().$("div[id=modal-overlay" + lastDialog + "]").remove();
	if (typeof closeAndDestroy === "undefined") {
		closeAndDestroy = true;
		dDiv.dialog("option", "beforeClose", null);
	}
	dDiv.dialog("close");

	//Upload Specific: TO move the div from dialog to specific div
	parent.$(".uploadProgress").prepend($(parent.$(".modal-iframe")[parent.$(".modal-iframe").length - 1]).contents()
			.find(".uploadFileDiv"));
	$(parent.$(".uploadProgress").find(".uploadFileDiv")[0]).find(".uploadInProgress").show();
	parent.$(".uploadProgress").show();
};

/**
 *
 */
cvUtil.parseObject = function(obj) {
	var u = [];
	for ( var o in obj) {
		u.push(o + "=" + encodeURI(obj[o]));
	}
	return u;
};

/**
 *
 */
cvUtil.objectArrayToRequest = function(token, requestString) {
	var index = token.indexOf("=");
	var key = token.substring(0, index);
	var value = token.substring(index + 3, token.length - 1);
	value = decodeURI(value);
	requestString[key] = [];
	var elems = [];
	var len = token.length;
	while (value.indexOf("]") != -1) {
		index = value.indexOf("]");
		elems.push(value.substring(0, index));
		index += 3;
		value = value.substring(index, len - 1);
	}

	$.each(elems, function(index, elem) {
		var items = elem.split(',');
		var entity = new Object;
		$.each(items, function(index, item) {
			var nameValue = item.split('=');
			var key2 = nameValue[0];
			var value2 = nameValue[1];
			entity[key2] = value2;
		});

		requestString[key].push(entity);
	});
};

/*
 * Invoked the specified function if no ajax calls are pending. Otherwise, wait two seconds and tries again,
 * recursively.
 */
cvUtil.checkActiveCallsAndFire = function(callbackFunction) {
	if ($.active == 0) {
		console.debug("No calls pending - firing");
		callbackFunction();
	} else {
		console.debug("Calls are pending - waiting");
		cvUtil.runTaskAfterDelay(function() {
			cvUtil.checkActiveCallsAndFire(callbackFunction);
		}, 2000);
	}
};

/**
 * Returns true if an ajax error was caused by the user navigating away from the page before the ajax call was
 * done. This must be called from inside the ajax error callback.
 *
 * This function currently works by checking the response headers in xhr (an XMLHttpRequest instance), which
 * will be null or empty for an aborted ajax call. The other two params are currently unused, but should be
 * passed in just in case we change to another algorithm that depends on them later.
 *
 * WARNING: This algorithm will return a false positive if the ajax call gets no response rather than an error
 * response (e.g. if the server is down).
 */
cvUtil.isUserAborted = function(xhr, textStatus, errorThrown) {
	return !xhr.getAllResponseHeaders();
};
cvUtil.showCustomStartupMessage = function(startupMessage) {
	if (startupMessage) {
		var options = {};
		options.title = localMsg.pleaseNote;
		divText = '<p>' + startupMessage + '</p>';
		cvUtil.showInfoDialog(options, divText, function() {
			cvUtil.writeCookie("showCustomStartupMessageAcknowledged", "true", "", "", "/");
		});
	}
}
cvUtil.showInfoDialog = function(options, content, callbackFunctionOk) {
	var newDiv;
	if (content instanceof jQuery) {
		newDiv = content;
	} else {
		newDiv = $("#runtimeDialog");
		if (newDiv.length === 0) {
			newDiv = $("<div></div>", {
				'id' : 'runtimeDialog'
			});
			newDiv.appendTo("body");
		}
		if (options.sanitize) {
			// TODO: default this flag to true; need check calling code to confirm nothing will break first
			content = DOMPurify.sanitize(content);
		}
		if (options.textOnly) {
			newDiv.text(content);
		}
		else {
			newDiv.html(content);
		}
	}

	var closeDialog = function() {
		if (typeof callbackFunctionOk !== "undefined" && callbackFunctionOk !== null) {
			callbackFunctionOk();
		}
		newDiv.dialog('destroy');
	};

	var okButtonClasses = 'buttonContents okSaveClick vw-btn vw-btn-primary';

	if (options.additionalClassForOk) {
		okButtonClasses += ' ' + options.additionalClassForOk;
	}

	newDiv.dialog({
		resizable : false,
		modal : true,
		title : options.title,
		width : options.width || 400,
		dialogClass : options.dialogClass || 'warningDialog',
		open : function() {
			$(this).siblings('.ui-dialog-buttonpane').find(".okSaveClick").focus();
		},
		close : function() {
			if (typeof callbackFunctionOk !== "undefined" && callbackFunctionOk != null) {
				callbackFunctionOk();
			}
			newDiv.dialog('destroy');
		},
		buttons : {
			okLocalized : {
				text : options.okText || localMsg.ok,
				"class" : okButtonClasses,
				click : function() {
					newDiv.dialog('close');
				}
			}
		}
	});
	newDiv.show();
	return newDiv;
};

//div param can be html or jquery object
cvUtil.showWarningDialog = function(options, content, callbackFunctionYes, callbackFunctionNo, callbackFunctionCancel) {
	var newDiv;
	if (content instanceof jQuery) {
		newDiv = content;
	} else {
		newDiv = $("#runtimeDialog");
		if (newDiv.length === 0) {
			newDiv = $("<div></div>", {
				'id' : 'runtimeDialog'
			});
			newDiv.appendTo("body");
		}
		if (options.sanitize) {
			// TODO: default this flag to true; need check calling code to confirm nothing will break first
			content = DOMPurify.sanitize(content);
		}
		if (options.textOnly) {
			newDiv.text(content);
		}
		else {
			newDiv.html(content);
		}
	}

	var closeDialog = function() {
		if (typeof callbackFunctionNo !== "undefined" && callbackFunctionNo !== null) {
			callbackFunctionNo();
		}
		newDiv.dialog('destroy');
	};

	var okButtonClasses = 'buttonContents okSaveClick vw-btn vw-btn-primary';

	if (options.additionalClassForOk) {
		okButtonClasses += ' ' + options.additionalClassForOk;
	}

	var noButtonClasses = 'buttonContents dialogCancel vw-btn vw-btn-default';
	if (options.additionalClassForNo) {
		noButtonClasses += ' ' + options.additionalClassForNo;
	}

	newDiv.dialog({
		resizable : false,
		modal : true,
		title : options.title,
		width : options.width || 400,
		dialogClass : options.dialogClass || 'warningDialog',
		open : function() {
			$(this).siblings('.ui-dialog-buttonpane').find(".okSaveClick").focus();
		},
		close : function() {
			if (typeof callbackFunctionCancel !== "undefined" && callbackFunctionCancel != null) {
				callbackFunctionCancel();
			} else if (typeof callbackFunctionNo !== "undefined" && callbackFunctionNo != null) {
				callbackFunctionNo();
			}
			newDiv.dialog('destroy');
		},
		buttons : {
			noLocalized : {
				text : options.noText || localMsg.no,
				"class" : noButtonClasses,
				click : function() {
					if (typeof callbackFunctionNo !== "undefined" && callbackFunctionNo !== null) {
						callbackFunctionNo();
					}
					newDiv.dialog('close');
				}
			},
			yesLocalized : {
				text : options.yesText || localMsg.yes,
				"class" : okButtonClasses,
				click : function() {
					if (callbackFunctionYes(closeDialog)) {
						newDiv.dialog('close');
					}
				}
			}
		}
	});
	newDiv.show();
	return newDiv;
};

/**
 * cvUtil.getInternetExplorerMajorVersion()
 */
cvUtil.getInternetExplorerMajorVersion = function() {
	var result = cvUtil.getInternetExplorerMajorVersion.cached = (typeof cvUtil.getInternetExplorerMajorVersion.cached !== 'undefined') ? cvUtil.getInternetExplorerMajorVersion.cached
			: (function() {
				var v = 3, div = document.createElement('div'), all = div.getElementsByTagName('i');
				while ((div.innerHTML = '<!--[if gt IE ' + (++v) + ']><i></i><![endif]-->') && all[0]) {
				}
				return (v > 4) ? v : false;
			})();
	return result;
};

/**
 * cvUtil.isInternetExplorer()
 */
cvUtil.isInternetExplorer = function() {
	var result = cvUtil.isInternetExplorer.cached = (typeof cvUtil.isInternetExplorer.cached !== 'undefined') ? cvUtil.isInternetExplorer.cached
			: Boolean(cvUtil.getInternetExplorerMajorVersion());
	return result;
};

/**
 * cvUtil.isInternetExplorer8()
 *
 * Credit for this trick goes to Tim Down's post in this thread:
 * http://stackoverflow.com/questions/10964966/detect-ie-version-in-javascript
 */
cvUtil.isInternetExplorer8 = function() {
	if (typeof cvUtil.isInternetExplorer8.cached !== "undefined") {
		return cvUtil.isInternetExplorer8.cached;
	}

	var div = document.createElement("div");
	div.innerHTML = "<!--[if lt IE 9]><i></i><![endif]-->";
	cvUtil.isInternetExplorer8.cached = (div.getElementsByTagName("i").length == 1);
	return cvUtil.isInternetExplorer8.cached;
};

cvUtil.addCsrf = function(xhr, s) {

	// Piggy-backing the addition of remote CommServer details to request URL.
	cvUtil.addRemoteCSDetailsToSettings(s);

	var csrfParam = cvUtil.readCookie('csrf');
	var contentType = s.contentType;

	if (s.addCsrf || typeof s.addCsrf === "undefined") {
		xhr.setRequestHeader('X-CSRF-Token', csrfParam);
		xhr.setRequestHeader('csrf', csrfParam);
	}
	//https://github.com/borisyankov/DefinitelyTyped/issues/742 Jquery sets contentype to false for mulipart form data so we are skipping the set content type request header
	if (contentType != false &&
			(contentType === '' || contentType === 'text/plain; charset=UTF-8' || contentType === 'text/plain')) {
		xhr.setRequestHeader('Content-Type', 'application/x-www-form-urlencoded; charset=UTF-8');
	}else if(contentType!= false && contentType === 'text_plain'){
		xhr.setRequestHeader('Content-Type', 'text/plain');
	}
	else if (contentType != false && contentType != '') {
		xhr.setRequestHeader('Content-Type', contentType);
	}
};

cvUtil.generateUUID = function() {
	var currentTime = new Date().getTime();
	var uuid = 'xxxxxxxx-xxxx-4xxx-yxxx-xxxxxxxxxxxx'.replace(/[xy]/g, function(chr) {
		var randomNum = (currentTime + Math.random() * 16) % 16 | 0;
		currentTime = Math.floor(currentTime / 16);
		return (chr == 'x' ? randomNum : (randomNum & 0x7 | 0x8)).toString(16);
	});
	return uuid;
};

cvUtil.xTemplate = function(templatestring, data) {
	var xTemplateFunction = new Function("o", "var arr=['" +
			templatestring.replace(/[\r\t\n]/g, "").split("'").join("\\'").replace(/{%=\s*\(\s*(.+?)\s*\)\s*%}/g,
					"',($1),'").replace(/{%=\s*(.+?)\s*%}/g, "',(o.$1)?o.$1:'','") + "']; return arr.join('');");
	if (!data) {
		return xTemplateFunction;
	}
	return xTemplateFunction(data);
};

cvUtil.formatSize = function(size) {
	if (size < 1024) {
		return size + ' bytes';
	} else if (size < 1024 * 1024) {
		return (size / 1024.0).toFixed(2) + ' KB';
	} else if (size < 1024 * 1024 * 1024) {
		return (size / 1024.0 / 1024.0).toFixed(2) + ' MB';
	} else if (size < 1024 * 1024 * 1024 * 1024) {
		return (size / 1024.0 / 1024.0 / 1024.0).toFixed(2) + ' GB';
	} else {
		return (size / 1024.0 / 1024.0 / 1024.0 / 1024.0).toFixed(2) + ' TB';
	}
};

cvUtil.isKeepMeLoggedInSet = function() {
	return (cvUtil.readCookie("cvlcjs") !== null);
}

cvUtil.initializeTimoutVariables = function() {

	cvUtil.timeToShowDialog = cvUtil.getTopWindow().cvUtil.SESSION_TIMEOUT ||
			cvUtil.getTopWindow().cvUtil.DEFAULT_SESSION_TIMEOUT;

	if (cvUtil.isKeepMeLoggedInSet()) {
		cvUtil.timeToShowDialog -= 45000;
	} else {
		cvUtil.timeToShowDialog -= cvUtil.DEFAULT_SESSION_MODAL_OPEN;
	}

}

cvUtil.setSessionTimerTask = function() {

	if (cvUtil.sessionTimerTask !== null) {
		cvUtil.cancelTimerTask(cvUtil.sessionTimerTask);
	}

	if (cvUtil.isKeepMeLoggedInSet()) {
		// in case of "keep me logged in" send req early to maintain session
		cvUtil.sessionTimerTask = cvUtil.addTimerTask(function() {
			cvUtil.isSessionAlive(true);
		}, cvUtil.timeToShowDialog);
	} else {
		cvUtil.localLastUsed = Date.now() + cvUtil.timeToShowDialog;
		localforage.setItem(cvUtil.SESSION_LAST_USED, cvUtil.localLastUsed);
		if (cvUtil.getTopWindow() == window) {
			cvUtil.sessionTimerTask = cvUtil.runTaskAfterDelay(cvUtil.showKeepLoginDialog, cvUtil.timeToShowDialog);
		}
	}
};

//track session timer
cvUtil.trackLastUsedTime = function() {
	cvUtil.timerUpdatelastUsed = cvUtil.addTimerTask(function() {
		localforage.getItem(cvUtil.SESSION_LAST_USED, function(err, value) {
			if (err) {
				return;
			}
			var sessionLastUsed = parseInt(value);
			if (sessionLastUsed > cvUtil.localLastUsed) {
				//initialize the timer to open keep-login modal
				if (cvUtil.sessionTimerTask !== null) {
					cvUtil.cancelRunningTask(cvUtil.sessionTimerTask);
				}
				cvUtil.localLastUsed = sessionLastUsed;
				cvUtil.sessionTimerTask = cvUtil.runTaskAfterDelay(cvUtil.showKeepLoginDialog, cvUtil.localLastUsed -
						Date.now());
			}
		});
	}, 60000);
}

cvUtil.showKeepLoginDialog = function() {

	var curPath = window.location.pathname;
	if (curPath.match(/login\/(index|logout).jsp$/) == null && curPath.match(/login\/$/) == null) {
		//stop timer to track updated session time

		//initialize timer
		var timerModal = (cvUtil.localLastUsed + cvUtil.DEFAULT_SESSION_MODAL_OPEN - Date.now()) / 1000;
		//initiate time
		var min = Math.floor(timerModal / 60);
		var sec = Math.floor(timerModal % 60);

		//open a modal
		$("#keepLoginModal").modal("show");

		//start timer, which shows up on the keep-login modal
		var modalInterval = cvUtil.addTimerTask(function() {
			//set timer
			if (sec <= 0) {
				sec = 60;
				min--;
			}

			sec--;

			if (min >= 0 && sec >= 0) {
				$("#sessionTimer").text(min + ":" + ((sec.toString().length < 2) ? "0" + sec : sec));
			}
			/*
			 * check whether other events already happened by localStorage (or cookie) value lastUsedTime >
			 * cvUtil.localLastUsed : Yes was clicked lastUsedTime < cvUtil.localLastUsed : No was clicked
			 */
			localforage.getItem(cvUtil.SESSION_LAST_USED, function(err, value) {
				if (err) {
					return;
				}
				var lastUsedTime = parseInt(value);
				if (lastUsedTime != cvUtil.localLastUsed) {
					lastUsedTime > cvUtil.localLastUsed ? hideModal() : logout(true);
				}
			})

			//times out
			if (min < 0 || (min <= 0 && sec <= 0)) {
				logout(true);
			}

		}, 1000);

		//click event listener for keepLoginModal
		var hideModal = function() {
			if (modalInterval != null) {
				cvUtil.cancelTimerTask(modalInterval);
			}
			$("#keepLoginModal").modal("hide");
		}

		$(".keepLoginYes").click(function() {
			hideModal();
			cvUtil.isSessionAlive(true);
		});

		var logout = function(timedout){
			if (modalInterval != null) {
				cvUtil.cancelTimerTask(modalInterval);
			}
			localforage.setItem(cvUtil.SESSION_LAST_USED, cvUtil.localLastUsed - cvUtil.timeToShowDialog);
			cvUtil.cancelTimerTask(cvUtil.timerUpdatelastUsed);
			var logoutUrl = "/doLogout.do";
			if(timedout === true) {
				logoutUrl = logoutUrl + "?timedout=true";
			}
			location.href = cvUtil.getContextPath() + logoutUrl;
		};

		$(".keepLoginNo").click(function() {
			logout(false);
		});
	}

}

cvUtil.initializeLogoutTimer = function() {

	cvUtil.initializeTimoutVariables();
	cvUtil.setSessionTimerTask();
	if (cvUtil.getTopWindow() == window && !cvUtil.isKeepMeLoggedInSet()) {
		cvUtil.trackLastUsedTime();
	}
}

cvUtil.lockSession = function() {
	cvUtil.loadPageWithPOST("/webconsole/lockSession.do", null, function(result) {
		cvUtil.sessionLocked = true;
		cvUtil.initializeLockedDialog();
	});
};

cvUtil.unLockSession = function(pwd, fwdOnSuccess) {
	cvUtil.loadPageWithPOST("/webconsole/unLockSession.do", "pwd=" + pwd, function(result) {
		$(".lockedLogout, .lockedLogin, #lockedPassword").removeClass("disabled");
		$(".lockedLogin").removeClass("loading");
		if (result === "success") {
			cvUtil.sessionLocked = false;
			$("#lockedSessionModal").modal("hide");
			if (!!fwdOnSuccess) {
				window.location = cvUtil.getContextPath() + "/applications";
			}
		} else {
			$(".passError").show();
			//try again
		}
	});
}

cvUtil.initializeLockedDialog = function(fwdOnSuccess) {
	//open a modal
	$("#lockedPassword").val('');
	$("#lockedSessionModal").modal("show");
	$(".lockedLogin").click(function(e) {
		e.stopPropagation();
		$(".lockedLogout, .lockedLogin, #lockedPassword").addClass("disabled");
		$(".lockedLogin").addClass("loading");
		$("#lockedPassword").blur();
		var pwd = btoa($.trim($("#lockedPassword").val()));
		cvUtil.unLockSession(pwd, fwdOnSuccess);
	});

	$(".lockedLogout").click(function() {
		location.href = cvUtil.getContextPath() + "/doLogout.do";
	});
	$("#lockedPassword").keypress(function(e) {
		if (e.which == 13) {
			$(".lockedLogin").click();
		}
	});
}

/**
 *
 */
if (typeof document != "undefined") {
	$(document).ready(function() {
		if(cvUtil.CONTEXT_PATH !== "/adminconsole" && cvUtil.CONTEXT_PATH !== "/global"){
			// adminconsole has separate mechanism in appUtil.js
			cvUtil.initializeLogoutTimer();
		}
		cvUtil.setAutoComplete($("input[type=password]"), "off");
		window.alert = function(data) {
			cvUtil.errorToast(data);
		};

		$("#pgsearch").on("keyup", function(event) {
			if (event.keyCode === 13) {
				$('#advSearchBtn').click();
			}
		});

		$(document).on("ajaxSend", function(elm, xhr, s) {
			cvUtil.addCsrf(xhr, s);
		});

		$(document).on("submit", "form", function(e) {
			var csrfParam = cvUtil.readCookie('csrf');
			$("<input type='hidden' id='csrf' name='csrf' value='" + csrfParam + "'>").appendTo($(this));
			if ($(this).attr("enctype") == "multipart/form-data") {
				var action = $(this).attr("action") + "?csrf=" + csrfParam;
				$(this).attr("action", action);
			}
			return true;
		});
		if(cvUtil.CONTEXT_PATH === '/webconsole') {
			cvUtil.initTasksToPoll();
		}

		cvUtil.parseLocalVars();

		if(cvUtil.CONTEXT_PATH !== "/adminconsole" && cvUtil.CONTEXT_PATH !== "/global"){
			// adminconsole has separate mechanism in appUtil.js
			$(document).ajaxComplete(function(event, xhr, settings) {
				cvUtil.setSessionTimerTask();
			});
		}
	});
}

cvUtil.parseLocalVars = function() {
	window.localVars = window.localVars || {};
	$(".localVariables").each(function(i) {
		window.localVars = $.extend({}, window.localVars, JSON.parse($(this).html()));
	});
};

cvUtil.isValidWindowFileName = function(fileName) {
	var fileNameRegEx = /^(?!^(PRN|AUX|CLOCK\$|NUL|CON|COM\d|LPT\d|\..*)(\..+)?$)[^\x00-\x1f\\?*:<>\""|/]+$/i;
	if (fileName !== "undefined" && fileName !== null) {
		var tempFileName = fileName.trim();
		if (tempFileName.length > 0) {
			if (tempFileName.charAt(0) === '.' && tempFileName.indexOf(" ") > 0) {
				tempFileName = tempFileName.substring(1).trim();
			}
			return fileNameRegEx.test(tempFileName);
		}
	}
	return false;
};

cvUtil.toArray = function(list) {
	return Array.prototype.slice.call(list || [], 0);
};

cvUtil.logUserAction = function(reportname, action, exportType, message, loglevel) {
	var logLine = "Report=[" + reportname + "] ";
	if (action != undefined && action.trim() != "") {
		logLine = logLine + "Action=[" + action + "] ";
	}
	if (exportType != undefined && exportType.trim() != "") {
		logLine = logLine + "ExportType=[" + exportType + "] ";
	}
	if (message != undefined && message.trim() != "") {
		logLine += message;
	}
	var exportRequest = cvUtil.getParameter('exportType', '');
	if (!exportRequest) {
		if (loglevel != undefined && loglevel != "") {
			cvUtil.logGUIEvent(logLine, loglevel);
		} else {
			cvUtil.logGUIEvent(logLine);
		}
	}
};

cvUtil.GUIAuditReportLog = function(reportname, reportLevel) {
	var logLine = "ReportLevel=[" + reportLevel + "] Report=[" + reportname + "]";
	var exportRequest = cvUtil.getParameter('exportType', '');
	if (!exportRequest) {
		cvUtil.logGUIEvent(logLine);
	}
};

cvUtil.logToReportsUsage = function(reportname, reportLevel) {
	var logLine = reportname; //"Name: [" + reportname + "]";		//, Level: [" + reportLevel + "]
	var exportRequest = cvUtil.getParameter('exportType', '');
	if (!exportRequest) {
		cvUtil.logGUIEvent(logLine, null, 'reportsUsage');
	}
};

cvUtil.logGUIEvent = function(logLine, loglevel, logType) {
	var GUIAuditURL = cvUtil.getContextPath() + "/server/logReportMetaData.do";
	var params = {};
	params.URL = window.location.href;
	params.logLine = logLine;
	params.logType = logType;
	if (loglevel != undefined && loglevel != "") {
		params.loglevel = loglevel;
	}

	cvUtil.loadPage(GUIAuditURL, params, $.noop, function(err) {
		console.debug("Failed to log WebConsole  Event in GUI Audit Trail Log");
	});
};

/* Simple non-secure string hash function (variant of the sdbm has fn) */
cvUtil.sdbmHash = function(str) {
	var hash = 0;
	for (var i = 0; i < str.length; i++) {
		char = str.charCodeAt(i);
		hash = char + (hash << 6) + (hash << 16) - hash;
	}
	return hash;
};

cvUtil.isMobileAgent = function() {
	//StackOverFlow: http://stackoverflow.com/questions/11381673/detecting-a-mobile-browser/13819253#13819253
	var check = false;
	(function(a, b) {
		if (/(android|bb\d+|meego).+mobile|avantgo|bada\/|blackberry|blazer|compal|elaine|fennec|hiptop|iemobile|ip(hone|od)|iris|kindle|lge |maemo|midp|mmp|mobile.+firefox|netfront|opera m(ob|in)i|palm( os)?|phone|p(ixi|re)\/|plucker|pocket|psp|series(4|6)0|symbian|treo|up\.(browser|link)|vodafone|wap|windows ce|xda|xiino/i
				.test(a) ||
				/1207|6310|6590|3gso|4thp|50[1-6]i|770s|802s|a wa|abac|ac(er|oo|s\-)|ai(ko|rn)|al(av|ca|co)|amoi|an(ex|ny|yw)|aptu|ar(ch|go)|as(te|us)|attw|au(di|\-m|r |s )|avan|be(ck|ll|nq)|bi(lb|rd)|bl(ac|az)|br(e|v)w|bumb|bw\-(n|u)|c55\/|capi|ccwa|cdm\-|cell|chtm|cldc|cmd\-|co(mp|nd)|craw|da(it|ll|ng)|dbte|dc\-s|devi|dica|dmob|do(c|p)o|ds(12|\-d)|el(49|ai)|em(l2|ul)|er(ic|k0)|esl8|ez([4-7]0|os|wa|ze)|fetc|fly(\-|_)|g1 u|g560|gene|gf\-5|g\-mo|go(\.w|od)|gr(ad|un)|haie|hcit|hd\-(m|p|t)|hei\-|hi(pt|ta)|hp( i|ip)|hs\-c|ht(c(\-| |_|a|g|p|s|t)|tp)|hu(aw|tc)|i\-(20|go|ma)|i230|iac( |\-|\/)|ibro|idea|ig01|ikom|im1k|inno|ipaq|iris|ja(t|v)a|jbro|jemu|jigs|kddi|keji|kgt( |\/)|klon|kpt |kwc\-|kyo(c|k)|le(no|xi)|lg( g|\/(k|l|u)|50|54|\-[a-w])|libw|lynx|m1\-w|m3ga|m50\/|ma(te|ui|xo)|mc(01|21|ca)|m\-cr|me(rc|ri)|mi(o8|oa|ts)|mmef|mo(01|02|bi|de|do|t(\-| |o|v)|zz)|mt(50|p1|v )|mwbp|mywa|n10[0-2]|n20[2-3]|n30(0|2)|n50(0|2|5)|n7(0(0|1)|10)|ne((c|m)\-|on|tf|wf|wg|wt)|nok(6|i)|nzph|o2im|op(ti|wv)|oran|owg1|p800|pan(a|d|t)|pdxg|pg(13|\-([1-8]|c))|phil|pire|pl(ay|uc)|pn\-2|po(ck|rt|se)|prox|psio|pt\-g|qa\-a|qc(07|12|21|32|60|\-[2-7]|i\-)|qtek|r380|r600|raks|rim9|ro(ve|zo)|s55\/|sa(ge|ma|mm|ms|ny|va)|sc(01|h\-|oo|p\-)|sdk\/|se(c(\-|0|1)|47|mc|nd|ri)|sgh\-|shar|sie(\-|m)|sk\-0|sl(45|id)|sm(al|ar|b3|it|t5)|so(ft|ny)|sp(01|h\-|v\-|v )|sy(01|mb)|t2(18|50)|t6(00|10|18)|ta(gt|lk)|tcl\-|tdg\-|tel(i|m)|tim\-|t\-mo|to(pl|sh)|ts(70|m\-|m3|m5)|tx\-9|up(\.b|g1|si)|utst|v400|v750|veri|vi(rg|te)|vk(40|5[0-3]|\-v)|vm40|voda|vulc|vx(52|53|60|61|70|80|81|83|85|98)|w3c(\-| )|webc|whit|wi(g |nc|nw)|wmlb|wonu|x700|yas\-|your|zeto|zte\-/i
						.test(a.substr(0, 4))) {
			check = true
		}
	})(navigator.userAgent || navigator.vendor || window.opera);
	return check;
};

/* parseJSON util method, useful to make checks on what is passed to $.parseJSON */
cvUtil.parseJSON = function(data) {
	return JSON.parse(data || "null");
};

cvUtil.showTour = function(tour) {
	cvUtil.loadPageWithGET(cvUtil.getContextPath() + "/users/pageTours.do", null, function(tourArr) {
		tourArr = cvUtil.parseJSON(tourArr);
		$(tourArr.tourList).each(function(index, tourItem) {
			if (tourItem.page === tour.page && !tourItem.isTourDone) {
				var introguide = introJs();
				introguide.setOptions({
					'showStepNumbers' : false,
					'exitOnOverlayClick' : false,
					steps : tour.steps
				}).start();
				if (tour.oncomplete) {
					introguide.oncomplete(tour.oncomplete || null);
				}
			}
		});
	});
};

cvUtil.createAgeString = function(timestamp, localizeFn) {
	// Create an age string such as "5 minutes ago" give a time int
	var now = new Date().getTime();
	var age = Math.round((now - timestamp) / 1000);

	return cvUtil.createAgeStringFromTimeDiff(age, localizeFn);
};

cvUtil.createAgeStringFromTimeDiff = function(diff, localizeFn) {
	if (typeof diff === "undefined" || diff == null) {
		console.debug("Error while creating time String");
		return "";
	}

	var days = Math.floor(diff / (60 * 60 * 24));
	diff = diff % (60 * 60 * 24);

	var hrs = Math.floor(diff / (60 * 60));
	diff = diff % (60 * 60);

	var mins = Math.floor(diff / 60);
	diff = diff % 60;

	var secs = diff;

	return localizeFn(secs, mins, hrs, days);
};

cvUtil.localizeAgeForNotification = function(secs, mins, hrs, days) {
	if (days > 0) {
		if (days == 1) {
			return localMsg.dayAgo;
		} else {
			return localMsg.daysAgo.replace("{0}", days);
		}
	} else if (hrs > 0) {
		if (hrs == 1) {
			return localMsg.hourAgo;
		} else {
			return localMsg.hoursAgo.replace("{0}", hrs);
		}
	} else if (mins > 0) {
		if (mins == 1) {
			return localMsg.minuteAgo;
		} else {
			return localMsg.minutesAgo.replace("{0}", mins);
		}
	} else {
		return localMsg.secondsAgo.replace("{0}", secs);
	}
};

cvUtil.localizeAgeForLockedAcc = function(secs, mins, hrs, days) {
	var localizedMessage, timeNumeration;
	if (days > 0) {
		// for days, days and hrs will be shown. Example: 4 day(s) / 4 day(s) 23 hour(s)
		// it is not acceptable to show 4 days alone, when it is 4 days and few hours.
		timeNumeration = localMsg.numberDays.replace("{0}", days);
		if(hrs >0)
		{
			timeNumeration += " " + localMsg.numberHours.replace("{0}", hrs);
		}
		localizedMessage = localMsg.lockedAccount.replace("{0}", timeNumeration);
	} else if (hrs > 0) {
		//For hours, hours and minutes will be shown. Example: 4 hour(s) 59 minute(s)
		//It is not acceptable to show 4hours alone, when it is 4 hour(s) and few mintues.
		timeNumeration = localMsg.numberHours.replace("{0}", hrs);
		if(mins>0)
		{
			timeNumeration += " " + localMsg.numberMinutes.replace("{0}", mins);
		}
		localizedMessage = localMsg.lockedAccount.replace("{0}", timeNumeration);
	} else {
		if (mins < 1) {
			mins = 1;
		}
		localizedMessage =  localMsg.lockedAccount.replace("{0}", localMsg.numberMinutes.replace("{0}", mins));
	}
	return localizedMessage;
};

cvUtil.getTimeZone = function() {
	return /\((.*)\)/.exec(new Date().toString())[1];
};

cvUtil.getIANATimeZone = function(){
	const currentTimeZoneId = moment.tz.guess(true);

	const obsoleteTimeZones = {   //https://github.com/moment/moment/issues/3852
		"Asia/Calcutta": "Asia/Kolkata",
		"America/Buenos_Aires": "America/Argentina/Buenos_Aires"
	};
	
	if(currentTimeZoneId in obsoleteTimeZones)
		return obsoleteTimeZones[currentTimeZoneId];

	return currentTimeZoneId;
};

cvUtil.addRemoteCSDetailsToParams = function(params) {
	if (typeof cvUtil.ccId === "number" && cvUtil.ccId > 0) {
		params.push(cvUtil.createParamString(cvUtil.PARAM_CCID, cvUtil.ccId))
	}

	if (typeof cvUtil.ccName === "string" && cvUtil.ccName !== "") {
		params.push(cvUtil.createParamString(cvUtil.PARAM_CCNAME, cvUtil.ccName))
	}
}

cvUtil.addRemoteCSDetailsToSettings = function(settings) {
	if (typeof cvUtil.ccId === "number" && cvUtil.ccId > 0 && settings.url.indexOf(cvUtil.PARAM_CCID + "=") === -1) {
		settings.url += (settings.url.indexOf("?") === -1 ? "?" : "&") + cvUtil.PARAM_CCID + "=" + cvUtil.ccId;
	}

	if (typeof cvUtil.ccName === "string" && cvUtil.ccName !== "" &&
			settings.url.indexOf(cvUtil.PARAM_CCNAME + "=") === -1) {
		settings.url += (settings.url.indexOf("?") === -1 ? "?" : "&") + cvUtil.PARAM_CCNAME + "=" + cvUtil.ccName;
	}
};

cvUtil.addRemoteCSDetailsToTarget = function(target) {
	if (typeof cvUtil.ccId === "number" && cvUtil.ccId > 0 && target.href.indexOf(cvUtil.PARAM_CCID + "=") === -1) {
		target.href += (target.href.indexOf("?") === -1 ? "?" : "&") + cvUtil.PARAM_CCID + "=" + cvUtil.ccId;
	}

	if (typeof cvUtil.ccName === "string" && cvUtil.ccName !== "" &&
			target.href.indexOf(cvUtil.PARAM_CCNAME + "=") === -1) {
		target.href += (target.href.indexOf("?") === -1 ? "?" : "&") + cvUtil.PARAM_CCNAME + "=" + cvUtil.ccName;
	}
};

cvUtil.addRemoteCSDetailsToUrl = function(url) {
	if (typeof cvUtil.ccId === "number" && cvUtil.ccId > 0 && url.indexOf(cvUtil.PARAM_CCID + "=") === -1) {
		url += (url.indexOf("?") === -1 ? "?" : "&") + cvUtil.PARAM_CCID + "=" + cvUtil.ccId;
	}

	if (typeof cvUtil.ccName === "string" && cvUtil.ccName !== "" && url.indexOf(cvUtil.PARAM_CCNAME + "=") === -1) {
		url += (url.indexOf("?") === -1 ? "?" : "&") + cvUtil.PARAM_CCNAME + "=" + cvUtil.ccName;
	}

	return url;
};

cvUtil.cvLocalize = function(key) //can be moved to cvUtil.js with Parminder's approval  // -- Jagadeesh moved to cvutil.js for admin console integration
{
	if (typeof (localMsg) == 'undefined' || localMsg == null) {
		localMsg = {};
	}
	var result = localMsg[key];
	if (!localMsg[key]) {
		result = '???' + key + '???';
	}
	if (arguments.length > 1) {
		for (var i = 0; i < arguments.length - 1; i++) {
			result = result.replace('{' + i + '}', arguments[i + 1]);
		}
	}
	return result;
}

cvUtil.base64Decode = function(message) {
	var decodedMessage = message;
	try {
		decodedMessage = Base64.decode(message);
	} catch (e) {
		console.error(e);
	}
	return decodedMessage;
}

//this function takes Date string as an input
cvUtil.convertUnixTimeStampToDate = function(unix_timestamp, defaultVal, customPattern) {
	if (typeof (unix_timestamp) == 'undefined' || unix_timestamp == null || unix_timestamp === 0) {
		if (defaultVal) {
			return defaultVal;
		} else {
			return '';
		}
	}
	var pattern = 'MMM D, YYYY hh:mm:ss A';
	if (customPattern) {
		pattern = customPattern;
	}
	var timestamp = Date.parse(unix_timestamp);
	if (isNaN(timestamp) == false) {
		var date = new Date(timestamp);
	} else {
		return unix_timestamp;
	}
	return moment(date).format(pattern);
}


/*
 * This function takes an actual unix timestamp (e.g. seconds--*not* ms--since 1/1/1970), and uses the moment
 * library to convert it to a locale-specific date string. defaultVal: optional default string to return if
 * the timestamp is invalid. localeOverride: optional locale to use (e.g. 'en') instead of the currently
 * selected or current request's locale.
 */
cvUtil.convertUnixTimeStampToLocalizedDateString = function(unix_timestamp, defaultVal, localeOverride) {
	if (typeof unix_timestamp == 'undefined' || !unix_timestamp || isNaN(parseInt(unix_timestamp))) {
		if (defaultVal) {
			return defaultVal;
		} else {
			return '';
		}
	}
	if (typeof localeOverride === 'undefined' || !localeOverride) {
		// Use our locale cookie if no locale was already specified:
		if (typeof getCookie('locale') !== 'undefined') {
			localeOverride = getCookie('locale');
		}
	}
	var formatType = 'll LTS'; // e.g. "Apr 19, 2016 2:38:52 PM"
	if (typeof localeOverride !== 'undefined' && localeOverride) {
		// If we have a locale override specified, format using that
		return moment(new Date(unix_timestamp*1000)).locale(localeOverride).format(formatType);
	}
	else {
		// Format using moment's default (which will be the current request locale)
		return moment(new Date(unix_timestamp*1000)).format(formatType);
	}
}


cvUtil.detectIE = function detectIE() {
	var ua = window.navigator.userAgent;
	var msie = ua.indexOf('MSIE ');
	var trident = ua.indexOf('Trident/');
	var edge = ua.indexOf('Edge/');

	if (msie > 0 || trident > 0 || edge > 0) {
		return true;
	}
	// other browser
	return false;
}
cvUtil.setAutoComplete = function(element, status) {
	element.attr("autocomplete", status);
}

cvUtil.isAdminConsole = function() {
	return cvUtil.getContextPath() === '/adminconsole';
}

cvUtil.isWebConsole = function() {
	return cvUtil.getContextPath() === '/webconsole';
}

//This is to handle global CSRF handling for AJAX calls
if (typeof document != "undefined" && cvUtil.isWebConsole()) {
	$.ajaxSetup({
		beforeSend : cvUtil.addCsrf
	});
}

cvUtil.lazyLoad = function(options) {
	var _options, _response;
	_options = $.extend({
	      'cache': true
	  }, options);

	if (typeof _options.urls === 'string') {
	      _options.urls = [_options.urls];
	}

	_response = [];

	_sync = function () {
	      $.ajax({
	        url: _options.urls.shift(),
	        dataType: 'script',
	        cache: _options.cache,
	        success: function () {
	          _response.push(arguments);
	          if (_options.urls.length > 0) {
	            _sync();
	          } else if (typeof options.success === 'function') {
	            options.success($.merge([], _response));
	          }
	        }
	      });
	 };

	 _sync();
}

//This is used to post the saml response to the master commcell to perfom the login on master commcell.
cvUtil.doPostForMasterForeignCallback = function(isLogoutReq,foreignCallbackUrl, samlResponse,relayState,appKey,samlRequest,spURL) {
		if(foreignCallbackUrl){
			 var $form = $("<form>").attr("method", "post").attr("action", foreignCallbackUrl);
			 $("<input type='hidden'>").attr("name", "SAMLResponse").attr("value", samlResponse).appendTo($form);
			 $("<input type='hidden'>").attr("name", "samlAppKey").attr("value", appKey).appendTo($form);
			 $("<input type='hidden'>").attr("name", "RelayState").attr("value", relayState).appendTo($form);

			 if(isLogoutReq){
				$("<input type='hidden'>").attr("name", "SAMLRequest").attr("value", samlRequest).appendTo($form);
			 }
			 else
			 {
				 $("<input type='hidden'>").attr("name", "spURL").attr("value", spURL).appendTo($form);
			 }

			 $form.appendTo("body");
			 $form.submit();
		}
}

cvUtil.modifyUrlForComet = function(url, commcellName, parameter) {

	if (cv.isCometApp) {
		// return deadlink in case of no commcell name
		if(!commcellName)
			return 'undefinedCometURL';

		// return idp url
		if (commcellName == 'IDP') {
			url = _.get(_.find(cv.commcellUrls, 'isIdp'), parameter || 'webUrl', '') + url;
		} else {
			if (cv.commcellUrls[commcellName]) {
				url = _.get(cv.commcellUrls[commcellName], parameter || 'webUrl', '') + url;
			}
		}
	}
	return url;
}

cvUtil.redirectHttpConfig = function(commCell, ignoreComet) {
	var config = {};
	if ((cv.isCometApp || ignoreComet) && commCell) {
		config.headers = {
			_cn: commCell
		}
	}
	return config;
}

//If callBackUrl is external to commvault environment i.e. it is a foreign site then this method is called post login
	    //Here login response is posted to the foreign site. Auth token returned as part of login resp is utilized by the foreign site to make addiotional api calls to retrieve data.
	    //The foreign url should be added to cspExcludeList additional setting to allow POST request.
	    //The foreign Url should also be part of web domains list. Web domains can be configured using Command Center UI. Once added, it needs tomcat service restart.
	    cvUtil.doPostForForeignCallback = function(foreignCallbackUrl, loginData, referrerUrl) {
	        if(loginData && loginData.length > 0){
	            var $form = $("<form>").attr("method", "post").attr("action", foreignCallbackUrl);
	            $("<input type='hidden'>").attr("name", "idtoken").attr("value", loginData).appendTo($form);
	            $("<input type='hidden'>").attr("name", "referrer-url").attr("value", referrerUrl).appendTo($form);
	            $form.appendTo("body");
	            $form.submit();
	        }else{
	            console.debug("No data is available.");
	        }

			}

//Generic method to prepare form and send post request
cvUtil.doFormPost = function(destinationUrl, hash, params, target) {

    if(hash && hash.length > 0){
        destinationUrl = destinationUrl + hash;
    }

	var $form = $("<form>").attr("method", "post").attr("action", destinationUrl);
	
	if (target) {
		$form.attr("target", target);
	}

    if(params){
        for (var key in params) {
            $("<input type='hidden'>").attr("name", key).attr("value", params[key]).appendTo($form);
        }
    }

    $form.appendTo("body");
    $form.submit();
}



cvUtil.toUTF8Array = function(str) {
	var utf8 = [];
	for (var i = 0; i < str.length; i++) {
		var charcode = str.charCodeAt(i);
		if (charcode < 0x80) {
			utf8.push(charcode);
		}
		else if (charcode < 0x800) {
			utf8.push(0xc0 | (charcode >> 6),
								0x80 | (charcode & 0x3f));
		}
		else if (charcode < 0xd800 || charcode >= 0xe000) {
			utf8.push(0xe0 | (charcode >> 12),
								0x80 | ((charcode>>6) & 0x3f),
								0x80 | (charcode & 0x3f));
		}
		// surrogate pair
		else {
			i++;
			// UTF-16 encodes 0x10000-0x10FFFF by
			// subtracting 0x10000 and splitting the
			// 20 bits of 0x0-0xFFFFF into two halves
			charcode = 0x10000 + (((charcode & 0x3ff)<<10)
								| (str.charCodeAt(i) & 0x3ff));
			utf8.push(0xf0 | (charcode >>18),
								0x80 | ((charcode>>12) & 0x3f),
								0x80 | ((charcode>>6) & 0x3f),
								0x80 | (charcode & 0x3f));
		}
	}
	return utf8;
}

cvUtil.validatePassword = function(password){

	var hasError = false;

	var errorText = passwordError.errorText;
	errorText += "<ul>";

	// Validate lowercase varters
	var lowerCaseLetters = /[a-z]/g;
	if (!password.value.match(lowerCaseLetters)) {
		hasError = true;
		errorText += '<li>' + passwordError.lowercase+'</li>';
	}

	// Validate capital letters
	var upperCaseLetters = /[A-Z]/g;
	if (!password.value.match(upperCaseLetters)) {
		hasError = true;
		errorText += '<li>' + passwordError.uppercase+'</li>';
	}

	// Validate numbers
	var numbers = /[0-9]/g;
	if (!password.value.match(numbers)) {
		hasError = true;
		errorText += '<li>' + passwordError.number +'</li>';
	}

	// Validate special character
	var specialCharacter = /[!@#$%^&*()-_+=.,;:''"`~<>?/]/g;
	if (!password.value.match(specialCharacter)) {
		hasError = true;
		errorText += '<li>' + passwordError.specialCharacter +'</li>';
	}

	// Validate length
	if (password.value.length < 8) {
		hasError = true;
		errorText += '<li>' + passwordError.length+'</li>';
	}
	errorText += "<ul>";

	return hasError ? errorText : false;

}

cvUtil.doesURLcontainSensitiveParam = function(params){
	if(params){
		for(var key in params){
			if(key === "samlToken")
				return true;
		}
	}
	return false;
}

