(function() {
	var cvCommon = angular.module('cvCommon');

	cvCommon.factory('cvTreeFactory', [
			'$uibModal',
			function($modal) {

				var factory = {};

				//params = {
				//	dialogTitle : <string>,
				//	rootLevel : <obj>,
				//  isMultiSelect : <boolean>,
				//	selectedItems : <array>
				//	loadChildren : <function>,
				//	extractChildren : <function>
				//}
				factory.openCvTreeWrapperModal = function(params) {
					// open modal
					return $modal.open({
						templateUrl : appUtil.appRoot + 'common/partials/cvTreeWrapperModal.jsp',
						backdrop : 'static',
						controller : [
								'$scope',
								'$uibModalInstance',
								'cvLoc',
								'cvUtil',
								function($scope, $modalInstance, cvLoc, cvUtil) {
									$scope.cancel = function() {
										$modalInstance.dismiss('cancel');
									};

									$scope.submitSelection = function() {
										$modalInstance.close($scope.cvTreeParams.selectedItems);
									};

									$scope.cvTreeParams = params;
									// set dialog title
									$scope.title = params.dialogTitle;
								} ]
					});
				}

				return factory;
			} ]);

	//
	//  Usage:
	//
	//  	<cv-tree cvParams="cvTreeParams"></cv-tree>
	//			$scope.cvTreeParams = {
	//				treeRoot : {
	//					'label' : 'root',
	//				    'type' : "myType",
	//					'children' : [ {
	//						'label' : 'child1'
	//					}, {
	//						'label' : 'child2'
	//					} ]
	//				},
	//				selectedItems : [],
	//				loadChildren : function(entity) {
	//					return $http.get('children.do?parent='+entity.id); //must return array of children
	//				},
	//				processChildren : function(entity, children) {
	//					// typically used to customize the object received from server
	//					return children.map((c) => c.name);	// must return array of children
	//				},
	//				multiSelect : false, // optional, default false
	//				selectableTypes : [<string>], //optional, default (empty array) allow all
	//				labelField : <string>, // optional, default 'label'
	//				childrenField : <string>, // optional, default 'children',
	//				nodeTemplate : <string>, // optional
	//			};

	cvCommon.directive('cvTree', function() {
		return {
			restrict : "E",
			scope : {
				cvParams : '='
			},
			templateUrl : 'common/partials/cvtree.jsp',
			controller : [ '$scope', 'cvLoc', 'cvToaster', function($scope, cvLoc, cvToaster) {
				$scope.treeScope = $scope;
				$scope.isMultiSelect = !!$scope.cvParams.multiSelect;
				$scope.checkboxEnabled = true;

				// local variables
				var labelField = $scope.cvParams.labelField || 'label';
				var childrenField = $scope.cvParams.childrenField || 'children';

				// helper functions
				function wrapEntity(entity) {
					return {
						'entity' : entity,
						'label' : entity[labelField],
						'children' : entity[childrenField],
						'state' : entity.isLeaf ? 'leaf' : 'collapsed',
						'selectedState' : '',
						'loaded' : entity.isLeaf
					};
				}

				function wrapChildren(item) {
					item.children = item.entity.children.map(function(childItem) {
						var child = wrapEntity(childItem);
						child.parent = item;
						return child;
					});
				}

				function expand(item) {
					// load item if it is not previously loaded
					if (!item.loaded) {
						if (typeof $scope.cvParams.loadChildren === "function") {
							item.loading = true;
							item.state = 'expanded';

							$scope.cvParams.loadChildren(item.entity).then(function(children) { // if children are being loaded lazily that means we should expect a promise
								item.loading = false;

								// process children if callback is provided. The callback will also return an array
								if (typeof $scope.cvParams.processChildren === "function") {
									children = $scope.cvParams.processChildren(item.entity, children);
								}

								if (children && children.length) {
									// children exists and are loaded
									item.entity.children = children;
									wrapChildren(item);
									item.loaded = true;
								} else {
									// no children
									item.state = 'leaf';
									item.noChildren = true;
								}
							}, function(e) {
								// error callback
								item.loading = false;

								cvToaster.showErrorMessage({
									'ttl' : '10000', //10 sec
									'message' : e ? e.data : cvLoc("generic_error")
								});
							});
						} else {
							wrapChildren(item);
							item.loaded = true;
							item.state = 'expanded';
						}
					} else {
						item.state = 'expanded';
					}
				}

				function selectNode(item, isUpdateParents, isUpdateChildren) {
					// check if item is selectable
					if ($scope.cvParams.selectableTypes && $scope.cvParams.selectableTypes.length) {
						// type check is present
						if ($scope.cvParams.selectableTypes.indexOf(item.entity.type) !== -1) {
							item.selectedState = 'selected';
						}
					} else {
						// type check not present
						item.selectedState = 'selected';
					}

					if ($scope.isMultiSelect) {
						if (item.selectedState === 'selected') {
							$scope.cvParams.selectedItems.push(item);
						}
						// select all children
						if (isUpdateChildren && item.children) {
							item.children.forEach(function(child) {
								selectNode(child, false, true);
							});
						}

						// udpate partial for current item
						if (item.selectedState !== 'selected') {
							setPartial(item);
						}

						// update partial on all parents
						if (isUpdateParents) {
							var currentItem = item;
							while (currentItem.parent) {
								setPartial(currentItem.parent);
								currentItem = currentItem.parent;
							}
						}
					} else {
						if ($scope.cvParams.selectedItems.length) {
							deselectNode($scope.cvParams.selectedItems[0]);
						}
						$scope.cvParams.selectedItems.push(item);
					}
				}

				function deselectNode(item, isUpdateParents, isUpdateChildren) {
					// reset item selectedState
					item.selectedState = '';

					if ($scope.isMultiSelect) {
						var index = $scope.cvParams.selectedItems.indexOf(item);
						$scope.cvParams.selectedItems.splice(index, 1);

						//deselect all children
						if (isUpdateChildren && item.children) {
							item.children.forEach(function(child) {
								deselectNode(child, false, true);
							});
						}

						// update partial on all parents
						if (isUpdateParents) {
							var currentItem = item;
							while (currentItem.parent) {
								setPartial(currentItem.parent);
								currentItem = currentItem.parent;
							}
						}
					} else {
						$scope.cvParams.selectedItems.length = 0;
					}
				}

				function setPartial(item) {
					if (item.children) {
						var selectedChildren = 0;
						var itemState = '';
						for (var i = 0; i < item.children.length; i++) {
							var child = item.children[i];
							if (child.selectedState === 'partial') {
								// if child state is partial, irrespective of other child, item state will be partial
								itemState = 'partial';
								break;
							} else if (child.selectedState === 'selected') {
								selectedChildren++;
							}
						}
						if (!itemState && selectedChildren) {
							itemState = selectedChildren === item.children.length ? 'selected' : 'partial';
						}
						item.selectedState = itemState;
					}
				}

				$scope.toggleState = function(item) {
					if (item.state === 'expanded') {
						item.state = 'collapsed';
					} else {
						expand(item);
					}
				};

				$scope.toggleItem = function(item) {
					if ($scope.isMultiSelect) {
						if (!item.loaded) {
							$scope.toggleState(item);
							return;
						}
					} else {
						// in case of single select
						if (item.state !== 'leaf') {
							$scope.toggleState(item);
							return;
						}
					}

					// perform the required operation
					if (item.selectedState === 'selected') {
						deselectNode(item, true, true);
					} else {
						selectNode(item, true, true);
					}
				};

				// initalize root items
				if (Array.isArray($scope.cvParams.treeRoot)) {
					$scope.rootItems = $scope.cvParams.treeRoot.map(function(i) {
						return wrapEntity(i);
					});
				} else {
					$scope.rootItems = [ wrapEntity($scope.cvParams.treeRoot) ];
				}

				// if items are pre selected
				if ($scope.cvParams.selectedItems.length) {
					// select each node
					$scope.cvParams.selectedItems.forEach(function(item, selectedItemIndex, selectedItemsArray) {
						// find the item in heirarchy
						var heirarchy = [];
						var currentLevel = item;

						// create heirarchy
						while (currentLevel && currentLevel.entity) {
							heirarchy.unshift(currentLevel);
							currentLevel = currentLevel.parent;
						}

						// select the item
						var currentTreeLevel = $scope.rootItems;
						heirarchy.forEach(function(curr, idx, arr) {
							var itemMatched = false;
							if (idx === arr.length - 1) {
								// final element in heirarchy.. select this
								for ( var i in currentTreeLevel) {
									var currentItem = currentTreeLevel[i];
									if (currentItem.label === curr[labelField]) {
										selectNode(currentItem, true, true);
										itemMatched = true;
										break;
									}
								}
							} else {
								// expand this element
								for ( var i in currentTreeLevel) {
									var currentItem = currentTreeLevel[i];
									if (currentItem.label === curr[labelField]) {
										expand(currentItem);
										currentTreeLevel = currentItem.children;
										itemMatched = true;
										break;
									}
								}
							}
							if (!itemMatched) {
								// item not found.. heirarchy broken
								selectedItemsArray.splice(selectedItemIndex, 1);
							}
						});
					});
				}
			} ]
		};
	});

	cvCommon.directive('cvNode', [ '$compile', 'RecursionHelper', function($compile, RecursionHelper) {
		return {
			restrict : "AE",
			scope : {
				item : '=',
				treeScope : '='
			},
			templateUrl : 'common/partials/cvNode.jsp',
			compile : function(element) {
				// Use the compile function from the RecursionHelper,
				// And return the linking function(s) which it returns
				return RecursionHelper.compile(element, function(scope, elem, attrs) {
					// link function
					if (scope.treeScope.cvParams.nodeTemplate) {
						var itemLabelPlaceholder = elem.find('.cv-node-item-label');
						itemLabelPlaceholder.empty();
						var template = scope.treeScope.cvParams.nodeTemplate;
						itemLabelPlaceholder.append($compile(template)(scope));
					}
				});
			}
		};
	} ]);

	/**
	 * Based on http://stackoverflow.com/questions/14430655/recursion-in-angular-directives
	 * 
	 */
	cvCommon.factory('RecursionHelper', [ '$compile', function($compile) {
		return {
			/**
			 * Manually compiles the element, fixing the recursion loop.
			 * 
			 * @param element
			 * @param [link]
			 *            A post-link function, or an object with function(s) registered via pre and post
			 *            properties.
			 * @returns An object containing the linking functions.
			 */
			compile : function(element, link) {
				// Normalize the link parameter
				if (angular.isFunction(link)) {
					link = {
						post : link
					};
				}

				// Break the recursion loop by removing the contents
				var contents = element.contents().remove();
				var compiledContents;
				return {
					pre : (link && link.pre) ? link.pre : null,
					/**
					 * Compiles and re-adds the contents
					 */
					post : function(scope, element) {
						// Compile the contents
						if (!compiledContents) {
							compiledContents = $compile(contents);
						}
						// Re-add the compiled contents to the element
						compiledContents(scope, function(clone) {
							element.append(clone);
						});

						// Call the post-linking function, if any
						if (link && link.post) {
							link.post.apply(null, arguments);
						}
					}
				};
			}
		};
	} ]);

})();