(function() {
	'use strict';

	var cvEntityTypes = angular.module('cvEntityTypes', []);

	cvEntityTypes.constant('EntityTypes', {
		ALL_CLIENTS : 2,
		CLIENT_ENTITY : 3,
		APPTYPE_ENTITY : 4,
		INSTANCE_ENTITY : 5,
		BACKUPSET_ENTITY : 6,
		SUBCLIENT_ENTITY : 7,
		STORAGE_POLICIES_ENTITY : 16,
		STORAGE_POLICY_ENTITY : 17,
		ALL_CLIENT_GROUPS_ENTITY : 27,
		CLIENT_GROUP_ENTITY : 28,
		PROVIDER_ENTITY : 61,
		PLAN_ENTITY : 158,
		AGENTTYPE_ENTITY : 79
	});

	cvEntityTypes
			.service(
					'EntityTypesUtil',
					[
							'SIM_IDS',
							'CLIENT_TYPE',
							'AppTypesUtil',
							'cvLoc',
							function(SIM_IDS, CLIENT_TYPE, AppTypesUtil, cvLoc) {

								this.getEntityIdForType = function(entity, entityType) {
									if (entity) {
										if (!entityType) {
											entityType = this.getEntityType(entity);
										}

										switch (entityType) {
										case "CLIENT_GROUP_ENTITY":
											return entity.clientGroupId;
										case "CLIENT_ENTITY":
											return entity.clientId;
										case "APPTYPE_ENTITY":
											return entity.applicationId;
										case "BACKUPSET_ENTITY":
											return entity.backupsetId;
										case "INSTANCE_ENTITY":
											return entity.instanceId;
										case "SUBCLIENT_ENTITY":
											return entity.subclientId;
										case "STORAGE_POLICY_ENTITY":
											return entity.storagePolicyId;
										case "STORAGE_POLICY_COPY_ENTITY":
											return entity.copyId;
										case "LIBRARY_ENTITY":
											return entity.libraryId;
										case "MEDIAAGENT_ENTITY":
											return entity.mediaAgentId;
										case "DOWNLOAD_SET_ENTITY":
											return entity.downloadSetId;
										case "SEA_DATASOURCE_ENTITY":
											return entity.seaDataSourceId;
										case "REVIEW_SET_ENTITY":
											return entity.reviewSetId;
										case "CUSTOM_ENTITY":
											return entity.entityId;
										case "WORKFLOW_ENTITY":
											return entity.workflowId;
										case "LM_MONITORING_POLICY_ENTITY":
											return entity.policyId;
										case "TAG_ENTITY":
											return entity.tagId;
										case "CLASSIFICATION_ENTITY":
											return entity.tagId;
										case "SCHEDULE_POLICY_ENTITY":
											return entity.schedulePolicyId;
										case "PROVIDER_ENTITY":
											return entity.providerDomainId;
										case "COMMCELL_ENTITY":
											return entity.commCellId;
										case "USER_ENTITY":
											return entity.userId;
										case "USERGROUP_ENTITY":
											return entity.userGroupId;
										case "EXTERNAL_GROUP_ENTITY":
											return entity.externalGroupId;
										case "TRACKING_POLICY_ENTITY":
											return entity.trackingPolicyId;
										case "LOCATION_ENTITY":
											return entity.locationId;
										case "CONTAINER_ENTITY":
											return entity.containerId;
										case "STORAGE_POOL_ENTITY":
											return entity.storagePoolId;
										case "SHELF_ENTITY":
											return entity.shelfId;
										case "ALERT_ENTITY":
											return entity.alertId;
										case "ARRAY_ENTITY":
										case "CUSTOM_ENTITY":
										case "CONFIGURATION_POLICY_ENTITY":
										case "EXCHANGE_POLICY_ENTITY":
											return entity.entityId;
										case "SUBCLIENT_POLICY_ENTITY":
											return entity.subclientPolicyId;
										case "ROLE_ENTITY":
											return entity.roleId;
										case "KEY_MANAGEMENT_SERVER_ENTITY":
											return entity.keyProviderId;
										case "STORAGE_POLICIES_ENTITY":
											return 0;
										default:
											return entity.entityId;
										}
									}
									return 0;
								};

								this.getEntityNameForType = function(entity, entityType, useClientDisplayName,
										showNamesWithHierarchy) {
									if (entity) {
										if (!entityType) {
											entityType = this.getEntityType(entity);
										}

										switch (entityType) {
										case "CLIENT_GROUP_ENTITY":
											return entity.clientGroupName;
										case "CLIENT_ENTITY":
											if (useClientDisplayName) {
												return _.get(entity, 'displayName', entity.clientName);
											}
											return entity.clientName;
										case "APPTYPE_ENTITY":
											if (showNamesWithHierarchy) {
												return entity.clientName + " > " + entity.appName;
											}
											return entity.appName;
										case "BACKUPSET_ENTITY":
											if (showNamesWithHierarchy) {
												return entity.clientName + " > " + entity.appName + " > "
														+ entity.backupsetName;
											}
											return entity.backupsetName;
										case "INSTANCE_ENTITY":
											if (showNamesWithHierarchy) {
												return entity.clientName + " > " + entity.appName + " > "
														+ entity.instanceName;
											}
											return entity.instanceName;
										case "SUBCLIENT_ENTITY":
											if (showNamesWithHierarchy) {
												var subClientName = entity.clientName + " > " + entity.appName + " > ";
												if (!_.isEmpty(entity.instanceName)) {
													subClientName += entity.instanceName + " > ";
												}
												if (!_.isEmpty(entity.backupsetName)) {
													subClientName += entity.backupsetName + " > ";
												}
												subClientName += entity.subclientName;
												return subClientName;
											}
											return entity.subclientName;
										case "STORAGE_POLICY_ENTITY":
											return entity.storagePolicyName;
										case "STORAGE_POLICY_COPY_ENTITY":
											if (showNamesWithHierarchy) {
												return entity.storagePolicyName + " > " + entity.copyName;
											}
											return entity.copyName;
										case "LIBRARY_ENTITY":
											return entity.libraryName;
										case "MEDIAAGENT_ENTITY":
											return entity.mediaAgentName;
										case "DOWNLOAD_SET_ENTITY":
											return entity.downloadSetName;
										case "SEA_DATASOURCE_ENTITY":
											return entity.seaDataSourceName;
										case "REVIEW_SET_ENTITY":
											return entity.reviewSetName;
										case "WORKFLOW_ENTITY":
											return entity.workflowName;
										case "LM_MONITORING_POLICY_ENTITY":
											return entity.policyName;
										case "TAG_ENTITY":
											return entity.tagName;
										case "CLASSIFICATION_ENTITY":
											return entity.tagName;
										case "SCHEDULE_POLICY_ENTITY":
											return entity.schedulePolicyName;
										case "PROVIDER_ENTITY":
											return entity.providerDomainName;

										case "ALL_CLIENTS":
											return cvLoc('label.servers');
										case "ALL_CLIENT_GROUPS_ENTITY":
											return cvLoc('label.serverGroups');
										case "STORAGE_POLICIES_ENTITY":
											return cvLoc('label.storagePolicies');
										case "COMMCELL_ENTITY":
											return entity.commCellName;
										case "USER_ENTITY":
											return entity.userName;
										case "USERGROUP_ENTITY":
											return entity.userGroupName;
										case "EXTERNAL_GROUP_ENTITY":
											return entity.externalGroupName;
										case "TRACKING_POLICY_ENTITY":
											return entity.trackingPolicyName;
										case "LOCATION_ENTITY":
											return entity.locationName;
										case "CONTAINER_ENTITY":
											return entity.containerName;
										case "STORAGE_POOL_ENTITY":
											return entity.storagePoolName;
										case "SHELF_ENTITY":
											return entity.shelfName;
										case "ALERT_ENTITY":
											return entity.alertName;
										case "ARRAY_ENTITY":
										case "CUSTOM_ENTITY":
										case "CONFIGURATION_POLICY_ENTITY":
										case "EXCHANGE_POLICY_ENTITY":
											return entity.entityName;
										case "SUBCLIENT_POLICY_ENTITY":
											return entity.subclientPolicyName;
										case "ROLE_ENTITY":
											return entity.roleName;
										case "KEY_MANAGEMENT_SERVER_ENTITY":
											return entity.keyProviderName;
										default:
											return entity.entityName;
										}
									}
									return '';
								};

								this.getEntityType = function(entity) {
									if (entity) {
										if (entity.subclientId && (((entity.subclientId != 0)))) {
											return "SUBCLIENT_ENTITY";
										}

										if (entity.backupsetId && (((entity.backupsetId != 0)))) {
											return "BACKUPSET_ENTITY";
										}

										if (entity.instanceId && (((entity.instanceId != 0)))) {
											return "INSTANCE_ENTITY";
										}

										if (entity.applicationId && (((entity.applicationId != 0)))) {
											return "APPTYPE_ENTITY";
										}

										if (entity.clientId && (((entity.clientId != 0)))) {
											return "CLIENT_ENTITY";
										}

										if (entity.clientGroupId && (entity.clientGroupId != 0)) {
											return "CLIENT_GROUP_ENTITY";
										}

										if (entity.copyId && (entity.copyId != 0)) {
											return "STORAGE_POLICY_COPY_ENTITY";
										}

										if (entity.storagePolicyId && (entity.storagePolicyId != 0)) {
											return "STORAGE_POLICY_ENTITY";
										}
									}
									return "ROOT_ENTITY";
								};

								this.isNasOS = function(osId) {
									switch (osId) {
									case SIM_IDS.SIM_ID_NAS_OS:
									case SIM_IDS.SIM_ID_EMC_CELERRA_OS:
									case SIM_IDS.SIM_ID_CHAMELEON_FILER_OS:
									case SIM_IDS.SIM_ID_GENERIC_FILER_OS:
									case SIM_IDS.SIM_ID_BLUEARC_FILER_OS:
									case SIM_IDS.SIM_ID_HITACHI_ENAS_OS:
									case SIM_IDS.SIM_ID_EMC_CENTERA_OS:
										return true;
									default:
										return false;
									}
									;
								};

								this.getNasOSList = function() {
									return [
											SIM_IDS.SIM_ID_NAS_OS,
											SIM_IDS.SIM_ID_EMC_CELERRA_OS,
											SIM_IDS.SIM_ID_CHAMELEON_FILER_OS,
											SIM_IDS.SIM_ID_GENERIC_FILER_OS,
											SIM_IDS.SIM_ID_BLUEARC_FILER_OS,
											SIM_IDS.SIM_ID_HITACHI_ENAS_OS,
											SIM_IDS.SIM_ID_EMC_CENTERA_OS ]
								}

								this.isPseudoClient = function(clientInfo) {
									return ((clientInfo.pseudoClientInfo && (clientInfo.pseudoClientInfo.clientType == CLIENT_TYPE.EDGE_DRIVE_CLIENT
											|| clientInfo.pseudoClientInfo.clientType == CLIENT_TYPE.CLOUD_CONNECTOR_CLIENT
											|| clientInfo.pseudoClientInfo.clientType == CLIENT_TYPE.SHAREPOINT_FARM || (this
											.isCommCellPackageAbsent(clientInfo) && clientInfo.pseudoClientInfo.clientType == CLIENT_TYPE.VIRTUAL_SERVER_CLIENT))) || (clientInfo.clientProps && (clientInfo.clientProps.IsPseudoRAC
											|| clientInfo.clientProps.IsPseudoSAPHANA
											|| clientInfo.clientProps.isMSSQLAG
											|| clientInfo.clientProps.IsPseudoDPF
											|| clientInfo.clientProps.isPseudoDAG
											|| clientInfo.clientProps.IsExchangeOnePassClient
											|| clientInfo.clientProps.isPseudoSRM || (!clientInfo.clientProps.IsDeletedClient && this
											.isCommCellPackageAbsent(clientInfo)))));
								};

								this.isPseudoDistributedClient = function(clientInfo) {
									return (clientInfo.pseudoClientInfo && clientInfo.pseudoClientInfo.clientType == CLIENT_TYPE.DISTRIBUTED_IDA);
								};

								this.isNasClient = function(clientInfo) {
									return (clientInfo.client && clientInfo.client.osInfo && this
											.isNasOS(clientInfo.client.osInfo.osId));
								};

								this.isOpenVMSClient = function(clientInfo) {
									return (clientInfo.client && clientInfo.client.osInfo && (clientInfo.client.osInfo.osId == SIM_IDS.SIM_ID_OPENVMS_OS));
								};
								this.isGitAppClient = function(clientInfo) {
									if (!clientInfo && !clientInfo.vendorType) {
										return false;
									}
									return (clientInfo.vendorType == CLIENT_TYPE.GIT_HUB || clientInfo.vendorType == CLIENT_TYPE.AZURE_DEVOPS);
								};
								this.isCloudAppClient = function(clientInfo) {
									if (!clientInfo && !clientInfo.vendorType) {
										return false;
									}
									return clientInfo.vendorType == CLIENT_TYPE.SALESFORCE;
								};
								this.isSendLogsSupportedForPseudoClient = function(clientInfo) {
									if (this.isGitAppClient(clientInfo) || this.isCloudAppClient(clientInfo)) {
										return true;
									}
									if (AppTypesUtil.isIbmiFileSystem(clientInfo.client.osInfo.osId)
											|| AppTypesUtil.isOpenvmsFileSystem(clientInfo.client.osInfo.osId)) {
										return false;
									}
									return (this.isPseudoClient(clientInfo)
											|| this.isPseudoDistributedClient(clientInfo)
											|| this.isNasClient(clientInfo) || this.isOpenVMSClient(clientInfo));
								};

								this.isCommCellPackageAbsent = function(clientInfo) {
									return (clientInfo.clientProps && clientInfo.clientProps.isCommCellPackageAbsent);
								};

								this.isSendLogsSupportedForClient = function(clientInfo) {
									if (!this.isSendLogsSupportedForPseudoClient(clientInfo)
											&& this.isCommCellPackageAbsent(clientInfo)) {
										return false;
									}
									return true;
								};

							} ]);

})();