import { cvCommonModule } from "common/js/modules";

var cvCommon = cvCommonModule;

cvCommon.factory('dialogFactory',['cvLoc', '$uibModal', function(cvLoc,  $modal){
    var factory = {};

    

    const getData = function(header,message, confirmMsg, option, actionButtonLabel) {
        return {
            'title' : header || cvLoc('label.confirmDelete'),
            'message' : message,
            'confirmMsg' : confirmMsg || _.toUpper(cvLoc('label.delete')),
            'option' : Object.assign({useCheckbox: false, useConfirm: false}, option),
            'actionButtonLabel': actionButtonLabel || cvLoc('action.delete')
        }
    }

    const getModalSettings = function(header,message, confirmMsg, option, actionButtonLabel) {
        return {
            background: 'static',
            windowClass: 'confirm-dialog',
            templateUrl: appUtil.appRoot + 'adminConsole/partials/deleteConfirmModal.jsp',
            controllerAs : 'dcmCtrl',
            controller:'cvDeleteDialogController',
            resolve : {
                'data': function() {
                    return getData(header,message, confirmMsg, option, actionButtonLabel);
                } 
            }
        }
    }

    factory.deleteConfirmDialog = function(header, msg, confirmMsg, actionButtonLabel){
        return $modal.open(getModalSettings(header, msg, confirmMsg, {useConfirm: true}, actionButtonLabel));
    };

    factory.deleteDialogwithOneOption = function(header, msg, checkLabel) {
        return $modal.open(getModalSettings(header,msg,undefined, {useCheckbox: true, 'checkLabel':checkLabel}));
    }
    return factory;
}]);

cvCommon.controller('cvDeleteDialogController',['$uibModalInstance','cvLoc', 'cvUtil','data',function($uibModalInstance, cvLoc, cvUtil, data){
    var self = this;
    self.title = data.title;
    self.msg= data.message;
    self.confirmMsg = data.confirmMsg;
    self.actionButtonLabel =  data.actionButtonLabel;
    self.option = angular.copy(data.option);
    if(self.option.useConfirm) {
        self.userConfirm = "";
    }
    
    if(self.option.useCheckbox) {
        self.checkLabel = self.option.checkLabel;
        self.optionCheck = false;
    }

    self.save = function() {
        self.errorMsg = cvUtil.emptyMsg();
        let validate = self.option.useConfirm ? self.userConfirm === self.confirmMsg : true;

        if(validate) {
            $uibModalInstance.close(self.optionCheck);
        }else {
            self.errorMsg = cvUtil.errMsg(cvLoc('error.deleteConfirm'));
        }
        
    }

    self.close = function() {
        $uibModalInstance.dismiss('cancel');
    }

}]);