export default class ContextMenu {
	constructor(element, options) {
		this.element = element;
		this.options = options;
		this.options.showOn = options.showOn || 'click';
	}

	build() {
		const self = this;
		this.element.kendoContextMenu({
			target: self.options.target,
			dataSource: self.options.actionMenu.map(menu => ({
				text: `<span id="${menu.id}" data-method="${menu.value}">${menu.label}</span>`,
				encoded: false
			})),
			alignToAnchor: true,
			showOn: self.options.showOn,
			select: function(event) {
				const method = $(event.item)
					.find('[data-method]')
					.data('method');
				self.options.onContextMenuSelect(method);
			}
		});
	}

	destroy() {
		//Safely datach all events for context menu
		this.element.data('kendoContextMenu').destroy();
	}
}
