import ColumnFilter from '../newGrid/columnFilter';

export default class AutoComplete extends ColumnFilter {
	get textInput() {
		return this.isBuilt() ? this.autoComplete.element : null;
	}

	get wrapper() {
		return this.isBuilt() ? this.autoComplete.wrapper : null;
	}

	initialize(options) {
		super.initialize(options);
		this.separator = options.separator;
		this.placeholder = options.placeHolder;
		this.filter = options.autocompleteFilter;
		this.minLength = options.autocompleteMinLength;
		this.height = options.height;
	}

	build(element, initialFilterData) {
		super.build(element);
		element.kendoAutoComplete({
			filter: this.filter,
			placeholder: this.placeholder,
			minLength: this.minLength,
			separator: this.separator,
			dataSource: this.dataSrc,
			change: this.onFilterInputChange.bind(this),
		});
		this.autoComplete = element.getKendoAutoComplete();

		// Update the tooltip on input:
		const onTextInputChange = _.debounce(this.refreshInputTooltip.bind(this), 150);
		this.textInput.on('input', onTextInputChange);
		this.textInput.on('change', onTextInputChange);
	}

	setInputValue(val) {
		if (this.isBuilt()) {
			this.autoComplete.value(val);
			this.refreshInputTooltip();
		}
	}

	getInputValue() {
		if (this.isBuilt()) {
			return this.autoComplete.value();
		}
		return null;
	}

	destroy() {
		super.destroy();
		if (this.isBuilt()) {
			this.autoComplete.destroy();
		}
	}
}
