var appUtil = appUtil || {};
appUtil.thirdPartyMods = [
		'ngRoute',
		'chieffancypants.loadingBar',
		'ui.bootstrap',
		'ui.bootstrap.datetimepicker',
		'angularAwesomeSlider',
		'ui.router',
		'highcharts-ng',
		'dialogs',
		'ui.grid',
		'ui.grid.treeView',
		'ui.grid.pagination',
		'ui.grid.selection',
		'ui.grid.autoResize',
		'ui.grid.resizeColumns',
		'ui.grid.moveColumns',
		'ui.grid.infiniteScroll',
		'ui.grid.saveState',
		'ui.grid.importer',
		'ui.ace',
		'ngSanitize',
		'cfp.hotkeys',
		'ivh.treeview',
		'isteven-multi-select',
		'AdalAngular',
		window.angularDragula(angular) ];

appUtil.commonMods = [
		'ngAnimate',
		'cvModule.server',
		'cvModule.schedule',
		'common.storage',
		'common.userPreference',
		'common.storagePolicy',
		'cvModule.alerts',
		'cvModule.navigation',
		'cvModule.settings',
		'cvModule.network',
		'cvModule.snapArray',
		'webScaleApp.storagePool',
		'cvCommon',
		'common.tour',
		'reports',
		'cvAppTypes',
		'surveyApp',
		'cvEntityTypes' ];

/*
 * In case any extra modules are needed in debug mode, you can add them here.
 */
if (cvConfig.debugMode) {
	appUtil.commonMods.push('common.globalParams');
	appUtil.commonMods.push('acApp.components');
}

appUtil.getAllDeps = function(appDeps) {
	return [].concat(appDeps, appUtil.commonMods, appUtil.thirdPartyMods);

};

/**
 * Holds all the ajax requests made by the app for use of cancelling in the future
 */
appUtil.requests = [];

/**
 * This function will return empty string if param is not found
 */
appUtil.getParameterByName = function(name, url) {
	if (!url) {
		url = window.location.href;
	}
	name = name.replace(/[\[\]]/g, "\\$&");
	var regex = new RegExp("[?&]" + name + "(=([^&#]*)|&|#|$)"), results = regex.exec(url);
	if (!results) {
		return '';
	}
	if (!results[2]) {
		return '';
	}
	return decodeURIComponent(results[2].replace(/\+/g, " "));
};

appUtil.addMultiCcParam = function(params) {
	angular.forEach([ '_cid', '_cn' ], function(name) {
		if (!params.hasOwnProperty(name)) {
			var mCcParam = appUtil.getParameterByName(name);
			if (mCcParam !== '') {
				params[name] = mCcParam;
			}
		}
	});
};

appUtil.logLoc = function(loc) {
	var log = localStorage.getItem('audit');
	if (log !== null && log !== '') {
		log = JSON.parse(log);
	} else {
		log = [];
	}
	log.push({
		page : loc,
		user : System.loggedInUserName
	});
	var logStr = JSON.stringify(log);
	if (log.length >= 3) {
		cvUtil.loadPageWithPOST('/adminconsole/auditLog.do', {
			log : logStr
		});
		logStr = '';
	}
	localStorage.setItem('audit', logStr);
};

appUtil.setupApp = function(app) {
	app.config(['$sanitizeProvider', function($sanitizeProvider) {
		$sanitizeProvider.enableSvg(true);
	}])
	app
			.config([
					'adalAuthenticationServiceProvider',
					function(adalAuthenticationServiceProvider) {
						adalAuthenticationServiceProvider
								.init({
									clientId : angular.isObject(cv.additionalSettings)
											&& angular.isObject(cv.additionalSettings.AdminConsole)
											&& angular.isString(cv.additionalSettings.AdminConsole.azureAppId) ? cv.additionalSettings.AdminConsole.azureAppId
											: 'no-key', // For some reason, you can't put NULL or an empty string here. It crashes Admin Console
									popUp : true,
									cacheLocation : 'localStorage'
								});
					} ]);

	app.config([ 'cfpLoadingBarProvider', function(cfpLoadingBarProvider) {
		cfpLoadingBarProvider.includeSpinner = false;
	} ]);

	app.config([ '$provide', function($provide) {
		$provide.decorator('$state', [ '$delegate', function($delegate) {
			var state = $delegate;
				state.baseGo = state.go;

				var go = function(to, params, options) {
						options = options || {};
						params = params || {};
						appUtil.addMultiCcParam(params);
						this.baseGo(to, params, options);
				};
				state.go = go;
			return $delegate;
		} ]);
		
		$provide.decorator('$http', [ '$delegate', function($delegate) {
			var wrapper = function(verb) {
				var promise = verb;
				promise.success = function(fn) {
					promise.then(function(response) {
						fn(response.data, response.status, response.headers);
					});
					return promise;
				};

				promise.error = function(fn) {
					promise.then(null, function(response) {
						if(response.xhrStatus !== "abort"){
							fn(response.data, response.status, response.headers);
						}
					});
					return promise;
				};
				return promise;
			};

			//used for $http(config);
			function HTTP(config) {
				if (config) {
					return wrapper($delegate(config));
				}
			};
			//used for $http get/post/put/delete function
			var httpShortCuts = {
					defaults: $delegate.defaults,
		            get: function (url, data) {
		                return wrapper($delegate.get(url, data));
		            },
		            post: function (url, data, config) {
		                return wrapper($delegate.post(url, data, config));
		            },
		            put: function (url, data, config) {
		                return wrapper($delegate.put(url, data, config));
		            },
		            delete: function (url, data) {
		                return wrapper($delegate.delete(url, data));
		            },
		            pendingRequests: $delegate.pendingRequests
		        }
			Object.assign(HTTP, httpShortCuts);
			return HTTP;
		} ]);
	} ]);

	app.config([ '$compileProvider', function($compileProvider) {
		$compileProvider.strictComponentBindingsEnabled(false)
		//TODO: Enable this after image upload has been fixed by Suraj
		//		$compileProvider.debugInfoEnabled(cvConfig.debugMode && cvConfig.debugMode === true);
	} ]);

	app.config([ 'ivhTreeviewOptionsProvider', function(ivhTreeviewOptionsProvider) {
		ivhTreeviewOptionsProvider.set({
			idAttribute : 'id',
			labelAttribute : 'label',
			childrenAttribute : 'children',
			selectedAttribute : 'selected',
			useCheckboxes : true,
			expandToDepth : 0,
			indeterminateAttribute : '__ivhTreeviewIndeterminate',
			expandedAttribute : '__ivhTreeviewExpanded',
			defaultSelectedState : true,
			validate : true,
			twistieCollapsedTpl : '<span class="glyphicon glyphicon-chevron-right"></span>',
			twistieExpandedTpl : '<span class="glyphicon glyphicon-chevron-down"></span>',
			twistieLeafTpl : '&#9679;'
		});
	} ]);

	app.config([ '$provide', function($provide) {
		$provide.decorator('$state', [ '$delegate', '$stateParams', function($delegate, $stateParams) {
			$delegate.forceReload = function() {
					return $delegate.go($delegate.current, $stateParams, {
					reload : true,
					inherit : false,
					notify : true
				});
			};
			return $delegate;
		} ]);

		$provide.decorator("$exceptionHandler", [ '$delegate', function($delegate) {
			return function(exception, cause) {
				if (typeof globalErrorHandler !== 'undefined' && globalErrorHandler) {
					globalErrorHandler.captureException(exception);
				}
				$delegate(exception, cause);
			};
		} ]);
	} ]);

	var appStudioNamespace = "/appstudio";

	app.run([
			'$http',
			'$rootScope',
			'$templateCache',
			'$uibModalStack',
			'SharedData',
			'cvUtil',
			'$location',
			'customAPIHeaderFactory',
			function($http, $rootScope, $templateCache, $modalStack, SharedData, cvUtil, $location,
					customAPIHeaderFactory) {
				$http.defaults.headers.common["X-Requested-With"] = 'XMLHttpRequest';
				
				$http.get("prewarmClients.do");
				// Needed for Angular 2 routing to work with Angular 1 routing
				$rootScope.$on("$locationChangeSuccess", function(evt, url) {
					var intoAppStudio = url.includes(appStudioNamespace);

					if (intoAppStudio) {
						$rootScope['appStudioRedirectLock'] = $rootScope['appStudioRedirectLock'] !== undefined;
					} else {
						$rootScope['appStudioRedirectLock'] = undefined;
					}
					var top = $modalStack.getTop();
					if (top) {
						$modalStack.dismiss(top.key);
						event.preventDefault();
					}
				});

				$rootScope.$on('$routeChangeStart', function(event, next, current) {
					if (typeof current !== 'undefined') {
						$templateCache.remove(current.templateUrl);
					}
				});
				
				$rootScope.$on('$locationChangeSuccess', function(event, next, current) {
					let str = window.location.hash;
					cv.customParams = [];
					str.indexOf('?')>=0 ?  str = str.substring(str.indexOf('?') + 1) : str="";
					if(str) {
						str = str.split('&');
						cv.customParams = str.map(function(item){return item.split('=')});
					} else {
						cv.customParams.length = 0;
					}
				});

				$rootScope.$on('$locationChangeStart', function(event, next) {
					if (SharedData.oldCsrfCookie != '' && SharedData.oldCsrfCookie !== cvUtil.readCookie('csrf')) {
						location.href = "redirect.do?page=" + encodeURIComponent(next);
					}

					SharedData.targetUrl = next;
					var loc = next;
					if (loc.indexOf('#') < 0) {
						loc = next;
					} else {
						loc = next.substr(next.indexOf('#') + 1);
					}
					appUtil.logLoc(loc);

					customAPIHeaderFactory.clear();
				});

			} ]);

	var cvHttpInterceptorDefaults = {
		headers: {
			get: {
				'If-Modified-Since': '0'
			},
			post: {
				'Content-Type': 'application/x-www-form-urlencoded;charset=utf-8'
			}
		},
		transformRequest: [function(data) {
			/**
			 * The workhorse; converts an object to x-www-form-urlencoded serialization.
			 * 
			 * @param {Object}
			 *            obj
			 * @return {String}
			 */
			var param = function(obj) {
				var query = '';
				var name, value, fullSubName, subName, subValue, innerObj, i;

				for (name in obj) {
					value = obj[name];

					if (value instanceof Array) {
						for (i = 0; i < value.length; ++i) {
							subValue = value[i];
							fullSubName = name + '[' + i + ']';
							innerObj = {};
							innerObj[fullSubName] = subValue;
							query += param(innerObj) + '&';
						}
					} else if (value instanceof Object) {
						for (subName in value) {
							subValue = value[subName];
							fullSubName = name + '[' + subName + ']';
							innerObj = {};
							innerObj[fullSubName] = subValue;
							query += param(innerObj) + '&';
						}
					} else if (value !== undefined && value !== null) {
						query += encodeURIComponent(name) + '=' + encodeURIComponent(value) + '&';
					}
				}

				return query.length ? query.substr(0, query.length - 1) : query;
			};

			return angular.isObject(data) && String(data) !== '[object File]' ? param(data) : data;
		}]
	};

	app.factory('cvHttpInterceptorFactory', [
		'$q',
		'$location',
		'cvUtil',
		'ajaxButtonFactory',
		'SharedData',
		'cvMultiCommcell',
		'urlExceptionsFactory',
		'$injector',
		'customAPIHeaderFactory',
		'PayloadFactory',
		'DASHBOARD_LINKS',
		'hideToaster',
		'cvLoc',
		'cvToaster',
		'multiCommcell',
		function($q, $location, cvUtil, ajaxButtonFactory, SharedData,
			cvMultiCommcell, urlExceptionsFactory, $injector,
			customAPIHeaderFactory,PayloadFactory, DASHBOARD_LINKS,hideToaster, cvLoc, cvToaster, multiCommcell) {

			var enableAjaxBtn = function() {
				if (ajaxButtonFactory.currentButton) {
					ajaxButtonFactory.currentButton = null;
				}

				angular.element('.cvDisabledOnAjax').removeClass('cvDisabledOnAjax');
				ajaxButtonFactory.isRequestOngoing = false;
			};

			// Adding this check as we want to display a message in brave browser when the site is opened with a unsecure connection and hangs
			var alertForBrowser = false;
			var checkBrowserErrorStatus = function(resp) {
				if(resp.status ===-1 && resp.xhrStatus === "error" && resp.statusText==="" && resp.data===null) {
					if(window.Brave && navigator.brave && navigator.brave.isBrave){
						navigator.brave.isBrave().then(function(r){
							if(r) {
								document.getElementById('unsupportedBrowserMessage').style.display = "block";
								if(!alertForBrowser) {
									cvToaster.showErrorMessage({
										ttl: '10000', //10 sec
										message: cvLoc('error.unsupportedBrowser')
									});
									alertForBrowser = true;
								}
							}
						});
					}
				}
			}

			var replaceObjVals = function(obj, fld, replacement) {
				if (obj === null || angular.isUndefined(obj) || typeof obj !== 'object') {
					return false;
				}
				var keys = Object.keys(obj);
				var anyRepMade = false;
				keys
						.forEach(function(key) {
							var val = obj[key];
							if (typeof val === 'object') {
								var repMade = replaceObjVals(val, fld, replacement);
								anyRepMade = anyRepMade || repMade;
							} else {
								if (val == fld.val
										&& (key === fld.id || key === fld.name || key === fld.model)) {
									obj[key] = replacement;
									anyRepMade = true;
								} else if (typeof val === 'string'
										&& val.indexOf(fld.val) > -1) {
									try {
										var valObj = JSON.parse(val);
										var repMade = replaceObjVals(
												valObj,
												fld,
												replacement);
										obj[key] = JSON.stringify(valObj);
										anyRepMade = anyRepMade || repMade;
									} catch (e) {
										//ignore
									}
								}
							}
						});
				return anyRepMade;
			};

			var addCommcellNameToUrls = function() {

				angular.element(".site-wrap a[href='']").each(function(idx, a) {

				});

				angular
						.element(".site-wrap a")
						.each(
								function(idx, a) {
									var href = a.href;
									var clz = a.attributes["class"] ? a.attributes["class"].value
											: '';
									//ignore first breadcrumb

									// For any link which is empty include the URL to that link so when user clicks open in new tab same page is opened
									// Reverting for MR 200678
									// if(a.hash==="") {
									// 	a.href=window.location.href;
									// }
									//If only one commcell is selected we have to update the breadCrumbs as well

									if (clz.indexOf("bc-item_0") > -1) {
										if (!cvUtil
												.objectContainsNestedProperty(
														"cv.additionalSettings.AdminConsole.multiCommCellAware",
														cv)
												|| (cvUtil
														.objectContainsNestedProperty(
																"cv.additionalSettings.AdminConsole.multiCommCellAware",
																cv)
														&& cv.additionalSettings.AdminConsole.multiCommCellAware && cvMultiCommcell
														.getselectedCClength() > 1)) {
											return;
										}
									}
									if (href === ''
											|| href === '#'
											|| appUtil.getParameterByName("_cid", href) !== ''
											|| appUtil.getParameterByName("_cn", href) != '') {
										return;
									}
									if (href.indexOf('#') < 0) {
										return;
									}
									var append = href.indexOf("?") > -1 ? "&" : "?";

									if (appUtil.getParameterByName("_cn") !== '') {
										a.href += append + "_cn="
												+ appUtil.getParameterByName("_cn");
									}

									if (appUtil.getParameterByName("_cid") !== '') {
										a.href += append + append + "_cid="
												+ appUtil.getParameterByName("_cid");
									}
								});
			};

			return {
				defaults: cvHttpInterceptorDefaults,
				interceptors: {
					'response' : function(response) {
						enableAjaxBtn();
						window.setTimeout(addCommcellNameToUrls, 5000);
						SharedData.oldCsrfCookie = cvUtil.readCookie('csrf');
						if (response.config.url
								.indexOf('report.do?name=dashboard&app=ADMIN_CONSOLE') > 0) {
							var $template = angular.element('<div/>').append(response.data);
							if ($location.path() === DASHBOARD_LINKS.OVERVIEW) {
								$template.find('h1.page-title').text('All Dashboards');
								response.data = $template.html();
							}
						}
	
						if (response.config.url
								.includes("/proxy/cr/reportsplusengine/datasets")
								&& response.config.headers.convertCreResponse) {
							response.data = CreConverter(
									response.data,
									response.config.creResponse || {});
						}
						app.startLogoutTimer();
						//if header has save script set to true, fire event to return response as a json
						var customAPIHeaders = customAPIHeaderFactory.get();
						//if header has save script set to true, fire event to return response as a json
						var customAPIHeaders = customAPIHeaderFactory.get();
						if (customAPIHeaders.ReturnReqPayloadAsResp && response.data.url) {
							PayloadFactory.showPayloadInModal(response.data);
							response.data = '';
							//set it to blank to avoid displaying any error message
							return $q.reject(response);
						}
						// Process response headers and handle multicommcell errors
						multiCommcell.processHeader(response);
						return response;
					},
					'responseError' : function(response) {
						checkBrowserErrorStatus(response);
						if (response.status && response.status > 0) {
							var error = new Error("HTTP Response error " + response.status);
							if (globalErrorHandler) {
								globalErrorHandler.captureException(error);
							}
						}
						//if header has save script set to true, fire event to return response as a json
						var customAPIHeaders = customAPIHeaderFactory.get();
						if (customAPIHeaders.ReturnReqPayloadAsResp) {
							PayloadFactory.showPayloadInModal(response.data);
							response.data = '';
							//set it to blank to avoid displaying any error message
							return $q.reject(response);
						}
						enableAjaxBtn();
						if (response.status === 401) {
							response.data = {
								status : false,
								description : 'Authentication required!'
							};
							cvUtil.writeCookie(
									"csrf",
									"",
									"Thu, 01 Jan 1970 00:00:01 GMT",
									"",
									cv.contextPath);
							cvUtil.writeCookie(
									"user",
									"",
									"Thu, 01 Jan 1970 00:00:01 GMT",
									"",
									cv.contextPath);
							cvUtil.writeCookie(
									"webServer",
									"",
									"Thu, 01 Jan 1970 00:00:01 GMT",
									"",
									cv.contextPath);
							if (globalErrorHandler) {
								globalErrorHandler
										.captureException("Sending logout request due to 401 API Response. API: "
												+ response.config.url);
							}
							window.location = cv.contextPath + "/logout.do?401"
									+ window.location.hash;
							return response;
						}
	
						if(response.status === 503) {
							window.location = window.location.origin + window.location.pathname + "patching?ref=" + window.location.href;
						}

						if (response.status === 900) {
							const cvLoc = $injector.get('cvLoc');
							// When response has browse error  as locked by passkey, a modal to authorize for browse is opened where client owner enters the passkey
							if (response.data
									&& typeof response.data === 'string'
									&& response.data
											.startsWith(cvLoc('error.browsePrivacy'))) {
								const securityFactory = $injector.get('securityFactory');
								securityFactory.processBrowseError(response);
							}
						}
	
						if (response.status === 419) {
							response.data = cvLoc('label.refreshBrowser');
						}
	
						return $q.reject(response);
					},
					request : function(config) {
						const $stateParams = $injector.get('$stateParams');
						if (config.method === 'PUT' || config.method === 'POST') {
							var pwdElements = angular.element("input[type='password']");
							var pwdFlds = [];
							angular.forEach(
									pwdElements,
									function(pf, idx) {
										var ele = angular.element(pf);
										var model = ele.data("ng-model");
										if (typeof model === 'undefined') {
											model = ele.attr("ng-model");
										}
										if (typeof model !== 'undefined'
												&& model.indexOf(".") > -1) {
											model = model
													.substr(model.lastIndexOf(".") + 1);
										}
										var pv = ele.val();
										if (pv !== '') {
											pwdFlds.push({
												val : pv,
												id : ele.attr("id"),
												name : ele.attr("name"),
												model : model
											});
										}
									});
	
							if (pwdFlds.length > 0) {
								var replacedPwds = [];
								var postedData = JSON.stringify(config.data);
								angular.forEach(pwdFlds, function(fld) {
									var pv = fld.val;
									if (postedData && postedData.indexOf(pv) > -1) {
										var encodedPwd = Base64.encode(pv);
										var replacementsMade = false;
	
										if (typeof config.data === 'string') {
											var valObj = JSON.parse(config.data);
											replacementsMade = replaceObjVals(
													valObj,
													fld,
													encodedPwd);
											config.data = JSON.stringify(valObj);
										}
										else {
											replacementsMade = replaceObjVals(
													config.data,
													fld,
													encodedPwd);
										}
										if (replacementsMade) {
											replacedPwds.push(encodedPwd);
										}
									}
								});
								if (replacedPwds.length > 0) {
									config.headers['replaced-pwds'] = JSON
											.stringify(replacedPwds);
								}
							}
							
							//While calling POST or PUT api directly, we need to change content-type to "application/json"
							
							if((config.url).includes('proxy/') || (config.url).includes('api/')){
								if(config.headers['Content-Type'] !== "application/xml") {
									config.headers['Content-Type'] = "application/json";
								}
							}
							
						}
	
						if (!config.ignoreLoadingBar) {
							ajaxButtonFactory.isRequestOngoing = true;
							angular.element('.cvBusyOnAjax').addClass('cvDisabledOnAjax');
						}
						config.headers['ts'] = angular.element("body").data("ts");
						var cc = cvMultiCommcell.getcommCellNameforLinks();
						if (appUtil.getParameterByName("_cn") !== '' || cc !== undefined
								&& cc !== null) {
							if ($location.search().hasOwnProperty("_cn")) {
								config.headers['_cn'] = appUtil.getParameterByName("_cn");
							} else if (cc !== undefined && cc !== null) {
								config.headers['_cn'] = cc;
							}
	
						}
	
						if (appUtil.getParameterByName("_cid") !== '') {
							config.headers['_cid'] = appUtil.getParameterByName("_cid");
						}
	
						if (cv && cv.sessionContext && cv.sessionContext.operatorCompanyId) {
							config.headers['operatorCompanyId'] = cv.sessionContext.operatorCompanyId;
						}
	
						if (
							cv.gridCompanyId >= 0  &&
							config.method === 'GET' &&
							!_.isEqual(config.url, 'getUserPrefs.do') &&
							!_.includes(config.url, 'setViewAsDefault.do') &&
							(_.includes(config.url, 'proxy/') ||
								_.includes(config.url, 'api/') ||
								_.includes(config.url, '.do'))
						) {
	
							if (cv.gridCompanyId > 0) {
								config.headers.operatorCompanyId = cv.gridCompanyId;
								config.headers.OnlyGetCompanyOwnedEntities = 1;
							} else {
								//Only for mongoDb cached API calls.
								var commCellFq = '&fq=' + encodeURIComponent('companyId:eq:0');
	
								if (_.includes(config.url, '.do') && !_.isEmpty(_.get(config, 'params.url'))) {
									config.params.url += commCellFq;
								} else if (_.includes(config.url, '?')) {        //  /api or /proxy
									config.url += commCellFq;
								}
							}
	
							delete cv.gridCompanyId;
						}
						// Add header companyId so all APIs sent gets data for that company only
						if ($stateParams["companyId"] && !isNaN($stateParams["companyId"])
								&& !config.headers["companyId"] && parseInt($stateParams["companyId"]) !== 0) {
							config.headers['companyId'] = $stateParams["companyId"];
						}
	
						var csrfParam = cvUtil.readCookie('csrf');
						config.headers['csrf'] = csrfParam;
						config.headers['timeZoneInfo'] = moment().format("Z");
	
						config.headers['ref-page'] = window.location.hash;
						config.headers['ref-endpoint'] = config.url
								.indexOf(window.location.pathname) >= 0 ? config.url
								.substring(window.location.pathname.length) : config.url;
						config.headers['ref-ts'] = System.ts;
	
						var localeParam = cvUtil.readCookie('locale');
						if (localeParam) {
							config.headers['Accept-Language'] = localeParam;
						}
	
						var customAPIHeaders = customAPIHeaderFactory.get();
						if (customAPIHeaders !== '') {
							Object.keys(customAPIHeaders).forEach(function(key){
								config.headers[key] = customAPIHeaders[key];
							});
						}
	
						// Store All Requests made during route change except for the ones that are included in exceptions
						if (config.url
								&& !urlExceptionsFactory.checkUrlExceptions(config.url)) {
							/*
							 * Checking if the config object has an option to
							 * override timeout or if config.timeout is not a
							 * number (ie, its a promise) then the request is not
							 * added to appUtil.requests list. This is done so
							 * that we can cancel an http request if needed from
							 * outside appUtil.js file.
							 */
							if (!config.overrideTimeout || !isNaN(config.timeout)) {
								var cancelReq = $q.defer();
	
								config.timeout = cancelReq.promise;
								appUtil.requests.push(cancelReq);
							}
						}
						//in case of save as script, if v2 api is integrated, return data from here
						//else pull data from here
						var customAPIHeaders = customAPIHeaderFactory.get();
						if(customAPIHeaders.ReturnReqPayloadAsResp){
							//toaster should not be visible for api refrence call
							hideToaster.hide=true;
							//if its a v2 api or a get request, donot make a call to java layer for getting api reference content
							if((config.url).includes('proxy/') || (config.url).includes('api/')){
								PayloadFactory.showPayloadInModal(config);
								appUtil.requests[appUtil.requests.length - 1].resolve();
							}
						}
						return config;
					}
				},
			};
		}
	]);

	app
			.config([
					'$httpProvider',
					function($httpProvider) {

						if (!$httpProvider.defaults.headers.get) {
							$httpProvider.defaults.headers.get = {};
						}
						//disable IE ajax request caching
						$httpProvider.defaults.headers.get['If-Modified-Since'] = cvHttpInterceptorDefaults.headers.get['If-Modified-Since'];

						$httpProvider.defaults.headers.post['Content-Type'] = cvHttpInterceptorDefaults.headers.post['Content-Type'];

						// Override $http service's default transformRequest
						$httpProvider.defaults.transformRequest = cvHttpInterceptorDefaults.transformRequest;

						$httpProvider.interceptors
								.push([
										'cvHttpInterceptorFactory',
										function(cvHttpInterceptorFactory) {
											return cvHttpInterceptorFactory.interceptors;
										} ]);
					} ]);

	app.factory('Constants', function() {
		return {
			ContextPath : '/AdminConsole'
		};
	});

	app.factory('SharedData', function() {
		return {
			oldCsrfCookie : ''
		};
	});

	app.run([
			'$rootScope',
			'$state',
			'$window',
			'$timeout',
			'cvUtil',
			'cvLoc',
			'cvMultiCommcell',
			'cvNavigationFactory',
			'globalJobListener',
			'downloadJobsService',
			'SharedData',
			'$transitions',
			function($rootScope, $state, $window, $timeout, cvUtil, cvLoc, cvMultiCommcell, cvNavigationFactory,
					globalJobListener, downloadJobsService, SharedData, $transitions) {
				$rootScope.$state = $state;

				var countdown = parseInt(cvUtil.readCookie("acLogoutTimer"));

				//reducing timeout value by 20 seconds because we poll every 15 seconds so there might be a dealy when we detect timeout.
				//tomcat session times out after exact timeout value. this is to ensure that logout request is fired before tomcat session is destroyed so that session is terminated cleanly
				if (countdown == null || countdown == undefined || isNaN(countdown)) {
					countdown = 30 * 60; //default sessionTimeout value is 30 mins.
				}
				var buffer = 30; //30 second buffer
				if (countdown > buffer) {
					countdown = countdown - buffer;
				}

				app.startLogoutTimer = function() {
					if (app.logoutTimer) {
						window.clearInterval(app.logoutTimer)
					}
					var now = Date.parse(new Date());
					var updatedLogoutTime = Date.parse(new Date(now + countdown * 1000));
					cvUtil.writeCookie("ac_st", updatedLogoutTime);
					app.logoutTimer = window.setInterval(function() {
						var sec = (cvUtil.readCookie("ac_st") - Date.parse(new Date())) / 1000;
						if (sec <= 0) {
							window.location.href = "logout.do?timedout=true" + window.location.hash;
						}
					}, 15000);//poll every 15 seconds. If timed out, fire logout request to clear adminconsole and webconsole sessions
				}

				/*
				 * This below addition fixes an error when a user is using a certain version of windows in
				 * conjunction with IE. The error that occurs is windows.location.origin comes in undefined.
				 * so if this is the case, we rebuild it ourself so that it doesn't break other places.
				 * 
				 * The bug has been reported here:
				 * https://connect.microsoft.com/IE/feedback/details/1763802/location-origin-is-undefined-in-ie-11-on-windows-10-but-works-on-windows-7.
				 * It seems to have already been patched, so the issue is very rare.
				 */
				if (window.location.origin === undefined) {
					window.location.origin = window.location.protocol + "//" + window.location.hostname
							+ (window.location.port ? ':' + window.location.port : '');
				}

				//start listening for jobs (this is so that jobs for ma installation while core setup are also tracked)
				globalJobListener.listenToJobs();

				/*
				 * If the user is on the CommCell level, AND the user did not finish the Core Setup yet, then
				 * we want to restrict his/her movement throughout most of the site until the core setup is
				 * completed.
				 */
				if (cv.isOnCommcellLevel
						&& !(angular.isUndefined(cvApp.globalParams.skipInitialSetup)
								|| cvApp.globalParams.skipInitialSetup === 'true' || cvConfig.skipCoreSetup)
						&& !cv.sessionContext.setupStepsMap.CORE_SETUP.every(function(finished) {
							return finished;
						})) {
					/*
					 * An array of state names of pages the user is allowed to visit even when the Core Setup
					 * is not complete yet.
					 */
					var allowedPages = [ 'coreSetup', 'gettingStarted', 'license', 'changePassword', 'feedback' ];
					var deregFunction = $transitions.onStart({}, function(transition) {
						var toState = transition.to();
						var fromState = transition.from();
						if (allowedPages.indexOf(toState.name) < 0) {
							/*
							 * The user is going to a page that is not allowed to be visited unless the core
							 * setup is complete. Therefore, if the core setup is complete, we will deregister
							 * the $transitions.onStart listener. Otherwise, we prevent the user from visiting
							 * the page. Additionally, if the user is not currently on an allowed page, we
							 * will direct them to the Getting Started page.
							 */
							if (cvApp.globalParams && cvApp.globalParams.skipInitialSetup
									&& cvApp.globalParams.skipInitialSetup === 'true') {
								return true;
							}
							if (cv.sessionContext.setupStepsMap.CORE_SETUP.every(function(finished) {
								return finished;
							})) {
								deregFunction();
							} else {
								event.preventDefault();
								if (allowedPages.indexOf(fromState.name) < 0) {
									$state.go('gettingStarted');
								}
							}
						}
					});
				}

				$transitions.onStart({}, function(transition) {
					var toState = transition.to();
					var fromState = transition.from();
					var isSameState = fromState.name === toState.name;
					if (localStorage) {
						var fsServerAdded = localStorage.getItem('fsServerAdded');
						if (!fsServerAdded && (fromState.name !== '')) {
							//for non-ctrl f5/f5,remove the cache refresh flag (except when fs server was just added)
							localStorage.removeItem('cacheRefreshFlag');
						} else {
							localStorage.removeItem('fsServerAdded');
						}
					}
					;
					// Check to see if this is first load
					if (fromState.name.length > 0 && !isSameState) {
						// Cancel All Pending Requests
						angular.forEach(appUtil.requests, function(req) {
							req.resolve();
						})
						appUtil.requests = [];
					}
					if (toState.preloadScripts && toState.preloadScripts.length && toState.preloadScripts.length > 0) {
						event.preventDefault();
						//TODO: Show progress
						cvUtil.lazyLoad({
							urls : toState.preloadScripts,
							success : function() {
								window.location = SharedData.targetUrl;
							},
							error : function() {
								console.log('Failed to preload scripts');
								window.location = SharedData.targetUrl;
							}
						});
					}
				}, {priority: 9999});

				// insert event to handle wizard page navigation issue
				$transitions.onSuccess({}, function(transition) {
					var toState = transition.to();
					var fromState = transition.from();
					var toParams = transition.params();
					var fromParams = transition.params('from');
					System.ts = new Date().getTime();
					$state.previous = {
						route : fromState,
						routeParams : fromParams
					}
					toState.isMultiCommCellAware ? cvMultiCommcell.setCapability() : cvMultiCommcell.resetCapability();
					if (toState.name) {
						cvUtil.writeCookie("page", toState.name, '', '', cv.contextPath);
						cvUtil.writeCookie(
								"pageParams",
								Base64.encode(JSON.stringify(toParams)),
								'',
								'',
								cv.contextPath);
						// Check if cvLoc have the correct Label
						if (toState.pageTitle && !cvLoc(toState.pageTitle).includes('??')) {
							$rootScope.title = cvLoc(toState.pageTitle);
							$window.document.title = cvLoc(toState.pageTitle);
						}
					} else {
						console.error('No state name:', toState);
					}
				}, {
					priority: 9999
				});

				//check if this is happening during session start and not on a page refresh or opening of a new tab.
				//this variable is un-set after the first check, so the next time this condition would be false;
				//during initial session start, clear the local storage for power jobs
				if (cv.isNewUserSession) {
					//clear local storage used for power restore jobs
					globalJobListener.clearPowerRestoreLocalStorage();

					//make an API call to un-set the isNewUserSession property
					downloadJobsService.clearIsNewUserSession().success(function() {
						//console.log('isNewUserSession variable has been un-set.');
					}).error(function(err) {
						//console.log('isNewUserSession variable not un-set ' + err);
					});
				}
			} ]);

	if (document.getElementById("wrapper").className.indexOf('showWrapper') < 0) {
		document.getElementById("wrapper").className += 'showWrapper';
	}

	document.getElementById('initial-loading-check').checked = true;
};

window.addEventListener('beforeunload', function u(e) {
	document.cookie = "page-refresh-requested=true";
	localStorage.removeItem('creCacheId');
	localStorage.removeItem('jobCacheId');
	localStorage.setItem('cacheRefreshFlag', 'true');
	sessionStorage.removeItem("vmGroupRefresh");
	localStorage.removeItem('showAdminJobs');

}, false);

document.cookie = "page-refresh-requested=; expires=Thu, 01 Jan 1970 00:00:00 UTC;";
