(function() {
	'use strict';

	var cvCommon = angular.module('cvCommon');

	cvCommon
			.filter(
					'filterNodes',
					[
							'cvLoc',
							function(cvLoc) {
								return function(items, searchKeyWord, parentNode, showSelected) {
									let filtered = [];
									var reg = new RegExp(searchKeyWord, "i");

									if (items) {

										if (parentNode.clientSidePaging) {

											angular.forEach(items, function(item) {
												if (!item.parentNode.enableSearch
														|| isNodeApplicable(reg, item, searchKeyWord)) {
													filtered.push(item);
												}
											});

											parentNode.remainingItems = filtered.length < (parentNode.pageNo * parentNode.clientSidePagingSize) ? 0
													: filtered.length
															- (parentNode.pageNo * parentNode.clientSidePagingSize);

											parentNode.showMoreMessage = cvLoc(
													'label.showMoreItems',
													parentNode.remainingItems);

										} else {
											angular.forEach(items, function(item) {
												if (!item.parentNode.enableSearch || item.parentNode.externalPaging
														|| isNodeApplicable(reg, item, searchKeyWord)) {
													filtered.push(item);
												}
											});
										}

										if (!filtered.length) {
											parentNode.noChild = true;
										}
									}

									return filtered;
								}

								function isNodeApplicable(reg, node, keyWord) {
									return reg.test(node.ItemName);
								}
							} ]);
})();