/**
 * Encodes \r and \n into html entities
 * @param {string} string
 * @returns {string} Returns the text with the newline characters encoded
 */
function encodeNewlines(string) {
	return string.replace(/\r/g, '&#13;').replace(/\n/g, '&#10;');
}

/**
 * Encodes characters into html entities
 * @param {string} text
 * @param {Element} [encoderElem] An element to use for encoding. Useful to
 * prevent the creation of unnecessary elements (for performance).
 * @returns The text with html entities encoded
 */
export default function encodeText(text, encoderElem = document.createElement('div')) {
	encoderElem.textContent = text;
	return encodeNewlines(encoderElem.innerHTML);
}
