class XmlParseError extends Error {
	constructor(source) {
		super("Error parsing XML");
		this.source = source;
	}

	toString() {
		return this.source;
	}
}

/**
 * @author ssubash
 */
export default function xmlTojson(xmlString, domParser = new DOMParser()) {
	var xml = domParser.parseFromString(`<data>${xmlString}</data>`, 'text/xml');
	if (xml.getElementsByTagName("parsererror").length > 0) {
		throw new XmlParseError(xmlString);
	}
	return xmlToJson(xml).data;
}

// Changes XML to JSON
function xmlToJson(xml) {
	
	// Create the return object
	var obj = {};

	if (xml.nodeType == 1) { // element
		// do attributes
		if (xml.attributes.length > 0) {
			for (var j = 0; j < xml.attributes.length; j++) {
				var attribute = xml.attributes.item(j);
				obj[attribute.nodeName] = attribute.nodeValue;
			}
		}
	} else if (xml.nodeType == 3) { // text
		obj = _.trim(xml.nodeValue);
	}

	// do children
	if (xml.hasChildNodes()) {
		for(var i = 0; i < xml.childNodes.length; i++) {
			var item = xml.childNodes.item(i);
			var nodeName = item.nodeName;
			var nodeXml = xmlToJson(item);
			if (typeof(obj[nodeName]) == "undefined") {
				if(!_.isEmpty(nodeXml)) {
						obj[nodeName] = nodeXml;
				}
			} else {
				if (typeof(obj[nodeName].push) == "undefined") {
					// Convert to array
					var old = obj[nodeName];
					obj[nodeName] = [];
					obj[nodeName].push(old);
				}
				obj[nodeName].push(nodeXml);
			}
		}
	}
	return obj;
};