<%@  taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core"%>
<%@ taglib uri="/WEB-INF/cvtaglib.tld" prefix="cv"%>
<%@  taglib prefix="fmt" uri="http://java.sun.com/jsp/jstl/fmt"%>
<script nonce="${sessionScope.cspNonce}" >
	<cv:cvMessages bundle="localization.HeaderLanguages"></cv:cvMessages>
	<cv:cvMessages bundle="localization.serversJs"></cv:cvMessages>
	<cv:cvMessages bundle="localization.settings"></cv:cvMessages>
	<cv:cvMessages bundle="localization.messagesJs"></cv:cvMessages>
	<cv:cvMessages bundle="localization.schedule"></cv:cvMessages>
	<cv:cvMessages bundle="localization.clients"></cv:cvMessages>
	<cv:cvMessages bundle="localization.storage"></cv:cvMessages>
	<cv:cvMessages bundle="localization.scheduleJs"></cv:cvMessages>
	<cv:cvMessages bundle="localization.dr"></cv:cvMessages>
	<cv:cvMessages bundle="localization.alerts"></cv:cvMessages>
	<cv:cvMessages bundle="localization.ediscovery"></cv:cvMessages>
	<cv:cvMessages bundle="localization.sqlserver"></cv:cvMessages>
	<cv:cvMessages bundle="localization.profiles"></cv:cvMessages>
	<cv:cvEnum name="EVGui.ProxyGatewayConfigurationType"></cv:cvEnum>
	<cv:cvEnum name="EVGui.SoftwareDownloadProtocolType"></cv:cvEnum>
	<cv:cvMessages bundle="localization.servers"></cv:cvMessages>
	<cv:cvMessages bundle="localization.restore"></cv:cvMessages>
	<cv:cvMessages bundle="localization.snapArray"></cv:cvMessages>
	<cv:cvMessages bundle="localization.commcell"></cv:cvMessages>
</script>
<div class="header-left-wrapper">
	<div><a data-dashboard-link support-custom-link='true'><cv-logo-default></cv-logo-default></a></div>
	<div><jsp:include page="/common/globalSearch.jsp" /></div>
</div>
<div class="cv-flex header-dropdown-wrapper" data-ng-controller="headerUserSettingsController">
	<c:if test="${applicationScope['CVAppContext'].licenseMode == 'EVALUATION' && loginContext.isAdminOnCommcellLevel()}">
		<a class="evaluation-mode" href="#/license" data-ng-if="coreSetupCompleted"><span><cv:msg key="label.evaluationMode" bundle="settings" /></span></a>
	</c:if>
	<%-- tracker for current downloads --%>
	<div class="uib-dropdown download-tracker header-menu"  on-toggle="downloadTrackingToggled(open)" data-ng-show="showCurrentDownloads()" uib-dropdown data-ng-controller="currentDownloadsTrackerController">
		<a class="uib-dropdown-toggle" href="javascript:void(0);" uib-dropdown-toggle id="download-tracker">
			<span class="header-svg spin-animation"><svg fill="currentColor" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 25 25"><circle cx="12.5" cy="4.2" r="2.5"/><circle cx="3.6" cy="10.6" r="2.5"/><circle cx="7" cy="20.7" r="2.5"/><circle cx="21.4" cy="10.5" r="2.5"/><circle cx="17.9" cy="20.8" r="2.5"/></svg></span>
		</a>
		<div uib-dropdown-menu class="dropdown-menu download-dropdown">
			<ul uid-dropdown-menu >
				<li class="text text-center"><span><cv:msg key="label.downloadTrackerHeader" bundle="settings"/></span></li>
				<li class="text" data-ng-repeat="downloadItem in downloadItems">
					<span class="crop" title={{downloadItem.name}}>{{downloadItem.name}}</span>
				</li>
			</ul>
		</div>
	</div>
<%-- NEED DO GO UNDER HAMBUR --%>
<div class="hamburger">
	<div class="hamburger-list">
	<monitor-notification class="header-menu no-wiard-page padding-right-10 monitor-notification"></monitor-notification>
	<commcellsetting-dropdown data-ng-if="isMultiComcell" class="header-menu"></commcellsetting-dropdown>
    <div class="uib-dropdown commcell-selection header-menu" uib-dropdown data-ng-if="groupedCommcellList.length > 0 && showCommcellRedirectDropdown">
       <a class="uib-dropdown-toggle header-menu-item" href="javascript:void(0);" uib-dropdown-toggle id="commcell-dropdown">
           <span ng-bind="commcellName"></span>&nbsp;<span class="k-icon k-i-arrow-60-down header-menu-arrow"></span></a>
       </a>
       <ul uib-dropdown-menu class="dropdown-menu cv-dropdown-style-2 cv-permitted-actions-append-to-body" id="commcellDropdown">
           <div class="part-scroll">
			   <!--
				   Using aliases groupFirst and groupLast since there's nested ng-repeats
				   and can cause conflict in default exposed $first, $last scope variables
				-->
				<div
					class="commcell-grouped-dropdown"
					ng-repeat="group in groupedCommcellList track by $index"
					ng-init="$groupFirst= $first; $groupLast = $last"
				>
					<div ng-if="group.groupName">
						<hr ng-if="!$groupFirst" class="header-menu">
						<span class="dropdown-header no-wrap" ng-bind="group.groupName"></span>
					</div>
					<li
						ng-class="{ 'padding-top-10': ($groupFirst && !group.groupName), 'padding-bottom-10': $groupLast }"
						data-ng-repeat="commcell in group.redirectLists"
					>
						<a class="commcell-link vertical-center" href="{{ commcell.redirectUrl }}" ng-click="redirectToCommcell($event, commcell)">
							<span ng-if="group.iconClass" class="{{ group.iconClass }}"></span>
							<span ng-if="group.svgIcon" ng-bind-html="group.svgIcon"></span>
							<span data-ng-if="!commcell.displayName" class="margin-left-10" ng-bind="commcell.commcellName"></span>
							<span data-ng-if="commcell.displayName" class="margin-left-10" ng-bind="commcell.displayName"></span>
						</a>
					</li>
					<span ng-if="!$groupLast"></span>
				</div>
         	</div>
       </ul>
    </div>
	<companysetting-dropdown data-ng-if="showCompanyDropdown" class="header-menu"></companysetting-dropdown>
	<usersetting-dropdown data-ng-if="showUserSettingsDropdown" class="header-menu"></usersetting-dropdown>
	</div>
</div>
