<%@ taglib uri="/WEB-INF/cvtaglib.tld" prefix="cv"%>
<script type="text/ng-template" id="customTemplate.html">
	<div class="custom-popup-wrapper" ng-show="isOpen() && !moveInProgress" aria-hidden="{{!isOpen()}}">
	   <ul class="dropdown-menu" role="listbox">
	     <li class="uib-typeahead-match crop" ng-repeat="match in matches track by $index" ng-class="{active: isActive($index) }"
	       ng-mouseenter="selectActive($index)" ng-click="selectMatch($index)" role="option" id="{{::match.id}}" >
			<a data-ng-if="match.model.displayType" class="global-search-item global-search-type">
				<span class="parenthetical-text"> {{match.model.displayType}} </span>
			</a>
			<a data-ng-if="match.model.state" class="global-search-item">
				<span ng-bind-html="match.label | uibTypeaheadHighlight:query" data-cv-name="{{match.model.lastName}}" data-cv-id="{{match.model.id}}" class="nav-search"></span>
				<span class="placeholder-description-setup" data-ng-if="match.model.inCompleteSetup"><cv:msg key="label.completeSetup" bundle="messagesJs"/></span>
				<span class="placeholder-description" data-ng-bind="match.model.searchPlaceHolder"></span>
			</a>
			<a data-ng-if="match.model.url || ($parent.$parent.$parent.commandMode && $parent.$parent.$parent.commandMode.commandId === 'nlp')" target="{{match.model.urlTarget}}" href="{{match.model.url}}" class="global-search-item" data-ng-click="$parent.$parent.$parent.performSupportedAction(match.model, $event)">
				<div ng-bind-html="match.label | uibTypeaheadHighlight:query" data-cv-name="{{match.label}}"  data-cv-actionSupport="{{match.model.actionSupport}}" class="entity-search"></div>
				<span class="multicommcell-newtab" data-ng-if="match.model.urlTarget==='_blank'">CS: {{match.model.commcellName}}
						<span class="margin-left-10"><svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" fill="#fff"><path d="M19 19H5V5h7V3H5a2 2 0 0 0-2 2v14c0 1.1.9 2 2 2h14a2 2 0 0 0 2-2v-7h-2v7zM14 3v2h3.6l-9.8 9.8 1.4 1.4L19 6.4V10h2V3h-7z"></path></svg></span>
				</span>
				<span class="placeholder-description" data-ng-bind="match.model.actionPlaceHolder"></span>
			</a>
			<a data-ng-if="match.model.commandName">
				<span ng-bind-html="match.model.commandName | uibTypeaheadHighlight:query"></span>
				<span class="command-description" ng-bind-html="match.model.commandDescription"></span>
			</a>
			<a title="{{match.model.FileName}}" data-ng-if="match.model.FileName" class="global-file-search" data-ng-click="$parent.$parent.$parent.$parent.doShowRestoreDialog(match.model, $event)">
				<span>
					<span class="crop highlight filename-name" ng-bind-html="match.model.FileName | uibTypeaheadHighlight:query"></span>
					<span title="{{match.model.downloadLocale}} {{match.model.FileName}}" data-ng-if="!match.model.hideOption" class="filename-download" data-ng-click="$parent.$parent.$parent.$parent.downloadFile(match.model, $event)">
						<img width="30px" height="30px" src="common/img/downloadFromPreview.png" />
					</span>
				</span>
				<div class="global-search-results-wrapper">
					<span class="inline-block-server-name" title="{{match.model.ClientName}}" data-ng-if="match.model.ClientName">{{match.model.serverNameLocale}}: {{match.model.ClientName}}</span>
					<span class="inline-block-path-name" title="{{match.model.FilePath}}" data-ng-if="match.model.FilePath">{{match.model.pathNameLocale}}: {{match.model.FilePath}}</span>
				</div>
			</a>
			<a data-ng-if="match.model.entityActionName" href="{{match.model.href}}" class="global-search-item">
				<span data-ng-bind-html="match.model.entityActionName | uibTypeaheadHighlight:query"></span>
			</a>
			<a data-ng-if="match.model.addEntityName" class="global-search-item">
				<span data-ng-bind-html="match.model.addEntityName | uibTypeaheadHighlight:query"></span>
			</a>
			<a ng-if="match.model.type === 'nlp'" class="global-search-item">
				<span class="glyphicon glyphicon-search"></span>&nbsp;&nbsp;<span ng-bind-html="match.model.name | uibTypeaheadHighlight:query" class="global-search-item"></span>
				<span class="placeholder-description" data-ng-bind="match.model.actionPlaceHolder"></span>		</a>
	     </li>
	   </ul>
	 </div>
</script>
<div
	data-ng-controller="globalSearchController"
	data-ng-show="showSearch"
	class="global-search no-wizard-page"
	data-ng-cloak
	ng-class="{'padding-right-15': nlpNoResults}"
>
	<span class="global-search-icon">
		<span class="glyphicon glyphicon-search"></span>
	</span>

	<div id="globalSearch">
		<span data-ng-bind="entitySearchTitle" class="entity-search-title"></span>
		<span id="commandName" data-ng-if="commandMode.enable" data-ng-class="{'command-name': commandMode.enable}">{{
			commandName
		}}</span>
		<span
			id="entityActionName"
			class="crop"
			style="max-width:150px; margin-right: 10px;"
			data-ng-if="entityAction.enable"
			data-ng-class="{'command-name': entityAction.enable}"
			>{{ entityActionName }}</span
		>
		<input
			id="globalSearchInput"
			data-ng-class="{'input-margin': commandMode.enable}"
			type="text"
			maxlength="50"
			data-ng-show="showSearch"
			data-ng-model="typeEntity"
			placeholder="{{ placeHolder }}"
			uib-typeahead="data as data.name for data in getSearchResults($viewValue)"
			typeahead-popup-template-url="customTemplate.html"
			class="form-control no-margin no-padding"
			typeahead-on-select="selectedEntity($item, typeEntity, $label, $event); typeEntity='';"
			typeahead-min-length="0"
			typeahead-loading="loadingResults"
			typeahead-no-results="noResults"
			typeahead-wait-ms="500"
			typeahead-append-to="'#searchResults'"
			typeahead-should-select="!userTyping"
			data-ng-focus="focusEvt($event)"
			ng-keyup="setUserTyping($event)"
			ng-keydown="removeTagOnBackspace(typeEntity, $event, commandMode, entityAction)"
			autocomplete="off"
		/>
		<div ng-show="!userTyping && (typeEntity != '' || entityAction && entityAction.enable)" id="searchResults"></div>
		<ul class="dropdown-menu" data-ng-show="loadingResults && dataFromServer.length<1 && typeEntity != ''">
			<li>
				<a class="crop"> <cv:msg key="Loading" bundle="messagesJs"/></a>
			</li>
		</ul>
	</div>
	<span class="nlp-feedback">
		<span class="text-warning" ng-if="nlpNoResults"><cv:msg key="label.noResultsFound" bundle="messagesJs"/></span>
	</span>
</div>
