<%@ taglib uri="/WEB-INF/cvtaglib.tld" prefix="cv"%>
<script nonce="${sessionScope.cspNonce}" >
    <cv:cvMessages bundle="localization.bigData"></cv:cvMessages>
    <cv:cvMessages bundle="localization.serversJs"></cv:cvMessages>
    <cv:cvMessages bundle="localization.restoreJs"></cv:cvMessages>
</script>
<div class="setup-title">
	<h1><cv:msg key="header.restore" bundle="serversJs"/></h1>
</div>
<div class="setup-content" ng-init="ctrl.init()">
    <span class="serverMessage" ng-class="ctrl.serverMessage.type" ng-bind="ctrl.serverMessage.message"></span>
    <form name="restoreForm" class="restore-form" cv-submit="ctrl.restore()" novalidate autocomplete="off">
    
            <div class="global-options remove-border-padding margin-top-30">
                <div style="clear: both;" data-ng-show="ctrl.showOverWrite">
						<input name="overwrite" id="overwrite" type="checkbox"
							data-ng-model="ctrl.restoreOptions.whenDocExist"> <label
							for="overwrite" class="overwriteLabel"><cv:msg
								key="label.overwriteIndex" bundle="bigData" /></label>
				</div>
            </div>
           
            <div class="global-options remove-border-padding margin-top-30">
                <div style="clear:both;">
                    <input type="checkbox" id="outOfPlaceRestore" name="outOfPlaceRestore" ng-model="ctrl.restoreOptions.outOfPlaceRestore" 
                    data-ng-click="ctrl.restoreOptions.whenDocExist=ctrl.restoreOptions.whenDocExist == 2 ? 0 : ctrl.restoreOptions.whenDocExist" />
                    <label for="outOfPlaceRestore"><cv:msg key="label.oopRestore" bundle="bigData" /></label>
                </div>
            </div>
            
            
            <div class="global-options destinationServerDiv credentials" ng-if="ctrl.restoreOptions.outOfPlaceRestore" ng-init="ctrl.initInstances()">
                    <label for="destinationInstance" class="select-label restorePathLabel"><cv:msg key="label.destinationClientInstance" bundle="bigData" />
                        <select ng-if="ctrl.instanceList" ng-options="instance.instanceEntity.instanceId as instance.instanceEntity.clientName + '/' + instance.instanceEntity.instanceName for instance in ctrl.instanceList" ng-model="ctrl.restoreOptions.destinationInstance" ng-change="ctrl.initNodes(ctrl.restoreOptions.destinationInstance)"></select>
                    </label>
            </div> 
            
             



		<div class="plain-accordion global-options remove-border-padding margin-top-30" data-ng-show="ctrl.isShowAdvancedOptions">
		
		  <cv-plain-accordion accordion-label='<cv:msg key="label.advancedOptions" bundle="bigData" />'>
			<div class="margin-left-5 margin-right-0 padding-left-15 padding-right-15">
				    <div class="form-group row margin-top-10">

					<div class="global-options remove-border-padding margin-top-30">
						<div style="clear: both;">
							<input type="checkbox" id="renameIndex" name="renameIndex"
								ng-model="ctrl.restoreOptions.renameIndex" /> <label
								for="renameIndex"><cv:msg key="label.renameIndexes"
									bundle="bigData" /></label>
						</div>
					</div>

					<div class="global-options remove-border-padding credentials"
						data-ng-show="ctrl.restoreOptions.renameIndex">
						<label for="suffixString"> <cv:msg
								key="label.suffixString" bundle="bigData" /> <input type="text"
							name="suffixString" id="suffixString"
							placeholder='<cv:msg key="label.renameIndex.placeholder" bundle="bigData" />'
							data-ng-model="ctrl.restoreOptions.suffixString"
							data-ng-required="ctrl.restoreOptions.renameIndex"> <span
							class="help-block"
							data-ng-show="cv.restoreForm.needsAttention(restoreForm.suffixString)">
								<cv:msg key="error.empty.suffixString" bundle="bigData" />
						</span>
						</label>
					</div>

					<div class="global-options remove-border-padding margin-top-30">
						<div style="clear: both;">
							<input name="restoredeleted" id="restoredeleted" type="checkbox"
								data-ng-model="ctrl.restoreOptions.frozenAsThawed"> <label
								for="restoredeleted" class="overwriteLabel"><cv:msg
									key="label.deletedBuckets" bundle="bigData" /></label>
						</div>
					</div>
				</div>
				<!--Overwrite data--END-->
			</div>
		  </cv-plain-accordion>
		</div>



		<div class="button-container">
                <button id="splunkRestoreOptionsModal_button_#7069" type="button" class="btn btn-default cvBusyOnAjax" ng-click="ctrl.dismiss()"><cv:msg key="Cancel" bundle="messages"/></button> 
                <button id="splunkRestoreOptionsModal_button_#5039" type="submit" class="btn btn-primary cvBusyOnAjax"><cv:msg key="OK" bundle="messages"/></button> 
            </div>
        </form>
    
</div>