<%@ taglib uri="/WEB-INF/cvtaglib.tld" prefix="cv"%>
<script nonce="${sessionScope.cspNonce}" >
    <cv:cvMessages bundle="localization.bigData"></cv:cvMessages>
    <cv:cvMessages bundle="localization.serversJs"></cv:cvMessages>
    <cv:cvMessages bundle="localization.restoreJs"></cv:cvMessages>
    <cv:cvMessages bundle="localization.restore"></cv:cvMessages>
    <cv:cvMessages bundle="localization.messages"></cv:cvMessages>
    <cv:cvMessages bundle="localization.messagesJs"></cv:cvMessages>
    <cv:cvMessages bundle="localization.oracle"></cv:cvMessages>
    <cv:cvMessages bundle="localization.sqlserver"></cv:cvMessages>
</script>
<div class="setup-title">
    <h1><cv:msg key="header.restore" bundle="serversJs"/></h1>
</div>

<div class="serverMessage" ng-class="ctrl.serverMessage.type" ng-bind="ctrl.serverMessage.message"></div>

<div ng-init="ctrl.init()"  >


    <form id="restoreBigDataForm" name="restoreBigDataForm" cv-submit="ctrl.restore()" novalidate autocomplete="off">

    <div class="modal-body bootstrap-wrapper" data-ng-if="ctrl.instancesLoaded" >
        <div id="modern-tab" class="tab-3">
           <cv-tabset-component control='ctrl.tabControls' default-tab="ctrl.tabControls.defaultTab">
                <!--
                ****************************************************************************
                In  Place Restore
                ****************************************************************************
                -->
                <cv-tab tabname='<cv:msg key="label.restoreInPlace" bundle="restore" />' data-ng-selected="ctrl.onTabChanged()"
                    help-text="{{ctrl.inPlaceRestoreHelpText}}">
                    <div ng-init="ctrl.initInstances()" data-ng-disabled="!ctrl.restoreOptions.outOfPlaceRestore" class="margin-top-20  min-height-0">
                        <div class="form-group row" >
                            <label class="col-xs-12 col-sm-5" for="destinationCluster"><cv:msg key="label.destinationClusterServer" bundle="bigData" /></label>
                             <label class="col-xs-12 col-lg-7 label-as-input">
                                 {{ctrl.inplaceRestoreClientName}}
                             </label>
                        </div>

                        <div class="form-group row" ng-if="ctrl.clientInstances.length>1">
                            <label class="col-xs-12 col-sm-5" for="destinationClusterInstance"><cv:msg key="label.destinationClusterInstance" bundle="bigData" /></label>
                            <label class="col-xs-12 col-lg-7 label-as-input">
                                  {{ctrl.inplaceRestoreInstanceName}}
                             </label>
                        </div>
                    </div>

                </cv-tab>
                <!--
                ****************************************************************************
                Out of Place Restore:
                ****************************************************************************
                -->
                <cv-tab tabname='<cv:msg key="label.OOPRestore" bundle="restore" />' data-ng-selected="ctrl.onTabChanged()"
                    help-text="{{ctrl.outOfPlaceRestoreHelpText}}" >
                    <div class="margin-top-20" >
                        <div class="form-group row" >
                            <label class="col-xs-12 col-sm-5" for="OOPdestinationClusterServer"><cv:msg key="label.destinationClusterServer" bundle="bigData" /></label>
                            <div class="col-xs-12 col-sm-7" ng-if="ctrl.instanceList" >
                                <isteven-multi-select
                                    id="OOPdestinationClusterServer"
                                    input-model="ctrl.clients"
                                    output-model="ctrl.restoreOptions.selectedClient"
                                    button-label="clientName"
                                    item-label="clientName"
                                    search-property="clientName"
                                    selection-mode="single"
                                    on-item-click="ctrl.clickDestinationClient(data)"
                                    helper-elements="all none filter"
                                    disable-property="disabled"
                                    tick-property="selected">
                                </isteven-multi-select>
                                <span class="help-block" data-ng-show="inputAlertFlags.OOPdestinationClusterServer"><cv:msg key="error.dataAccessNodes" bundle="bigData" /></span>
                            </div>
                        </div>

                        <div class="form-group row" ng-if="ctrl.clientInstances.length>1" >
                            <label class="col-xs-12 col-sm-5" for="destinationClusterInstance"><cv:msg key="label.destinationClusterInstance" bundle="bigData" /></label>
                            <div class="col-xs-12 col-sm-7" >
                                <isteven-multi-select
                                    id="bigDataRestoreOptionsModal_isteven-multi-select_#6204"
                                    directive-id="destinationInstance"
                                    input-model="ctrl.clientInstances"
                                    output-model="ctrl.restoreOptions.selectedInstance"
                                    button-label="instanceName"
                                    item-label="instanceName"
                                    search-property="instanceName"
                                    selection-mode="single"
                                    on-item-click="ctrl.clickDestinationInstance(data)"
                                    tick-property="selected">
                                </isteven-multi-select>
								<span class="help-block" data-ng-show="ctrl.inputAlertFlags.oopdestinationInstance"><cv:msg key="error.destinationInstance" bundle="bigData" /></span>
                            </div>
                        </div>

                    </div>

                </cv-tab>

                <!--
                ****************************************************************************
                Restore to DISK
                ****************************************************************************
                -->
                <cv-tab tabname='<cv:msg key="label.mongoDBManualRestore" bundle="bigData" />' data-ng-selected="ctrl.onTabChanged()" data-ng-if="ctrl.collectionView === false"
                    help-text='<cv:msg key="helpText.restoreToDisk" bundle="bigData" />'>
                    <div ng-init="ctrl.initInstances()" class="margin-top-20">

                        <div class="form-group row">
                            <label class="col-xs-12 col-sm-5" for="destinationCluster">
                                <cv:msg key="label.destinationClusterServer" bundle="bigData" /></label>
                            <div class="col-xs-12 col-sm-7" ng-if="ctrl.instanceList">
                                <isteven-multi-select
                                	id="mongoDBRestoreOptionsModal_rtd_server_isteven-multi-select_#6203"
                                    input-model="ctrl.clients"
                                    output-model="ctrl.restoreOptions.selectedClient"
                                    button-label="clientName"
                                    item-label="clientName"
                                    search-property="clientName"
                                    selection-mode="single"
                                    on-item-click="ctrl.clickDestinationClient(data)"
                                    helper-elements="all none filter"
                                    tick-property="selected">
                                </isteven-multi-select>
                            </div>
                        </div>

                        <div class="form-group row" ng-if="ctrl.clientInstances.length>1">
                            <label class="col-xs-12 col-sm-5" for="destinationClusterInstance">
                                <cv:msg key="label.destinationClusterInstance" bundle="bigData" /></label>
                            <div class="col-xs-12 col-sm-7">
                                <isteven-multi-select
                                	id="mongoDBRestoreOptionsModal_rtd_instance_isteven-multi-select_#6204"
                                    input-model="ctrl.clientInstances"
                                    output-model="ctrl.restoreOptions.selectedInstance"
                                    button-label="instanceName"
                                    item-label="instanceName"
                                    search-property="instanceName"
                                    on-item-click="ctrl.clickDestinationInstance(data)"
                                    selection-mode="single"
                                    tick-property="selected">
                                </isteven-multi-select>
                                <span class="help-block" data-ng-show="ctrl.inputAlertFlags.rtddestinationInstance"><cv:msg key="error.destinationInstance" bundle="bigData" /></span>
                            </div>
                        </div>

                    </div>

                </cv-tab>

            </cv-tabset-component>
        </div>

        <div class="form-group row" data-ng-if="ctrl.collectionView=== false" >
            <label for="stagingpathforlogrestore" class="col-xs-12 col-md-5 col-lg-5">
                <cv-help-text help-label="label.stagingpathforlogrestore" help-text="helpText.stagingpathforlogrestore" />
                <span class="optional-text"><cv:msg key="label.optional" bundle="subscriptions"/></span>
           </label>
           <div class="col-xs-12 col-md-7 col-lg-7">
                <div class="input-group">
                    <input type="text" name="stagingPathLogRestore" id="stagingPathLogRestore" data-ng-class="text-right"
                    data-ng-model="ctrl.stagingPathLogRestore" data-ng-change="ctrl.inputAlertFlags.stagingPathLogRestore = false;" >
                    <span class="input-group-btn">
                         <button id="mongoDBRestoreOptions_button_99991" type="button" data-ng-click="ctrl.browseStagingPathClient(ctrl.selectedInstanceMasterNodeClientId)" class="btn btn-default browse-btn">
                        <cv:msg key="action.browse" bundle="bigData"/></button>
                    </span>
                </div>
                 <span class="help-block" ng-show="ctrl.inputAlertFlags.stagingPathLogRestore"><cv:msg key="error.stagingLocation" bundle="bigData" /></span>
           </div>
        </div>

		<div class="form-group row" data-ng-if="ctrl.collectionView=== false" >
            <div class="col-xs-12">
                <input name="shutdownRemoveExistingData" id="shutdownRemoveExistingData" type="checkbox" data-ng-model="ctrl.restoreOptions.shutdownRemoveExistingData">
                <label for="shutdownRemoveExistingData">
                	<cv-help-text help-label="label.shutdownRemoveExistingData" help-text="helpText.shutdownRemoveExistingData" />
                </label>
            </div>
       	</div>

        <div class="form-group row"  data-ng-if="!ctrl.restoreOptions.inPlaceRestore && ctrl.collectionView === false" >
			<h4>
               <cv:msg key="heading.replicasetOptions" bundle="bigData"/>
               <cv-help-component help-text="<cv:msg key="helpText.mongoDBRestoreRepset" bundle="bigData"/>"></cv-help-component>
        	</h4>
            <cv-kendo-grid class="case-inline-grid" cv-grid-options="ctrl.replicasetGridOptions" ng-if="ctrl.replicasetGridOptions" ></cv-kendo-grid>
        </div>

        <div class="form-group row" data-ng-if="ctrl.collectionView=== true">

            <cv-plain-accordion
                ng-if="!ctrl.restoreOptions.restoreToDisk  && ctrl.collectionView === true  && ctrl.dataTables.length > 0"
                accordion-label="{{ctrl.accordionLabelText}}" collapsed="false" >

                <div class="hadoop-wrapper">
                    <div class="destinationTable" data-ng-disabled="ctrl.restoreOptions.inPlaceRestore">
                        <table class="destinationList">
                            <thead>
                                <tr class="heading">
                                    <th class="dataTabelLabel" data-ng-bind="'<cv:msg key="header.source"
                                        bundle="bigData" />'"></th>
                                    <th class="dataTabelLabel" id="destinationTableLabel" data-ng-bind="'<cv:msg key="header.destination" bundle="bigData" />'"></th>
                                </tr>
                            </thead>
                            <tbody>
                                <tr data-ng-repeat="dataTable in ctrl.dataTables">
                                    <td class="sourceTableName" title="{{dataTable.label}}"
                                        data-ng-bind="dataTable.label">
                                    </td>
                                    <td class="destinationInput">
                                        <input class="input" type="text" id={{dataTable.id}}
                                            name="{{dataTable.destinationTableName}}"
                                            data-ng-model="dataTable.destinationTableName"
                                            data-ng-change="ctrl.verifyDestinationtableName(dataTable.destinationTableName,dataTable.id, dataTable.bIsCollection)" />
                                        <span class="help-block" ng-show="ctrl.inputAlertFlags.{{dataTable.id}}"><cv:msg key="error.destinationObjName" bundle="bigData" /></span>
                                    </td>
                                </tr>
                            </tbody>
                        </table>
                    </div>
                </div>

            </cv-plain-accordion>

        </div>


       	<div class="form-group row" ng-if="!ctrl.restoreOptions.restoreToDisk  && ctrl.collectionView === true  && ctrl.dataTables.length > 0">
            <div class="col-xs-12">
                <input name="overwrite" id="overwrite" type="checkbox" data-ng-model="ctrl.restoreOptions.overwrite">
                <label for="overwrite" class="overwriteLabel">
                    <cv:msg key="warning.overwrite" bundle="restore" /></label>
            </div>
       	</div>

        <div class="form-group row">
            <div class="col-xs-12"><cv-alert-me selected="false" text="<cv:msg key='label.notifyUserOnJobCompletion' bundle='messages'/>"></cv-alert-me></div>
        </div>

    </div>

    <div class="modal-footer">
        <button id="mongoDBRestoreOptions_button_99998" type="button" class="btn btn-default cvBusyOnAjax" ng-click="ctrl.dismiss()"><cv:msg key="Cancel" bundle="messages"/></button>
        <button id="mongoDBRestoreOptions_button_99999" type="submit" class="btn btn-primary cvBusyOnAjax"><cv:msg key="Submit" bundle="messages"/></button>
    </div>

    </form>

</div>


