<%@ taglib uri="/WEB-INF/cvtaglib.tld" prefix="cv"%>
<script nonce="${sessionScope.cspNonce}" >
    <cv:cvMessages bundle="localization.bigData"></cv:cvMessages>
    <cv:cvMessages bundle="localization.alerts"></cv:cvMessages>
</script>
<div class="setup-title">
     <h1>{{params.title}}</h1>
</div>
<div calss="setup-content">
    <span class="{{serverMessage.type}}" data-ng-bind="serverMessage.message"></span>

    <div class="modal-list bootstrap-wrapper" data-ng-if="!params.replaceDeadNode">
        <form id="configureNodeForm" name="configureNodeForm" class="margin-top-15">

            <div class="form-group row" data-ng-if="params.isEdit"  >
                <label class="col-xs-12 col-sm-4" for="destShardName"><cv:msg key="label.addDestReplicaset" bundle="bigData" /></label>
                <div class="col-xs-12 col-sm-8">
                    <input type="text" name="destShardName" data-ng-class="text-right" id="destShardName"
                    data-ng-model="params.destShardName"
                    data-ng-change="inputAlertFlags.destShardName = false;"
                    required autofocus >
                    <span class="help-block" ng-show="inputAlertFlags.destShardName"><cv:msg key="error.mongoDBDestinationRepset" bundle="bigData" /></span>
                </div>
            </div>

            <div class="form-group row">
                <label class="col-xs-12 col-sm-4" for="clientNode"><cv:msg key="label.addDestClient" bundle="bigData" /></label>
                <div class="col-xs-12 col-sm-8">
                <isteven-multi-select id="configureNode_isteven-multi-select_#9384"
                    directive-id="clientNode"
                    input-model="params.clientNodes"
                    output-model="params.clientNode"
                    button-label="clientName"
                    item-label="clientName"
                    search-property = "clientName"
                    selection-mode="single"
                    on-item-click="clickClientNode(data)"
                    tick-property="selected"
                    >
                </isteven-multi-select>
                    <span class="help-block" data-ng-if="inputAlertFlags.clientNode"><cv:msg key="error.clientNode" bundle="bigData" /></span>
                </div>
            </div>

            <div class="form-group row">
                <label class="col-xs-12 col-sm-4" for="destDataDir"><cv:msg key="label.addDestdbPath" bundle="bigData" /></label>
                <div class="col-xs-12 col-sm-8">
                     <div class="input-group">
                        <input type="text" name="destDataDir" data-ng-class="text-right" id="destDataDir" data-ng-model="params.destDataDir" data-ng-change="inputAlertFlags.destDataDir = false;" required autofocus >
                             <span class="input-group-btn">
                                <button id="mongoDBrestore_addRepset_browse_button_99998" type="button" data-ng-click="browseShardClient(params.node.clientNode.clientId)" class="btn btn-default browse-btn">
                                <cv:msg key="action.browse" bundle="bigData"/></button>
                             </span>
                      </div>
                       <span class="help-block" ng-show="inputAlertFlags.destDataDir"><cv:msg key="error.mongoDBPathDirectory" bundle="bigData" /></span>
                </div>
            </div>

            <div class="form-group row">
                <label class="col-xs-12 col-sm-4" for="destPortNumber"><cv:msg key="label.addDestPortnumber" bundle="bigData" /></label>
                <div class="col-xs-12 col-sm-8">
                    <input type=number name="destPortNumber" data-ng-class="text-right" id="destPortNumber" data-ng-model="params.destPortNumber">
                    <span class="help-block" data-ng-show="inputAlertFlags.destPortNumber"><cv:msg key="error.mongoDBportNumber" bundle="bigData" /></span>
                </div>
            </div>

        </form>
    </div>

    <div class="modal-footer">
        <button id="mongoDBrestore_addRepset_button_#0858" type="button" class="btn btn-default" ng-click="cancel()"><cv:msg key="label.cancel" bundle="alerts" /></button>
        <button id="mongoDBrestore_addRepset_button_#1840" class="btn btn-primary" ng-click="ok()"><cv:msg key="label.save" bundle="alerts" /></button>
    </div>
</div>