<%@ taglib uri="/WEB-INF/cvtaglib.tld" prefix="cv"%>

<script nonce="${sessionScope.cspNonce}">
    <cv:cvMessages bundle="localization.bigData"></cv:cvMessages>
</script>

<div class="setup-title">
      <h1 data-ng-if="!ctrl.authentication">
        <cv:msg key="header.editclusterDetails" bundle="bigData" />
      </h1>
      <h1 data-ng-if="ctrl.authentication">
        <cv:msg key="heading.editAuthentication" params=" " bundle="bigData" />
      </h1>
</div>

<div class="setup-content">
    <div class="serverMessage" ng-class="ctrl.serverMessage.type" ng-bind="ctrl.serverMessage.message"></div>
    <form id="editGeneralForm" name="editGeneralForm" cv-submit="ctrl.updateClusterInfo()" novalidate autocomplete="off">
        <div class="modal-list bootstrap-wrapper">
        <div data-ng-if="!ctrl.authentication">

            <!-- primary Server -->
            <div class="form-group row">
                <label class="col-xs-12 col-sm-5" ><cv:msg key="label.masterNode" bundle="bigData"/></label>

                <div class="col-xs-12 col-sm-7">
                    <div class="padding-right-20" style="width: 100%;">
                    <isteven-multi-select input-model="ctrl.nodeList" button-label="clientName" item-label="clientName" tick-property="selected"
                    class="isteven-multi-select user-group-select" helper-elements="none" selection-mode="single"
                    on-item-click="ctrl.updateMasterNode(data)" translation="ctrl.localLang"></isteven-multi-select>
                        <span class="help-block" data-ng-show="ctrl.inputAlertFlags.clientNode"><cv:msg key="error.primaryNode" bundle="bigData" /></span>
                    </div>
                </div>
            </div>

              <!-- Binary Path -->
            <div class="form-group row">
                <label class="col-xs-12 col-sm-5" for="binPath"><cv:msg key="label.binaryPath" bundle="bigData" /></label>
                <div class="col-xs-12 col-sm-7">
                    <div class="input-group">
                        <input type="text" name="binPath" data-ng-class="text-right" id="binPath" data-ng-model="ctrl.masterNode.binPath"
                            data-ng-change="ctrl.inputAlertFlags.binPath = false" >

                        <span class="input-group-btn">
                            <button id="editMongoDBGeneralInfo_button_99991" type="button"
                                data-ng-click="ctrl.browseBinPath(ctrl.selectedNode.clientId)"
                                class="btn btn-default browse-btn">
                                <cv:msg key="action.browse" bundle="bigData" /></button>
                        </span>
                    </div>
                    <span class="help-block" data-ng-show="ctrl.inputAlertFlags.binPath">
                        <cv:msg key="error.binPath" bundle="bigData" /></span>
                </div>

            </div>

            <!-- OS User Name -->

            <div class="form-group row">
                <label class="col-xs-12 col-sm-5" for="osUser"><cv:msg key="label.osUserName" bundle="bigData" /> </label>
                <div class="col-xs-12 col-sm-7">
                    <input type="text" name="osUser" data-ng-class="text-right" id="osUser" data-ng-model="ctrl.masterNode.osUser" data-ng-change="ctrl.inputAlertFlags.osUser = false"   >
                    <span class="help-block" data-ng-show="ctrl.inputAlertFlags.osUser"><cv:msg key="error.mongoDBosUserName" bundle="bigData" /></span>
                </div>
            </div>

            <!-- PortNumber -->

            <div class="form-group row">
                <label class="col-xs-12 col-sm-5" for="portNumber"><cv:msg key="label.portNumber" bundle="bigData" /></label>
                <div class="col-xs-12 col-sm-2">
                    <input type="number" name="portNumber" data-ng-class="text-left" id="portNumber" data-ng-model="ctrl.masterNode.portNumber"
                    data-ng-change="ctrl.inputAlertFlags.portNumber = false">
                    <span class="help-block" data-ng-if="ctrl.inputAlertFlags.portNumber"><cv:msg key="error.mongoDBportNumber" bundle="bigData" /></span>
                </div>
            </div>

        </div>

        <div data-ng-if="ctrl.authentication">

            <div class="form-group row">
                <label class="col-xs-12 col-sm-5" for="DBUsername">
                    <cv:msg key="label.DBUsername" bundle="bigData" /></label>

                <div class="col-xs-12 col-sm-7">
                    <input type="text" name="dbUsername" data-ng-class="text-right" id="dbUsername" data-ng-model="ctrl.clusterConfig.adminUser.userName" data-ng-change="inputAlertFlags.dbUsername = false" >
                </div>
            </div>

            <div class="form-group row">
                <label class="col-xs-12 col-sm-5" for="DBPassword">
                    <cv:msg key="label.DBPassword" bundle="bigData" /></label>

                <div class="col-xs-12 col-sm-7">
                    <!-- <input type="text" name="dbPassword" data-ng-class="text-right" id="dbPassword" data-ng-model="ctrl.clusterConfig.adminUser.password" data-ng-change="inputAlertFlags.dbPassword = false" >-->
                    <input type="password" name="dbPassword" data-ng-class="text-right" id="dbPassword" data-ng-model="ctrl.clusterConfig.adminUser.password" data-ng-change="ctrl.inputAlertFlags.password = false">
                    <span class="help-block" data-ng-show=" ctrl.inputAlertFlags.password"><cv:msg key="error.password" bundle="bigData" /></span>
                </div>
            </div>

        </div>


        <div class="button-container">
            <button type="button" class="btn btn-default cvBusyOnAjax" ng-click="ctrl.cancelUpdate()"><cv:msg key="action.cancel" bundle="profiles"/></button>
            <button type="submit" class="btn btn-primary cvBusyOnAjax"><cv:msg key="action.save" bundle="profiles"/></button>
        </div>

    </div>
    </form>
</div>