<%@ taglib uri="/WEB-INF/cvtaglib.tld" prefix="cv"%>
<script nonce="${sessionScope.cspNonce}">
	<cv:cvMessages bundle="localization.bigData"></cv:cvMessages>
	<cv:cvMessages bundle="localization.restore"></cv:cvMessages>
	<cv:cvMessages bundle="localization.subscriptions"></cv:cvMessages>
</script>
<div class="setup-title">
	<h1 data-ng-if="!ctrl.authentication"><cv:msg key="header.editGeneral" bundle="bigData"/></h1>
	<h1 data-ng-if="ctrl.authentication"><cv:msg key="heading.editAuthentication" params=" " bundle="bigData"/></h1>
</div>
<div class="setup-content">
	<div class="serverMessage" ng-class="ctrl.serverMessage.type" ng-bind="ctrl.serverMessage.message"></div>
	<form id="editGeneralForm" name="editGeneralForm" cv-submit="ctrl.updateClusterInfo()" novalidate autocomplete="off">
        <div class="modal-list bootstrap-wrapper">
            <div data-ng-if="!ctrl.authentication">
                <div class="form-group row">
                    <label class="col-xs-12 col-sm-5" for="gatewayNode"><cv:msg key="label.gatewayNode" bundle="bigData"/></label>
                    <div class="col-xs-12 col-sm-7">
                        <isteven-multi-select id="editBigDataGeneralInfoModal_isteven-multi-select_#8691" input-model="ctrl.nodeList" button-label="clientName" item-label="clientName" tick-property="selected" class="isteven-multi-select user-group-select" helper-elements="none" selection-mode="single" on-item-click="ctrl.updateGatewayNode(data)" translation="ctrl.localLang"></isteven-multi-select> 
                    </div>
                </div>
                
                <div class="form-group row">
                    <label class="col-xs-12 col-sm-5" for="configFilePath"><cv:msg key="label.configFilePath" bundle="bigData"/></label>
                    <div class="col-xs-12 col-sm-7">
                        <input type="text" id="configFilePath" name="configFilePath" ng-model="ctrl.clusterConfig.configFilePath" data-ng-change="ctrl.inputAlertFlags.configFilePath = false" />
                        <span class="help-block" data-ng-if="ctrl.inputAlertFlags.configFilePath"><cv:msg key="error.configFilePath" bundle="bigData" /></span>
                    </div>
                </div>
                
                <div class="form-group row">
                    <label class="col-xs-12 col-sm-5" for="javaHome"><cv:msg key="label.javaHome" bundle="bigData"/> <span class="optional-text"><cv:msg key="label.optional" bundle="subscriptions"/></span></label>
                    <div class="col-xs-12 col-sm-7">
                        <input type="text" id="javaHome" name="javaHome" ng-model="ctrl.gateway.node.javaHome" />
                    </div>
                </div>
                
                <div class="form-group row">
                    <label class="col-xs-12 col-sm-5" for="ipAddress"><cv:msg key="label.ipAddress" bundle="bigData"/></label>
                    <div class="col-xs-12 col-sm-7">
                        <input type="text" id="ipAddress" name="ipAddress" ng-model="ctrl.gateway.node.ipAddress" data-ng-change="ctrl.inputAlertFlags.ipAddress = false"  />
                        <span class="help-block" data-ng-if="ctrl.inputAlertFlags.ipAddress"><cv:msg key="error.ipAddress" bundle="bigData" /></span>
                    </div>
                </div>
            </div>
                
            <div data-ng-if="ctrl.authentication">
                <div class="form-group row">
                    <label class="col-xs-12 col-sm-5" for="gatewayCQLPort"><cv:msg key="label.gatewayCQLPort" bundle="bigData"/></label>
                    <div class="col-xs-12 col-sm-7 text-left">
                        <input type="number" id="gatewayCQLPort" name="gatewayCQLPort" ng-model="ctrl.gateway.gatewayCQLPort" data-ng-change="ctrl.inputAlertFlags.gatewayCQLPort = false"/>
                        <span class="help-block" data-ng-if="ctrl.inputAlertFlags.gatewayCQLPort"><cv:msg key="error.gatewayCQLPort" bundle="bigData" /></span>
                    </div>
                </div>
                
                <div class="form-group row">
                    <label class="col-xs-12 col-sm-5" for="jmxPort"><cv:msg key="label.port" bundle="bigData"/></label>
                    <div class="col-xs-12 col-sm-7 text-left">
                        <input type="number" id="jmxPort" name="jmxPort" ng-model="ctrl.gatewayInfo.jmxConnection.port" data-ng-change="ctrl.inputAlertFlags.port = false"/>
                        <span class="help-block" data-ng-if="ctrl.inputAlertFlags.port"><cv:msg key="error.port" bundle="bigData" /></span>
                    </div>
                </div>
            </div>
        </div>
        
		<div class="button-container">
			<button id="editBigDataGeneralInfoModal_button_#2987" type="button" class="btn btn-default cvBusyOnAjax" ng-click="ctrl.cancelUpdate()"><cv:msg key="action.cancel" bundle="profiles"/></button> 
			<button id="editBigDataGeneralInfoModal_button_#3611" type="submit" class="btn btn-primary cvBusyOnAjax"><cv:msg key="action.save" bundle="profiles"/></button> 
		</div>
	</form>
</div>