<%@ taglib uri="/WEB-INF/cvtaglib.tld" prefix="cv"%>
<script nonce="${sessionScope.cspNonce}" >
	<cv:cvMessages bundle="localization.bigData"></cv:cvMessages>
	<cv:cvMessages bundle="localization.servers"></cv:cvMessages>
	<cv:cvMessages bundle="localization.messages"></cv:cvMessages>
	<cv:cvMessages bundle="localization.restore"></cv:cvMessages>
	<cv:cvMessages bundle="localization.alerts"></cv:cvMessages>
</script>
	<div class="panel panel-default">
	<div class="panel-body">
	<div class="bootstrap-wrapper form-horizontal padding-bottom-0">
	<form id="createCassandraGeneral" name="createCassandraGeneral" autocomplete="off" novalidate>
				<div class="form-group">
					<label class="col-xs-12 col-sm-4" for="name">
						<cv-help-text id="clientName" help-label="label.bigDataName" help-text="helpText.name" />
					</label>
					<div class="col-xs-12 col-sm-8">
						<input type="text" name="clientName" data-ng-class="text-right" id="name" data-ng-model="model.clientName" data-ng-change="inputAlertFlags.clientName = false" required autofocus />
						<span class="help-block" data-ng-if="inputAlertFlags.clientName"><cv:msg key="error.name" bundle="bigData" /></span>
					</div>
				</div>
                <div class="form-group">
                    <label class="col-xs-12 col-sm-4" for="clientNode">
                        <cv-help-text help-label="label.clientNode" help-text="helpText.clientNode" />
                    </label>
                    <div class="col-xs-12 col-sm-7">
						<isteven-multi-select 
							input-model="dummyModel.clientNodes" 
							output-model="model.clientNode" 
							tick-property="selected"
							item-label="clientName" 
							class="isteven-multi-select user-group-select" 
							on-item-click="clickClientNode()"
							button-label="clientName" 
							id="cassandraClients" 
							helper-elements="filter" 
							selection-mode="single"
							translation="localLangGatewayNode" 
							disable-property="disabled">
						</isteven-multi-select>

                        <span class="help-block" data-ng-if="inputAlertFlags.clientNode"><cv:msg key="error.clientNode" bundle="bigData" /></span>
                    </div>
                    <div class="col-xs-12 col-sm-1 padding-left-0" >
                        <span class="input-group-btn">
                            <button id="btnAddNewNode"
                                type="button"
                                class="icon-style cv-material-button browse"
                                data-ng-click="openPushInstallDialog()">
                                <div class="cv-material-button-icon cursor-pointer">
                                    <span class="k-icon k-i-plus font-size-page-title primary-theme-color cursor-pointer"> </span>
                                </div>
                            </button>
                        </span>
                    </div>

                </div>
				<div class="form-group">
					<label class="col-xs-12 col-sm-4" for="configFilePath">
						<cv-help-text help-label="label.configFilePath" help-text="helpText.configFilePath" />
					</label>
					<div class="col-xs-12 col-sm-8">
						<input type="text" name="configFilePath" data-ng-class="text-right" id="configFilePath" data-ng-model="model.configFilePath" data-ng-change="inputAlertFlags.configFilePath = false" required autofocus />
						<span class="help-block" data-ng-if="inputAlertFlags.configFilePath"><cv:msg key="error.configFilePath" bundle="bigData" /></span>
					</div>
				</div>
				<div class="form-group">
					<label class="col-xs-12 col-sm-4" for="javaHome">
						<cv-help-text help-label="label.javaHome" help-text="helpText.javaHome" />
					</label>
					<div class="col-xs-12 col-sm-8">
						<input type="text" name="javaHome" placeholder='<cv:msg key="label.optional" bundle="restore"/>' data-ng-class="text-right" id="javaHome" data-ng-model="model.javaHome" data-ng-change="inputAlertFlags.javaHome = false" required autofocus >
						<span class="help-block" data-ng-if="inputAlertFlags.javaHome"><cv:msg key="error.javaHome" bundle="bigData" /></span>
					</div>
				</div>
				<div class="form-group">
					<label class="col-xs-12 col-sm-4" for="ipAddress">
						<cv-help-text help-label="label.cqlHost" help-text="helpText.ipAddress" />
					</label>
					<div class="col-xs-12 col-sm-8">
						<input type="text" name="ipAddress" data-ng-class="text-right" id="ipAddress" data-ng-model="model.ipAddress" data-ng-change="inputAlertFlags.ipAddress = false" required autofocus >
						<span class="help-block" data-ng-if="inputAlertFlags.ipAddress"><cv:msg key="error.ipAddress" bundle="bigData" /></span>
					</div>
				</div>
				<div class="form-group">
					<label class="col-xs-12 col-sm-4" for="plan">
						<cv-help-text help-label="label.plan" help-text="helpText.plan" />
					</label>
					<div class="col-xs-12 col-sm-8">
						<isteven-multi-select
							input-model="dummyModel.plans"
							output-model="model.plan"
							tick-property="selected"
							item-label="planName"
							class="isteven-multi-select user-group-select"
							on-item-click="clickPlan()"
							button-label="planName"
							id="plan"
							helper-elements="filter"
							selection-mode="single"
							translation="localLangPlan"
							disable-property="disabled">
						</isteven-multi-select>

						<span class="help-block" data-ng-if="inputAlertFlags.plan"><cv:msg key="error.plan" bundle="bigData" /></span>
					</div>
				</div>
			<uib-accordion close-others="true"  class="text-left margin-top-20">
				<div uib-accordion-group data-is-open="accordionStatus.additionalTab" data-scroll-to-when-open >
					<uib-accordion-heading>
						<cv:msg key="heading.additionalSettings" bundle="bigData"/>
						<i class="float-right glyphicon" data-ng-class="{'glyphicon-chevron-down': accordionStatus.additionalTab, 'glyphicon-chevron-right': !accordionStatus.additionalTab}"></i>
					</uib-accordion-heading>
					<h5><cv:msg key="label.CQLAuthentication" bundle="bigData" /></h5>
					<div class="form-group">
						<label class="col-xs-12 col-sm-3 offset-1" for="gatewayCQLPort">
							<cv-help-text help-label="label.port2" help-text="helpText.gatewayCQLPort" />
						</label>
						<div class="col-xs-12 col-sm-8">
							<input type="number" name="gatewayCQLPort" data-ng-class="text-right" id="gatewayCQLPort" data-ng-model="model.gatewayCQLPort" data-ng-change="inputAlertFlags.gatewayCQLPort = false" required autofocus />
							<span class="help-block" data-ng-if="inputAlertFlags.gatewayCQLPort"><cv:msg key="error.gatewayCQLPort" bundle="bigData" /></span>
						</div>
					</div>
					<div class="form-group">
						<label class="col-xs-12 col-sm-3 offset-1" for="CQLAuthentication">
							<cv:msg key="label.authentication" bundle="bigData" />
						</label>
						<div class="col-sm-8">
							<toggle-control
								status="dummyModel.enableCQLAuthentication"
								data-ng-click="enableAuthentication('CQL')"
								title='<cv:msg key="label.enableDisable" bundle="messages" /> <cv:msg key="label.CQLAuthentication" bundle="bigData" />'>
							</toggle-control>
							<span data-ng-if="model.enableCQLAuthentication">
								<a data-ng-click="editAuthentication('CQL')"><cv:msg key="label.edit" bundle="alerts" /></a>
							</span>
						</div>
					</div>
					<h5><cv:msg key="label.JMXAuthentication" bundle="bigData" /></h5>
					<div class="form-group">
						<label class="col-xs-12 col-sm-3 offset-1" for="port">
							<cv-help-text help-label="label.port2" help-text="helpText.port" />
						</label>
						<div class="col-xs-12 col-sm-8">
							<input type="number" name="port" data-ng-class="text-right" id="port" data-ng-model="model.port" data-ng-change="inputAlertFlags.port = false" required autofocus />
							<span class="help-block" data-ng-if="inputAlertFlags.port"><cv:msg key="error.port" bundle="bigData" /></span>
						</div>
					</div>
					<div class="form-group">
						<label class="col-xs-12 col-sm-3 offset-1" for="JMXAuthentication">
							<cv:msg key="label.authentication" bundle="bigData" />
						</label>
						<div class="col-sm-8">
							<toggle-control
								status="dummyModel.enableJMXAuthentication"
								data-ng-click="enableAuthentication('JMX')"
								title='<cv:msg key="label.enableDisable" bundle="messages" /> <cv:msg key="label.JMXAuthentication" bundle="bigData" />'>
							</toggle-control>
							<span data-ng-if="model.enableJMXAuthentication">
								<a data-ng-click="editAuthentication('JMX')"><cv:msg key="label.edit" bundle="alerts" /></a>
							</span>
						</div>
					</div>
					<h5><cv:msg key="label.SSLAuthentication" bundle="bigData" /></h5>
					<div class="form-group">
						<label class="col-xs-12 col-sm-3 offset-1" for="SSLAuthentication">
							<cv:msg key="label.authentication" bundle="bigData" />
						</label>
						<div class="col-sm-8">
							<toggle-control
								status="dummyModel.enableSSLAuthentication"
								data-ng-click="enableAuthentication('SSL')"
								title='<cv:msg key="label.enableDisable" bundle="messages" /> <cv:msg key="label.SSLAuthentication" bundle="bigData" />'>
							</toggle-control>
							<span data-ng-if="model.enableSSLAuthentication">
								<a data-ng-click="editAuthentication('SSL')"><cv:msg key="label.edit" bundle="alerts" /></a>
							</span>
						</div>
					</div>
				</div>
			</uib-accordion>
		</form>
	</div>
</div></div>