<%@  taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core"%>
<%@  taglib prefix="fmt" uri="http://java.sun.com/jsp/jstl/fmt"%>
<%@ taglib uri="/WEB-INF/cvtaglib.tld" prefix="cv"%>
<script nonce="${sessionScope.cspNonce}" >
    <cv:cvMessages bundle="localization.bigData"></cv:cvMessages>
    <cv:cvMessages bundle="localization.clients"></cv:cvMessages>
    <cv:cvMessages bundle="localization.serversJs"></cv:cvMessages>
</script>
<div class="row">
    <div class="col-xs-12">
        <cv-changename obj="ctrl.changeNameObj" data-service-method="changeServerName.do" callback="ctrl.changeNameSuccess" class="float-left"></cv-changename>
        <span data-ng-if="ctrl.generateDeviceActionsParams" class="page-action-item spacing-right">
            <span uib-dropdown class="uib-dropdown" on-toggle="toggled(open)">
                <a href class="uib-dropdown-toggle" uib-dropdown-toggle>
                    <span class="dropdownArrow right"></span><cv:msg key="label.moreActions" bundle="bigData"/>
                </a>
                <cv-generate-device-actions params="ctrl.generateDeviceActionsParams" redirect-on-delete="ctrl.redirectState"></cv-generate-device-actions>
            </span>
        </span>
        <!-- <span><a data-ng-click="ctrl.deleteClient()" class="page-action-item" ><cv:msg key="action.delete" bundle="bigData" /></a></span> -->
    </div>
</div>
<div class="row">
    <div class="col-xs-12 col-sm-6">
        <cv-tile-component ac-id="bigDataGeneralDetails" loader="ctrl.clientDetails" data-title='<cv:msg key="heading.clientGeneral" bundle="clients" />'>
			<ul class="list-style-secondary">
				<cv-tile-label-value label='<cv:msg key="label.clientName" bundle="clients" />' value="{{ctrl.clientDetails.client.displayName}}"></cv-tile-label-value>
			</ul>
        </cv-tile-component>
        <cv-security-component entity-type="ctrl.entityType" generic-entity='ctrl.genericEntity' associations='ctrl.secParams.associations' associations-loaded='ctrl.secParams.associationsLoaded' show-owners=true></cv-security-component>
    	<cv-proxy-servers data-cv-client-id="ctrl.clientDetails.ActivePhysicalNode.clientId" data-cv-client-details="ctrl.PseudoClients"></cv-proxy-servers>
    </div>
    <div class="col-xs-12 col-sm-6">
        <cv-activity-control-component data-ac-params="ctrl.acParams"></cv-activity-control-component>
    </div>
</div>
<cv-grid cv-grid-options="ctrl.cvGridOptions" ng-if="ctrl.cvGridOptions"></cv-grid>
